/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.Utils;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior$$Lambda$2;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior$$Lambda$3;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.text.HitInfo;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Window;

public class TextFieldBehavior
extends TextInputControlBehavior<TextField> {
    private TextFieldSkin skin;
    private ContextMenu contextMenu = new ContextMenu();
    private TwoLevelFocusBehavior tlFocus;
    private ChangeListener<Scene> sceneListener;
    private ChangeListener<Node> focusOwnerListener;
    private boolean focusGainedByMouseClick = false;
    private boolean shiftDown = false;
    private boolean deferClick = false;

    public TextFieldBehavior(TextField textField) {
        super(textField, (List<KeyBinding>)TEXT_INPUT_BINDINGS);
        if (IS_TOUCH_SUPPORTED) {
            this.contextMenu.getStyleClass().add("text-input-context-menu");
        }
        this.handleFocusChange();
        textField.focusedProperty().addListener(TextFieldBehavior$$Lambda$1.lambdaFactory$(this));
        this.focusOwnerListener = TextFieldBehavior$$Lambda$2.lambdaFactory$(this, textField);
        WeakChangeListener<Node> weakFocusOwnerListener = new WeakChangeListener<Node>(this.focusOwnerListener);
        this.sceneListener = TextFieldBehavior$$Lambda$3.lambdaFactory$(weakFocusOwnerListener);
        textField.sceneProperty().addListener(new WeakChangeListener<Scene>(this.sceneListener));
        if (textField.getScene() != null) {
            textField.getScene().focusOwnerProperty().addListener(weakFocusOwnerListener);
        }
        if (com.sun.javafx.scene.control.skin.Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(textField);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    private void handleFocusChange() {
        TextField textField = (TextField)this.getControl();
        if (textField.isFocused()) {
            if (PlatformUtil.isIOS()) {
                TextInputTypes type = TextInputTypes.TEXT_FIELD;
                if (textField.getClass().equals(PasswordField.class)) {
                    type = TextInputTypes.PASSWORD_FIELD;
                } else if (textField.getParent().getClass().equals(ComboBox.class)) {
                    type = TextInputTypes.EDITABLE_COMBO;
                }
                Bounds bounds = textField.getBoundsInParent();
                double w = bounds.getWidth();
                double h = bounds.getHeight();
                Affine3D trans = TextFieldBehavior.calculateNodeToSceneTransform(textField);
                String text = textField.getText();
                textField.getScene().getWindow().impl_getPeer().requestInput(text, type.ordinal(), w, h, trans.getMxx(), trans.getMxy(), trans.getMxz(), trans.getMxt(), trans.getMyx(), trans.getMyy(), trans.getMyz(), trans.getMyt(), trans.getMzx(), trans.getMzy(), trans.getMzz(), trans.getMzt());
            }
            if (!this.focusGainedByMouseClick) {
                this.setCaretAnimating(true);
            }
        } else {
            if (PlatformUtil.isIOS() && textField.getScene() != null) {
                textField.getScene().getWindow().impl_getPeer().releaseInput();
            }
            this.focusGainedByMouseClick = false;
            this.setCaretAnimating(false);
        }
    }

    static Affine3D calculateNodeToSceneTransform(Node node) {
        Affine3D transform = new Affine3D();
        do {
            transform.preConcatenate(node.impl_getLeafTransform());
        } while ((node = node.getParent()) != null);
        return transform;
    }

    public void setTextFieldSkin(TextFieldSkin skin) {
        this.skin = skin;
    }

    @Override
    protected void fire(KeyEvent event) {
        TextField textField = (TextField)this.getControl();
        EventHandler<ActionEvent> onAction = textField.getOnAction();
        ActionEvent actionEvent = new ActionEvent(textField, null);
        textField.fireEvent(actionEvent);
        textField.commitValue();
        if (onAction == null && !actionEvent.isConsumed()) {
            this.forwardToParent(event);
        }
    }

    @Override
    protected void cancelEdit(KeyEvent event) {
        TextField textField = (TextField)this.getControl();
        if (textField.getTextFormatter() != null) {
            textField.cancelEdit();
        } else {
            this.forwardToParent(event);
        }
    }

    @Override
    protected void deleteChar(boolean previous) {
        this.skin.deleteChar(previous);
    }

    @Override
    protected void replaceText(int start, int end, String txt) {
        this.skin.replaceText(start, end, txt);
    }

    @Override
    protected void deleteFromLineStart() {
        TextField textField = (TextField)this.getControl();
        int end = textField.getCaretPosition();
        if (end > 0) {
            this.replaceText(0, end, "");
        }
    }

    @Override
    protected void setCaretAnimating(boolean play) {
        if (this.skin != null) {
            this.skin.setCaretAnimating(play);
        }
    }

    private void beep() {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TextField textField = (TextField)this.getControl();
        super.mousePressed(e);
        if (!textField.isDisabled()) {
            if (!textField.isFocused()) {
                this.focusGainedByMouseClick = true;
                textField.requestFocus();
            }
            this.setCaretAnimating(false);
            if (e.isPrimaryButtonDown() && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown()) {
                HitInfo hit = this.skin.getIndex(e.getX(), e.getY());
                String text = textField.textProperty().getValueSafe();
                int i = com.sun.javafx.scene.control.skin.Utils.getHitInsertionIndex(hit, text);
                int anchor = textField.getAnchor();
                int caretPosition = textField.getCaretPosition();
                if (e.getClickCount() < 2 && (IS_TOUCH_SUPPORTED || anchor != caretPosition && (i > anchor && i < caretPosition || i < anchor && i > caretPosition))) {
                    this.deferClick = true;
                } else if (!(e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown())) {
                    switch (e.getClickCount()) {
                        case 1: {
                            this.mouseSingleClick(hit);
                            break;
                        }
                        case 2: {
                            this.mouseDoubleClick(hit);
                            break;
                        }
                        case 3: {
                            this.mouseTripleClick(hit);
                            break;
                        }
                    }
                } else if (e.isShiftDown() && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown() && e.getClickCount() == 1) {
                    this.shiftDown = true;
                    if (PlatformUtil.isMac()) {
                        textField.extendSelection(i);
                    } else {
                        this.skin.positionCaret(hit, true);
                    }
                }
                this.skin.setForwardBias(hit.isLeading());
            }
        }
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        TextField textField = (TextField)this.getControl();
        if (!(textField.isDisabled() || this.deferClick || !e.isPrimaryButtonDown() || e.isMiddleButtonDown() || e.isSecondaryButtonDown() || e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown())) {
            this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TextField textField = (TextField)this.getControl();
        super.mouseReleased(e);
        if (!textField.isDisabled()) {
            this.setCaretAnimating(false);
            if (this.deferClick) {
                this.deferClick = false;
                this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), this.shiftDown);
                this.shiftDown = false;
            }
            this.setCaretAnimating(true);
        }
    }

    @Override
    public void contextMenuRequested(ContextMenuEvent e) {
        TextField textField = (TextField)this.getControl();
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        } else if (textField.getContextMenu() == null) {
            double screenX = e.getScreenX();
            double screenY = e.getScreenY();
            double sceneX = e.getSceneX();
            if (IS_TOUCH_SUPPORTED) {
                Point2D menuPos;
                if (textField.getSelection().getLength() == 0) {
                    this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), false);
                    menuPos = this.skin.getMenuPosition();
                } else {
                    menuPos = this.skin.getMenuPosition();
                    if (menuPos != null && (menuPos.getX() <= 0.0 || menuPos.getY() <= 0.0)) {
                        this.skin.positionCaret(this.skin.getIndex(e.getX(), e.getY()), false);
                        menuPos = this.skin.getMenuPosition();
                    }
                }
                if (menuPos != null) {
                    Point2D p = ((TextField)this.getControl()).localToScene(menuPos);
                    Scene scene = ((TextField)this.getControl()).getScene();
                    Window window = scene.getWindow();
                    Point2D location = new Point2D(window.getX() + scene.getX() + p.getX(), window.getY() + scene.getY() + p.getY());
                    screenX = location.getX();
                    sceneX = p.getX();
                    screenY = location.getY();
                }
            }
            this.skin.populateContextMenu(this.contextMenu);
            double menuWidth = this.contextMenu.prefWidth(-1.0);
            double menuX = screenX - (IS_TOUCH_SUPPORTED ? menuWidth / 2.0 : 0.0);
            Screen currentScreen = Utils.getScreenForPoint(screenX, 0.0);
            Rectangle2D bounds = currentScreen.getBounds();
            if (menuX < bounds.getMinX()) {
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", screenX);
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", sceneX);
                this.contextMenu.show((Node)this.getControl(), bounds.getMinX(), screenY);
            } else if (screenX + menuWidth > bounds.getMaxX()) {
                double leftOver = menuWidth - (bounds.getMaxX() - screenX);
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", screenX);
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", sceneX);
                this.contextMenu.show((Node)this.getControl(), screenX - leftOver, screenY);
            } else {
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCREEN_X", 0);
                ((TextField)this.getControl()).getProperties().put("CONTEXT_MENU_SCENE_X", 0);
                this.contextMenu.show((Node)this.getControl(), menuX, screenY);
            }
        }
        e.consume();
    }

    protected void mouseSingleClick(HitInfo hit) {
        this.skin.positionCaret(hit, false);
    }

    protected void mouseDoubleClick(HitInfo hit) {
        TextField textField = (TextField)this.getControl();
        textField.previousWord();
        if (PlatformUtil.isWindows()) {
            textField.selectNextWord();
        } else {
            textField.selectEndOfNextWord();
        }
    }

    protected void mouseTripleClick(HitInfo hit) {
        ((TextField)this.getControl()).selectAll();
    }

    static /* synthetic */ void lambda$new$188(WeakChangeListener weakChangeListener, ObservableValue observable, Scene oldValue, Scene newValue) {
        if (oldValue != null) {
            oldValue.focusOwnerProperty().removeListener(weakChangeListener);
        }
        if (newValue != null) {
            newValue.focusOwnerProperty().addListener(weakChangeListener);
        }
    }

    /* synthetic */ void lambda$new$187(TextField textField, ObservableValue observable, Node oldValue, Node newValue) {
        if (newValue == textField) {
            if (!this.focusGainedByMouseClick) {
                textField.selectRange(textField.getLength(), 0);
            }
        } else {
            textField.selectRange(0, 0);
        }
    }

    /* synthetic */ void lambda$new$186(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        this.handleFocusChange();
    }

    static enum TextInputTypes {
        TEXT_FIELD,
        PASSWORD_FIELD,
        EDITABLE_COMBO,
        TEXT_AREA;

    }
}

