/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TitledPaneBehavior
extends BehaviorBase<TitledPane> {
    private TitledPane titledPane;
    private static final String PRESS_ACTION = "Press";
    protected static final List<KeyBinding> TITLEDPANE_BINDINGS = new ArrayList<KeyBinding>();

    public TitledPaneBehavior(TitledPane pane) {
        super(pane, TITLEDPANE_BINDINGS);
        this.titledPane = pane;
    }

    @Override
    protected void callAction(String name) {
        switch (name) {
            case "Press": {
                if (!this.titledPane.isCollapsible() || !this.titledPane.isFocused()) break;
                this.titledPane.setExpanded(!this.titledPane.isExpanded());
                this.titledPane.requestFocus();
                break;
            }
            default: {
                super.callAction(name);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        TitledPane tp = (TitledPane)this.getControl();
        tp.requestFocus();
    }

    public void expand() {
        this.titledPane.setExpanded(true);
    }

    public void collapse() {
        this.titledPane.setExpanded(false);
    }

    public void toggle() {
        this.titledPane.setExpanded(!this.titledPane.isExpanded());
    }

    static {
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, PRESS_ACTION));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, PRESS_ACTION));
    }
}

