/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;

public class ToggleButtonBehavior<C extends ToggleButton>
extends ButtonBehavior<C> {
    protected static final List<KeyBinding> TOGGLE_BUTTON_BINDINGS = new ArrayList<KeyBinding>();

    public ToggleButtonBehavior(C button) {
        super(button, TOGGLE_BUTTON_BINDINGS);
    }

    private int nextToggleIndex(ObservableList<Toggle> toggles, int from) {
        Toggle toggle;
        if (from < 0 || from >= toggles.size()) {
            return 0;
        }
        int i = (from + 1) % toggles.size();
        while (i != from && (toggle = (Toggle)toggles.get(i)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            i = (i + 1) % toggles.size();
        }
        return i;
    }

    private int previousToggleIndex(ObservableList<Toggle> toggles, int from) {
        Toggle toggle;
        if (from < 0 || from >= toggles.size()) {
            return toggles.size();
        }
        int i = ToggleButtonBehavior.floorMod(from - 1, toggles.size());
        while (i != from && (toggle = (Toggle)toggles.get(i)) instanceof Node && ((Node)((Object)toggle)).isDisabled()) {
            i = ToggleButtonBehavior.floorMod(i - 1, toggles.size());
        }
        return i;
    }

    @Override
    protected void callAction(String name) {
        ToggleButton toggleButton = (ToggleButton)this.getControl();
        ToggleGroup toggleGroup = toggleButton.getToggleGroup();
        if (toggleGroup == null) {
            super.callAction(name);
            return;
        }
        ObservableList<Toggle> toggles = toggleGroup.getToggles();
        int currentToggleIdx = toggles.indexOf(toggleButton);
        switch (name) {
            case "ToggleNext-Right": 
            case "ToggleNext-Down": 
            case "TogglePrevious-Left": 
            case "TogglePrevious-Up": {
                boolean traversingToNext = this.traversingToNext(name, toggleButton.getEffectiveNodeOrientation());
                if (Utils.isTwoLevelFocus()) {
                    super.callAction(this.toggleToTraverseAction(name));
                    break;
                }
                if (traversingToNext) {
                    int nextToggleIndex = this.nextToggleIndex(toggles, currentToggleIdx);
                    if (nextToggleIndex == currentToggleIdx) {
                        super.callAction(this.toggleToTraverseAction(name));
                        break;
                    }
                    Toggle toggle = (Toggle)toggles.get(nextToggleIndex);
                    toggleGroup.selectToggle(toggle);
                    ((Control)((Object)toggle)).requestFocus();
                    break;
                }
                int prevToggleIndex = this.previousToggleIndex(toggles, currentToggleIdx);
                if (prevToggleIndex == currentToggleIdx) {
                    super.callAction(this.toggleToTraverseAction(name));
                    break;
                }
                Toggle toggle = (Toggle)toggles.get(prevToggleIndex);
                toggleGroup.selectToggle(toggle);
                ((Control)((Object)toggle)).requestFocus();
                break;
            }
            default: {
                super.callAction(name);
            }
        }
    }

    private boolean traversingToNext(String name, NodeOrientation effectiveNodeOrientation) {
        boolean rtl = effectiveNodeOrientation == NodeOrientation.RIGHT_TO_LEFT;
        switch (name) {
            case "ToggleNext-Right": {
                return !rtl;
            }
            case "ToggleNext-Down": {
                return true;
            }
            case "TogglePrevious-Left": {
                return rtl;
            }
            case "TogglePrevious-Up": {
                return false;
            }
        }
        throw new IllegalArgumentException("Not a toggle action");
    }

    private String toggleToTraverseAction(String name) {
        switch (name) {
            case "ToggleNext-Right": {
                return "TraverseRight";
            }
            case "ToggleNext-Down": {
                return "TraverseDown";
            }
            case "TogglePrevious-Left": {
                return "TraverseLeft";
            }
            case "TogglePrevious-Up": {
                return "TraverseUp";
            }
        }
        throw new IllegalArgumentException("Not a toggle action");
    }

    private static int floorMod(int a, int b) {
        return (a % b + b) % b;
    }

    static {
        TOGGLE_BUTTON_BINDINGS.addAll(BUTTON_BINDINGS);
        TOGGLE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "ToggleNext-Right"));
        TOGGLE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TogglePrevious-Left"));
        TOGGLE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "ToggleNext-Down"));
        TOGGLE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.UP, "TogglePrevious-Up"));
    }
}

