/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase$$Lambda$1;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;

public abstract class BehaviorSkinBase<C extends Control, BB extends BehaviorBase<C>>
extends SkinBase<C> {
    protected static final boolean IS_TOUCH_SUPPORTED = Platform.isSupported(ConditionalFeature.INPUT_TOUCH);
    private BB behavior;
    private MultiplePropertyChangeListenerHandler changeListenerHandler;
    private final EventHandler<MouseEvent> mouseHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent e) {
            EventType<? extends MouseEvent> type = e.getEventType();
            if (type == MouseEvent.MOUSE_ENTERED) {
                BehaviorSkinBase.this.behavior.mouseEntered(e);
            } else if (type == MouseEvent.MOUSE_EXITED) {
                BehaviorSkinBase.this.behavior.mouseExited(e);
            } else if (type == MouseEvent.MOUSE_PRESSED) {
                BehaviorSkinBase.this.behavior.mousePressed(e);
            } else if (type == MouseEvent.MOUSE_RELEASED) {
                BehaviorSkinBase.this.behavior.mouseReleased(e);
            } else if (type == MouseEvent.MOUSE_DRAGGED) {
                BehaviorSkinBase.this.behavior.mouseDragged(e);
            } else {
                throw new AssertionError((Object)"Unsupported event type received");
            }
        }
    };
    private final EventHandler<ContextMenuEvent> contextMenuHandler = new EventHandler<ContextMenuEvent>(){

        @Override
        public void handle(ContextMenuEvent event) {
            BehaviorSkinBase.this.behavior.contextMenuRequested(event);
        }
    };

    protected BehaviorSkinBase(C control, BB behavior) {
        super(control);
        if (behavior == null) {
            throw new IllegalArgumentException("Cannot pass null for behavior");
        }
        this.behavior = behavior;
        ((Node)control).addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
        ((Node)control).addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
        ((Node)control).addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
        ((Node)control).addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
        ((Node)control).addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        ((Node)control).addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this.contextMenuHandler);
    }

    public final BB getBehavior() {
        return this.behavior;
    }

    @Override
    public void dispose() {
        Skinnable control;
        if (this.changeListenerHandler != null) {
            this.changeListenerHandler.dispose();
        }
        if ((control = this.getSkinnable()) != null) {
            ((Node)((Object)control)).removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseHandler);
            ((Node)((Object)control)).removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseHandler);
            ((Node)((Object)control)).removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseHandler);
            ((Node)((Object)control)).removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseHandler);
            ((Node)((Object)control)).removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseHandler);
        }
        if (this.behavior != null) {
            ((BehaviorBase)this.behavior).dispose();
            this.behavior = null;
        }
        super.dispose();
    }

    protected final void registerChangeListener(ObservableValue<?> property, String reference) {
        if (this.changeListenerHandler == null) {
            this.changeListenerHandler = new MultiplePropertyChangeListenerHandler(BehaviorSkinBase$$Lambda$1.lambdaFactory$(this));
        }
        this.changeListenerHandler.registerChangeListener(property, reference);
    }

    protected void handleControlPropertyChanged(String propertyReference) {
    }

    /* synthetic */ Void lambda$registerChangeListener$61(String p) {
        this.handleControlPropertyChanged(p);
        return null;
    }
}

