/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ChoiceBoxBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ChoiceBoxSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ChoiceBoxSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ChoiceBoxSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;

public class ChoiceBoxSkin<T>
extends BehaviorSkinBase<ChoiceBox<T>, ChoiceBoxBehavior<T>> {
    private ObservableList<T> choiceBoxItems;
    private ContextMenu popup;
    private StackPane openButton;
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private SelectionModel<T> selectionModel;
    private Label label;
    private final ListChangeListener<T> choiceBoxItemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> c) {
            while (c.next()) {
                int i;
                if (c.getRemovedSize() > 0 || c.wasPermutated()) {
                    ChoiceBoxSkin.this.toggleGroup.getToggles().clear();
                    ChoiceBoxSkin.this.popup.getItems().clear();
                    i = 0;
                    for (Object obj : c.getList()) {
                        ChoiceBoxSkin.this.addPopupItem(obj, i);
                        ++i;
                    }
                    continue;
                }
                for (i = c.getFrom(); i < c.getTo(); ++i) {
                    Object obj = c.getList().get(i);
                    ChoiceBoxSkin.this.addPopupItem(obj, i);
                }
            }
            ChoiceBoxSkin.this.updateSelection();
            ((ChoiceBox)ChoiceBoxSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakChoiceBoxItemsListener = new WeakListChangeListener<T>(this.choiceBoxItemsListener);
    private InvalidationListener selectionChangeListener = ChoiceBoxSkin$$Lambda$1.lambdaFactory$(this);

    public ChoiceBoxSkin(ChoiceBox<T> control) {
        super(control, new ChoiceBoxBehavior<T>(control));
        this.initialize();
        control.requestLayout();
        this.registerChangeListener(control.selectionModelProperty(), "SELECTION_MODEL");
        this.registerChangeListener(control.showingProperty(), "SHOWING");
        this.registerChangeListener(control.itemsProperty(), "ITEMS");
        this.registerChangeListener(control.getSelectionModel().selectedItemProperty(), "SELECTION_CHANGED");
        this.registerChangeListener(control.converterProperty(), "CONVERTER");
    }

    private void initialize() {
        this.updateChoiceBoxItems();
        this.label = new Label();
        this.label.setMnemonicParsing(false);
        this.openButton = new StackPane();
        this.openButton.getStyleClass().setAll((String[])new String[]{"open-button"});
        StackPane region = new StackPane();
        region.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.openButton.getChildren().clear();
        this.openButton.getChildren().addAll((Node[])new Node[]{region});
        this.popup = new ContextMenu();
        this.popup.showingProperty().addListener(ChoiceBoxSkin$$Lambda$2.lambdaFactory$(this));
        this.popup.setId("choice-box-popup-menu");
        this.getChildren().setAll((Node[])new Node[]{this.label, this.openButton});
        this.updatePopupItems();
        this.updateSelectionModel();
        this.updateSelection();
        if (this.selectionModel != null && this.selectionModel.getSelectedIndex() == -1) {
            this.label.setText("");
        }
    }

    private void updateChoiceBoxItems() {
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.removeListener(this.weakChoiceBoxItemsListener);
        }
        this.choiceBoxItems = ((ChoiceBox)this.getSkinnable()).getItems();
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.addListener(this.weakChoiceBoxItemsListener);
        }
    }

    String getChoiceBoxSelectedText() {
        return this.label.getText();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ITEMS".equals(p)) {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
            this.updateSelectionModel();
            this.updateSelection();
            if (this.selectionModel != null && this.selectionModel.getSelectedIndex() == -1) {
                this.label.setText("");
            }
        } else if ("SELECTION_MODEL".equals(p)) {
            this.updateSelectionModel();
        } else if ("SELECTION_CHANGED".equals(p)) {
            MenuItem item;
            int index;
            if (((ChoiceBox)this.getSkinnable()).getSelectionModel() != null && (index = ((ChoiceBox)this.getSkinnable()).getSelectionModel().getSelectedIndex()) != -1 && (item = (MenuItem)this.popup.getItems().get(index)) instanceof RadioMenuItem) {
                ((RadioMenuItem)item).setSelected(true);
            }
        } else if ("SHOWING".equals(p)) {
            if (((ChoiceBox)this.getSkinnable()).isShowing()) {
                ContextMenuContent cmContent;
                boolean hasSelection;
                MenuItem item = null;
                SingleSelectionModel sm = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
                if (sm == null) {
                    return;
                }
                long currentSelectedIndex = sm.getSelectedIndex();
                int itemInControlCount = this.choiceBoxItems.size();
                boolean bl = hasSelection = currentSelectedIndex >= 0L && currentSelectedIndex < (long)itemInControlCount;
                if (hasSelection) {
                    item = (MenuItem)this.popup.getItems().get((int)currentSelectedIndex);
                    if (item != null && item instanceof RadioMenuItem) {
                        ((RadioMenuItem)item).setSelected(true);
                    }
                } else if (itemInControlCount > 0) {
                    item = (MenuItem)this.popup.getItems().get(0);
                }
                ((ChoiceBox)this.getSkinnable()).autosize();
                double y = 0.0;
                if (this.popup.getSkin() != null && (cmContent = (ContextMenuContent)this.popup.getSkin().getNode()) != null && currentSelectedIndex != -1L) {
                    y = -cmContent.getMenuYOffset((int)currentSelectedIndex);
                }
                this.popup.show((Node)((Object)this.getSkinnable()), Side.BOTTOM, 2.0, y);
            } else {
                this.popup.hide();
            }
        } else if ("CONVERTER".equals(p)) {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
        }
    }

    private void addPopupItem(T o, int i) {
        MenuItem popupItem = null;
        if (o instanceof Separator) {
            popupItem = new SeparatorMenuItem();
        } else if (o instanceof SeparatorMenuItem) {
            popupItem = (SeparatorMenuItem)o;
        } else {
            StringConverter<T> c = ((ChoiceBox)this.getSkinnable()).getConverter();
            String displayString = c == null ? (o == null ? "" : o.toString()) : c.toString(o);
            RadioMenuItem item = new RadioMenuItem(displayString);
            item.setId("choice-box-menu-item");
            item.setToggleGroup(this.toggleGroup);
            item.setOnAction(ChoiceBoxSkin$$Lambda$3.lambdaFactory$(this, o, item));
            popupItem = item;
        }
        popupItem.setMnemonicParsing(false);
        this.popup.getItems().add(i, popupItem);
    }

    private void updatePopupItems() {
        this.toggleGroup.getToggles().clear();
        this.popup.getItems().clear();
        this.toggleGroup.selectToggle(null);
        for (int i = 0; i < this.choiceBoxItems.size(); ++i) {
            Object o = this.choiceBoxItems.get(i);
            this.addPopupItem(o, i);
        }
    }

    private void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().removeListener(this.selectionChangeListener);
        }
        this.selectionModel = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().addListener(this.selectionChangeListener);
        }
    }

    private void updateSelection() {
        if (this.selectionModel == null || this.selectionModel.isEmpty()) {
            this.toggleGroup.selectToggle(null);
            this.label.setText("");
        } else {
            int selectedIndex = this.selectionModel.getSelectedIndex();
            if (selectedIndex == -1 || selectedIndex > this.popup.getItems().size()) {
                this.label.setText("");
                return;
            }
            if (selectedIndex < this.popup.getItems().size()) {
                MenuItem selectedItem = (MenuItem)this.popup.getItems().get(selectedIndex);
                if (selectedItem instanceof RadioMenuItem) {
                    ((RadioMenuItem)selectedItem).setSelected(true);
                    this.toggleGroup.selectToggle(null);
                }
                this.label.setText(((MenuItem)this.popup.getItems().get(selectedIndex)).getText());
            }
        }
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double obw = this.openButton.prefWidth(-1.0);
        ChoiceBox control = (ChoiceBox)this.getSkinnable();
        this.label.resizeRelocate(x, y, w, h);
        this.openButton.resize(obw, this.openButton.prefHeight(-1.0));
        this.positionInArea(this.openButton, x + w - obw, y, obw, h, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double boxWidth = this.label.minWidth(-1.0) + this.openButton.minWidth(-1.0);
        double popupWidth = this.popup.minWidth(-1.0);
        return leftInset + Math.max(boxWidth, popupWidth) + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double displayHeight = this.label.minHeight(-1.0);
        double openButtonHeight = this.openButton.minHeight(-1.0);
        return topInset + Math.max(displayHeight, openButtonHeight) + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double boxWidth = this.label.prefWidth(-1.0) + this.openButton.prefWidth(-1.0);
        double popupWidth = this.popup.prefWidth(-1.0);
        if (popupWidth <= 0.0 && this.popup.getItems().size() > 0) {
            popupWidth = new Text(((MenuItem)this.popup.getItems().get(0)).getText()).prefWidth(-1.0);
        }
        return this.popup.getItems().size() == 0 ? 50.0 : leftInset + Math.max(boxWidth, popupWidth) + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double displayHeight = this.label.prefHeight(-1.0);
        double openButtonHeight = this.openButton.prefHeight(-1.0);
        return topInset + Math.max(displayHeight, openButtonHeight) + bottomInset;
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ChoiceBox)this.getSkinnable()).prefHeight(width);
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ChoiceBox)this.getSkinnable()).prefWidth(height);
    }

    /* synthetic */ void lambda$new$283(Observable observable) {
        this.updateSelection();
    }

    /* synthetic */ void lambda$addPopupItem$282(Object object, RadioMenuItem radioMenuItem, ActionEvent e) {
        if (this.selectionModel == null) {
            return;
        }
        int index = ((ChoiceBox)this.getSkinnable()).getItems().indexOf(object);
        this.selectionModel.select(index);
        radioMenuItem.setSelected(true);
    }

    /* synthetic */ void lambda$initialize$281(ObservableValue o, Boolean ov, Boolean nv) {
        if (!nv.booleanValue()) {
            ((ChoiceBox)this.getSkinnable()).hide();
        }
    }
}

