/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxListViewBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxListViewSkin<T>
extends ComboBoxPopupControl<T> {
    private static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    private final ComboBox<T> comboBox;
    private ObservableList<T> comboBoxItems;
    private ListCell<T> buttonCell;
    private Callback<ListView<T>, ListCell<T>> cellFactory;
    private TextField textField;
    private final ListView<T> listView;
    private ObservableList<T> listViewItems;
    private boolean listSelectionLock = false;
    private boolean listViewSelectionDirty = false;
    private boolean itemCountDirty;
    private final ListChangeListener<T> listViewItemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> c) {
            ComboBoxListViewSkin.this.itemCountDirty = true;
            ((ComboBoxBase)ComboBoxListViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private EventHandler<KeyEvent> textFieldKeyEventHandler = ComboBoxListViewSkin$$Lambda$1.lambdaFactory$(this);
    private EventHandler<MouseEvent> textFieldMouseEventHandler = ComboBoxListViewSkin$$Lambda$2.lambdaFactory$(this);
    private EventHandler<DragEvent> textFieldDragEventHandler = ComboBoxListViewSkin$$Lambda$3.lambdaFactory$(this);
    private String initialTextFieldValue = null;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass PSEUDO_CLASS_EMPTY = PseudoClass.getPseudoClass("empty");
    private static final PseudoClass PSEUDO_CLASS_FILLED = PseudoClass.getPseudoClass("filled");

    public ComboBoxListViewSkin(ComboBox<T> comboBox) {
        super(comboBox, new ComboBoxListViewBehavior<T>(comboBox));
        this.comboBox = comboBox;
        this.updateComboBoxItems();
        TextField textField = this.textField = comboBox.isEditable() ? this.getEditableInputNode() : null;
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        this.listView = this.createListView();
        this.listView.setManaged(false);
        this.getChildren().add(this.listView);
        this.updateListViewItems();
        this.updateCellFactory();
        this.updateButtonCell();
        comboBox.focusedProperty().addListener(ComboBoxListViewSkin$$Lambda$4.lambdaFactory$(this, comboBox));
        comboBox.addEventFilter(KeyEvent.ANY, ComboBoxListViewSkin$$Lambda$5.lambdaFactory$(this, comboBox));
        if (comboBox.getOnInputMethodTextChanged() == null) {
            comboBox.setOnInputMethodTextChanged(ComboBoxListViewSkin$$Lambda$6.lambdaFactory$(this, comboBox));
        }
        this.updateEditable();
        this.updateValue();
        comboBox.setImpl_traversalEngine(new ParentTraversalEngine(comboBox, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return null;
            }
        }));
        this.registerChangeListener(comboBox.itemsProperty(), "ITEMS");
        this.registerChangeListener(comboBox.promptTextProperty(), "PROMPT_TEXT");
        this.registerChangeListener(comboBox.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(comboBox.visibleRowCountProperty(), "VISIBLE_ROW_COUNT");
        this.registerChangeListener(comboBox.converterProperty(), "CONVERTER");
        this.registerChangeListener(comboBox.buttonCellProperty(), "BUTTON_CELL");
        this.registerChangeListener(comboBox.valueProperty(), "VALUE");
        this.registerChangeListener(comboBox.editableProperty(), "EDITABLE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ITEMS".equals(p)) {
            this.updateComboBoxItems();
            this.updateListViewItems();
        } else if ("PROMPT_TEXT".equals(p)) {
            this.updateDisplayNode();
        } else if ("CELL_FACTORY".equals(p)) {
            this.updateCellFactory();
        } else if ("VISIBLE_ROW_COUNT".equals(p)) {
            if (this.listView == null) {
                return;
            }
            this.listView.requestLayout();
        } else if ("CONVERTER".equals(p)) {
            this.updateListViewItems();
        } else if ("EDITOR".equals(p)) {
            this.getEditableInputNode();
        } else if ("BUTTON_CELL".equals(p)) {
            this.updateButtonCell();
        } else if ("VALUE".equals(p)) {
            this.updateValue();
            this.comboBox.fireEvent(new ActionEvent());
        } else if ("EDITABLE".equals(p)) {
            this.updateEditable();
        }
    }

    private void updateEditable() {
        final TextField newTextField = this.comboBox.getEditor();
        if (!this.comboBox.isEditable()) {
            if (this.textField != null) {
                this.textField.removeEventFilter(KeyEvent.ANY, this.textFieldKeyEventHandler);
                this.textField.removeEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
                this.textField.removeEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
                this.comboBox.setInputMethodRequests(null);
            }
        } else if (newTextField != null) {
            newTextField.addEventFilter(KeyEvent.ANY, this.textFieldKeyEventHandler);
            newTextField.addEventFilter(MouseEvent.DRAG_DETECTED, this.textFieldMouseEventHandler);
            newTextField.addEventFilter(DragEvent.ANY, this.textFieldDragEventHandler);
            this.comboBox.setInputMethodRequests(new ExtendedInputMethodRequests(){

                @Override
                public Point2D getTextLocation(int offset) {
                    return newTextField.getInputMethodRequests().getTextLocation(offset);
                }

                @Override
                public int getLocationOffset(int x, int y) {
                    return newTextField.getInputMethodRequests().getLocationOffset(x, y);
                }

                @Override
                public void cancelLatestCommittedText() {
                    newTextField.getInputMethodRequests().cancelLatestCommittedText();
                }

                @Override
                public String getSelectedText() {
                    return newTextField.getInputMethodRequests().getSelectedText();
                }

                @Override
                public int getInsertPositionOffset() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getInsertPositionOffset();
                }

                @Override
                public String getCommittedText(int begin, int end) {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedText(begin, end);
                }

                @Override
                public int getCommittedTextLength() {
                    return ((ExtendedInputMethodRequests)newTextField.getInputMethodRequests()).getCommittedTextLength();
                }
            });
        }
        this.textField = newTextField;
    }

    @Override
    public Node getDisplayNode() {
        Control displayNode = this.comboBox.isEditable() ? this.getEditableInputNode() : this.buttonCell;
        this.updateDisplayNode();
        return displayNode;
    }

    public void updateComboBoxItems() {
        this.comboBoxItems = this.comboBox.getItems();
        this.comboBoxItems = this.comboBoxItems == null ? FXCollections.emptyObservableList() : this.comboBoxItems;
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = this.comboBoxItems;
        this.listView.setItems(this.listViewItems);
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.itemCountDirty = true;
        ((ComboBoxBase)this.getSkinnable()).requestLayout();
    }

    @Override
    public Node getPopupContent() {
        return this.listView;
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return 50.0;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double superPrefWidth = super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        double listViewWidth = this.listView.prefWidth(height);
        double pw = Math.max(superPrefWidth, listViewWidth);
        this.reconfigurePopup();
        return pw;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return super.computeMaxWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.reconfigurePopup();
        return super.computeMaxHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.listViewSelectionDirty) {
            try {
                this.listSelectionLock = true;
                Object item = this.comboBox.getSelectionModel().getSelectedItem();
                this.listView.getSelectionModel().clearSelection();
                this.listView.getSelectionModel().select(item);
            }
            finally {
                this.listSelectionLock = false;
                this.listViewSelectionDirty = false;
            }
        }
        super.layoutChildren(x, y, w, h);
    }

    protected boolean isHideOnClickEnabled() {
        return true;
    }

    private void handleKeyEvent(KeyEvent ke, boolean doConsume) {
        if (ke.getCode() == KeyCode.ENTER) {
            this.setTextFromTextFieldIntoComboBoxValue();
            if (doConsume) {
                ke.consume();
            }
        } else if (ke.getCode() == KeyCode.F4) {
            if (ke.getEventType() == KeyEvent.KEY_RELEASED) {
                if (this.comboBox.isShowing()) {
                    this.comboBox.hide();
                } else {
                    this.comboBox.show();
                }
            }
            ke.consume();
        } else if ((ke.getCode() == KeyCode.F10 || ke.getCode() == KeyCode.ESCAPE) && doConsume) {
            ke.consume();
        }
    }

    private void updateValue() {
        Object newValue = this.comboBox.getValue();
        MultipleSelectionModel listViewSM = this.listView.getSelectionModel();
        if (newValue == null) {
            listViewSM.clearSelection();
        } else {
            int indexOfNewValue = this.getIndexOfComboBoxValueInItemsList();
            if (indexOfNewValue == -1) {
                this.listSelectionLock = true;
                listViewSM.clearSelection();
                this.listSelectionLock = false;
            } else {
                int index = this.comboBox.getSelectionModel().getSelectedIndex();
                if (index >= 0 && index < this.comboBoxItems.size()) {
                    Object itemsObj = this.comboBoxItems.get(index);
                    if (itemsObj != null && itemsObj.equals(newValue)) {
                        listViewSM.select(index);
                    } else {
                        listViewSM.select(newValue);
                    }
                } else {
                    int listViewIndex = this.comboBoxItems.indexOf(newValue);
                    if (listViewIndex == -1) {
                        this.updateDisplayNode();
                    } else {
                        listViewSM.select(listViewIndex);
                    }
                }
            }
        }
    }

    private TextField getEditableInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.comboBox.getEditor();
        this.textField.focusTraversableProperty().bindBidirectional(this.comboBox.focusTraversableProperty());
        this.textField.promptTextProperty().bind(this.comboBox.promptTextProperty());
        this.textField.tooltipProperty().bind(this.comboBox.tooltipProperty());
        this.initialTextFieldValue = this.textField.getText();
        this.textField.focusedProperty().addListener(ComboBoxListViewSkin$$Lambda$7.lambdaFactory$(this));
        return this.textField;
    }

    private void updateDisplayNode() {
        StringConverter c = this.comboBox.getConverter();
        if (c == null) {
            return;
        }
        Object value = this.comboBox.getValue();
        if (this.comboBox.isEditable()) {
            if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
                this.textField.setText(this.initialTextFieldValue);
                this.initialTextFieldValue = null;
            } else {
                String stringValue = c.toString(value);
                if (value == null || stringValue == null) {
                    this.textField.setText("");
                } else if (!stringValue.equals(this.textField.getText())) {
                    this.textField.setText(stringValue);
                }
            }
        } else {
            int index = this.getIndexOfComboBoxValueInItemsList();
            if (index > -1) {
                this.buttonCell.setItem(null);
                this.buttonCell.updateIndex(index);
            } else {
                this.buttonCell.updateIndex(-1);
                boolean empty = this.updateDisplayText(this.buttonCell, value, false);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_EMPTY, empty);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_FILLED, !empty);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
            }
        }
    }

    private boolean updateDisplayText(ListCell<T> cell, T item, boolean empty) {
        if (empty) {
            if (cell == null) {
                return true;
            }
            cell.setGraphic(null);
            cell.setText(null);
            return true;
        }
        if (item instanceof Node) {
            Node currentNode = cell.getGraphic();
            Node newNode = (Node)item;
            if (currentNode == null || !currentNode.equals(newNode)) {
                cell.setText(null);
                cell.setGraphic(newNode);
            }
            return newNode == null;
        }
        StringConverter<T> c = this.comboBox.getConverter();
        String s = item == null ? this.comboBox.getPromptText() : (c == null ? item.toString() : c.toString(item));
        cell.setText(s);
        cell.setGraphic(null);
        return s == null || s.isEmpty();
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        Object value;
        if (!this.comboBox.isEditable()) {
            return;
        }
        StringConverter<T> c = this.comboBox.getConverter();
        if (c == null) {
            return;
        }
        Object oldValue = this.comboBox.getValue();
        String text = this.textField.getText();
        Object object = value = oldValue == null && (text == null || text.isEmpty()) ? null : (Object)c.fromString(this.textField.getText());
        if (value == null && oldValue == null || value != null && value.equals(oldValue)) {
            return;
        }
        this.comboBox.setValue(value);
    }

    private int getIndexOfComboBoxValueInItemsList() {
        Object value = this.comboBox.getValue();
        int index = this.comboBoxItems.indexOf(value);
        return index;
    }

    private void updateButtonCell() {
        this.buttonCell = this.comboBox.getButtonCell() != null ? this.comboBox.getButtonCell() : this.getDefaultCellFactory().call(this.listView);
        this.buttonCell.setMouseTransparent(true);
        this.buttonCell.updateListView(this.listView);
        this.updateDisplayArea();
        this.buttonCell.setAccessibleRole(AccessibleRole.NODE);
    }

    private void updateCellFactory() {
        Callback<ListView<T>, ListCell<T>> cf = this.comboBox.getCellFactory();
        this.cellFactory = cf != null ? cf : this.getDefaultCellFactory();
        this.listView.setCellFactory(this.cellFactory);
    }

    private Callback<ListView<T>, ListCell<T>> getDefaultCellFactory() {
        return new Callback<ListView<T>, ListCell<T>>(){

            @Override
            public ListCell<T> call(ListView<T> listView) {
                return new ListCell<T>(){

                    @Override
                    public void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        ComboBoxListViewSkin.this.updateDisplayText(this, item, empty);
                    }
                };
            }
        };
    }

    private ListView<T> createListView() {
        ListView _listView = new ListView<T>(){
            {
                this.getProperties().put("selectFirstRowByDefault", false);
            }

            @Override
            protected double computeMinHeight(double width) {
                return 30.0;
            }

            @Override
            protected double computePrefWidth(double height) {
                double pw;
                if (this.getSkin() instanceof ListViewSkin) {
                    ListViewSkin skin = (ListViewSkin)this.getSkin();
                    if (ComboBoxListViewSkin.this.itemCountDirty) {
                        skin.updateRowCount();
                        ComboBoxListViewSkin.this.itemCountDirty = false;
                    }
                    int rowsToMeasure = -1;
                    if (ComboBoxListViewSkin.this.comboBox.getProperties().containsKey(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY)) {
                        rowsToMeasure = (Integer)ComboBoxListViewSkin.this.comboBox.getProperties().get(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY);
                    }
                    pw = Math.max(ComboBoxListViewSkin.this.comboBox.getWidth(), skin.getMaxCellWidth(rowsToMeasure) + 30.0);
                } else {
                    pw = Math.max(100.0, ComboBoxListViewSkin.this.comboBox.getWidth());
                }
                if (this.getItems().isEmpty() && this.getPlaceholder() != null) {
                    pw = Math.max(super.computePrefWidth(height), pw);
                }
                return Math.max(50.0, pw);
            }

            @Override
            protected double computePrefHeight(double width) {
                return ComboBoxListViewSkin.this.getListViewPrefHeight();
            }
        };
        _listView.setId("list-view");
        _listView.placeholderProperty().bind(this.comboBox.placeholderProperty());
        _listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        _listView.setFocusTraversable(false);
        _listView.getSelectionModel().selectedIndexProperty().addListener(ComboBoxListViewSkin$$Lambda$8.lambdaFactory$(this));
        this.comboBox.getSelectionModel().selectedItemProperty().addListener(ComboBoxListViewSkin$$Lambda$9.lambdaFactory$(this));
        _listView.addEventFilter(MouseEvent.MOUSE_RELEASED, ComboBoxListViewSkin$$Lambda$10.lambdaFactory$(this));
        _listView.setOnKeyPressed(ComboBoxListViewSkin$$Lambda$11.lambdaFactory$(this));
        return _listView;
    }

    private double getListViewPrefHeight() {
        double ph;
        if (this.listView.getSkin() instanceof VirtualContainerBase) {
            int maxRows = this.comboBox.getVisibleRowCount();
            VirtualContainerBase skin = (VirtualContainerBase)this.listView.getSkin();
            ph = skin.getVirtualFlowPreferredHeight(maxRows);
        } else {
            double ch = this.comboBoxItems.size() * 25;
            ph = Math.min(ch, 200.0);
        }
        return ph;
    }

    public ListView<T> getListView() {
        return this.listView;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                if (this.comboBox.isShowing()) {
                    return this.listView.queryAccessibleAttribute(attribute, parameters);
                }
                return null;
            }
            case TEXT: {
                String title;
                String accText = this.comboBox.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                String string = title = this.comboBox.isEditable() ? this.textField.getText() : this.buttonCell.getText();
                if (title == null || title.isEmpty()) {
                    title = this.comboBox.getPromptText();
                }
                return title;
            }
            case SELECTION_START: {
                return this.textField.getSelection().getStart();
            }
            case SELECTION_END: {
                return this.textField.getSelection().getEnd();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$createListView$324(KeyEvent t) {
        if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.SPACE || t.getCode() == KeyCode.ESCAPE) {
            this.comboBox.hide();
        }
    }

    /* synthetic */ void lambda$createListView$323(MouseEvent t) {
        ObservableList<String> s;
        EventTarget target = t.getTarget();
        if (target instanceof Parent && ((s = ((Parent)target).getStyleClass()).contains("thumb") || s.contains("track") || s.contains("decrement-arrow") || s.contains("increment-arrow"))) {
            return;
        }
        if (this.isHideOnClickEnabled()) {
            this.comboBox.hide();
        }
    }

    /* synthetic */ void lambda$createListView$322(Observable o) {
        this.listViewSelectionDirty = true;
    }

    /* synthetic */ void lambda$createListView$321(Observable o) {
        if (this.listSelectionLock) {
            return;
        }
        int index = this.listView.getSelectionModel().getSelectedIndex();
        this.comboBox.getSelectionModel().select(index);
        this.updateDisplayNode();
        this.comboBox.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
    }

    /* synthetic */ void lambda$getEditableInputNode$320(ObservableValue ov, Boolean t, Boolean hasFocus) {
        if (!this.comboBox.isEditable()) {
            return;
        }
        this.comboBox.getProperties().put("FOCUSED", hasFocus);
        if (!hasFocus.booleanValue()) {
            this.setTextFromTextFieldIntoComboBoxValue();
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
        } else {
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
        }
    }

    /* synthetic */ void lambda$new$319(ComboBox comboBox, InputMethodEvent event) {
        if (this.textField != null && comboBox.isEditable() && comboBox.getScene().getFocusOwner() == comboBox && this.textField.getOnInputMethodTextChanged() != null) {
            this.textField.getOnInputMethodTextChanged().handle(event);
        }
    }

    /* synthetic */ void lambda$new$318(ComboBox comboBox, KeyEvent ke) {
        if (this.textField == null || !comboBox.isEditable()) {
            this.handleKeyEvent(ke, false);
        } else {
            if (ke.getTarget().equals(this.textField)) {
                return;
            }
            this.textField.fireEvent(ke.copyFor(this.textField, this.textField));
            ke.consume();
        }
    }

    /* synthetic */ void lambda$new$317(ComboBox comboBox, ObservableValue ov, Boolean t, Boolean hasFocus) {
        if (comboBox.isEditable()) {
            ((FakeFocusTextField)this.textField).setFakeFocus(hasFocus);
        }
    }

    /* synthetic */ void lambda$new$316(DragEvent event) {
        ComboBoxBase comboBox = (ComboBoxBase)this.getSkinnable();
        if (event.getTarget().equals(comboBox)) {
            return;
        }
        comboBox.fireEvent(event.copyFor(comboBox, comboBox));
        event.consume();
    }

    /* synthetic */ void lambda$new$315(MouseEvent event) {
        ComboBoxBase comboBox = (ComboBoxBase)this.getSkinnable();
        if (event.getTarget().equals(comboBox)) {
            return;
        }
        comboBox.fireEvent(event.copyFor(comboBox, comboBox));
        event.consume();
    }

    /* synthetic */ void lambda$new$314(KeyEvent event) {
        if (this.textField == null || !((ComboBoxBase)this.getSkinnable()).isEditable()) {
            return;
        }
        this.handleKeyEvent(event, true);
    }

    public static final class FakeFocusTextField
    extends TextField {
        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        @Override
        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return this.getParent();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }
}

