/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxBaseSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$1;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$2;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$3;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$4;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl$$Lambda$5;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.WindowEvent;

public abstract class ComboBoxPopupControl<T>
extends ComboBoxBaseSkin<T> {
    protected PopupControl popup;
    public static final String COMBO_BOX_STYLE_CLASS = "combo-box-popup";
    private boolean popupNeedsReconfiguring = true;

    public ComboBoxPopupControl(ComboBoxBase<T> comboBox, ComboBoxBaseBehavior<T> behavior) {
        super(comboBox, behavior);
    }

    protected abstract Node getPopupContent();

    protected PopupControl getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    @Override
    public void show() {
        if (this.getSkinnable() == null) {
            throw new IllegalStateException("ComboBox is null");
        }
        Node content = this.getPopupContent();
        if (content == null) {
            throw new IllegalStateException("Popup node is null");
        }
        if (this.getPopup().isShowing()) {
            return;
        }
        this.positionAndShowPopup();
    }

    @Override
    public void hide() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)((Object)this.getSkinnable()), this.getPopupContent(), HPos.CENTER, VPos.BOTTOM, 0.0, 0.0, false);
    }

    private void positionAndShowPopup() {
        PopupControl _popup = this.getPopup();
        _popup.getScene().setNodeOrientation(((ComboBoxBase)this.getSkinnable()).getEffectiveNodeOrientation());
        Node popupContent = this.getPopupContent();
        popupContent.applyCss();
        if (popupContent instanceof Region) {
            Region r = (Region)popupContent;
            double prefWidth = r.prefWidth(-1.0);
            double minWidth = r.minWidth(-1.0);
            double maxWidth = r.maxWidth(-1.0);
            double w = Math.min(Math.max(prefWidth, minWidth), Math.max(minWidth, maxWidth));
            double prefHeight = r.prefHeight(-1.0);
            double minHeight = r.minHeight(-1.0);
            double maxHeight = r.maxHeight(-1.0);
            double h = Math.min(Math.max(prefHeight, minHeight), Math.max(minHeight, maxHeight));
            popupContent.resize(this.snapSize(w), this.snapSize(h));
        } else {
            popupContent.autosize();
        }
        Point2D p = this.getPrefPopupPosition();
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getSkinnable();
        _popup.show(comboBoxBase.getScene().getWindow(), this.snapPosition(p.getX()), this.snapPosition(p.getY()));
        popupContent.requestFocus();
    }

    private void createPopup() {
        this.popup = new PopupControl(){
            {
                this.setSkin(new Skin<Skinnable>(){

                    @Override
                    public Skinnable getSkinnable() {
                        return ComboBoxPopupControl.this.getSkinnable();
                    }

                    @Override
                    public Node getNode() {
                        return ComboBoxPopupControl.this.getPopupContent();
                    }

                    @Override
                    public void dispose() {
                    }
                });
            }

            @Override
            public Styleable getStyleableParent() {
                return ComboBoxPopupControl.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add(COMBO_BOX_STYLE_CLASS);
        this.popup.setConsumeAutoHidingEvents(false);
        this.popup.setAutoHide(true);
        this.popup.setAutoFix(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnAutoHide(ComboBoxPopupControl$$Lambda$1.lambdaFactory$(this));
        this.popup.addEventHandler(MouseEvent.MOUSE_CLICKED, ComboBoxPopupControl$$Lambda$2.lambdaFactory$(this));
        this.popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, ComboBoxPopupControl$$Lambda$3.lambdaFactory$(this));
        InvalidationListener layoutPosListener = ComboBoxPopupControl$$Lambda$4.lambdaFactory$(this);
        ((ComboBoxBase)this.getSkinnable()).layoutXProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).layoutYProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).widthProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).heightProperty().addListener(layoutPosListener);
        ((ComboBoxBase)this.getSkinnable()).sceneProperty().addListener(ComboBoxPopupControl$$Lambda$5.lambdaFactory$(this));
    }

    void reconfigurePopup() {
        double newHeight;
        if (this.popup == null) {
            return;
        }
        boolean isShowing = this.popup.isShowing();
        if (!isShowing) {
            return;
        }
        if (!this.popupNeedsReconfiguring) {
            return;
        }
        this.popupNeedsReconfiguring = false;
        Point2D p = this.getPrefPopupPosition();
        Node popupContent = this.getPopupContent();
        double minWidth = popupContent.prefWidth(-1.0);
        double minHeight = popupContent.prefHeight(-1.0);
        if (p.getX() > -1.0) {
            this.popup.setAnchorX(p.getX());
        }
        if (p.getY() > -1.0) {
            this.popup.setAnchorY(p.getY());
        }
        if (minWidth > -1.0) {
            this.popup.setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.popup.setMinHeight(minHeight);
        }
        Bounds b = popupContent.getLayoutBounds();
        double currentWidth = b.getWidth();
        double currentHeight = b.getHeight();
        double newWidth = currentWidth < minWidth ? minWidth : currentWidth;
        double d = newHeight = currentHeight < minHeight ? minHeight : currentHeight;
        if (newWidth != currentWidth || newHeight != currentHeight) {
            popupContent.resize(newWidth, newHeight);
            if (popupContent instanceof Region) {
                ((Region)popupContent).setMinSize(newWidth, newHeight);
                ((Region)popupContent).setPrefSize(newWidth, newHeight);
            }
        }
    }

    /* synthetic */ void lambda$createPopup$293(Observable o) {
        if (((ObservableValue)o).getValue() == null) {
            this.hide();
        }
    }

    /* synthetic */ void lambda$createPopup$292(Observable o) {
        this.popupNeedsReconfiguring = true;
        this.reconfigurePopup();
    }

    /* synthetic */ void lambda$createPopup$291(WindowEvent t) {
        ((ComboBoxBase)this.getSkinnable()).notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_NODE);
    }

    /* synthetic */ void lambda$createPopup$290(MouseEvent t) {
        ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide();
    }

    /* synthetic */ void lambda$createPopup$289(Event e) {
        ((ComboBoxBaseBehavior)this.getBehavior()).onAutoHide();
    }
}

