/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.DatePickerBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.DatePickerContent;
import com.sun.javafx.scene.control.skin.DatePickerHijrahContent;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.DatePickerSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.HijrahChronology;
import java.time.format.DateTimeParseException;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.StringConverter;

public class DatePickerSkin
extends ComboBoxPopupControl<LocalDate> {
    private DatePicker datePicker;
    private TextField displayNode;
    private DatePickerContent datePickerContent;
    private TextField textField;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");

    public DatePickerSkin(DatePicker datePicker) {
        super(datePicker, new DatePickerBehavior(datePicker));
        this.datePicker = datePicker;
        this.textField = this.getEditableInputNode();
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        this.arrow.paddingProperty().addListener(new InvalidationListener(){
            private boolean rounding = false;

            @Override
            public void invalidated(Observable observable) {
                Insets padding;
                Insets rounded;
                if (!this.rounding && !(rounded = new Insets(Math.round((padding = DatePickerSkin.this.arrow.getPadding()).getTop()), Math.round(padding.getRight()), Math.round(padding.getBottom()), Math.round(padding.getLeft()))).equals(padding)) {
                    this.rounding = true;
                    DatePickerSkin.this.arrow.setPadding(rounded);
                    this.rounding = false;
                }
            }
        });
        datePicker.focusedProperty().addListener(DatePickerSkin$$Lambda$1.lambdaFactory$(this));
        datePicker.addEventFilter(KeyEvent.ANY, DatePickerSkin$$Lambda$2.lambdaFactory$(this, datePicker));
        if (datePicker.getOnInputMethodTextChanged() == null) {
            datePicker.setOnInputMethodTextChanged(DatePickerSkin$$Lambda$3.lambdaFactory$(this, datePicker));
        }
        if (this.textField != null) {
            this.textField.addEventFilter(MouseEvent.DRAG_DETECTED, DatePickerSkin$$Lambda$4.lambdaFactory$(datePicker));
            this.textField.addEventFilter(DragEvent.ANY, DatePickerSkin$$Lambda$5.lambdaFactory$(datePicker));
            datePicker.setInputMethodRequests(new ExtendedInputMethodRequests(){

                @Override
                public Point2D getTextLocation(int offset) {
                    return DatePickerSkin.this.textField.getInputMethodRequests().getTextLocation(offset);
                }

                @Override
                public int getLocationOffset(int x, int y) {
                    return DatePickerSkin.this.textField.getInputMethodRequests().getLocationOffset(x, y);
                }

                @Override
                public void cancelLatestCommittedText() {
                    DatePickerSkin.this.textField.getInputMethodRequests().cancelLatestCommittedText();
                }

                @Override
                public String getSelectedText() {
                    return DatePickerSkin.this.textField.getInputMethodRequests().getSelectedText();
                }

                @Override
                public int getInsertPositionOffset() {
                    return ((ExtendedInputMethodRequests)DatePickerSkin.this.textField.getInputMethodRequests()).getInsertPositionOffset();
                }

                @Override
                public String getCommittedText(int begin, int end) {
                    return ((ExtendedInputMethodRequests)DatePickerSkin.this.textField.getInputMethodRequests()).getCommittedText(begin, end);
                }

                @Override
                public int getCommittedTextLength() {
                    return ((ExtendedInputMethodRequests)DatePickerSkin.this.textField.getInputMethodRequests()).getCommittedTextLength();
                }
            });
        }
        datePicker.setImpl_traversalEngine(new ParentTraversalEngine(datePicker, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return null;
            }
        }));
        this.registerChangeListener(datePicker.chronologyProperty(), "CHRONOLOGY");
        this.registerChangeListener(datePicker.converterProperty(), "CONVERTER");
        this.registerChangeListener(datePicker.dayCellFactoryProperty(), "DAY_CELL_FACTORY");
        this.registerChangeListener(datePicker.showWeekNumbersProperty(), "SHOW_WEEK_NUMBERS");
        this.registerChangeListener(datePicker.valueProperty(), "VALUE");
    }

    @Override
    public Node getPopupContent() {
        if (this.datePickerContent == null) {
            this.datePickerContent = this.datePicker.getChronology() instanceof HijrahChronology ? new DatePickerHijrahContent(this.datePicker) : new DatePickerContent(this.datePicker);
        }
        return this.datePickerContent;
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 50.0;
    }

    @Override
    protected void focusLost() {
    }

    @Override
    public void show() {
        super.show();
        this.datePickerContent.clearFocus();
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        if ("CHRONOLOGY".equals(p) || "DAY_CELL_FACTORY".equals(p)) {
            this.updateDisplayNode();
            this.datePickerContent = null;
            this.popup = null;
        } else if ("CONVERTER".equals(p)) {
            this.updateDisplayNode();
        } else if ("EDITOR".equals(p)) {
            this.getEditableInputNode();
        } else if ("SHOWING".equals(p)) {
            if (this.datePicker.isShowing()) {
                if (this.datePickerContent != null) {
                    LocalDate date = (LocalDate)this.datePicker.getValue();
                    this.datePickerContent.displayedYearMonthProperty().set(date != null ? YearMonth.from(date) : YearMonth.now());
                    this.datePickerContent.updateValues();
                }
                this.show();
            } else {
                this.hide();
            }
        } else if ("SHOW_WEEK_NUMBERS".equals(p)) {
            if (this.datePickerContent != null) {
                this.datePickerContent.updateGrid();
                this.datePickerContent.updateWeeknumberDateCells();
            }
        } else if ("VALUE".equals(p)) {
            this.updateDisplayNode();
            if (this.datePickerContent != null) {
                LocalDate date = (LocalDate)this.datePicker.getValue();
                this.datePickerContent.displayedYearMonthProperty().set(date != null ? YearMonth.from(date) : YearMonth.now());
                this.datePickerContent.updateValues();
            }
            this.datePicker.fireEvent(new ActionEvent());
        } else {
            super.handleControlPropertyChanged(p);
        }
    }

    @Override
    public Node getDisplayNode() {
        if (this.displayNode == null) {
            this.displayNode = this.getEditableInputNode();
            this.displayNode.getStyleClass().add("date-picker-display-node");
            this.updateDisplayNode();
        }
        this.textField.setEditable(this.datePicker.isEditable());
        return this.displayNode;
    }

    private TextField getEditableInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.datePicker.getEditor();
        this.textField.focusTraversableProperty().bindBidirectional(this.datePicker.focusTraversableProperty());
        this.textField.promptTextProperty().bind(this.datePicker.promptTextProperty());
        this.textField.focusedProperty().addListener(DatePickerSkin$$Lambda$6.lambdaFactory$(this));
        return this.textField;
    }

    private void updateDisplayNode() {
        if (this.displayNode != null) {
            LocalDate date = (LocalDate)this.datePicker.getValue();
            StringConverter<LocalDate> c = this.datePicker.getConverter();
            if (date != null && c != null) {
                this.displayNode.setText(c.toString(date));
            } else {
                this.displayNode.setText("");
            }
        }
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        StringConverter<LocalDate> c = this.datePicker.getConverter();
        if (c != null) {
            LocalDate oldValue;
            LocalDate value = oldValue = (LocalDate)this.datePicker.getValue();
            String text = this.textField.getText();
            if (text == null || text.isEmpty()) {
                value = null;
            } else {
                try {
                    value = c.fromString(text);
                }
                catch (DateTimeParseException ex) {
                    // empty catch block
                }
            }
            this.datePicker.setValue(value);
            this.updateDisplayNode();
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && this.datePicker.isShowing()) {
            this.datePicker.hide();
        }
    }

    /* synthetic */ void lambda$getEditableInputNode$348(ObservableValue ov, Boolean t, Boolean hasFocus) {
        this.datePicker.getProperties().put("FOCUSED", hasFocus);
        if (!hasFocus.booleanValue()) {
            this.setTextFromTextFieldIntoComboBoxValue();
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
        } else {
            this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
        }
    }

    static /* synthetic */ void lambda$new$347(DatePicker datePicker, DragEvent event) {
        if (event.getTarget().equals(datePicker)) {
            return;
        }
        datePicker.fireEvent(event.copyFor(datePicker, datePicker));
        event.consume();
    }

    static /* synthetic */ void lambda$new$346(DatePicker datePicker, MouseEvent event) {
        if (event.getTarget().equals(datePicker)) {
            return;
        }
        datePicker.fireEvent(event.copyFor(datePicker, datePicker));
        event.consume();
    }

    /* synthetic */ void lambda$new$345(DatePicker datePicker, InputMethodEvent event) {
        if (datePicker.getScene().getFocusOwner() == datePicker && this.textField.getOnInputMethodTextChanged() != null) {
            this.textField.getOnInputMethodTextChanged().handle(event);
        }
    }

    /* synthetic */ void lambda$new$344(DatePicker datePicker, KeyEvent ke) {
        if (this.textField == null) {
            return;
        }
        if (ke.getTarget().equals(this.textField)) {
            return;
        }
        if (ke.getCode() == KeyCode.ENTER) {
            this.setTextFromTextFieldIntoComboBoxValue();
            if (!Utils.isTwoLevelFocus()) {
                ke.consume();
            }
            return;
        }
        if (ke.getCode() == KeyCode.F4 && ke.getEventType() == KeyEvent.KEY_RELEASED) {
            if (datePicker.isShowing()) {
                datePicker.hide();
            } else {
                datePicker.show();
            }
            ke.consume();
            return;
        }
        if (ke.getCode() == KeyCode.F10 || ke.getCode() == KeyCode.ESCAPE) {
            ke.consume();
            return;
        }
        this.textField.fireEvent(ke.copyFor(this.textField, this.textField));
        ke.consume();
    }

    /* synthetic */ void lambda$new$343(ObservableValue ov, Boolean t, Boolean hasFocus) {
        ((ComboBoxListViewSkin.FakeFocusTextField)this.textField).setFakeFocus(hasFocus);
    }
}

