/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.EmbeddedTextContextMenuContent$$Lambda$1;
import com.sun.javafx.scene.control.skin.EmbeddedTextContextMenuContent$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class EmbeddedTextContextMenuContent
extends StackPane {
    private ContextMenu contextMenu;
    private StackPane pointer;
    private HBox menuBox;

    public EmbeddedTextContextMenuContent(ContextMenu popupMenu) {
        this.contextMenu = popupMenu;
        this.menuBox = new HBox();
        this.pointer = new StackPane();
        this.pointer.getStyleClass().add("pointer");
        this.updateMenuItemContainer();
        this.getChildren().addAll((Node[])new Node[]{this.pointer, this.menuBox});
        this.contextMenu.ownerNodeProperty().addListener(EmbeddedTextContextMenuContent$$Lambda$1.lambdaFactory$(this));
        this.contextMenu.getItems().addListener(EmbeddedTextContextMenuContent$$Lambda$2.lambdaFactory$(this));
    }

    private void updateMenuItemContainer() {
        this.menuBox.getChildren().clear();
        for (MenuItem item : this.contextMenu.getItems()) {
            MenuItemContainer menuItemContainer = new MenuItemContainer(item);
            menuItemContainer.visibleProperty().bind(item.visibleProperty());
            this.menuBox.getChildren().add(menuItemContainer);
        }
    }

    private void hideAllMenus(MenuItem item) {
        Menu parentMenu;
        this.contextMenu.hide();
        while ((parentMenu = item.getParentMenu()) != null) {
            parentMenu.hide();
            item = parentMenu;
        }
        if (parentMenu == null && item.getParentPopup() != null) {
            item.getParentPopup().hide();
        }
    }

    @Override
    protected double computePrefHeight(double width) {
        double pointerHeight = this.snapSize(this.pointer.prefHeight(width));
        double menuBoxHeight = this.snapSize(this.menuBox.prefHeight(width));
        return this.snappedTopInset() + pointerHeight + menuBoxHeight + this.snappedBottomInset();
    }

    @Override
    protected double computePrefWidth(double height) {
        double menuBoxWidth = this.snapSize(this.menuBox.prefWidth(height));
        return this.snappedLeftInset() + menuBoxWidth + this.snappedRightInset();
    }

    @Override
    protected void layoutChildren() {
        double left = this.snappedLeftInset();
        double right = this.snappedRightInset();
        double top = this.snappedTopInset();
        double width = this.getWidth() - (left + right);
        double pointerWidth = this.snapSize(Utils.boundedSize(this.pointer.prefWidth(-1.0), this.pointer.minWidth(-1.0), this.pointer.maxWidth(-1.0)));
        double pointerHeight = this.snapSize(Utils.boundedSize(this.pointer.prefWidth(-1.0), this.pointer.minWidth(-1.0), this.pointer.maxWidth(-1.0)));
        double menuBoxWidth = this.snapSize(Utils.boundedSize(this.menuBox.prefWidth(-1.0), this.menuBox.minWidth(-1.0), this.menuBox.maxWidth(-1.0)));
        double menuBoxHeight = this.snapSize(Utils.boundedSize(this.menuBox.prefWidth(-1.0), this.menuBox.minWidth(-1.0), this.menuBox.maxWidth(-1.0)));
        double sceneX = 0.0;
        double screenX = 0.0;
        double pointerX = 0.0;
        ObservableMap<Object, Object> properties = null;
        if (this.contextMenu.getOwnerNode() instanceof TextArea) {
            properties = ((TextArea)this.contextMenu.getOwnerNode()).getProperties();
        } else if (this.contextMenu.getOwnerNode() instanceof TextField) {
            properties = ((TextField)this.contextMenu.getOwnerNode()).getProperties();
        }
        if (properties != null) {
            if (properties.containsKey("CONTEXT_MENU_SCENE_X")) {
                sceneX = Double.valueOf(properties.get("CONTEXT_MENU_SCENE_X").toString());
                properties.remove("CONTEXT_MENU_SCENE_X");
            }
            if (properties.containsKey("CONTEXT_MENU_SCREEN_X")) {
                screenX = Double.valueOf(properties.get("CONTEXT_MENU_SCREEN_X").toString());
                properties.remove("CONTEXT_MENU_SCREEN_X");
            }
        }
        pointerX = sceneX == 0.0 ? width / 2.0 : screenX - sceneX - this.contextMenu.getX() + sceneX;
        this.pointer.resize(pointerWidth, pointerHeight);
        this.positionInArea(this.pointer, pointerX, top, pointerWidth, pointerHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.menuBox.resize(menuBoxWidth, menuBoxHeight);
        this.positionInArea(this.menuBox, left, top + pointerHeight, menuBoxWidth, menuBoxHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    /* synthetic */ void lambda$new$355(ListChangeListener.Change c) {
        this.updateMenuItemContainer();
    }

    /* synthetic */ void lambda$new$354(Observable arg0) {
        if (this.contextMenu.getOwnerNode() instanceof TextArea) {
            TextAreaSkin tas = (TextAreaSkin)((TextArea)this.contextMenu.getOwnerNode()).getSkin();
            ((TextArea)tas.getSkinnable()).getProperties().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable arg0) {
                    EmbeddedTextContextMenuContent.this.requestLayout();
                }
            });
        } else if (this.contextMenu.getOwnerNode() instanceof TextField) {
            TextFieldSkin tfs = (TextFieldSkin)((TextField)this.contextMenu.getOwnerNode()).getSkin();
            ((TextField)tfs.getSkinnable()).getProperties().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable arg0) {
                    EmbeddedTextContextMenuContent.this.requestLayout();
                }
            });
        }
    }

    class MenuItemContainer
    extends Button {
        private MenuItem item;

        public MenuItemContainer(MenuItem item) {
            this.getStyleClass().addAll((Collection<String>)item.getStyleClass());
            this.setId(item.getId());
            this.item = item;
            this.setText(item.getText());
            this.setStyle(item.getStyle());
            this.textProperty().bind(item.textProperty());
        }

        public MenuItem getItem() {
            return this.item;
        }

        @Override
        public void fire() {
            Event.fireEvent(this.item, new ActionEvent());
            if (!Boolean.TRUE.equals((Boolean)this.item.getProperties().get("refreshMenu"))) {
                EmbeddedTextContextMenuContent.this.hideAllMenus(this.item);
            }
        }
    }
}

