/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TextBinding;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.LabeledSkinBase$$Lambda$1;
import com.sun.javafx.scene.control.skin.LabeledSkinBase$$Lambda$2;
import com.sun.javafx.scene.control.skin.LabeledText;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Skinnable;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.Mnemonic;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public abstract class LabeledSkinBase<C extends Labeled, B extends BehaviorBase<C>>
extends BehaviorSkinBase<C, B> {
    LabeledText text;
    boolean invalidText = true;
    Node graphic;
    double textWidth = Double.NEGATIVE_INFINITY;
    double ellipsisWidth = Double.NEGATIVE_INFINITY;
    final InvalidationListener graphicPropertyChangedListener = LabeledSkinBase$$Lambda$1.lambdaFactory$(this);
    private Rectangle textClip;
    private double wrapWidth;
    private double wrapHeight;
    public TextBinding bindings;
    Line mnemonic_underscore;
    private boolean containsMnemonic = false;
    private Scene mnemonicScene = null;
    private KeyCombination mnemonicCode;
    private Node labeledNode = null;

    public LabeledSkinBase(C labeled, B behavior) {
        super(labeled, behavior);
        this.text = new LabeledText((Labeled)labeled);
        this.updateChildren();
        this.registerChangeListener(((Labeled)labeled).ellipsisStringProperty(), "ELLIPSIS_STRING");
        this.registerChangeListener(((Region)labeled).widthProperty(), "WIDTH");
        this.registerChangeListener(((Region)labeled).heightProperty(), "HEIGHT");
        this.registerChangeListener(((Labeled)labeled).textFillProperty(), "TEXT_FILL");
        this.registerChangeListener(((Labeled)labeled).fontProperty(), "FONT");
        this.registerChangeListener(((Labeled)labeled).graphicProperty(), "GRAPHIC");
        this.registerChangeListener(((Labeled)labeled).contentDisplayProperty(), "CONTENT_DISPLAY");
        this.registerChangeListener(((Labeled)labeled).labelPaddingProperty(), "LABEL_PADDING");
        this.registerChangeListener(((Labeled)labeled).graphicTextGapProperty(), "GRAPHIC_TEXT_GAP");
        this.registerChangeListener(((Labeled)labeled).alignmentProperty(), "ALIGNMENT");
        this.registerChangeListener(((Labeled)labeled).mnemonicParsingProperty(), "MNEMONIC_PARSING");
        this.registerChangeListener(((Labeled)labeled).textProperty(), "TEXT");
        this.registerChangeListener(((Labeled)labeled).textAlignmentProperty(), "TEXT_ALIGNMENT");
        this.registerChangeListener(((Labeled)labeled).textOverrunProperty(), "TEXT_OVERRUN");
        this.registerChangeListener(((Labeled)labeled).wrapTextProperty(), "WRAP_TEXT");
        this.registerChangeListener(((Labeled)labeled).underlineProperty(), "UNDERLINE");
        this.registerChangeListener(((Labeled)labeled).lineSpacingProperty(), "LINE_SPACING");
        this.registerChangeListener(((Node)labeled).sceneProperty(), "SCENE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("WIDTH".equals(p)) {
            this.updateWrappingWidth();
            this.invalidText = true;
        } else if ("HEIGHT".equals(p)) {
            this.invalidText = true;
        } else if ("FONT".equals(p)) {
            this.textMetricsChanged();
            this.invalidateWidths();
            this.ellipsisWidth = Double.NEGATIVE_INFINITY;
        } else if ("GRAPHIC".equals(p)) {
            this.updateChildren();
            this.textMetricsChanged();
        } else if ("CONTENT_DISPLAY".equals(p)) {
            this.updateChildren();
            this.textMetricsChanged();
        } else if ("LABEL_PADDING".equals(p)) {
            this.textMetricsChanged();
        } else if ("GRAPHIC_TEXT_GAP".equals(p)) {
            this.textMetricsChanged();
        } else if ("ALIGNMENT".equals(p)) {
            ((Labeled)this.getSkinnable()).requestLayout();
        } else if ("MNEMONIC_PARSING".equals(p)) {
            this.containsMnemonic = false;
            this.textMetricsChanged();
        } else if ("TEXT".equals(p)) {
            this.updateChildren();
            this.textMetricsChanged();
            this.invalidateWidths();
        } else if (!"TEXT_ALIGNMENT".equals(p)) {
            if ("TEXT_OVERRUN".equals(p)) {
                this.textMetricsChanged();
            } else if ("ELLIPSIS_STRING".equals(p)) {
                this.textMetricsChanged();
                this.invalidateWidths();
                this.ellipsisWidth = Double.NEGATIVE_INFINITY;
            } else if ("WRAP_TEXT".equals(p)) {
                this.updateWrappingWidth();
                this.textMetricsChanged();
            } else if ("UNDERLINE".equals(p)) {
                this.textMetricsChanged();
            } else if ("LINE_SPACING".equals(p)) {
                this.textMetricsChanged();
            } else if ("SCENE".equals(p)) {
                this.sceneChanged();
            }
        }
    }

    protected double topLabelPadding() {
        return this.snapSize(((Labeled)this.getSkinnable()).getLabelPadding().getTop());
    }

    protected double bottomLabelPadding() {
        return this.snapSize(((Labeled)this.getSkinnable()).getLabelPadding().getBottom());
    }

    protected double leftLabelPadding() {
        return this.snapSize(((Labeled)this.getSkinnable()).getLabelPadding().getLeft());
    }

    protected double rightLabelPadding() {
        return this.snapSize(((Labeled)this.getSkinnable()).getLabelPadding().getRight());
    }

    private void textMetricsChanged() {
        this.invalidText = true;
        ((Labeled)this.getSkinnable()).requestLayout();
    }

    protected void mnemonicTargetChanged() {
        if (this.containsMnemonic) {
            this.removeMnemonic();
            Skinnable control = this.getSkinnable();
            if (control instanceof Label) {
                this.labeledNode = ((Label)control).getLabelFor();
                this.addMnemonic();
            } else {
                this.labeledNode = null;
            }
        }
    }

    private void sceneChanged() {
        Labeled labeled = (Labeled)this.getSkinnable();
        Scene scene = labeled.getScene();
        if (scene != null && this.containsMnemonic) {
            this.addMnemonic();
        }
    }

    private void invalidateWidths() {
        this.textWidth = Double.NEGATIVE_INFINITY;
    }

    void updateDisplayedText() {
        this.updateDisplayedText(-1.0, -1.0);
    }

    private void updateDisplayedText(double w, double h) {
        if (this.invalidText) {
            String result;
            int i;
            Labeled labeled = (Labeled)this.getSkinnable();
            String s = labeled.getText();
            int mnemonicIndex = -1;
            if (s != null && s.length() > 0) {
                this.bindings = new TextBinding(s);
                if (!PlatformUtil.isMac() && ((Labeled)this.getSkinnable()).isMnemonicParsing()) {
                    this.labeledNode = labeled instanceof Label ? ((Label)labeled).getLabelFor() : labeled;
                    if (this.labeledNode == null) {
                        this.labeledNode = labeled;
                    }
                    mnemonicIndex = this.bindings.getMnemonicIndex();
                }
            }
            if (this.containsMnemonic) {
                if (this.mnemonicScene != null) {
                    if (mnemonicIndex == -1 || this.bindings != null && !this.bindings.getMnemonicKeyCombination().equals(this.mnemonicCode)) {
                        this.removeMnemonic();
                    }
                    this.containsMnemonic = false;
                }
            } else {
                this.removeMnemonic();
            }
            if (s != null && s.length() > 0 && mnemonicIndex >= 0 && !this.containsMnemonic) {
                this.containsMnemonic = true;
                this.mnemonicCode = this.bindings.getMnemonicKeyCombination();
                this.addMnemonic();
            }
            if (this.containsMnemonic) {
                s = this.bindings.getText();
                if (this.mnemonic_underscore == null) {
                    this.mnemonic_underscore = new Line();
                    this.mnemonic_underscore.setStartX(0.0);
                    this.mnemonic_underscore.setStartY(0.0);
                    this.mnemonic_underscore.setEndY(0.0);
                    this.mnemonic_underscore.getStyleClass().clear();
                    this.mnemonic_underscore.getStyleClass().setAll((String[])new String[]{"mnemonic-underline"});
                }
                if (!this.getChildren().contains(this.mnemonic_underscore)) {
                    this.getChildren().add(this.mnemonic_underscore);
                }
            } else {
                s = ((Labeled)this.getSkinnable()).isMnemonicParsing() && PlatformUtil.isMac() && this.bindings != null ? this.bindings.getText() : labeled.getText();
                if (this.mnemonic_underscore != null && this.getChildren().contains(this.mnemonic_underscore)) {
                    Platform.runLater(LabeledSkinBase$$Lambda$2.lambdaFactory$(this));
                }
            }
            int len = s != null ? s.length() : 0;
            boolean multiline = false;
            if (s != null && len > 0 && (i = s.indexOf(10)) > -1 && i < len - 1) {
                multiline = true;
            }
            boolean horizontalPosition = labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT;
            double availableWidth = labeled.getWidth() - this.snappedLeftInset() - this.leftLabelPadding() - this.snappedRightInset() - this.rightLabelPadding();
            availableWidth = Math.max(availableWidth, 0.0);
            if (w == -1.0) {
                w = availableWidth;
            }
            double minW = Math.min(this.computeMinLabeledPartWidth(-1.0, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset()), availableWidth);
            if (horizontalPosition && !this.isIgnoreGraphic()) {
                double graphicW = labeled.getGraphic().getLayoutBounds().getWidth() + labeled.getGraphicTextGap();
                w -= graphicW;
                minW -= graphicW;
            }
            this.wrapWidth = Math.max(minW, w);
            boolean verticalPosition = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM;
            double availableHeight = labeled.getHeight() - this.snappedTopInset() - this.topLabelPadding() - this.snappedBottomInset() - this.bottomLabelPadding();
            availableHeight = Math.max(availableHeight, 0.0);
            if (h == -1.0) {
                h = availableHeight;
            }
            double minH = Math.min(this.computeMinLabeledPartHeight(this.wrapWidth, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset()), availableHeight);
            if (verticalPosition && labeled.getGraphic() != null) {
                double graphicH = labeled.getGraphic().getLayoutBounds().getHeight() + labeled.getGraphicTextGap();
                h -= graphicH;
                minH -= graphicH;
            }
            this.wrapHeight = Math.max(minH, h);
            this.updateWrappingWidth();
            Font font = this.text.getFont();
            OverrunStyle truncationStyle = labeled.getTextOverrun();
            String ellipsisString = labeled.getEllipsisString();
            if (labeled.isWrapText()) {
                result = Utils.computeClippedWrappedText(font, s, this.wrapWidth, this.wrapHeight, truncationStyle, ellipsisString, this.text.getBoundsType());
            } else if (multiline) {
                StringBuilder sb = new StringBuilder();
                String[] splits = s.split("\n");
                for (int i2 = 0; i2 < splits.length; ++i2) {
                    sb.append(Utils.computeClippedText(font, splits[i2], this.wrapWidth, truncationStyle, ellipsisString));
                    if (i2 >= splits.length - 1) continue;
                    sb.append('\n');
                }
                result = sb.toString();
            } else {
                result = Utils.computeClippedText(font, s, this.wrapWidth, truncationStyle, ellipsisString);
            }
            if (result != null && result.endsWith("\n")) {
                result = result.substring(0, result.length() - 1);
            }
            this.text.setText(result);
            this.updateWrappingWidth();
            this.invalidText = false;
        }
    }

    private void addMnemonic() {
        if (this.labeledNode != null) {
            this.mnemonicScene = this.labeledNode.getScene();
            if (this.mnemonicScene != null) {
                this.mnemonicScene.addMnemonic(new Mnemonic(this.labeledNode, this.mnemonicCode));
            }
        }
    }

    private void removeMnemonic() {
        if (this.mnemonicScene != null && this.labeledNode != null) {
            this.mnemonicScene.removeMnemonic(new Mnemonic(this.labeledNode, this.mnemonicCode));
            this.mnemonicScene = null;
        }
    }

    private void updateWrappingWidth() {
        Labeled labeled = (Labeled)this.getSkinnable();
        this.text.setWrappingWidth(0.0);
        if (labeled.isWrapText()) {
            double w = Math.min(this.text.prefWidth(-1.0), this.wrapWidth);
            this.text.setWrappingWidth(w);
        }
    }

    protected void updateChildren() {
        Labeled labeled = (Labeled)this.getSkinnable();
        if (this.graphic != null) {
            this.graphic.layoutBoundsProperty().removeListener(this.graphicPropertyChangedListener);
        }
        this.graphic = labeled.getGraphic();
        if (this.graphic instanceof ImageView) {
            this.graphic.setMouseTransparent(true);
        }
        if (this.isIgnoreGraphic()) {
            if (labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Node[])new Node[]{this.text});
            }
        } else {
            this.graphic.layoutBoundsProperty().addListener(this.graphicPropertyChangedListener);
            if (this.isIgnoreText()) {
                this.getChildren().setAll((Node[])new Node[]{this.graphic});
            } else {
                this.getChildren().setAll((Node[])new Node[]{this.graphic, this.text});
            }
            this.graphic.impl_processCSS(false);
        }
    }

    protected boolean isIgnoreGraphic() {
        return this.graphic == null || !this.graphic.isManaged() || ((Labeled)this.getSkinnable()).getContentDisplay() == ContentDisplay.TEXT_ONLY;
    }

    protected boolean isIgnoreText() {
        Labeled labeled = (Labeled)this.getSkinnable();
        String txt = labeled.getText();
        return txt == null || txt.equals("") || labeled.getContentDisplay() == ContentDisplay.GRAPHIC_ONLY;
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computeMinLabeledPartWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    private double computeMinLabeledPartWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        boolean emptyText;
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        double gap = labeled.getGraphicTextGap();
        double minTextWidth = 0.0;
        Font font = this.text.getFont();
        OverrunStyle truncationStyle = labeled.getTextOverrun();
        String ellipsisString = labeled.getEllipsisString();
        String string = labeled.getText();
        boolean bl = emptyText = string == null || string.isEmpty();
        if (!emptyText) {
            if (truncationStyle == OverrunStyle.CLIP) {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = Utils.computeTextWidth(font, string.substring(0, 1), 0.0);
                }
                minTextWidth = this.textWidth;
            } else {
                if (this.textWidth == Double.NEGATIVE_INFINITY) {
                    this.textWidth = Utils.computeTextWidth(font, string, 0.0);
                }
                if (this.ellipsisWidth == Double.NEGATIVE_INFINITY) {
                    this.ellipsisWidth = Utils.computeTextWidth(font, ellipsisString, 0.0);
                }
                minTextWidth = Math.min(this.textWidth, this.ellipsisWidth);
            }
        }
        Node graphic = labeled.getGraphic();
        double width = this.isIgnoreGraphic() ? minTextWidth : (this.isIgnoreText() ? graphic.minWidth(-1.0) : (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT ? minTextWidth + graphic.minWidth(-1.0) + gap : Math.max(minTextWidth, graphic.minWidth(-1.0))));
        return width + leftInset + this.leftLabelPadding() + rightInset + this.rightLabelPadding();
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computeMinLabeledPartHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    private double computeMinLabeledPartHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double textHeight;
        int newlineIndex;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String str = labeled.getText();
        if (str != null && str.length() > 0 && (newlineIndex = str.indexOf(10)) >= 0) {
            str = str.substring(0, newlineIndex);
        }
        double s = labeled.getLineSpacing();
        double h = textHeight = Utils.computeTextHeight(font, str, 0.0, s, this.text.getBoundsType());
        if (!this.isIgnoreGraphic()) {
            Node graphic = labeled.getGraphic();
            h = labeled.getContentDisplay() == ContentDisplay.TOP || labeled.getContentDisplay() == ContentDisplay.BOTTOM ? graphic.minHeight(width) + labeled.getGraphicTextGap() + textHeight : Math.max(textHeight, graphic.minHeight(width));
        }
        return topInset + h + bottomInset + this.topLabelPadding() - this.bottomLabelPadding();
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        String string = labeled.getText();
        boolean emptyText = string == null || string.isEmpty();
        double widthPadding = leftInset + this.leftLabelPadding() + rightInset + this.rightLabelPadding();
        double textWidth = emptyText ? 0.0 : Utils.computeTextWidth(font, string, 0.0);
        Node graphic = labeled.getGraphic();
        if (this.isIgnoreGraphic()) {
            return textWidth + widthPadding;
        }
        if (this.isIgnoreText()) {
            return graphic.prefWidth(-1.0) + widthPadding;
        }
        if (labeled.getContentDisplay() == ContentDisplay.LEFT || labeled.getContentDisplay() == ContentDisplay.RIGHT) {
            return textWidth + labeled.getGraphicTextGap() + graphic.prefWidth(-1.0) + widthPadding;
        }
        return Math.max(textWidth, graphic.prefWidth(-1.0)) + widthPadding;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double textHeight;
        Labeled labeled = (Labeled)this.getSkinnable();
        Font font = this.text.getFont();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        double gap = labeled.getGraphicTextGap();
        width -= leftInset + this.leftLabelPadding() + rightInset + this.rightLabelPadding();
        String str = labeled.getText();
        if (str != null && str.endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        double textWidth = width;
        if (!(this.isIgnoreGraphic() || contentDisplay != ContentDisplay.LEFT && contentDisplay != ContentDisplay.RIGHT)) {
            textWidth -= this.graphic.prefWidth(-1.0) + gap;
        }
        double h = textHeight = Utils.computeTextHeight(font, str, labeled.isWrapText() ? textWidth : 0.0, labeled.getLineSpacing(), this.text.getBoundsType());
        if (!this.isIgnoreGraphic()) {
            Node graphic = labeled.getGraphic();
            h = contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM ? graphic.prefHeight(width) + gap + textHeight : Math.max(textHeight, graphic.prefHeight(width));
        }
        return topInset + h + bottomInset + this.topLabelPadding() + this.bottomLabelPadding();
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Labeled)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Labeled)this.getSkinnable()).prefHeight(width);
    }

    @Override
    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        double textBaselineOffset;
        double h = textBaselineOffset = this.text.getBaselineOffset();
        Labeled labeled = (Labeled)this.getSkinnable();
        Node g = labeled.getGraphic();
        if (!this.isIgnoreGraphic()) {
            ContentDisplay contentDisplay = labeled.getContentDisplay();
            if (contentDisplay == ContentDisplay.TOP) {
                h = g.prefHeight(-1.0) + labeled.getGraphicTextGap() + textBaselineOffset;
            } else if (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT) {
                h = textBaselineOffset + (g.prefHeight(-1.0) - this.text.prefHeight(-1.0)) / 2.0;
            }
        }
        return topInset + this.topLabelPadding() + h;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        this.layoutLabelInArea(x, y, w, h);
    }

    protected void layoutLabelInArea(double x, double y, double w, double h) {
        this.layoutLabelInArea(x, y, w, h, null);
    }

    protected void layoutLabelInArea(double x, double y, double w, double h, Pos alignment) {
        double textWidth;
        double textHeight;
        double graphicWidth;
        double graphicHeight;
        Labeled labeled = (Labeled)this.getSkinnable();
        ContentDisplay contentDisplay = labeled.getContentDisplay();
        if (alignment == null) {
            alignment = labeled.getAlignment();
        }
        HPos hpos = alignment == null ? HPos.LEFT : alignment.getHpos();
        VPos vpos = alignment == null ? VPos.CENTER : alignment.getVpos();
        boolean ignoreGraphic = this.isIgnoreGraphic();
        boolean ignoreText = this.isIgnoreText();
        x += this.leftLabelPadding();
        y += this.topLabelPadding();
        w -= this.leftLabelPadding() + this.rightLabelPadding();
        h -= this.topLabelPadding() + this.bottomLabelPadding();
        if (ignoreGraphic) {
            graphicHeight = 0.0;
            graphicWidth = 0.0;
        } else if (ignoreText) {
            if (this.graphic.isResizable()) {
                Orientation contentBias = this.graphic.getContentBias();
                if (contentBias == Orientation.HORIZONTAL) {
                    graphicWidth = Utils.boundedSize(w, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    graphicHeight = Utils.boundedSize(h, this.graphic.minHeight(graphicWidth), this.graphic.maxHeight(graphicWidth));
                } else if (contentBias == Orientation.VERTICAL) {
                    graphicHeight = Utils.boundedSize(h, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                    graphicWidth = Utils.boundedSize(w, this.graphic.minWidth(graphicHeight), this.graphic.maxWidth(graphicHeight));
                } else {
                    graphicWidth = Utils.boundedSize(w, this.graphic.minWidth(-1.0), this.graphic.maxWidth(-1.0));
                    graphicHeight = Utils.boundedSize(h, this.graphic.minHeight(-1.0), this.graphic.maxHeight(-1.0));
                }
                this.graphic.resize(graphicWidth, graphicHeight);
            } else {
                graphicWidth = this.graphic.getLayoutBounds().getWidth();
                graphicHeight = this.graphic.getLayoutBounds().getHeight();
            }
        } else {
            this.graphic.autosize();
            graphicWidth = this.graphic.getLayoutBounds().getWidth();
            graphicHeight = this.graphic.getLayoutBounds().getHeight();
        }
        if (ignoreText) {
            textHeight = 0.0;
            textWidth = 0.0;
            this.text.setText("");
        } else {
            this.updateDisplayedText(w, h);
            textWidth = this.snapSize(Math.min(this.text.getLayoutBounds().getWidth(), this.wrapWidth));
            textHeight = this.snapSize(Math.min(this.text.getLayoutBounds().getHeight(), this.wrapHeight));
        }
        double gap = ignoreText || ignoreGraphic ? 0.0 : labeled.getGraphicTextGap();
        double contentWidth = Math.max(graphicWidth, textWidth);
        double contentHeight = Math.max(graphicHeight, textHeight);
        if (contentDisplay == ContentDisplay.TOP || contentDisplay == ContentDisplay.BOTTOM) {
            contentHeight = graphicHeight + gap + textHeight;
        } else if (contentDisplay == ContentDisplay.LEFT || contentDisplay == ContentDisplay.RIGHT) {
            contentWidth = graphicWidth + gap + textWidth;
        }
        double contentX = hpos == HPos.LEFT ? x : (hpos == HPos.RIGHT ? x + (w - contentWidth) : x + (w - contentWidth) / 2.0);
        double contentY = vpos == VPos.TOP ? y : (vpos == VPos.BOTTOM ? y + (h - contentHeight) : y + (h - contentHeight) / 2.0);
        double preMnemonicWidth = 0.0;
        double mnemonicWidth = 0.0;
        double mnemonicHeight = 0.0;
        if (this.containsMnemonic) {
            Font font = this.text.getFont();
            String preSt = this.bindings.getText();
            preMnemonicWidth = Utils.computeTextWidth(font, preSt.substring(0, this.bindings.getMnemonicIndex()), 0.0);
            mnemonicWidth = Utils.computeTextWidth(font, preSt.substring(this.bindings.getMnemonicIndex(), this.bindings.getMnemonicIndex() + 1), 0.0);
            mnemonicHeight = Utils.computeTextHeight(font, "_", 0.0, this.text.getBoundsType());
        }
        if (!(ignoreGraphic && ignoreText || this.text.isManaged())) {
            this.text.setManaged(true);
        }
        if (ignoreGraphic && ignoreText) {
            if (this.text.isManaged()) {
                this.text.setManaged(false);
            }
            this.text.relocate(this.snapPosition(contentX), this.snapPosition(contentY));
        } else if (ignoreGraphic) {
            this.text.relocate(this.snapPosition(contentX), this.snapPosition(contentY));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(mnemonicWidth - 2.0);
                this.mnemonic_underscore.relocate(contentX + preMnemonicWidth, contentY + mnemonicHeight - 1.0);
            }
        } else if (ignoreText) {
            this.text.relocate(this.snapPosition(contentX), this.snapPosition(contentY));
            this.graphic.relocate(this.snapPosition(contentX), this.snapPosition(contentY));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(mnemonicWidth);
                this.mnemonic_underscore.setStrokeWidth(mnemonicHeight / 10.0);
                this.mnemonic_underscore.relocate(contentX + preMnemonicWidth, contentY + mnemonicHeight - 1.0);
            }
        } else {
            double graphicX = 0.0;
            double graphicY = 0.0;
            double textX = 0.0;
            double textY = 0.0;
            if (contentDisplay == ContentDisplay.TOP) {
                graphicX = contentX + (contentWidth - graphicWidth) / 2.0;
                textX = contentX + (contentWidth - textWidth) / 2.0;
                graphicY = contentY;
                textY = graphicY + graphicHeight + gap;
            } else if (contentDisplay == ContentDisplay.RIGHT) {
                textX = contentX;
                graphicX = textX + textWidth + gap;
                graphicY = contentY + (contentHeight - graphicHeight) / 2.0;
                textY = contentY + (contentHeight - textHeight) / 2.0;
            } else if (contentDisplay == ContentDisplay.BOTTOM) {
                graphicX = contentX + (contentWidth - graphicWidth) / 2.0;
                textX = contentX + (contentWidth - textWidth) / 2.0;
                textY = contentY;
                graphicY = textY + textHeight + gap;
            } else if (contentDisplay == ContentDisplay.LEFT) {
                graphicX = contentX;
                textX = graphicX + graphicWidth + gap;
                graphicY = contentY + (contentHeight - graphicHeight) / 2.0;
                textY = contentY + (contentHeight - textHeight) / 2.0;
            } else if (contentDisplay == ContentDisplay.CENTER) {
                graphicX = contentX + (contentWidth - graphicWidth) / 2.0;
                textX = contentX + (contentWidth - textWidth) / 2.0;
                graphicY = contentY + (contentHeight - graphicHeight) / 2.0;
                textY = contentY + (contentHeight - textHeight) / 2.0;
            }
            this.text.relocate(this.snapPosition(textX), this.snapPosition(textY));
            if (this.containsMnemonic) {
                this.mnemonic_underscore.setEndX(mnemonicWidth);
                this.mnemonic_underscore.setStrokeWidth(mnemonicHeight / 10.0);
                this.mnemonic_underscore.relocate(this.snapPosition(textX + preMnemonicWidth), this.snapPosition(textY + mnemonicHeight - 1.0));
            }
            this.graphic.relocate(this.snapPosition(graphicX), this.snapPosition(graphicY));
        }
        if (this.text != null && (this.text.getLayoutBounds().getHeight() > this.wrapHeight || this.text.getLayoutBounds().getWidth() > this.wrapWidth)) {
            if (this.textClip == null) {
                this.textClip = new Rectangle();
            }
            if (labeled.getEffectiveNodeOrientation() == NodeOrientation.LEFT_TO_RIGHT) {
                this.textClip.setX(this.text.getLayoutBounds().getMinX());
            } else {
                this.textClip.setX(this.text.getLayoutBounds().getMaxX() - this.wrapWidth);
            }
            this.textClip.setY(this.text.getLayoutBounds().getMinY());
            this.textClip.setWidth(this.wrapWidth);
            this.textClip.setHeight(this.wrapHeight);
            if (this.text.getClip() == null) {
                this.text.setClip(this.textClip);
            }
        } else if (this.text.getClip() != null) {
            this.text.setClip(null);
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                Object result;
                String text;
                Labeled labeled = (Labeled)this.getSkinnable();
                String accText = labeled.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                if (this.bindings != null && (text = this.bindings.getText()) != null && !text.isEmpty()) {
                    return text;
                }
                if (labeled != null && (text = labeled.getText()) != null && !text.isEmpty()) {
                    return text;
                }
                if (this.graphic != null && (result = this.graphic.queryAccessibleAttribute(AccessibleAttribute.TEXT, new Object[0])) != null) {
                    return result;
                }
                return null;
            }
            case MNEMONIC: {
                if (this.bindings != null) {
                    return this.bindings.getMnemonic();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$updateDisplayedText$278() {
        this.getChildren().remove(this.mnemonic_underscore);
        this.mnemonic_underscore = null;
    }

    /* synthetic */ void lambda$new$277(Observable valueModel) {
        this.invalidText = true;
        ((Labeled)this.getSkinnable()).requestLayout();
    }
}

