/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader$$Lambda$1;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import com.sun.javafx.scene.control.skin.TreeTableViewSkin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class NestedTableColumnHeader
extends TableColumnHeader {
    private static final int DRAG_RECT_WIDTH = 4;
    private static final String TABLE_COLUMN_KEY = "TableColumn";
    private static final String TABLE_COLUMN_HEADER_KEY = "TableColumnHeader";
    private ObservableList<? extends TableColumnBase> columns;
    private TableColumnHeader label;
    private ObservableList<TableColumnHeader> columnHeaders;
    private double lastX = 0.0;
    private double dragAnchorX = 0.0;
    private Map<TableColumnBase<?, ?>, Rectangle> dragRects = new WeakHashMap();
    boolean updateColumns = true;
    private final ListChangeListener<TableColumnBase> columnsListener = NestedTableColumnHeader$$Lambda$1.lambdaFactory$(this);
    private final WeakListChangeListener weakColumnsListener = new WeakListChangeListener<TableColumnBase>(this.columnsListener);
    private static final EventHandler<MouseEvent> rectMousePressed = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent me) {
            Rectangle rect = (Rectangle)me.getSource();
            TableColumnBase column = (TableColumnBase)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader header = (NestedTableColumnHeader)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!header.isColumnResizingEnabled()) {
                return;
            }
            if (me.getClickCount() == 2 && me.isPrimaryButtonDown()) {
                header.getTableViewSkin().resizeColumnToFitContent(column, -1);
            } else {
                Rectangle innerRect = (Rectangle)me.getSource();
                double startX = header.getTableHeaderRow().sceneToLocal(innerRect.localToScene(innerRect.getBoundsInLocal())).getMinX() + 2.0;
                header.dragAnchorX = me.getSceneX();
                header.columnResizingStarted(startX);
            }
            me.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectMouseDragged = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent me) {
            Rectangle rect = (Rectangle)me.getSource();
            TableColumnBase column = (TableColumnBase)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader header = (NestedTableColumnHeader)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!header.isColumnResizingEnabled()) {
                return;
            }
            header.columnResizing(column, me);
            me.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectMouseReleased = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent me) {
            Rectangle rect = (Rectangle)me.getSource();
            TableColumnBase column = (TableColumnBase)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader header = (NestedTableColumnHeader)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (!header.isColumnResizingEnabled()) {
                return;
            }
            header.columnResizingComplete(column, me);
            me.consume();
        }
    };
    private static final EventHandler<MouseEvent> rectCursorChangeListener = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent me) {
            Rectangle rect = (Rectangle)me.getSource();
            TableColumnBase column = (TableColumnBase)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_KEY);
            NestedTableColumnHeader header = (NestedTableColumnHeader)rect.getProperties().get(NestedTableColumnHeader.TABLE_COLUMN_HEADER_KEY);
            if (header.getCursor() == null) {
                rect.setCursor(header.isColumnResizingEnabled() && rect.isHover() && column.isResizable() ? Cursor.H_RESIZE : null);
            }
        }
    };

    public NestedTableColumnHeader(TableViewSkinBase skin, TableColumnBase tc) {
        super(skin, tc);
        this.getStyleClass().setAll((String[])new String[]{"nested-column-header"});
        this.setFocusTraversable(false);
        this.label = new TableColumnHeader(skin, this.getTableColumn());
        this.label.setTableHeaderRow(this.getTableHeaderRow());
        this.label.setParentHeader(this.getParentHeader());
        this.label.setNestedColumnHeader(this);
        if (this.getTableColumn() != null) {
            this.changeListenerHandler.registerChangeListener(this.getTableColumn().textProperty(), "TABLE_COLUMN_TEXT");
        }
        this.changeListenerHandler.registerChangeListener(skin.columnResizePolicyProperty(), "TABLE_VIEW_COLUMN_RESIZE_POLICY");
    }

    @Override
    protected void handlePropertyChanged(String p) {
        super.handlePropertyChanged(p);
        if ("TABLE_VIEW_COLUMN_RESIZE_POLICY".equals(p)) {
            this.updateContent();
        } else if ("TABLE_COLUMN_TEXT".equals(p)) {
            this.label.setVisible(this.getTableColumn().getText() != null && !this.getTableColumn().getText().isEmpty());
        }
    }

    @Override
    public void setTableHeaderRow(TableHeaderRow header) {
        super.setTableHeaderRow(header);
        this.label.setTableHeaderRow(header);
        for (TableColumnHeader c : this.getColumnHeaders()) {
            c.setTableHeaderRow(header);
        }
    }

    @Override
    public void setParentHeader(NestedTableColumnHeader parentHeader) {
        super.setParentHeader(parentHeader);
        this.label.setParentHeader(parentHeader);
    }

    ObservableList<? extends TableColumnBase> getColumns() {
        return this.columns;
    }

    void setColumns(ObservableList<? extends TableColumnBase> newColumns) {
        if (this.columns != null) {
            this.columns.removeListener(this.weakColumnsListener);
        }
        this.columns = newColumns;
        if (this.columns != null) {
            this.columns.addListener(this.weakColumnsListener);
        }
    }

    void updateTableColumnHeaders() {
        if (this.getTableColumn() == null && this.getTableViewSkin() != null) {
            this.setColumns(this.getTableViewSkin().getColumns());
        } else if (this.getTableColumn() != null) {
            this.setColumns(this.getTableColumn().getColumns());
        }
        if (this.getColumns().isEmpty()) {
            for (int i = 0; i < this.getColumnHeaders().size(); ++i) {
                TableColumnHeader header = (TableColumnHeader)this.getColumnHeaders().get(i);
                header.dispose();
            }
            NestedTableColumnHeader parentHeader = this.getParentHeader();
            if (parentHeader != null) {
                ObservableList<TableColumnHeader> parentColumnHeaders = parentHeader.getColumnHeaders();
                int index = parentColumnHeaders.indexOf(this);
                if (index >= 0 && index < parentColumnHeaders.size()) {
                    parentColumnHeaders.set(index, this.createColumnHeader(this.getTableColumn()));
                }
            } else {
                this.getColumnHeaders().clear();
            }
        } else {
            int i;
            ArrayList<TableColumnHeader> oldHeaders = new ArrayList<TableColumnHeader>(this.getColumnHeaders());
            ArrayList<TableColumnHeader> newHeaders = new ArrayList<TableColumnHeader>();
            for (i = 0; i < this.getColumns().size(); ++i) {
                TableColumnBase column = (TableColumnBase)this.getColumns().get(i);
                if (column == null || !column.isVisible()) continue;
                boolean found = false;
                for (int j = 0; j < oldHeaders.size(); ++j) {
                    TableColumnHeader oldColumn = (TableColumnHeader)oldHeaders.get(j);
                    if (column != oldColumn.getTableColumn()) continue;
                    newHeaders.add(oldColumn);
                    found = true;
                    break;
                }
                if (found) continue;
                newHeaders.add(this.createColumnHeader(column));
            }
            this.getColumnHeaders().setAll((Collection<TableColumnHeader>)newHeaders);
            oldHeaders.removeAll(newHeaders);
            for (i = 0; i < oldHeaders.size(); ++i) {
                ((TableColumnHeader)oldHeaders.get(i)).dispose();
            }
        }
        this.updateContent();
        for (TableColumnHeader header : this.getColumnHeaders()) {
            header.applyCss();
        }
    }

    @Override
    void dispose() {
        super.dispose();
        if (this.label != null) {
            this.label.dispose();
        }
        if (this.getColumns() != null) {
            this.getColumns().removeListener(this.weakColumnsListener);
        }
        for (int i = 0; i < this.getColumnHeaders().size(); ++i) {
            TableColumnHeader header = (TableColumnHeader)this.getColumnHeaders().get(i);
            header.dispose();
        }
        for (Rectangle rect : this.dragRects.values()) {
            if (rect == null) continue;
            rect.visibleProperty().unbind();
        }
        this.dragRects.clear();
        this.getChildren().clear();
        this.changeListenerHandler.dispose();
    }

    public ObservableList<TableColumnHeader> getColumnHeaders() {
        if (this.columnHeaders == null) {
            this.columnHeaders = FXCollections.observableArrayList();
        }
        return this.columnHeaders;
    }

    @Override
    protected void layoutChildren() {
        double w = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double h = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        int labelHeight = (int)this.label.prefHeight(-1.0);
        if (this.label.isVisible()) {
            this.label.resize(w, labelHeight);
            this.label.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }
        double x = this.snappedLeftInset();
        boolean pos = false;
        int max = this.getColumnHeaders().size();
        for (int i = 0; i < max; ++i) {
            TableColumnHeader n = (TableColumnHeader)this.getColumnHeaders().get(i);
            if (!n.isVisible()) continue;
            double prefWidth = this.snapSize(n.prefWidth(-1.0));
            n.resize(prefWidth, this.snapSize(h - (double)labelHeight));
            n.relocate(x, (double)labelHeight + this.snappedTopInset());
            x += prefWidth;
            Rectangle dragRect = this.dragRects.get(n.getTableColumn());
            if (dragRect == null) continue;
            dragRect.setHeight(n.getDragRectHeight());
            dragRect.relocate(x - 2.0, this.snappedTopInset() + (double)labelHeight);
        }
    }

    @Override
    double getDragRectHeight() {
        return this.label.prefHeight(-1.0);
    }

    @Override
    protected double computePrefWidth(double height) {
        this.checkState();
        double width = 0.0;
        if (this.getColumns() != null) {
            for (TableColumnHeader c : this.getColumnHeaders()) {
                if (!c.isVisible()) continue;
                width += this.snapSize(c.computePrefWidth(height));
            }
        }
        return width;
    }

    @Override
    protected double computePrefHeight(double width) {
        this.checkState();
        double height = 0.0;
        if (this.getColumnHeaders() != null) {
            for (TableColumnHeader n : this.getColumnHeaders()) {
                height = Math.max(height, n.prefHeight(-1.0));
            }
        }
        return height + this.label.prefHeight(-1.0) + this.snappedTopInset() + this.snappedBottomInset();
    }

    protected TableColumnHeader createTableColumnHeader(TableColumnBase col) {
        return col.getColumns().isEmpty() ? new TableColumnHeader(this.getTableViewSkin(), col) : new NestedTableColumnHeader(this.getTableViewSkin(), col);
    }

    protected void setHeadersNeedUpdate() {
        this.updateColumns = true;
        for (int i = 0; i < this.getColumnHeaders().size(); ++i) {
            TableColumnHeader header = (TableColumnHeader)this.getColumnHeaders().get(i);
            if (!(header instanceof NestedTableColumnHeader)) continue;
            ((NestedTableColumnHeader)header).setHeadersNeedUpdate();
        }
        this.requestLayout();
    }

    private void updateContent() {
        ArrayList<Node> content = new ArrayList<Node>();
        content.add(this.label);
        content.addAll(this.getColumnHeaders());
        if (this.isColumnResizingEnabled()) {
            this.rebuildDragRects();
            content.addAll(this.dragRects.values());
        }
        this.getChildren().setAll((Collection<Node>)content);
    }

    private void rebuildDragRects() {
        boolean isConstrainedResize;
        if (!this.isColumnResizingEnabled()) {
            return;
        }
        this.getChildren().removeAll(this.dragRects.values());
        for (Rectangle rect : this.dragRects.values()) {
            rect.visibleProperty().unbind();
        }
        this.dragRects.clear();
        ObservableList<? extends TableColumnBase> columns = this.getColumns();
        if (columns == null) {
            return;
        }
        TableViewSkinBase<?, ?, ?, ?, ?, TableColumnBase<?, ?>> skin = this.getTableViewSkin();
        Callback columnResizePolicy = (Callback)skin.columnResizePolicyProperty().get();
        boolean bl = skin instanceof TableViewSkin ? TableView.CONSTRAINED_RESIZE_POLICY.equals(columnResizePolicy) : (isConstrainedResize = skin instanceof TreeTableViewSkin ? TreeTableView.CONSTRAINED_RESIZE_POLICY.equals(columnResizePolicy) : false);
        if (isConstrainedResize && skin.getVisibleLeafColumns().size() == 1) {
            return;
        }
        for (int col = 0; !(col >= columns.size() || isConstrainedResize && col == this.getColumns().size() - 1); ++col) {
            TableColumnBase c = (TableColumnBase)columns.get(col);
            Rectangle rect = new Rectangle();
            rect.getProperties().put(TABLE_COLUMN_KEY, c);
            rect.getProperties().put(TABLE_COLUMN_HEADER_KEY, this);
            rect.setWidth(4.0);
            rect.setHeight(this.getHeight() - this.label.getHeight());
            rect.setFill(Color.TRANSPARENT);
            rect.visibleProperty().bind(c.visibleProperty());
            rect.setSmooth(false);
            rect.setOnMousePressed(rectMousePressed);
            rect.setOnMouseDragged(rectMouseDragged);
            rect.setOnMouseReleased(rectMouseReleased);
            rect.setOnMouseEntered(rectCursorChangeListener);
            rect.setOnMouseExited(rectCursorChangeListener);
            this.dragRects.put(c, rect);
        }
    }

    private void checkState() {
        if (this.updateColumns) {
            this.updateTableColumnHeaders();
            this.updateColumns = false;
        }
    }

    private TableColumnHeader createColumnHeader(TableColumnBase col) {
        TableColumnHeader newCol = this.createTableColumnHeader(col);
        newCol.setTableHeaderRow(this.getTableHeaderRow());
        newCol.setParentHeader(this);
        return newCol;
    }

    private boolean isColumnResizingEnabled() {
        return true;
    }

    private void columnResizingStarted(double startX) {
        this.setCursor(Cursor.H_RESIZE);
        this.columnReorderLine.setLayoutX(startX);
    }

    private void columnResizing(TableColumnBase col, MouseEvent me) {
        double draggedX = me.getSceneX() - this.dragAnchorX;
        if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            draggedX = -draggedX;
        }
        double delta = draggedX - this.lastX;
        boolean allowed = this.getTableViewSkin().resizeColumn(col, delta);
        if (allowed) {
            this.lastX = draggedX;
        }
    }

    private void columnResizingComplete(TableColumnBase col, MouseEvent me) {
        this.setCursor(null);
        this.columnReorderLine.setTranslateX(0.0);
        this.columnReorderLine.setLayoutX(0.0);
        this.lastX = 0.0;
    }

    /* synthetic */ void lambda$new$77(ListChangeListener.Change c) {
        this.setHeadersNeedUpdate();
    }
}

