/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.skin.ProgressBarSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ProgressBarSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ProgressIndicatorSkin;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.util.Duration;

public class ProgressBarSkin
extends ProgressIndicatorSkin {
    private DoubleProperty indeterminateBarLength = null;
    private BooleanProperty indeterminateBarEscape = null;
    private BooleanProperty indeterminateBarFlip = null;
    private DoubleProperty indeterminateBarAnimationTime = null;
    private StackPane bar;
    private StackPane track;
    private Region clipRegion;
    private double barWidth;
    boolean wasIndeterminate = false;

    private DoubleProperty indeterminateBarLengthProperty() {
        if (this.indeterminateBarLength == null) {
            this.indeterminateBarLength = new StyleableDoubleProperty(60.0){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarLength";
                }

                @Override
                public CssMetaData<ProgressBar, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_LENGTH;
                }
            };
        }
        return this.indeterminateBarLength;
    }

    private Double getIndeterminateBarLength() {
        return this.indeterminateBarLength == null ? 60.0 : this.indeterminateBarLength.get();
    }

    private BooleanProperty indeterminateBarEscapeProperty() {
        if (this.indeterminateBarEscape == null) {
            this.indeterminateBarEscape = new StyleableBooleanProperty(true){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarEscape";
                }

                @Override
                public CssMetaData<ProgressBar, Boolean> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_ESCAPE;
                }
            };
        }
        return this.indeterminateBarEscape;
    }

    private Boolean getIndeterminateBarEscape() {
        return this.indeterminateBarEscape == null ? true : this.indeterminateBarEscape.get();
    }

    private BooleanProperty indeterminateBarFlipProperty() {
        if (this.indeterminateBarFlip == null) {
            this.indeterminateBarFlip = new StyleableBooleanProperty(true){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarFlip";
                }

                @Override
                public CssMetaData<ProgressBar, Boolean> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_FLIP;
                }
            };
        }
        return this.indeterminateBarFlip;
    }

    private Boolean getIndeterminateBarFlip() {
        return this.indeterminateBarFlip == null ? true : this.indeterminateBarFlip.get();
    }

    private DoubleProperty indeterminateBarAnimationTimeProperty() {
        if (this.indeterminateBarAnimationTime == null) {
            this.indeterminateBarAnimationTime = new StyleableDoubleProperty(2.0){

                @Override
                public Object getBean() {
                    return ProgressBarSkin.this;
                }

                @Override
                public String getName() {
                    return "indeterminateBarAnimationTime";
                }

                @Override
                public CssMetaData<ProgressBar, Number> getCssMetaData() {
                    return StyleableProperties.INDETERMINATE_BAR_ANIMATION_TIME;
                }
            };
        }
        return this.indeterminateBarAnimationTime;
    }

    private double getIndeterminateBarAnimationTime() {
        return this.indeterminateBarAnimationTime == null ? 2.0 : this.indeterminateBarAnimationTime.get();
    }

    public ProgressBarSkin(ProgressBar control) {
        super(control);
        this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
        InvalidationListener listener = ProgressBarSkin$$Lambda$1.lambdaFactory$(this);
        control.widthProperty().addListener(listener);
        this.initialize();
        ((ProgressIndicator)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.bar = new StackPane();
        this.bar.getStyleClass().setAll((String[])new String[]{"bar"});
        this.getChildren().setAll((Node[])new Node[]{this.track, this.bar});
        this.clipRegion = new Region();
        this.bar.backgroundProperty().addListener(ProgressBarSkin$$Lambda$2.lambdaFactory$(this));
    }

    @Override
    protected void createIndeterminateTimeline() {
        if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
        }
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double startX = this.getIndeterminateBarEscape() != false ? -this.getIndeterminateBarLength().doubleValue() : 0.0;
        double endX = this.getIndeterminateBarEscape() != false ? w : w - this.getIndeterminateBarLength();
        this.indeterminateTransition = new IndeterminateTransition(startX, endX, this);
        this.indeterminateTransition.setCycleCount(-1);
        this.clipRegion.translateXProperty().bind(new When(this.bar.scaleXProperty().isEqualTo(-1.0, 1.0E-100)).then(this.bar.translateXProperty().subtract(w).add(this.indeterminateBarLengthProperty())).otherwise(this.bar.translateXProperty().negate()));
    }

    @Override
    protected void updateProgress() {
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        if (!isIndeterminate || !this.wasIndeterminate) {
            this.barWidth = (double)((int)(control.getWidth() - this.snappedLeftInset() - this.snappedRightInset()) * 2) * Math.min(1.0, Math.max(0.0, control.getProgress())) / 2.0;
            ((ProgressIndicator)this.getSkinnable()).requestLayout();
        }
        this.wasIndeterminate = isIndeterminate;
    }

    @Override
    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(100.0, leftInset + this.bar.prefWidth(((ProgressIndicator)this.getSkinnable()).getWidth()) + rightInset);
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.bar.prefHeight(width) + bottomInset;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressIndicator)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((ProgressIndicator)this.getSkinnable()).prefHeight(width);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        ProgressIndicator control = (ProgressIndicator)this.getSkinnable();
        boolean isIndeterminate = control.isIndeterminate();
        this.clipRegion.resizeRelocate(0.0, 0.0, w, h);
        this.track.resizeRelocate(x, y, w, h);
        this.bar.resizeRelocate(x, y, isIndeterminate ? this.getIndeterminateBarLength() : this.barWidth, h);
        this.track.setVisible(true);
        if (isIndeterminate) {
            this.createIndeterminateTimeline();
            if (((ProgressIndicator)this.getSkinnable()).impl_isTreeVisible()) {
                this.indeterminateTransition.play();
            }
            this.bar.setClip(this.clipRegion);
        } else if (this.indeterminateTransition != null) {
            this.indeterminateTransition.stop();
            this.indeterminateTransition = null;
            this.bar.setClip(null);
            this.bar.setScaleX(1.0);
            this.bar.setTranslateX(0.0);
            this.clipRegion.translateXProperty().unbind();
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ProgressBarSkin.getClassCssMetaData();
    }

    /* synthetic */ void lambda$initialize$434(ObservableValue observable, Background oldValue, Background newValue) {
        if (newValue != null && !newValue.getFills().isEmpty()) {
            BackgroundFill[] fills = new BackgroundFill[newValue.getFills().size()];
            for (int i = 0; i < newValue.getFills().size(); ++i) {
                BackgroundFill bf = newValue.getFills().get(i);
                fills[i] = new BackgroundFill(Color.BLACK, bf.getRadii(), bf.getInsets());
            }
            this.clipRegion.setBackground(new Background(fills));
        }
    }

    /* synthetic */ void lambda$new$433(Observable valueModel) {
        this.updateProgress();
    }

    private static class IndeterminateTransition
    extends Transition {
        private final WeakReference<ProgressBarSkin> skin;
        private final double startX;
        private final double endX;
        private final boolean flip;

        public IndeterminateTransition(double startX, double endX, ProgressBarSkin progressBarSkin) {
            this.startX = startX;
            this.endX = endX;
            this.skin = new WeakReference<ProgressBarSkin>(progressBarSkin);
            this.flip = progressBarSkin.getIndeterminateBarFlip();
            progressBarSkin.getIndeterminateBarEscape();
            this.setCycleDuration(Duration.seconds(progressBarSkin.getIndeterminateBarAnimationTime() * (double)(this.flip ? 2 : 1)));
        }

        @Override
        protected void interpolate(double frac) {
            ProgressBarSkin s = (ProgressBarSkin)this.skin.get();
            if (s == null) {
                this.stop();
            } else if (frac <= 0.5 || !this.flip) {
                s.bar.setScaleX(-1.0);
                s.bar.setTranslateX(this.startX + (double)(this.flip ? 2 : 1) * frac * (this.endX - this.startX));
            } else {
                s.bar.setScaleX(1.0);
                s.bar.setTranslateX(this.startX + 2.0 * (1.0 - frac) * (this.endX - this.startX));
            }
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ProgressBar, Number> INDETERMINATE_BAR_LENGTH = new CssMetaData<ProgressBar, Number>("-fx-indeterminate-bar-length", SizeConverter.getInstance(), (Number)60.0){

            @Override
            public boolean isSettable(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return skin.indeterminateBarLength == null || !skin.indeterminateBarLength.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indeterminateBarLengthProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Boolean> INDETERMINATE_BAR_ESCAPE = new CssMetaData<ProgressBar, Boolean>("-fx-indeterminate-bar-escape", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return skin.indeterminateBarEscape == null || !skin.indeterminateBarEscape.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indeterminateBarEscapeProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Boolean> INDETERMINATE_BAR_FLIP = new CssMetaData<ProgressBar, Boolean>("-fx-indeterminate-bar-flip", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return skin.indeterminateBarFlip == null || !skin.indeterminateBarFlip.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indeterminateBarFlipProperty());
            }
        };
        private static final CssMetaData<ProgressBar, Number> INDETERMINATE_BAR_ANIMATION_TIME = new CssMetaData<ProgressBar, Number>("-fx-indeterminate-bar-animation-time", SizeConverter.getInstance(), (Number)2.0){

            @Override
            public boolean isSettable(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return skin.indeterminateBarAnimationTime == null || !skin.indeterminateBarAnimationTime.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ProgressBar n) {
                ProgressBarSkin skin = (ProgressBarSkin)n.getSkin();
                return (StyleableProperty)((Object)skin.indeterminateBarAnimationTimeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            styleables.add(INDETERMINATE_BAR_LENGTH);
            styleables.add(INDETERMINATE_BAR_ESCAPE);
            styleables.add(INDETERMINATE_BAR_FLIP);
            styleables.add(INDETERMINATE_BAR_ANIMATION_TIME);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

