/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.ScrollBarBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.ScrollBarSkin$$Lambda$9;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class ScrollBarSkin
extends BehaviorSkinBase<ScrollBar, ScrollBarBehavior> {
    public static final int DEFAULT_LENGTH = 100;
    public static final int DEFAULT_WIDTH = 20;
    private StackPane thumb;
    private StackPane trackBackground;
    private StackPane track;
    private EndButton incButton;
    private EndButton decButton;
    private double trackLength;
    private double thumbLength;
    private double preDragThumbPos;
    private Point2D dragStart;
    private double trackPos;
    private static final double DEFAULT_EMBEDDED_SB_BREADTH = 8.0;

    public ScrollBarSkin(ScrollBar scrollbar) {
        super(scrollbar, new ScrollBarBehavior(scrollbar));
        this.initialize();
        ((ScrollBar)this.getSkinnable()).requestLayout();
        this.registerChangeListener(scrollbar.minProperty(), "MIN");
        this.registerChangeListener(scrollbar.maxProperty(), "MAX");
        this.registerChangeListener(scrollbar.valueProperty(), "VALUE");
        this.registerChangeListener(scrollbar.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(scrollbar.visibleAmountProperty(), "VISIBLE_AMOUNT");
    }

    private void initialize() {
        this.track = new StackPane();
        this.track.getStyleClass().setAll((String[])new String[]{"track"});
        this.trackBackground = new StackPane();
        this.trackBackground.getStyleClass().setAll((String[])new String[]{"track-background"});
        this.thumb = new StackPane(){

            @Override
            public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
                switch (attribute) {
                    case VALUE: {
                        return ((ScrollBar)ScrollBarSkin.this.getSkinnable()).getValue();
                    }
                }
                return super.queryAccessibleAttribute(attribute, parameters);
            }
        };
        this.thumb.getStyleClass().setAll((String[])new String[]{"thumb"});
        this.thumb.setAccessibleRole(AccessibleRole.THUMB);
        if (!IS_TOUCH_SUPPORTED) {
            this.incButton = new EndButton("increment-button", "increment-arrow"){

                @Override
                public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
                    switch (action) {
                        case FIRE: {
                            ((ScrollBar)ScrollBarSkin.this.getSkinnable()).increment();
                            break;
                        }
                        default: {
                            super.executeAccessibleAction(action, parameters);
                        }
                    }
                }
            };
            this.incButton.setAccessibleRole(AccessibleRole.INCREMENT_BUTTON);
            this.incButton.setOnMousePressed(ScrollBarSkin$$Lambda$1.lambdaFactory$(this));
            this.incButton.setOnMouseReleased(ScrollBarSkin$$Lambda$2.lambdaFactory$(this));
            this.decButton = new EndButton("decrement-button", "decrement-arrow"){

                @Override
                public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
                    switch (action) {
                        case FIRE: {
                            ((ScrollBar)ScrollBarSkin.this.getSkinnable()).decrement();
                            break;
                        }
                        default: {
                            super.executeAccessibleAction(action, parameters);
                        }
                    }
                }
            };
            this.decButton.setAccessibleRole(AccessibleRole.DECREMENT_BUTTON);
            this.decButton.setOnMousePressed(ScrollBarSkin$$Lambda$3.lambdaFactory$(this));
            this.decButton.setOnMouseReleased(ScrollBarSkin$$Lambda$4.lambdaFactory$(this));
        }
        this.track.setOnMousePressed(ScrollBarSkin$$Lambda$5.lambdaFactory$(this));
        this.track.setOnMouseReleased(ScrollBarSkin$$Lambda$6.lambdaFactory$(this));
        this.thumb.setOnMousePressed(ScrollBarSkin$$Lambda$7.lambdaFactory$(this));
        this.thumb.setOnMouseDragged(ScrollBarSkin$$Lambda$8.lambdaFactory$(this));
        this.thumb.setOnScrollStarted(ScrollBarSkin$$Lambda$9.lambdaFactory$(this));
        this.thumb.setOnScroll(ScrollBarSkin$$Lambda$10.lambdaFactory$(this));
        ((ScrollBar)this.getSkinnable()).addEventHandler(ScrollEvent.SCROLL, ScrollBarSkin$$Lambda$11.lambdaFactory$(this));
        this.getChildren().clear();
        if (!IS_TOUCH_SUPPORTED) {
            this.getChildren().addAll((Node[])new Node[]{this.trackBackground, this.incButton, this.decButton, this.track, this.thumb});
        } else {
            this.getChildren().addAll((Node[])new Node[]{this.track, this.thumb});
        }
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ORIENTATION".equals(p)) {
            ((ScrollBar)this.getSkinnable()).requestLayout();
        } else if ("MIN".equals(p) || "MAX".equals(p) || "VISIBLE_AMOUNT".equals(p)) {
            this.positionThumb();
            ((ScrollBar)this.getSkinnable()).requestLayout();
        } else if ("VALUE".equals(p)) {
            this.positionThumb();
        }
    }

    double getBreadth() {
        if (!IS_TOUCH_SUPPORTED) {
            if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                return Math.max(this.decButton.prefWidth(-1.0), this.incButton.prefWidth(-1.0)) + this.snappedLeftInset() + this.snappedRightInset();
            }
            return Math.max(this.decButton.prefHeight(-1.0), this.incButton.prefHeight(-1.0)) + this.snappedTopInset() + this.snappedBottomInset();
        }
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return Math.max(8.0, 8.0) + this.snappedLeftInset() + this.snappedRightInset();
        }
        return Math.max(8.0, 8.0) + this.snappedTopInset() + this.snappedBottomInset();
    }

    double minThumbLength() {
        return 1.5 * this.getBreadth();
    }

    double minTrackLength() {
        return 2.0 * this.getBreadth();
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            return this.getBreadth();
        }
        if (!IS_TOUCH_SUPPORTED) {
            return this.decButton.minWidth(-1.0) + this.incButton.minWidth(-1.0) + this.minTrackLength() + leftInset + rightInset;
        }
        return this.minTrackLength() + leftInset + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
            if (!IS_TOUCH_SUPPORTED) {
                return this.decButton.minHeight(-1.0) + this.incButton.minHeight(-1.0) + this.minTrackLength() + topInset + bottomInset;
            }
            return this.minTrackLength() + topInset + bottomInset;
        }
        return this.getBreadth();
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        return s.getOrientation() == Orientation.VERTICAL ? this.getBreadth() : 100.0 + leftInset + rightInset;
    }

    @Override
    protected double computePrefHeight(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        return s.getOrientation() == Orientation.VERTICAL ? 100.0 + topInset + bottomInset : this.getBreadth();
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        return s.getOrientation() == Orientation.VERTICAL ? s.prefWidth(-1.0) : Double.MAX_VALUE;
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        return s.getOrientation() == Orientation.VERTICAL ? Double.MAX_VALUE : s.prefHeight(-1.0);
    }

    void positionThumb() {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        double clampedValue = Utils.clamp(s.getMin(), s.getValue(), s.getMax());
        double d = this.trackPos = s.getMax() - s.getMin() > 0.0 ? (this.trackLength - this.thumbLength) * (clampedValue - s.getMin()) / (s.getMax() - s.getMin()) : 0.0;
        if (!IS_TOUCH_SUPPORTED) {
            this.trackPos = s.getOrientation() == Orientation.VERTICAL ? (this.trackPos += this.decButton.prefHeight(-1.0)) : (this.trackPos += this.decButton.prefWidth(-1.0));
        }
        this.thumb.setTranslateX(this.snapPosition(s.getOrientation() == Orientation.VERTICAL ? this.snappedLeftInset() : this.trackPos + this.snappedLeftInset()));
        this.thumb.setTranslateY(this.snapPosition(s.getOrientation() == Orientation.VERTICAL ? this.trackPos + this.snappedTopInset() : this.snappedTopInset()));
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        ScrollBar s = (ScrollBar)this.getSkinnable();
        double visiblePortion = s.getMax() > s.getMin() ? s.getVisibleAmount() / (s.getMax() - s.getMin()) : 1.0;
        if (s.getOrientation() == Orientation.VERTICAL) {
            if (!IS_TOUCH_SUPPORTED) {
                double decHeight = this.snapSize(this.decButton.prefHeight(-1.0));
                double incHeight = this.snapSize(this.incButton.prefHeight(-1.0));
                this.decButton.resize(w, decHeight);
                this.incButton.resize(w, incHeight);
                this.trackLength = this.snapSize(h - (decHeight + incHeight));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * visiblePortion, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(x), this.snapPosition(y), w, this.trackLength + decHeight + incHeight);
                this.decButton.relocate(this.snapPosition(x), this.snapPosition(y));
                this.incButton.relocate(this.snapPosition(x), this.snapPosition(y + h - incHeight));
                this.track.resizeRelocate(this.snapPosition(x), this.snapPosition(y + decHeight), w, this.trackLength);
                this.thumb.resize(this.snapSize(x >= 0.0 ? w : w + x), this.thumbLength);
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(h);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * visiblePortion, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(x), this.snapPosition(y), w, this.trackLength);
                this.thumb.resize(this.snapSize(x >= 0.0 ? w : w + x), this.thumbLength);
                this.positionThumb();
            }
        } else {
            if (!IS_TOUCH_SUPPORTED) {
                double decWidth = this.snapSize(this.decButton.prefWidth(-1.0));
                double incWidth = this.snapSize(this.incButton.prefWidth(-1.0));
                this.decButton.resize(decWidth, h);
                this.incButton.resize(incWidth, h);
                this.trackLength = this.snapSize(w - (decWidth + incWidth));
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * visiblePortion, this.trackLength));
                this.trackBackground.resizeRelocate(this.snapPosition(x), this.snapPosition(y), this.trackLength + decWidth + incWidth, h);
                this.decButton.relocate(this.snapPosition(x), this.snapPosition(y));
                this.incButton.relocate(this.snapPosition(x + w - incWidth), this.snapPosition(y));
                this.track.resizeRelocate(this.snapPosition(x + decWidth), this.snapPosition(y), this.trackLength, h);
                this.thumb.resize(this.thumbLength, this.snapSize(y >= 0.0 ? h : h + y));
                this.positionThumb();
            } else {
                this.trackLength = this.snapSize(w);
                this.thumbLength = this.snapSize(Utils.clamp(this.minThumbLength(), this.trackLength * visiblePortion, this.trackLength));
                this.track.resizeRelocate(this.snapPosition(x), this.snapPosition(y), this.trackLength, h);
                this.thumb.resize(this.thumbLength, this.snapSize(y >= 0.0 ? h : h + y));
                this.positionThumb();
            }
            s.resize(this.snapSize(s.getWidth()), this.snapSize(s.getHeight()));
        }
        if (s.getOrientation() == Orientation.VERTICAL && h >= this.computeMinHeight(-1.0, (int)y, this.snappedRightInset(), this.snappedBottomInset(), (int)x) - (y + this.snappedBottomInset()) || s.getOrientation() == Orientation.HORIZONTAL && w >= this.computeMinWidth(-1.0, (int)y, this.snappedRightInset(), this.snappedBottomInset(), (int)x) - (x + this.snappedRightInset())) {
            this.trackBackground.setVisible(true);
            this.track.setVisible(true);
            this.thumb.setVisible(true);
            if (!IS_TOUCH_SUPPORTED) {
                this.incButton.setVisible(true);
                this.decButton.setVisible(true);
            }
        } else {
            this.trackBackground.setVisible(false);
            this.track.setVisible(false);
            this.thumb.setVisible(false);
            if (!IS_TOUCH_SUPPORTED) {
                if (h >= this.decButton.computeMinWidth(-1.0)) {
                    this.decButton.setVisible(true);
                } else {
                    this.decButton.setVisible(false);
                }
                if (h >= this.incButton.computeMinWidth(-1.0)) {
                    this.incButton.setVisible(true);
                } else {
                    this.incButton.setVisible(false);
                }
            }
        }
    }

    public Node getThumb() {
        return this.thumb;
    }

    public Node getTrack() {
        return this.track;
    }

    public Node getIncButton() {
        return this.incButton;
    }

    public Node getDecButton() {
        return this.decButton;
    }

    /* synthetic */ void lambda$initialize$445(ScrollEvent event) {
        if (this.trackLength > this.thumbLength) {
            double delta;
            double dx = event.getDeltaX();
            double dy = event.getDeltaY();
            dx = Math.abs(dx) < Math.abs(dy) ? dy : dx;
            ScrollBar sb = (ScrollBar)this.getSkinnable();
            double d = delta = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? dy : dx;
            if (event.isDirect()) {
                if (this.trackLength > this.thumbLength) {
                    ((ScrollBarBehavior)this.getBehavior()).thumbDragged((((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? event.getY() : event.getX()) / this.trackLength);
                    event.consume();
                }
            } else if (delta > 0.0 && sb.getValue() > sb.getMin()) {
                sb.decrement();
                event.consume();
            } else if (delta < 0.0 && sb.getValue() < sb.getMax()) {
                sb.increment();
                event.consume();
            }
        }
    }

    /* synthetic */ void lambda$initialize$444(ScrollEvent event) {
        if (event.isDirect() && ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
            if (this.trackLength > this.thumbLength) {
                Point2D cur = this.thumb.localToParent(event.getX(), event.getY());
                if (this.dragStart == null) {
                    this.dragStart = this.thumb.localToParent(event.getX(), event.getY());
                }
                double dragPos = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? cur.getY() - this.dragStart.getY() : cur.getX() - this.dragStart.getX();
                ((ScrollBarBehavior)this.getBehavior()).thumbDragged(this.preDragThumbPos + dragPos / (this.trackLength - this.thumbLength));
            }
            event.consume();
            return;
        }
    }

    /* synthetic */ void lambda$initialize$443(ScrollEvent se) {
        if (se.isDirect() && ((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
            this.dragStart = this.thumb.localToParent(se.getX(), se.getY());
            double clampedValue = Utils.clamp(((ScrollBar)this.getSkinnable()).getMin(), ((ScrollBar)this.getSkinnable()).getValue(), ((ScrollBar)this.getSkinnable()).getMax());
            this.preDragThumbPos = (clampedValue - ((ScrollBar)this.getSkinnable()).getMin()) / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin());
            se.consume();
        }
    }

    /* synthetic */ void lambda$initialize$442(MouseEvent me) {
        if (me.isSynthesized()) {
            me.consume();
            return;
        }
        if (((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
            if (this.trackLength > this.thumbLength) {
                Point2D cur = this.thumb.localToParent(me.getX(), me.getY());
                if (this.dragStart == null) {
                    this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
                }
                double dragPos = ((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? cur.getY() - this.dragStart.getY() : cur.getX() - this.dragStart.getX();
                ((ScrollBarBehavior)this.getBehavior()).thumbDragged(this.preDragThumbPos + dragPos / (this.trackLength - this.thumbLength));
            }
            me.consume();
        }
    }

    /* synthetic */ void lambda$initialize$441(MouseEvent me) {
        if (me.isSynthesized()) {
            me.consume();
            return;
        }
        if (((ScrollBar)this.getSkinnable()).getMax() > ((ScrollBar)this.getSkinnable()).getMin()) {
            this.dragStart = this.thumb.localToParent(me.getX(), me.getY());
            double clampedValue = Utils.clamp(((ScrollBar)this.getSkinnable()).getMin(), ((ScrollBar)this.getSkinnable()).getValue(), ((ScrollBar)this.getSkinnable()).getMax());
            this.preDragThumbPos = (clampedValue - ((ScrollBar)this.getSkinnable()).getMin()) / (((ScrollBar)this.getSkinnable()).getMax() - ((ScrollBar)this.getSkinnable()).getMin());
            me.consume();
        }
    }

    /* synthetic */ void lambda$initialize$440(MouseEvent me) {
        ((ScrollBarBehavior)this.getBehavior()).trackRelease();
        me.consume();
    }

    /* synthetic */ void lambda$initialize$439(MouseEvent me) {
        if (!this.thumb.isPressed() && me.getButton() == MouseButton.PRIMARY) {
            if (((ScrollBar)this.getSkinnable()).getOrientation() == Orientation.VERTICAL) {
                if (this.trackLength != 0.0) {
                    ((ScrollBarBehavior)this.getBehavior()).trackPress(me.getY() / this.trackLength);
                    me.consume();
                }
            } else if (this.trackLength != 0.0) {
                ((ScrollBarBehavior)this.getBehavior()).trackPress(me.getX() / this.trackLength);
                me.consume();
            }
        }
    }

    /* synthetic */ void lambda$initialize$438(MouseEvent me) {
        if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
            ((ScrollBarBehavior)this.getBehavior()).decButtonReleased();
        }
        me.consume();
    }

    /* synthetic */ void lambda$initialize$437(MouseEvent me) {
        if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
            ((ScrollBarBehavior)this.getBehavior()).decButtonPressed();
        }
        me.consume();
    }

    /* synthetic */ void lambda$initialize$436(MouseEvent me) {
        if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
            ((ScrollBarBehavior)this.getBehavior()).incButtonReleased();
        }
        me.consume();
    }

    /* synthetic */ void lambda$initialize$435(MouseEvent me) {
        if (!this.thumb.isVisible() || this.trackLength > this.thumbLength) {
            ((ScrollBarBehavior)this.getBehavior()).incButtonPressed();
        }
        me.consume();
    }

    private static class EndButton
    extends Region {
        private Region arrow;

        private EndButton(String styleClass, String arrowStyleClass) {
            this.getStyleClass().setAll((String[])new String[]{styleClass});
            this.arrow = new Region();
            this.arrow.getStyleClass().setAll((String[])new String[]{arrowStyleClass});
            this.getChildren().setAll((Node[])new Node[]{this.arrow});
            this.requestLayout();
        }

        @Override
        protected void layoutChildren() {
            double top = this.snappedTopInset();
            double left = this.snappedLeftInset();
            double bottom = this.snappedBottomInset();
            double right = this.snappedRightInset();
            double aw = this.snapSize(this.arrow.prefWidth(-1.0));
            double ah = this.snapSize(this.arrow.prefHeight(-1.0));
            double yPos = this.snapPosition((this.getHeight() - (top + bottom + ah)) / 2.0);
            double xPos = this.snapPosition((this.getWidth() - (left + right + aw)) / 2.0);
            this.arrow.resizeRelocate(xPos + left, yPos + top, aw, ah);
        }

        @Override
        protected double computeMinHeight(double width) {
            return this.prefHeight(-1.0);
        }

        @Override
        protected double computeMinWidth(double height) {
            return this.prefWidth(-1.0);
        }

        @Override
        protected double computePrefWidth(double height) {
            double left = this.snappedLeftInset();
            double right = this.snappedRightInset();
            double aw = this.snapSize(this.arrow.prefWidth(-1.0));
            return left + aw + right;
        }

        @Override
        protected double computePrefHeight(double width) {
            double top = this.snappedTopInset();
            double bottom = this.snappedBottomInset();
            double ah = this.snapSize(this.arrow.prefHeight(-1.0));
            return top + ah + bottom;
        }
    }
}

