/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.SplitPaneSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.SplitPaneSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.SplitPaneSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.SplitPaneSkin$$Lambda$4;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class SplitPaneSkin
extends BehaviorSkinBase<SplitPane, BehaviorBase<SplitPane>> {
    private ObservableList<Content> contentRegions;
    private ObservableList<ContentDivider> contentDividers;
    private boolean horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
    private double previousSize = -1.0;
    private int lastDividerUpdate = 0;
    private boolean resize = false;
    private boolean checkDividerPos = true;

    public SplitPaneSkin(SplitPane splitPane) {
        super(splitPane, new BehaviorBase<SplitPane>(splitPane, Collections.emptyList()));
        this.contentRegions = FXCollections.observableArrayList();
        this.contentDividers = FXCollections.observableArrayList();
        int index = 0;
        for (Node n : ((SplitPane)this.getSkinnable()).getItems()) {
            this.addContent(index++, n);
        }
        this.initializeContentListener();
        for (SplitPane.Divider d : ((SplitPane)this.getSkinnable()).getDividers()) {
            this.addDivider(d);
        }
        this.registerChangeListener(splitPane.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(splitPane.widthProperty(), "WIDTH");
        this.registerChangeListener(splitPane.heightProperty(), "HEIGHT");
    }

    private void addContent(int index, Node n) {
        Content c = new Content(n);
        this.contentRegions.add(index, c);
        this.getChildren().add(index, c);
    }

    private void removeContent(Node n) {
        for (Content c : this.contentRegions) {
            if (!c.getContent().equals(n)) continue;
            this.getChildren().remove(c);
            this.contentRegions.remove(c);
            break;
        }
    }

    private void initializeContentListener() {
        ((SplitPane)this.getSkinnable()).getItems().addListener(SplitPaneSkin$$Lambda$1.lambdaFactory$(this));
    }

    private void checkDividerPosition(ContentDivider divider, double newPos, double oldPos) {
        double maxLeft;
        double minRight;
        double minLeft;
        double dividerWidth = divider.prefWidth(-1.0);
        Content left = this.getLeft(divider);
        Content right = this.getRight(divider);
        double d = left == null ? 0.0 : (minLeft = this.horizontal ? left.minWidth(-1.0) : left.minHeight(-1.0));
        double d2 = right == null ? 0.0 : (minRight = this.horizontal ? right.minWidth(-1.0) : right.minHeight(-1.0));
        double d3 = left == null ? 0.0 : (left.getContent() != null ? (this.horizontal ? left.getContent().maxWidth(-1.0) : left.getContent().maxHeight(-1.0)) : (maxLeft = 0.0));
        double maxRight = right == null ? 0.0 : (right.getContent() != null ? (this.horizontal ? right.getContent().maxWidth(-1.0) : right.getContent().maxHeight(-1.0)) : 0.0);
        double previousDividerPos = 0.0;
        double nextDividerPos = this.getSize();
        int index = this.contentDividers.indexOf(divider);
        if (index - 1 >= 0 && (previousDividerPos = ((ContentDivider)this.contentDividers.get(index - 1)).getDividerPos()) == -1.0) {
            previousDividerPos = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(index - 1));
        }
        if (index + 1 < this.contentDividers.size() && (nextDividerPos = ((ContentDivider)this.contentDividers.get(index + 1)).getDividerPos()) == -1.0) {
            nextDividerPos = this.getAbsoluteDividerPos((ContentDivider)this.contentDividers.get(index + 1));
        }
        this.checkDividerPos = false;
        if (newPos > oldPos) {
            double min;
            double max = previousDividerPos == 0.0 ? maxLeft : previousDividerPos + dividerWidth + maxLeft;
            double stopPos = Math.min(max, min = nextDividerPos - minRight - dividerWidth);
            if (newPos >= stopPos) {
                this.setAbsoluteDividerPos(divider, stopPos);
            } else {
                double rightMax = nextDividerPos - maxRight - dividerWidth;
                if (newPos <= rightMax) {
                    this.setAbsoluteDividerPos(divider, rightMax);
                } else {
                    this.setAbsoluteDividerPos(divider, newPos);
                }
            }
        } else {
            double max = nextDividerPos - maxRight - dividerWidth;
            double min = previousDividerPos == 0.0 ? minLeft : previousDividerPos + minLeft + dividerWidth;
            double stopPos = Math.max(max, min);
            if (newPos <= stopPos) {
                this.setAbsoluteDividerPos(divider, stopPos);
            } else {
                double leftMax = previousDividerPos + maxLeft + dividerWidth;
                if (newPos >= leftMax) {
                    this.setAbsoluteDividerPos(divider, leftMax);
                } else {
                    this.setAbsoluteDividerPos(divider, newPos);
                }
            }
        }
        this.checkDividerPos = true;
    }

    private void addDivider(SplitPane.Divider d) {
        ContentDivider c = new ContentDivider(d);
        c.setInitialPos(d.getPosition());
        c.setDividerPos(-1.0);
        PosPropertyListener posPropertyListener = new PosPropertyListener(c);
        c.setPosPropertyListener(posPropertyListener);
        d.positionProperty().addListener(posPropertyListener);
        this.initializeDivderEventHandlers(c);
        this.contentDividers.add(c);
        this.getChildren().add(c);
    }

    private void removeAllDividers() {
        ListIterator dividers = this.contentDividers.listIterator();
        while (dividers.hasNext()) {
            ContentDivider c = (ContentDivider)dividers.next();
            this.getChildren().remove(c);
            c.getDivider().positionProperty().removeListener(c.getPosPropertyListener());
            dividers.remove();
        }
        this.lastDividerUpdate = 0;
    }

    private void initializeDivderEventHandlers(ContentDivider divider) {
        divider.addEventHandler(MouseEvent.ANY, SplitPaneSkin$$Lambda$2.lambdaFactory$());
        divider.setOnMousePressed(SplitPaneSkin$$Lambda$3.lambdaFactory$(this, divider));
        divider.setOnMouseDragged(SplitPaneSkin$$Lambda$4.lambdaFactory$(this, divider));
    }

    private Content getLeft(ContentDivider d) {
        int index = this.contentDividers.indexOf(d);
        if (index != -1) {
            return (Content)this.contentRegions.get(index);
        }
        return null;
    }

    private Content getRight(ContentDivider d) {
        int index = this.contentDividers.indexOf(d);
        if (index != -1) {
            return (Content)this.contentRegions.get(index + 1);
        }
        return null;
    }

    @Override
    protected void handleControlPropertyChanged(String property) {
        super.handleControlPropertyChanged(property);
        if ("ORIENTATION".equals(property)) {
            this.horizontal = ((SplitPane)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL;
            this.previousSize = -1.0;
            for (ContentDivider c : this.contentDividers) {
                c.setGrabberStyle(this.horizontal);
            }
            ((SplitPane)this.getSkinnable()).requestLayout();
        } else if ("WIDTH".equals(property) || "HEIGHT".equals(property)) {
            ((SplitPane)this.getSkinnable()).requestLayout();
        }
    }

    private void setAbsoluteDividerPos(ContentDivider divider, double value) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && divider != null) {
            SplitPane.Divider paneDivider = divider.getDivider();
            divider.setDividerPos(value);
            double size = this.getSize();
            if (size != 0.0) {
                double pos = value + divider.prefWidth(-1.0) / 2.0;
                paneDivider.setPosition(pos / size);
            } else {
                paneDivider.setPosition(0.0);
            }
        }
    }

    private double getAbsoluteDividerPos(ContentDivider divider) {
        if (((SplitPane)this.getSkinnable()).getWidth() > 0.0 && ((SplitPane)this.getSkinnable()).getHeight() > 0.0 && divider != null) {
            SplitPane.Divider paneDivider = divider.getDivider();
            double newPos = this.posToDividerPos(divider, paneDivider.getPosition());
            divider.setDividerPos(newPos);
            return newPos;
        }
        return 0.0;
    }

    private double posToDividerPos(ContentDivider divider, double pos) {
        double newPos = this.getSize() * pos;
        newPos = pos == 1.0 ? (newPos -= divider.prefWidth(-1.0)) : (newPos -= divider.prefWidth(-1.0) / 2.0);
        return Math.round(newPos);
    }

    private double totalMinSize() {
        double dividerWidth = !this.contentDividers.isEmpty() ? (double)this.contentDividers.size() * ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0) : 0.0;
        double minSize = 0.0;
        for (Content c : this.contentRegions) {
            if (this.horizontal) {
                minSize += c.minWidth(-1.0);
                continue;
            }
            minSize += c.minHeight(-1.0);
        }
        return minSize + dividerWidth;
    }

    private double getSize() {
        SplitPane s = (SplitPane)this.getSkinnable();
        double size = this.totalMinSize();
        if (this.horizontal) {
            if (s.getWidth() > size) {
                size = s.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
            }
        } else if (s.getHeight() > size) {
            size = s.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        }
        return size;
    }

    private double distributeTo(List<Content> available, double size) {
        if (available.isEmpty()) {
            return size;
        }
        size = this.snapSize(size);
        int portion = (int)size / available.size();
        while (size > 0.0 && !available.isEmpty()) {
            Iterator<Content> i = available.iterator();
            while (i.hasNext()) {
                double min;
                Content c = i.next();
                double max = Math.min(this.horizontal ? c.maxWidth(-1.0) : c.maxHeight(-1.0), Double.MAX_VALUE);
                double d = min = this.horizontal ? c.minWidth(-1.0) : c.minHeight(-1.0);
                if (c.getArea() >= max) {
                    c.setAvailable(c.getArea() - min);
                    i.remove();
                    continue;
                }
                if ((double)portion >= max - c.getArea()) {
                    size -= max - c.getArea();
                    c.setArea(max);
                    c.setAvailable(max - min);
                    i.remove();
                } else {
                    c.setArea(c.getArea() + (double)portion);
                    c.setAvailable(c.getArea() - min);
                    size -= (double)portion;
                }
                if ((int)size != 0) continue;
                return size;
            }
            if (available.isEmpty()) {
                return size;
            }
            portion = (int)size / available.size();
            int remainder = (int)size % available.size();
            if (portion != 0 || remainder == 0) continue;
            portion = remainder;
            remainder = 0;
        }
        return size;
    }

    private double distributeFrom(double size, List<Content> available) {
        if (available.isEmpty()) {
            return size;
        }
        size = this.snapSize(size);
        int portion = (int)size / available.size();
        while (size > 0.0 && !available.isEmpty()) {
            Iterator<Content> i = available.iterator();
            while (i.hasNext()) {
                Content c = i.next();
                if ((double)portion >= c.getAvailable()) {
                    c.setArea(c.getArea() - c.getAvailable());
                    size -= c.getAvailable();
                    c.setAvailable(0.0);
                    i.remove();
                } else {
                    c.setArea(c.getArea() - (double)portion);
                    c.setAvailable(c.getAvailable() - (double)portion);
                    size -= (double)portion;
                }
                if ((int)size != 0) continue;
                return size;
            }
            if (available.isEmpty()) {
                return size;
            }
            portion = (int)size / available.size();
            int remainder = (int)size % available.size();
            if (portion != 0 || remainder == 0) continue;
            portion = remainder;
            remainder = 0;
        }
        return size;
    }

    private void setupContentAndDividerForLayout() {
        double dividerWidth = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        double startX = 0.0;
        double startY = 0.0;
        for (Content c : this.contentRegions) {
            if (this.resize && !c.isResizableWithParent()) {
                c.setArea(c.getResizableWithParentArea());
            }
            c.setX(startX);
            c.setY(startY);
            if (this.horizontal) {
                startX += c.getArea() + dividerWidth;
                continue;
            }
            startY += c.getArea() + dividerWidth;
        }
        startX = 0.0;
        startY = 0.0;
        this.checkDividerPos = false;
        for (int i = 0; i < this.contentDividers.size(); ++i) {
            ContentDivider d = (ContentDivider)this.contentDividers.get(i);
            if (this.horizontal) {
                startX += this.getLeft(d).getArea() + (i == 0 ? 0.0 : dividerWidth);
            } else {
                startY += this.getLeft(d).getArea() + (i == 0 ? 0.0 : dividerWidth);
            }
            d.setX(startX);
            d.setY(startY);
            this.setAbsoluteDividerPos(d, this.horizontal ? d.getX() : d.getY());
            d.posExplicit = false;
        }
        this.checkDividerPos = true;
    }

    private void layoutDividersAndContent(double width, double height) {
        double paddingX = this.snappedLeftInset();
        double paddingY = this.snappedTopInset();
        double dividerWidth = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
        for (Content content : this.contentRegions) {
            if (this.horizontal) {
                content.setClipSize(content.getArea(), height);
                this.layoutInArea(content, content.getX() + paddingX, content.getY() + paddingY, content.getArea(), height, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            content.setClipSize(width, content.getArea());
            this.layoutInArea(content, content.getX() + paddingX, content.getY() + paddingY, width, content.getArea(), 0.0, HPos.CENTER, VPos.CENTER);
        }
        for (ContentDivider contentDivider : this.contentDividers) {
            if (this.horizontal) {
                contentDivider.resize(dividerWidth, height);
                this.positionInArea(contentDivider, contentDivider.getX() + paddingX, contentDivider.getY() + paddingY, dividerWidth, height, 0.0, HPos.CENTER, VPos.CENTER);
                continue;
            }
            contentDivider.resize(width, dividerWidth);
            this.positionInArea(contentDivider, contentDivider.getX() + paddingX, contentDivider.getY() + paddingY, width, dividerWidth, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double dividerWidth;
        block60: {
            double sh;
            double sw;
            block59: {
                int size;
                int remainder;
                int portion;
                boolean growing;
                ArrayList<Content> resizeList;
                block55: {
                    block58: {
                        SplitPane s = (SplitPane)this.getSkinnable();
                        sw = s.getWidth();
                        sh = s.getHeight();
                        if (!s.isVisible()) return;
                        if (this.horizontal) {
                            if (sw == 0.0) {
                                return;
                            }
                        } else if (sh == 0.0) return;
                        if (this.contentRegions.isEmpty()) {
                            return;
                        }
                        double d = dividerWidth = this.contentDividers.isEmpty() ? 0.0 : ((ContentDivider)this.contentDividers.get(0)).prefWidth(-1.0);
                        if (this.contentDividers.size() <= 0 || this.previousSize == -1.0 || this.previousSize == (this.horizontal ? sw : sh)) break block58;
                        resizeList = new ArrayList<Content>();
                        for (Content c : this.contentRegions) {
                            if (!c.isResizableWithParent()) continue;
                            resizeList.add(c);
                        }
                        double delta = (this.horizontal ? s.getWidth() : s.getHeight()) - this.previousSize;
                        growing = delta > 0.0;
                        if ((delta = Math.abs(delta)) == 0.0 || resizeList.isEmpty()) break block59;
                        portion = (int)delta / resizeList.size();
                        remainder = (int)delta % resizeList.size();
                        size = 0;
                        if (portion == 0) {
                            portion = remainder;
                            size = remainder;
                            remainder = 0;
                            break block55;
                        } else {
                            size = portion * resizeList.size();
                        }
                        break block55;
                    }
                    this.previousSize = this.horizontal ? sw : sh;
                    break block60;
                }
                while (size > 0 && !resizeList.isEmpty()) {
                    double area;
                    Content content;
                    block56: {
                        double min;
                        int id;
                        if (growing) {
                            ++this.lastDividerUpdate;
                        } else {
                            --this.lastDividerUpdate;
                            if (this.lastDividerUpdate < 0) {
                                this.lastDividerUpdate = this.contentRegions.size() - 1;
                            }
                        }
                        if (!(content = (Content)this.contentRegions.get(id = this.lastDividerUpdate % this.contentRegions.size())).isResizableWithParent() || !resizeList.contains(content)) continue;
                        area = content.getArea();
                        if (growing) {
                            double max;
                            double d = max = this.horizontal ? content.maxWidth(-1.0) : content.maxHeight(-1.0);
                            if (area + (double)portion <= max) {
                                area += (double)portion;
                                break block56;
                            } else {
                                resizeList.remove(content);
                                continue;
                            }
                        }
                        double d = min = this.horizontal ? content.minWidth(-1.0) : content.minHeight(-1.0);
                        if (area - (double)portion >= min) {
                            area -= (double)portion;
                        } else {
                            resizeList.remove(content);
                            continue;
                        }
                    }
                    content.setArea(area);
                    if ((size -= portion) == 0 && remainder != 0) {
                        portion = remainder;
                        size = remainder;
                        remainder = 0;
                        continue;
                    }
                    if (size != 0) continue;
                }
                for (Content c : this.contentRegions) {
                    c.setResizableWithParentArea(c.getArea());
                    c.setAvailable(0.0);
                }
                this.resize = true;
            }
            this.previousSize = this.horizontal ? sw : sh;
        }
        double minSize = this.totalMinSize();
        if (!(minSize > (this.horizontal ? w : h))) {
        } else {
            double percentage = 0.0;
            int i = 0;
            while (true) {
                if (i >= this.contentRegions.size()) {
                    this.setupContentAndDividerForLayout();
                    this.layoutDividersAndContent(w, h);
                    this.resize = false;
                    return;
                }
                Content c = (Content)this.contentRegions.get(i);
                double min = this.horizontal ? c.minWidth(-1.0) : c.minHeight(-1.0);
                percentage = min / minSize;
                c.setArea(this.snapSpace(percentage * (this.horizontal ? w : h)));
                c.setAvailable(0.0);
                ++i;
            }
        }
        for (int trys = 0; trys < 10; ++trys) {
            ContentDivider previousDivider = null;
            ContentDivider divider = null;
            for (int i = 0; i < this.contentRegions.size(); ++i) {
                double space = 0.0;
                if (i < this.contentDividers.size()) {
                    divider = (ContentDivider)this.contentDividers.get(i);
                    if (divider.posExplicit) {
                        this.checkDividerPosition(divider, this.posToDividerPos(divider, divider.d.getPosition()), divider.getDividerPos());
                    }
                    if (i == 0) {
                        space = this.getAbsoluteDividerPos(divider);
                    } else {
                        double newPos = this.getAbsoluteDividerPos(previousDivider) + dividerWidth;
                        if (this.getAbsoluteDividerPos(divider) <= this.getAbsoluteDividerPos(previousDivider)) {
                            this.setAndCheckAbsoluteDividerPos(divider, newPos);
                        }
                        space = this.getAbsoluteDividerPos(divider) - newPos;
                    }
                } else if (i == this.contentDividers.size()) {
                    space = (this.horizontal ? w : h) - (previousDivider != null ? this.getAbsoluteDividerPos(previousDivider) + dividerWidth : 0.0);
                }
                if (!this.resize || divider.posExplicit) {
                    ((Content)this.contentRegions.get(i)).setArea(space);
                }
                previousDivider = divider;
            }
            double spaceRequested = 0.0;
            double extraSpace = 0.0;
            for (Content c : this.contentRegions) {
                double max = 0.0;
                double min = 0.0;
                if (c != null) {
                    max = this.horizontal ? c.maxWidth(-1.0) : c.maxHeight(-1.0);
                    double d = min = this.horizontal ? c.minWidth(-1.0) : c.minHeight(-1.0);
                }
                if (c.getArea() >= max) {
                    extraSpace += c.getArea() - max;
                    c.setArea(max);
                }
                c.setAvailable(c.getArea() - min);
                if (!(c.getAvailable() < 0.0)) continue;
                spaceRequested += c.getAvailable();
            }
            spaceRequested = Math.abs(spaceRequested);
            ArrayList<Content> availableList = new ArrayList<Content>();
            ArrayList<Content> storageList = new ArrayList<Content>();
            ArrayList<Content> spaceRequestor = new ArrayList<Content>();
            double available = 0.0;
            for (Content c : this.contentRegions) {
                if (c.getAvailable() >= 0.0) {
                    available += c.getAvailable();
                    availableList.add(c);
                }
                if (this.resize && !c.isResizableWithParent()) {
                    if (c.getArea() >= c.getResizableWithParentArea()) {
                        extraSpace += c.getArea() - c.getResizableWithParentArea();
                    } else {
                        spaceRequested += c.getResizableWithParentArea() - c.getArea();
                    }
                    c.setAvailable(0.0);
                }
                if (this.resize) {
                    if (c.isResizableWithParent()) {
                        storageList.add(c);
                    }
                } else {
                    storageList.add(c);
                }
                if (!(c.getAvailable() < 0.0)) continue;
                spaceRequestor.add(c);
            }
            if (extraSpace > 0.0) {
                extraSpace = this.distributeTo(storageList, extraSpace);
                spaceRequested = 0.0;
                spaceRequestor.clear();
                available = 0.0;
                availableList.clear();
                for (Content c : this.contentRegions) {
                    if (c.getAvailable() < 0.0) {
                        spaceRequested += c.getAvailable();
                        spaceRequestor.add(c);
                        continue;
                    }
                    available += c.getAvailable();
                    availableList.add(c);
                }
                spaceRequested = Math.abs(spaceRequested);
            }
            if (available >= spaceRequested) {
                for (Content requestor : spaceRequestor) {
                    double min = this.horizontal ? requestor.minWidth(-1.0) : requestor.minHeight(-1.0);
                    requestor.setArea(min);
                    requestor.setAvailable(0.0);
                }
                if (spaceRequested > 0.0 && !spaceRequestor.isEmpty()) {
                    this.distributeFrom(spaceRequested, availableList);
                }
                if (this.resize) {
                    double total = 0.0;
                    for (Content c : this.contentRegions) {
                        if (c.isResizableWithParent()) {
                            total += c.getArea();
                            continue;
                        }
                        total += c.getResizableWithParentArea();
                    }
                    total += dividerWidth * (double)this.contentDividers.size();
                    double d = this.horizontal ? w : h;
                    if (total < d) {
                        this.distributeTo(storageList, extraSpace += (this.horizontal ? w : h) - total);
                    } else {
                        this.distributeFrom(spaceRequested += total - (this.horizontal ? w : h), storageList);
                    }
                }
            }
            this.setupContentAndDividerForLayout();
            boolean passed = true;
            for (Content c : this.contentRegions) {
                double min;
                double max = this.horizontal ? c.maxWidth(-1.0) : c.maxHeight(-1.0);
                double d = min = this.horizontal ? c.minWidth(-1.0) : c.minHeight(-1.0);
                if (!(c.getArea() < min) && !(c.getArea() > max)) continue;
                passed = false;
                break;
            }
            if (passed) break;
        }
        this.layoutDividersAndContent(w, h);
        this.resize = false;
    }

    private void setAndCheckAbsoluteDividerPos(ContentDivider divider, double value) {
        double oldPos = divider.getDividerPos();
        this.setAbsoluteDividerPos(divider, value);
        this.checkDividerPosition(divider, value, oldPos);
    }

    @Override
    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minWidth = 0.0;
        double maxMinWidth = 0.0;
        for (Content c : this.contentRegions) {
            minWidth += c.minWidth(-1.0);
            maxMinWidth = Math.max(maxMinWidth, c.minWidth(-1.0));
        }
        for (ContentDivider d : this.contentDividers) {
            minWidth += d.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return minWidth + leftInset + rightInset;
        }
        return maxMinWidth + leftInset + rightInset;
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double minHeight = 0.0;
        double maxMinHeight = 0.0;
        for (Content c : this.contentRegions) {
            minHeight += c.minHeight(-1.0);
            maxMinHeight = Math.max(maxMinHeight, c.minHeight(-1.0));
        }
        for (ContentDivider d : this.contentDividers) {
            minHeight += d.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return maxMinHeight + topInset + bottomInset;
        }
        return minHeight + topInset + bottomInset;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefWidth = 0.0;
        double prefMaxWidth = 0.0;
        for (Content c : this.contentRegions) {
            prefWidth += c.prefWidth(-1.0);
            prefMaxWidth = Math.max(prefMaxWidth, c.prefWidth(-1.0));
        }
        for (ContentDivider d : this.contentDividers) {
            prefWidth += d.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return prefWidth + leftInset + rightInset;
        }
        return prefMaxWidth + leftInset + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = 0.0;
        double maxPrefHeight = 0.0;
        for (Content c : this.contentRegions) {
            prefHeight += c.prefHeight(-1.0);
            maxPrefHeight = Math.max(maxPrefHeight, c.prefHeight(-1.0));
        }
        for (ContentDivider d : this.contentDividers) {
            prefHeight += d.prefWidth(-1.0);
        }
        if (this.horizontal) {
            return maxPrefHeight + topInset + bottomInset;
        }
        return prefHeight + topInset + bottomInset;
    }

    /* synthetic */ void lambda$initializeDivderEventHandlers$484(ContentDivider contentDivider, MouseEvent e) {
        double delta = 0.0;
        delta = this.horizontal ? (((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - e.getSceneX() : e.getSceneX()) : e.getSceneY();
        this.setAndCheckAbsoluteDividerPos(contentDivider, Math.ceil(contentDivider.getInitialPos() + (delta -= contentDivider.getPressPos())));
        e.consume();
    }

    /* synthetic */ void lambda$initializeDivderEventHandlers$483(ContentDivider contentDivider, MouseEvent e) {
        if (this.horizontal) {
            contentDivider.setInitialPos(contentDivider.getDividerPos());
            contentDivider.setPressPos(e.getSceneX());
            contentDivider.setPressPos(((SplitPane)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? ((SplitPane)this.getSkinnable()).getWidth() - e.getSceneX() : e.getSceneX());
        } else {
            contentDivider.setInitialPos(contentDivider.getDividerPos());
            contentDivider.setPressPos(e.getSceneY());
        }
        e.consume();
    }

    static /* synthetic */ void lambda$initializeDivderEventHandlers$482(MouseEvent event) {
        event.consume();
    }

    /* synthetic */ void lambda$initializeContentListener$481(ListChangeListener.Change c) {
        while (c.next()) {
            Object n3;
            int index;
            if (c.wasPermutated() || c.wasUpdated()) {
                this.getChildren().clear();
                this.contentRegions.clear();
                index = 0;
                for (Node n2 : c.getList()) {
                    this.addContent(index++, n2);
                }
                continue;
            }
            for (Object n3 : c.getRemoved()) {
                this.removeContent((Node)n3);
            }
            index = c.getFrom();
            n3 = c.getAddedSubList().iterator();
            while (n3.hasNext()) {
                Node n2;
                n2 = (Node)n3.next();
                this.addContent(index++, n2);
            }
        }
        this.removeAllDividers();
        for (SplitPane.Divider d : ((SplitPane)this.getSkinnable()).getDividers()) {
            this.addDivider(d);
        }
    }

    static class Content
    extends StackPane {
        private Node content;
        private Rectangle clipRect = new Rectangle();
        private double x;
        private double y;
        private double area;
        private double resizableWithParentArea;
        private double available;

        public Content(Node n) {
            this.setClip(this.clipRect);
            this.content = n;
            if (n != null) {
                this.getChildren().add(n);
            }
            this.x = 0.0;
            this.y = 0.0;
        }

        public Node getContent() {
            return this.content;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getArea() {
            return this.area;
        }

        public void setArea(double area) {
            this.area = area;
        }

        public double getAvailable() {
            return this.available;
        }

        public void setAvailable(double available) {
            this.available = available;
        }

        public boolean isResizableWithParent() {
            return SplitPane.isResizableWithParent(this.content);
        }

        public double getResizableWithParentArea() {
            return this.resizableWithParentArea;
        }

        public void setResizableWithParentArea(double resizableWithParentArea) {
            this.resizableWithParentArea = !this.isResizableWithParent() ? resizableWithParentArea : 0.0;
        }

        protected void setClipSize(double w, double h) {
            this.clipRect.setWidth(w);
            this.clipRect.setHeight(h);
        }

        @Override
        protected double computeMaxWidth(double height) {
            return this.snapSize(this.content.maxWidth(height));
        }

        @Override
        protected double computeMaxHeight(double width) {
            return this.snapSize(this.content.maxHeight(width));
        }
    }

    class ContentDivider
    extends StackPane {
        private double initialPos;
        private double dividerPos;
        private double pressPos;
        private SplitPane.Divider d;
        private StackPane grabber;
        private double x;
        private double y;
        private boolean posExplicit;
        private ChangeListener<Number> listener;

        public ContentDivider(SplitPane.Divider d) {
            this.getStyleClass().setAll((String[])new String[]{"split-pane-divider"});
            this.d = d;
            this.initialPos = 0.0;
            this.dividerPos = 0.0;
            this.pressPos = 0.0;
            this.grabber = new StackPane(){

                @Override
                protected double computeMinWidth(double height) {
                    return 0.0;
                }

                @Override
                protected double computeMinHeight(double width) {
                    return 0.0;
                }

                @Override
                protected double computePrefWidth(double height) {
                    return this.snappedLeftInset() + this.snappedRightInset();
                }

                @Override
                protected double computePrefHeight(double width) {
                    return this.snappedTopInset() + this.snappedBottomInset();
                }

                @Override
                protected double computeMaxWidth(double height) {
                    return this.computePrefWidth(-1.0);
                }

                @Override
                protected double computeMaxHeight(double width) {
                    return this.computePrefHeight(-1.0);
                }
            };
            this.setGrabberStyle(SplitPaneSkin.this.horizontal);
            this.getChildren().add(this.grabber);
        }

        public SplitPane.Divider getDivider() {
            return this.d;
        }

        public final void setGrabberStyle(boolean horizontal) {
            this.grabber.getStyleClass().clear();
            this.grabber.getStyleClass().setAll((String[])new String[]{"vertical-grabber"});
            this.setCursor(Cursor.V_RESIZE);
            if (horizontal) {
                this.grabber.getStyleClass().setAll((String[])new String[]{"horizontal-grabber"});
                this.setCursor(Cursor.H_RESIZE);
            }
        }

        public double getInitialPos() {
            return this.initialPos;
        }

        public void setInitialPos(double initialPos) {
            this.initialPos = initialPos;
        }

        public double getDividerPos() {
            return this.dividerPos;
        }

        public void setDividerPos(double dividerPos) {
            this.dividerPos = dividerPos;
        }

        public double getPressPos() {
            return this.pressPos;
        }

        public void setPressPos(double pressPos) {
            this.pressPos = pressPos;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public ChangeListener<Number> getPosPropertyListener() {
            return this.listener;
        }

        public void setPosPropertyListener(ChangeListener<Number> listener) {
            this.listener = listener;
        }

        @Override
        protected double computeMinWidth(double height) {
            return this.computePrefWidth(height);
        }

        @Override
        protected double computeMinHeight(double width) {
            return this.computePrefHeight(width);
        }

        @Override
        protected double computePrefWidth(double height) {
            return this.snappedLeftInset() + this.snappedRightInset();
        }

        @Override
        protected double computePrefHeight(double width) {
            return this.snappedTopInset() + this.snappedBottomInset();
        }

        @Override
        protected double computeMaxWidth(double height) {
            return this.computePrefWidth(height);
        }

        @Override
        protected double computeMaxHeight(double width) {
            return this.computePrefHeight(width);
        }

        @Override
        protected void layoutChildren() {
            double grabberWidth = this.grabber.prefWidth(-1.0);
            double grabberHeight = this.grabber.prefHeight(-1.0);
            double grabberX = (this.getWidth() - grabberWidth) / 2.0;
            double grabberY = (this.getHeight() - grabberHeight) / 2.0;
            this.grabber.resize(grabberWidth, grabberHeight);
            this.positionInArea(this.grabber, grabberX, grabberY, grabberWidth, grabberHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    class PosPropertyListener
    implements ChangeListener<Number> {
        ContentDivider divider;

        public PosPropertyListener(ContentDivider divider) {
            this.divider = divider;
        }

        @Override
        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (SplitPaneSkin.this.checkDividerPos) {
                this.divider.posExplicit = true;
            }
            ((SplitPane)SplitPaneSkin.this.getSkinnable()).requestLayout();
        }
    }
}

