/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$1;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$2;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$3;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$4;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$5;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$6;
import com.sun.javafx.scene.control.skin.TableHeaderRow$$Lambda$7;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class TableHeaderRow
extends StackPane {
    private static final String MENU_SEPARATOR = ControlResources.getString("TableView.nestedColumnControlMenuSeparator");
    private final VirtualFlow flow;
    private final TableViewSkinBase tableSkin;
    private Map<TableColumnBase, CheckMenuItem> columnMenuItems = new HashMap<TableColumnBase, CheckMenuItem>();
    private double scrollX;
    private double tableWidth;
    private Rectangle clip;
    private TableColumnHeader reorderingRegion;
    private StackPane dragHeader;
    private final Label dragHeaderLabel = new Label();
    private final NestedTableColumnHeader header;
    private Region filler;
    private Pane cornerRegion;
    private ContextMenu columnPopupMenu;
    private BooleanProperty reordering = new SimpleBooleanProperty(this, "reordering", false){

        @Override
        protected void invalidated() {
            TableColumnHeader r = TableHeaderRow.this.getReorderingRegion();
            if (r != null) {
                double dragHeaderHeight = r.getNestedColumnHeader() != null ? r.getNestedColumnHeader().getHeight() : TableHeaderRow.this.getReorderingRegion().getHeight();
                TableHeaderRow.this.dragHeader.resize(TableHeaderRow.this.dragHeader.getWidth(), dragHeaderHeight);
                TableHeaderRow.this.dragHeader.setTranslateY(TableHeaderRow.this.getHeight() - dragHeaderHeight);
            }
            TableHeaderRow.this.dragHeader.setVisible(TableHeaderRow.this.isReordering());
        }
    };
    private InvalidationListener tableWidthListener = TableHeaderRow$$Lambda$1.lambdaFactory$(this);
    private InvalidationListener tablePaddingListener = TableHeaderRow$$Lambda$2.lambdaFactory$(this);
    private ListChangeListener visibleLeafColumnsListener = new ListChangeListener<TableColumn<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<?, ?>> c) {
            TableHeaderRow.this.header.setHeadersNeedUpdate();
        }
    };
    private final ListChangeListener tableColumnsListener = TableHeaderRow$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener columnTextListener = TableHeaderRow$$Lambda$4.lambdaFactory$(this);
    private final WeakInvalidationListener weakTableWidthListener = new WeakInvalidationListener(this.tableWidthListener);
    private final WeakInvalidationListener weakTablePaddingListener = new WeakInvalidationListener(this.tablePaddingListener);
    private final WeakListChangeListener weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener weakTableColumnsListener = new WeakListChangeListener(this.tableColumnsListener);
    private final WeakInvalidationListener weakColumnTextListener = new WeakInvalidationListener(this.columnTextListener);

    public TableHeaderRow(TableViewSkinBase skin) {
        this.tableSkin = skin;
        this.flow = skin.flow;
        this.getStyleClass().setAll((String[])new String[]{"column-header-background"});
        this.clip = new Rectangle();
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind(this.heightProperty());
        this.setClip(this.clip);
        this.updateTableWidth();
        ((Region)((Object)this.tableSkin.getSkinnable())).widthProperty().addListener(this.weakTableWidthListener);
        ((Region)((Object)this.tableSkin.getSkinnable())).paddingProperty().addListener(this.weakTablePaddingListener);
        skin.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        this.columnPopupMenu = new ContextMenu();
        this.updateTableColumnListeners(this.tableSkin.getColumns(), Collections.emptyList());
        this.tableSkin.getColumns().addListener(this.weakTableColumnsListener);
        this.dragHeader = new StackPane();
        this.dragHeader.setVisible(false);
        this.dragHeader.getStyleClass().setAll((String[])new String[]{"column-drag-header"});
        this.dragHeader.setManaged(false);
        this.dragHeader.getChildren().add(this.dragHeaderLabel);
        this.header = this.createRootHeader();
        this.header.setFocusTraversable(false);
        this.header.setTableHeaderRow(this);
        this.filler = new Region();
        this.filler.getStyleClass().setAll((String[])new String[]{"filler"});
        this.setOnMousePressed(TableHeaderRow$$Lambda$5.lambdaFactory$(skin));
        final StackPane image = new StackPane();
        image.setSnapToPixel(false);
        image.getStyleClass().setAll((String[])new String[]{"show-hide-column-image"});
        this.cornerRegion = new StackPane(){

            @Override
            protected void layoutChildren() {
                double imageWidth = image.snappedLeftInset() + image.snappedRightInset();
                double imageHeight = image.snappedTopInset() + image.snappedBottomInset();
                image.resize(imageWidth, imageHeight);
                this.positionInArea(image, 0.0, 0.0, this.getWidth(), this.getHeight() - 3.0, 0.0, HPos.CENTER, VPos.CENTER);
            }
        };
        this.cornerRegion.getStyleClass().setAll((String[])new String[]{"show-hide-columns-button"});
        this.cornerRegion.getChildren().addAll((Node[])new Node[]{image});
        this.cornerRegion.setVisible(this.tableSkin.tableMenuButtonVisibleProperty().get());
        this.tableSkin.tableMenuButtonVisibleProperty().addListener(TableHeaderRow$$Lambda$6.lambdaFactory$(this));
        this.cornerRegion.setOnMousePressed(TableHeaderRow$$Lambda$7.lambdaFactory$(this));
        this.getChildren().addAll((Node[])new Node[]{this.filler, this.header, this.cornerRegion, this.dragHeader});
    }

    @Override
    protected void layoutChildren() {
        double x = this.scrollX;
        double headerWidth = this.snapSize(this.header.prefWidth(-1.0));
        double prefHeight = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        double cornerWidth = this.snapSize(this.flow.getVbar().prefWidth(-1.0));
        this.header.resizeRelocate(x, this.snappedTopInset(), headerWidth, prefHeight);
        Skinnable control = this.tableSkin.getSkinnable();
        if (control == null) {
            return;
        }
        double controlInsets = ((Region)((Object)control)).snappedLeftInset() + ((Region)((Object)control)).snappedRightInset();
        double fillerWidth = this.tableWidth - headerWidth + this.filler.getInsets().getLeft() - controlInsets;
        this.filler.setVisible((fillerWidth -= this.tableSkin.tableMenuButtonVisibleProperty().get() ? cornerWidth : 0.0) > 0.0);
        if (fillerWidth > 0.0) {
            this.filler.resizeRelocate(x + headerWidth, this.snappedTopInset(), fillerWidth, prefHeight);
        }
        this.cornerRegion.resizeRelocate(this.tableWidth - cornerWidth, this.snappedTopInset(), cornerWidth, prefHeight);
    }

    @Override
    protected double computePrefWidth(double height) {
        return this.header.prefWidth(height);
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    @Override
    protected double computePrefHeight(double width) {
        return this.snappedTopInset() + Math.max(this.header.prefHeight(width), this.cornerRegion.getHeight()) + this.snappedBottomInset();
    }

    protected NestedTableColumnHeader createRootHeader() {
        return new NestedTableColumnHeader(this.tableSkin, null);
    }

    protected TableViewSkinBase getTableSkin() {
        return this.tableSkin;
    }

    protected void updateScrollX() {
        this.scrollX = this.flow.getHbar().isVisible() ? -this.flow.getHbar().getValue() : 0.0;
        this.requestLayout();
        this.layout();
    }

    public final void setReordering(boolean value) {
        this.reordering.set(value);
    }

    public final boolean isReordering() {
        return this.reordering.get();
    }

    public final BooleanProperty reorderingProperty() {
        return this.reordering;
    }

    public TableColumnHeader getReorderingRegion() {
        return this.reorderingRegion;
    }

    public void setReorderingColumn(TableColumnBase rc) {
        this.dragHeaderLabel.setText(rc == null ? "" : rc.getText());
    }

    public void setReorderingRegion(TableColumnHeader reorderingRegion) {
        this.reorderingRegion = reorderingRegion;
        if (reorderingRegion != null) {
            this.dragHeader.resize(reorderingRegion.getWidth(), this.dragHeader.getHeight());
        }
    }

    public void setDragHeaderX(double dragHeaderX) {
        this.dragHeader.setTranslateX(dragHeaderX);
    }

    public NestedTableColumnHeader getRootHeader() {
        return this.header;
    }

    protected void updateTableWidth() {
        Skinnable c = this.tableSkin.getSkinnable();
        if (c == null) {
            this.tableWidth = 0.0;
        } else {
            Insets insets = ((Region)((Object)c)).getInsets() == null ? Insets.EMPTY : ((Region)((Object)c)).getInsets();
            double padding = this.snapSize(insets.getLeft()) + this.snapSize(insets.getRight());
            this.tableWidth = this.snapSize(((Region)((Object)c)).getWidth()) - padding;
        }
        this.clip.setWidth(this.tableWidth);
    }

    public TableColumnHeader getColumnHeaderFor(TableColumnBase<?, ?> col) {
        if (col == null) {
            return null;
        }
        ArrayList columnChain = new ArrayList();
        columnChain.add(col);
        for (TableColumnBase<?, ?> parent = col.getParentColumn(); parent != null; parent = parent.getParentColumn()) {
            columnChain.add(0, parent);
        }
        TableColumnHeader currentHeader = this.getRootHeader();
        for (int depth = 0; depth < columnChain.size(); ++depth) {
            TableColumnBase column = (TableColumnBase)columnChain.get(depth);
            currentHeader = this.getColumnHeaderFor(column, currentHeader);
        }
        return currentHeader;
    }

    public TableColumnHeader getColumnHeaderFor(TableColumnBase<?, ?> col, TableColumnHeader currentHeader) {
        if (currentHeader instanceof NestedTableColumnHeader) {
            ObservableList<TableColumnHeader> headers = ((NestedTableColumnHeader)currentHeader).getColumnHeaders();
            for (int i = 0; i < headers.size(); ++i) {
                TableColumnHeader header = (TableColumnHeader)headers.get(i);
                if (header.getTableColumn() != col) continue;
                return header;
            }
        }
        return null;
    }

    private void updateTableColumnListeners(List<? extends TableColumnBase<?, ?>> added, List<? extends TableColumnBase<?, ?>> removed) {
        for (TableColumnBase<?, ?> tc : removed) {
            this.remove(tc);
        }
        for (TableColumnBase<?, ?> tc : added) {
            this.add(tc);
        }
    }

    private void remove(TableColumnBase<?, ?> col) {
        if (col == null) {
            return;
        }
        CheckMenuItem item = this.columnMenuItems.remove(col);
        if (item != null) {
            col.textProperty().removeListener(this.weakColumnTextListener);
            item.selectedProperty().unbindBidirectional(col.visibleProperty());
            this.columnPopupMenu.getItems().remove(item);
        }
        if (!col.getColumns().isEmpty()) {
            for (TableColumnBase tableColumnBase : col.getColumns()) {
                this.remove(tableColumnBase);
            }
        }
    }

    private void add(TableColumnBase<?, ?> col) {
        if (col == null) {
            return;
        }
        if (col.getColumns().isEmpty()) {
            CheckMenuItem item = this.columnMenuItems.get(col);
            if (item == null) {
                item = new CheckMenuItem();
                this.columnMenuItems.put(col, item);
            }
            item.setText(this.getText(col.getText(), col));
            col.textProperty().addListener(this.weakColumnTextListener);
            item.selectedProperty().bindBidirectional(col.visibleProperty());
            this.columnPopupMenu.getItems().add(item);
        } else {
            for (TableColumnBase tableColumnBase : col.getColumns()) {
                this.add(tableColumnBase);
            }
        }
    }

    private String getText(String text, TableColumnBase col) {
        String s = text;
        for (TableColumnBase parentCol = col.getParentColumn(); parentCol != null; parentCol = parentCol.getParentColumn()) {
            if (!this.isColumnVisibleInHeader(parentCol, this.tableSkin.getColumns())) continue;
            s = parentCol.getText() + MENU_SEPARATOR + s;
        }
        return s;
    }

    private boolean isColumnVisibleInHeader(TableColumnBase col, List columns) {
        if (col == null) {
            return false;
        }
        for (int i = 0; i < columns.size(); ++i) {
            boolean isVisible;
            TableColumnBase column = (TableColumnBase)columns.get(i);
            if (col.equals(column)) {
                return true;
            }
            if (column.getColumns().isEmpty() || !(isVisible = this.isColumnVisibleInHeader(col, column.getColumns()))) continue;
            return true;
        }
        return false;
    }

    /* synthetic */ void lambda$new$84(Observable observable) {
        TableColumnBase column = (TableColumnBase)((StringProperty)observable).getBean();
        CheckMenuItem menuItem = this.columnMenuItems.get(column);
        if (menuItem != null) {
            menuItem.setText(this.getText(column.getText(), column));
        }
    }

    /* synthetic */ void lambda$new$83(ListChangeListener.Change c) {
        while (c.next()) {
            this.updateTableColumnListeners(c.getAddedSubList(), c.getRemoved());
        }
    }

    /* synthetic */ void lambda$new$82(Observable valueModel) {
        this.updateTableWidth();
    }

    /* synthetic */ void lambda$new$81(Observable valueModel) {
        this.updateTableWidth();
    }

    /* synthetic */ void lambda$new$80(MouseEvent me) {
        this.columnPopupMenu.show(this.cornerRegion, Side.BOTTOM, 0.0, 0.0);
        me.consume();
    }

    /* synthetic */ void lambda$new$79(Observable valueModel) {
        this.cornerRegion.setVisible(this.tableSkin.tableMenuButtonVisibleProperty().get());
        this.requestLayout();
    }

    static /* synthetic */ void lambda$new$78(TableViewSkinBase tableViewSkinBase, MouseEvent e) {
        ((Node)((Object)tableViewSkinBase.getSkinnable())).requestFocus();
    }
}

