/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TextAreaBehavior;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$10;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$11;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$12;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$13;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$14;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$15;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$16;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$17;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$18;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$19;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$20;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$21;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$22;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$3;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$4;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$5;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$6;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$7;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$8;
import com.sun.javafx.scene.control.skin.TextAreaSkin$$Lambda$9;
import com.sun.javafx.scene.control.skin.TextAreaSkin$ContentView$$Lambda$1;
import com.sun.javafx.scene.control.skin.TextAreaSkin$ContentView$$Lambda$2;
import com.sun.javafx.scene.control.skin.TextAreaSkin$ContentView$$Lambda$3;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.tk.FontMetrics;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.geometry.VerticalDirection;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import javafx.util.Duration;

public class TextAreaSkin
extends TextInputControlSkin<TextArea, TextAreaBehavior> {
    private final TextArea textArea;
    private final boolean USE_MULTIPLE_NODES = false;
    private double computedMinWidth = Double.NEGATIVE_INFINITY;
    private double computedMinHeight = Double.NEGATIVE_INFINITY;
    private double computedPrefWidth = Double.NEGATIVE_INFINITY;
    private double computedPrefHeight = Double.NEGATIVE_INFINITY;
    private double widthForComputedPrefHeight = Double.NEGATIVE_INFINITY;
    private double characterWidth;
    private double lineHeight;
    private ContentView contentView = new ContentView();
    private Group paragraphNodes = new Group();
    private Text promptNode;
    private ObservableBooleanValue usePromptText;
    private ObservableIntegerValue caretPosition;
    private Group selectionHighlightGroup = new Group();
    private ScrollPane scrollPane;
    private Bounds oldViewportBounds;
    private VerticalDirection scrollDirection = null;
    private Path characterBoundingPath = new Path();
    private Timeline scrollSelectionTimeline = new Timeline();
    private EventHandler<ActionEvent> scrollSelectionHandler = TextAreaSkin$$Lambda$1.lambdaFactory$(this);
    public static final int SCROLL_RATE = 30;
    private double pressX;
    private double pressY;
    private boolean handlePressed;
    double targetCaretX = -1.0;
    private static final Path tmpCaretPath = new Path();

    @Override
    protected void invalidateMetrics() {
        this.computedMinWidth = Double.NEGATIVE_INFINITY;
        this.computedMinHeight = Double.NEGATIVE_INFINITY;
        this.computedPrefWidth = Double.NEGATIVE_INFINITY;
        this.computedPrefHeight = Double.NEGATIVE_INFINITY;
    }

    public TextAreaSkin(final TextArea textArea) {
        super(textArea, new TextAreaBehavior(textArea));
        ((TextAreaBehavior)this.getBehavior()).setTextAreaSkin(this);
        this.textArea = textArea;
        this.caretPosition = new IntegerBinding(){
            {
                this.bind(textArea.caretPositionProperty());
            }

            @Override
            protected int computeValue() {
                return textArea.getCaretPosition();
            }
        };
        this.caretPosition.addListener(TextAreaSkin$$Lambda$2.lambdaFactory$(this));
        this.forwardBiasProperty().addListener(TextAreaSkin$$Lambda$3.lambdaFactory$(this, textArea));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setFitToWidth(textArea.isWrapText());
        this.scrollPane.setContent(this.contentView);
        this.getChildren().add(this.scrollPane);
        ((TextArea)this.getSkinnable()).addEventFilter(ScrollEvent.ANY, TextAreaSkin$$Lambda$4.lambdaFactory$(this));
        this.selectionHighlightGroup.setManaged(false);
        this.selectionHighlightGroup.setVisible(false);
        this.contentView.getChildren().add(this.selectionHighlightGroup);
        this.paragraphNodes.setManaged(false);
        this.contentView.getChildren().add(this.paragraphNodes);
        this.caretPath.setManaged(false);
        this.caretPath.setStrokeWidth(1.0);
        this.caretPath.fillProperty().bind(this.textFill);
        this.caretPath.strokeProperty().bind(this.textFill);
        this.caretPath.opacityProperty().bind(new DoubleBinding(){
            {
                this.bind(TextAreaSkin.this.caretVisible);
            }

            @Override
            protected double computeValue() {
                return TextAreaSkin.this.caretVisible.get() ? 1.0 : 0.0;
            }
        });
        this.contentView.getChildren().add(this.caretPath);
        if (SHOW_HANDLES) {
            this.contentView.getChildren().addAll((Node[])new Node[]{this.caretHandle, this.selectionHandle1, this.selectionHandle2});
        }
        this.scrollPane.hvalueProperty().addListener(TextAreaSkin$$Lambda$5.lambdaFactory$(this));
        this.scrollPane.vvalueProperty().addListener(TextAreaSkin$$Lambda$6.lambdaFactory$(this));
        this.scrollSelectionTimeline.setCycleCount(-1);
        ObservableList<KeyFrame> scrollSelectionFrames = this.scrollSelectionTimeline.getKeyFrames();
        scrollSelectionFrames.clear();
        scrollSelectionFrames.add(new KeyFrame(Duration.millis(350.0), this.scrollSelectionHandler, new KeyValue[0]));
        int n = 1;
        for (int i = 0; i < n; ++i) {
            String paragraph = n == 1 ? textArea.textProperty().getValueSafe() : (CharSequence)textArea.getParagraphs().get(i);
            this.addParagraphNode(i, paragraph.toString());
        }
        textArea.selectionProperty().addListener(TextAreaSkin$$Lambda$7.lambdaFactory$(this, textArea));
        textArea.wrapTextProperty().addListener(TextAreaSkin$$Lambda$8.lambdaFactory$(this));
        textArea.prefColumnCountProperty().addListener(TextAreaSkin$$Lambda$9.lambdaFactory$(this));
        textArea.prefRowCountProperty().addListener(TextAreaSkin$$Lambda$10.lambdaFactory$(this));
        this.updateFontMetrics();
        this.fontMetrics.addListener(TextAreaSkin$$Lambda$11.lambdaFactory$(this));
        this.contentView.paddingProperty().addListener(TextAreaSkin$$Lambda$12.lambdaFactory$(this));
        this.scrollPane.viewportBoundsProperty().addListener(TextAreaSkin$$Lambda$13.lambdaFactory$(this));
        textArea.scrollTopProperty().addListener(TextAreaSkin$$Lambda$14.lambdaFactory$(this));
        textArea.scrollLeftProperty().addListener(TextAreaSkin$$Lambda$15.lambdaFactory$(this));
        textArea.textProperty().addListener(TextAreaSkin$$Lambda$16.lambdaFactory$(this, textArea));
        this.usePromptText = new BooleanBinding(){
            {
                this.bind(textArea.textProperty(), textArea.promptTextProperty());
            }

            @Override
            protected boolean computeValue() {
                String txt = textArea.getText();
                String promptTxt = textArea.getPromptText();
                return (txt == null || txt.isEmpty()) && promptTxt != null && !promptTxt.isEmpty();
            }
        };
        if (this.usePromptText.get()) {
            this.createPromptNode();
        }
        this.usePromptText.addListener(TextAreaSkin$$Lambda$17.lambdaFactory$(this, textArea));
        this.updateHighlightFill();
        this.updatePrefViewportWidth();
        this.updatePrefViewportHeight();
        if (textArea.isFocused()) {
            this.setCaretAnimating(true);
        }
        if (SHOW_HANDLES) {
            this.selectionHandle1.setRotate(180.0);
            EventHandler handlePressHandler = TextAreaSkin$$Lambda$18.lambdaFactory$(this);
            EventHandler handleReleaseHandler = TextAreaSkin$$Lambda$19.lambdaFactory$(this);
            this.caretHandle.setOnMousePressed(handlePressHandler);
            this.selectionHandle1.setOnMousePressed(handlePressHandler);
            this.selectionHandle2.setOnMousePressed(handlePressHandler);
            this.caretHandle.setOnMouseReleased(handleReleaseHandler);
            this.selectionHandle1.setOnMouseReleased(handleReleaseHandler);
            this.selectionHandle2.setOnMouseReleased(handleReleaseHandler);
            this.caretHandle.setOnMouseDragged(TextAreaSkin$$Lambda$20.lambdaFactory$(this));
            this.selectionHandle1.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent e) {
                    TextArea textArea = (TextArea)TextAreaSkin.this.getSkinnable();
                    Text textNode = TextAreaSkin.this.getTextNode();
                    Point2D tp = textNode.localToScene(0.0, 0.0);
                    Point2D p = new Point2D(e.getSceneX() - tp.getX() + 10.0 - TextAreaSkin.this.pressX + TextAreaSkin.this.selectionHandle1.getWidth() / 2.0, e.getSceneY() - tp.getY() - TextAreaSkin.this.pressY + TextAreaSkin.this.selectionHandle1.getHeight() + 5.0);
                    HitInfo hit = textNode.impl_hitTestChar(TextAreaSkin.this.translateCaretPosition(p));
                    int pos = hit.getCharIndex();
                    if (textArea.getAnchor() < textArea.getCaretPosition()) {
                        textArea.selectRange(textArea.getCaretPosition(), textArea.getAnchor());
                    }
                    if (pos > 0) {
                        if (pos >= textArea.getAnchor()) {
                            pos = textArea.getAnchor();
                        }
                        int oldPos = textNode.getImpl_caretPosition();
                        textNode.setImpl_caretPosition(pos);
                        PathElement element = textNode.getImpl_caretShape()[0];
                        if (element instanceof MoveTo && ((MoveTo)element).getY() > e.getY() - TextAreaSkin.this.getTextTranslateY()) {
                            hit.setCharIndex(pos - 1);
                        }
                        textNode.setImpl_caretPosition(oldPos);
                    }
                    TextAreaSkin.this.positionCaret(hit, true, false);
                    e.consume();
                }
            });
            this.selectionHandle2.setOnMouseDragged((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent e) {
                    TextArea textArea = (TextArea)TextAreaSkin.this.getSkinnable();
                    Text textNode = TextAreaSkin.this.getTextNode();
                    Point2D tp = textNode.localToScene(0.0, 0.0);
                    Point2D p = new Point2D(e.getSceneX() - tp.getX() + 10.0 - TextAreaSkin.this.pressX + TextAreaSkin.this.selectionHandle2.getWidth() / 2.0, e.getSceneY() - tp.getY() - TextAreaSkin.this.pressY - 6.0);
                    HitInfo hit = textNode.impl_hitTestChar(TextAreaSkin.this.translateCaretPosition(p));
                    int pos = hit.getCharIndex();
                    if (textArea.getAnchor() > textArea.getCaretPosition()) {
                        textArea.selectRange(textArea.getCaretPosition(), textArea.getAnchor());
                    }
                    if (pos > 0) {
                        if (pos <= textArea.getAnchor() + 1) {
                            pos = Math.min(textArea.getAnchor() + 2, textArea.getLength());
                        }
                        int oldPos = textNode.getImpl_caretPosition();
                        textNode.setImpl_caretPosition(pos);
                        PathElement element = textNode.getImpl_caretShape()[0];
                        if (element instanceof MoveTo && ((MoveTo)element).getY() > e.getY() - TextAreaSkin.this.getTextTranslateY()) {
                            hit.setCharIndex(pos - 1);
                        }
                        textNode.setImpl_caretPosition(oldPos);
                        TextAreaSkin.this.positionCaret(hit, true, false);
                    }
                    e.consume();
                }
            });
        }
    }

    @Override
    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.scrollPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
    }

    private void createPromptNode() {
        if (this.promptNode == null && this.usePromptText.get()) {
            this.promptNode = new Text();
            this.contentView.getChildren().add(0, this.promptNode);
            this.promptNode.setManaged(false);
            this.promptNode.getStyleClass().add("text");
            this.promptNode.visibleProperty().bind(this.usePromptText);
            this.promptNode.fontProperty().bind(((TextArea)this.getSkinnable()).fontProperty());
            this.promptNode.textProperty().bind(((TextArea)this.getSkinnable()).promptTextProperty());
            this.promptNode.fillProperty().bind(this.promptTextFill);
        }
    }

    private void addParagraphNode(int i, String string) {
        TextArea textArea = (TextArea)this.getSkinnable();
        Text paragraphNode = new Text(string);
        paragraphNode.setTextOrigin(VPos.TOP);
        paragraphNode.setManaged(false);
        paragraphNode.getStyleClass().add("text");
        paragraphNode.boundsTypeProperty().addListener(TextAreaSkin$$Lambda$21.lambdaFactory$(this));
        this.paragraphNodes.getChildren().add(i, paragraphNode);
        paragraphNode.fontProperty().bind(textArea.fontProperty());
        paragraphNode.fillProperty().bind(this.textFill);
        paragraphNode.impl_selectionFillProperty().bind(this.highlightTextFill);
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        Text firstParagraph = (Text)this.paragraphNodes.getChildren().get(0);
        return Utils.getAscent(((TextArea)this.getSkinnable()).getFont(), firstParagraph.getBoundsType()) + this.contentView.snappedTopInset() + this.textArea.snappedTopInset();
    }

    @Override
    public char getCharacter(int index) {
        Text paragraphNode;
        int offset;
        int count;
        int n = this.paragraphNodes.getChildren().size();
        int paragraphIndex = 0;
        String paragraph = null;
        for (offset = index; paragraphIndex < n && offset >= (count = (paragraph = (paragraphNode = (Text)this.paragraphNodes.getChildren().get(paragraphIndex)).getText()).length() + 1); offset -= count, ++paragraphIndex) {
        }
        return offset == paragraph.length() ? (char)'\n' : paragraph.charAt(offset);
    }

    @Override
    public int getInsertionPoint(double x, double y) {
        TextArea textArea = (TextArea)this.getSkinnable();
        int n = this.paragraphNodes.getChildren().size();
        int index = -1;
        if (n > 0) {
            if (y < this.contentView.snappedTopInset()) {
                Text paragraphNode = (Text)this.paragraphNodes.getChildren().get(0);
                index = this.getNextInsertionPoint(paragraphNode, x, -1, VerticalDirection.DOWN);
            } else if (y > this.contentView.snappedTopInset() + this.contentView.getHeight()) {
                int lastParagraphIndex = n - 1;
                Text lastParagraphView = (Text)this.paragraphNodes.getChildren().get(lastParagraphIndex);
                index = this.getNextInsertionPoint(lastParagraphView, x, -1, VerticalDirection.UP) + (textArea.getLength() - lastParagraphView.getText().length());
            } else {
                int paragraphOffset = 0;
                for (int i = 0; i < n; ++i) {
                    Text paragraphNode = (Text)this.paragraphNodes.getChildren().get(i);
                    Bounds bounds = paragraphNode.getBoundsInLocal();
                    double paragraphViewY = paragraphNode.getLayoutY() + bounds.getMinY();
                    if (y >= paragraphViewY && y < paragraphViewY + paragraphNode.getBoundsInLocal().getHeight()) {
                        index = this.getInsertionPoint(paragraphNode, x - paragraphNode.getLayoutX(), y - paragraphNode.getLayoutY()) + paragraphOffset;
                        break;
                    }
                    paragraphOffset += paragraphNode.getText().length() + 1;
                }
            }
        }
        return index;
    }

    public void positionCaret(HitInfo hit, boolean select, boolean extendSelection) {
        boolean isNewLine;
        int pos = Utils.getHitInsertionIndex(hit, ((TextArea)this.getSkinnable()).getText());
        boolean bl = isNewLine = pos > 0 && pos <= ((TextArea)this.getSkinnable()).getLength() && ((TextArea)this.getSkinnable()).getText().codePointAt(pos - 1) == 10;
        if (!hit.isLeading() && isNewLine) {
            hit.setLeading(true);
            --pos;
        }
        if (select) {
            if (extendSelection) {
                ((TextArea)this.getSkinnable()).extendSelection(pos);
            } else {
                ((TextArea)this.getSkinnable()).selectPositionCaret(pos);
            }
        } else {
            ((TextArea)this.getSkinnable()).positionCaret(pos);
        }
        this.setForwardBias(hit.isLeading());
    }

    private double getScrollTopMax() {
        return Math.max(0.0, this.contentView.getHeight() - this.scrollPane.getViewportBounds().getHeight());
    }

    private double getScrollLeftMax() {
        return Math.max(0.0, this.contentView.getWidth() - this.scrollPane.getViewportBounds().getWidth());
    }

    private int getInsertionPoint(Text paragraphNode, double x, double y) {
        HitInfo hitInfo = paragraphNode.impl_hitTestChar(new Point2D(x, y));
        return Utils.getHitInsertionIndex(hitInfo, paragraphNode.getText());
    }

    public int getNextInsertionPoint(double x, int from, VerticalDirection scrollDirection) {
        return 0;
    }

    private int getNextInsertionPoint(Text paragraphNode, double x, int from, VerticalDirection scrollDirection) {
        return 0;
    }

    @Override
    public Rectangle2D getCharacterBounds(int index) {
        double height;
        TextArea textArea = (TextArea)this.getSkinnable();
        int paragraphIndex = this.paragraphNodes.getChildren().size();
        int paragraphOffset = textArea.getLength() + 1;
        Text paragraphNode = null;
        while (index < (paragraphOffset -= (paragraphNode = (Text)this.paragraphNodes.getChildren().get(--paragraphIndex)).getText().length() + 1)) {
        }
        int characterIndex = index - paragraphOffset;
        boolean terminator = false;
        if (characterIndex == paragraphNode.getText().length()) {
            --characterIndex;
            terminator = true;
        }
        this.characterBoundingPath.getElements().clear();
        this.characterBoundingPath.getElements().addAll((PathElement[])paragraphNode.impl_getRangeShape(characterIndex, characterIndex + 1));
        this.characterBoundingPath.setLayoutX(paragraphNode.getLayoutX());
        this.characterBoundingPath.setLayoutY(paragraphNode.getLayoutY());
        Bounds bounds = this.characterBoundingPath.getBoundsInLocal();
        double x = bounds.getMinX() + paragraphNode.getLayoutX() - textArea.getScrollLeft();
        double y = bounds.getMinY() + paragraphNode.getLayoutY() - textArea.getScrollTop();
        double width = bounds.isEmpty() ? 0.0 : bounds.getWidth();
        double d = height = bounds.isEmpty() ? 0.0 : bounds.getHeight();
        if (terminator) {
            x += width;
            width = 0.0;
        }
        return new Rectangle2D(x, y, width, height);
    }

    @Override
    public void scrollCharacterToVisible(int index) {
        Platform.runLater(TextAreaSkin$$Lambda$22.lambdaFactory$(this, index));
    }

    private void scrollCaretToVisible() {
        TextArea textArea = (TextArea)this.getSkinnable();
        Bounds bounds = this.caretPath.getLayoutBounds();
        double x = bounds.getMinX() - textArea.getScrollLeft();
        double y = bounds.getMinY() - textArea.getScrollTop();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        if (SHOW_HANDLES) {
            if (this.caretHandle.isVisible()) {
                h += this.caretHandle.getHeight();
            } else if (this.selectionHandle1.isVisible() && this.selectionHandle2.isVisible()) {
                x -= this.selectionHandle1.getWidth() / 2.0;
                y -= this.selectionHandle1.getHeight();
                w += this.selectionHandle1.getWidth() / 2.0 + this.selectionHandle2.getWidth() / 2.0;
                h += this.selectionHandle1.getHeight() + this.selectionHandle2.getHeight();
            }
        }
        if (w > 0.0 && h > 0.0) {
            this.scrollBoundsToVisible(new Rectangle2D(x, y, w, h));
        }
    }

    private void scrollBoundsToVisible(Rectangle2D bounds) {
        double x;
        double y;
        TextArea textArea = (TextArea)this.getSkinnable();
        Bounds viewportBounds = this.scrollPane.getViewportBounds();
        double viewportWidth = viewportBounds.getWidth();
        double viewportHeight = viewportBounds.getHeight();
        double scrollTop = textArea.getScrollTop();
        double scrollLeft = textArea.getScrollLeft();
        double slop = 6.0;
        if (bounds.getMinY() < 0.0) {
            y = scrollTop + bounds.getMinY();
            if (y <= this.contentView.snappedTopInset()) {
                y = 0.0;
            }
            textArea.setScrollTop(y);
        } else if (this.contentView.snappedTopInset() + bounds.getMaxY() > viewportHeight) {
            y = scrollTop + this.contentView.snappedTopInset() + bounds.getMaxY() - viewportHeight;
            if (y >= this.getScrollTopMax() - this.contentView.snappedBottomInset()) {
                y = this.getScrollTopMax();
            }
            textArea.setScrollTop(y);
        }
        if (bounds.getMinX() < 0.0) {
            x = scrollLeft + bounds.getMinX() - slop;
            if (x <= this.contentView.snappedLeftInset() + slop) {
                x = 0.0;
            }
            textArea.setScrollLeft(x);
        } else if (this.contentView.snappedLeftInset() + bounds.getMaxX() > viewportWidth) {
            x = scrollLeft + this.contentView.snappedLeftInset() + bounds.getMaxX() - viewportWidth + slop;
            if (x >= this.getScrollLeftMax() - this.contentView.snappedRightInset() - slop) {
                x = this.getScrollLeftMax();
            }
            textArea.setScrollLeft(x);
        }
    }

    private void updatePrefViewportWidth() {
        int columnCount = ((TextArea)this.getSkinnable()).getPrefColumnCount();
        this.scrollPane.setPrefViewportWidth((double)columnCount * this.characterWidth + this.contentView.snappedLeftInset() + this.contentView.snappedRightInset());
        this.scrollPane.setMinViewportWidth(this.characterWidth + this.contentView.snappedLeftInset() + this.contentView.snappedRightInset());
    }

    private void updatePrefViewportHeight() {
        int rowCount = ((TextArea)this.getSkinnable()).getPrefRowCount();
        this.scrollPane.setPrefViewportHeight((double)rowCount * this.lineHeight + this.contentView.snappedTopInset() + this.contentView.snappedBottomInset());
        this.scrollPane.setMinViewportHeight(this.lineHeight + this.contentView.snappedTopInset() + this.contentView.snappedBottomInset());
    }

    private void updateFontMetrics() {
        Text firstParagraph = (Text)this.paragraphNodes.getChildren().get(0);
        this.lineHeight = Utils.getLineHeight(((TextArea)this.getSkinnable()).getFont(), firstParagraph.getBoundsType());
        this.characterWidth = ((FontMetrics)this.fontMetrics.get()).computeStringWidth("W");
    }

    @Override
    protected void updateHighlightFill() {
        for (Node node : this.selectionHighlightGroup.getChildren()) {
            Path selectionHighlightPath = (Path)node;
            selectionHighlightPath.setFill((Paint)this.highlightFill.get());
        }
    }

    private double getTextTranslateX() {
        return this.contentView.snappedLeftInset();
    }

    private double getTextTranslateY() {
        return this.contentView.snappedTopInset();
    }

    private double getTextLeft() {
        return 0.0;
    }

    private Point2D translateCaretPosition(Point2D p) {
        return p;
    }

    private Text getTextNode() {
        return (Text)this.paragraphNodes.getChildren().get(0);
    }

    public HitInfo getIndex(double x, double y) {
        Point2D p;
        Text textNode = this.getTextNode();
        HitInfo hit = textNode.impl_hitTestChar(this.translateCaretPosition(p = new Point2D(x - textNode.getLayoutX(), y - this.getTextTranslateY())));
        int pos = hit.getCharIndex();
        if (pos > 0) {
            int oldPos = textNode.getImpl_caretPosition();
            textNode.setImpl_caretPosition(pos);
            PathElement element = textNode.getImpl_caretShape()[0];
            if (element instanceof MoveTo && ((MoveTo)element).getY() > y - this.getTextTranslateY()) {
                hit.setCharIndex(pos - 1);
            }
            textNode.setImpl_caretPosition(oldPos);
        }
        return hit;
    }

    @Override
    public void nextCharacterVisually(boolean moveRight) {
        if (this.isRTL()) {
            moveRight = !moveRight;
        }
        Text textNode = this.getTextNode();
        Bounds caretBounds = this.caretPath.getLayoutBounds();
        if (this.caretPath.getElements().size() == 4) {
            caretBounds = new Path((PathElement)this.caretPath.getElements().get(0), (PathElement)this.caretPath.getElements().get(1)).getLayoutBounds();
        }
        double hitX = moveRight ? caretBounds.getMaxX() : caretBounds.getMinX();
        double hitY = (caretBounds.getMinY() + caretBounds.getMaxY()) / 2.0;
        HitInfo hit = textNode.impl_hitTestChar(new Point2D(hitX, hitY));
        Path charShape = new Path(textNode.impl_getRangeShape(hit.getCharIndex(), hit.getCharIndex() + 1));
        if (moveRight && charShape.getLayoutBounds().getMaxX() > caretBounds.getMaxX() || !moveRight && charShape.getLayoutBounds().getMinX() < caretBounds.getMinX()) {
            hit.setLeading(!hit.isLeading());
            this.positionCaret(hit, false, false);
        } else {
            int dot = this.textArea.getCaretPosition();
            this.targetCaretX = moveRight ? 0.0 : Double.MAX_VALUE;
            this.downLines(moveRight ? 1 : -1, false, false);
            this.targetCaretX = -1.0;
            if (dot == this.textArea.getCaretPosition()) {
                if (moveRight) {
                    this.textArea.forward();
                } else {
                    this.textArea.backward();
                }
            }
        }
    }

    protected void downLines(int nLines, boolean select, boolean extendSelection) {
        Text textNode = this.getTextNode();
        Bounds caretBounds = this.caretPath.getLayoutBounds();
        double targetLineMidY = (caretBounds.getMinY() + caretBounds.getMaxY()) / 2.0 + (double)nLines * this.lineHeight;
        if (targetLineMidY < 0.0) {
            targetLineMidY = 0.0;
        }
        double x = this.targetCaretX >= 0.0 ? this.targetCaretX : caretBounds.getMaxX();
        HitInfo hit = textNode.impl_hitTestChar(this.translateCaretPosition(new Point2D(x, targetLineMidY)));
        int pos = hit.getCharIndex();
        int oldPos = textNode.getImpl_caretPosition();
        boolean oldBias = textNode.isImpl_caretBias();
        textNode.setImpl_caretBias(hit.isLeading());
        textNode.setImpl_caretPosition(pos);
        tmpCaretPath.getElements().clear();
        tmpCaretPath.getElements().addAll((PathElement[])textNode.getImpl_caretShape());
        tmpCaretPath.setLayoutX(textNode.getLayoutX());
        tmpCaretPath.setLayoutY(textNode.getLayoutY());
        Bounds tmpCaretBounds = tmpCaretPath.getLayoutBounds();
        double foundLineMidY = (tmpCaretBounds.getMinY() + tmpCaretBounds.getMaxY()) / 2.0;
        textNode.setImpl_caretBias(oldBias);
        textNode.setImpl_caretPosition(oldPos);
        if (pos > 0) {
            if (nLines > 0 && foundLineMidY > targetLineMidY) {
                hit.setCharIndex(pos - 1);
            }
            if (pos >= this.textArea.getLength() && this.getCharacter(pos - 1) == '\n') {
                hit.setLeading(true);
            }
        }
        if (nLines == 0 || nLines > 0 && foundLineMidY > caretBounds.getMaxY() || nLines < 0 && foundLineMidY < caretBounds.getMinY()) {
            this.positionCaret(hit, select, extendSelection);
            this.targetCaretX = x;
        }
    }

    public void previousLine(boolean select) {
        this.downLines(-1, select, false);
    }

    public void nextLine(boolean select) {
        this.downLines(1, select, false);
    }

    public void previousPage(boolean select) {
        this.downLines(-((int)(this.scrollPane.getViewportBounds().getHeight() / this.lineHeight)), select, false);
    }

    public void nextPage(boolean select) {
        this.downLines((int)(this.scrollPane.getViewportBounds().getHeight() / this.lineHeight), select, false);
    }

    public void lineStart(boolean select, boolean extendSelection) {
        this.targetCaretX = 0.0;
        this.downLines(0, select, extendSelection);
        this.targetCaretX = -1.0;
    }

    public void lineEnd(boolean select, boolean extendSelection) {
        this.targetCaretX = Double.MAX_VALUE;
        this.downLines(0, select, extendSelection);
        this.targetCaretX = -1.0;
    }

    public void paragraphStart(boolean previousIfAtStart, boolean select) {
        TextArea textArea = (TextArea)this.getSkinnable();
        String text = textArea.textProperty().getValueSafe();
        int pos = textArea.getCaretPosition();
        if (pos > 0) {
            if (previousIfAtStart && text.codePointAt(pos - 1) == 10) {
                --pos;
            }
            while (pos > 0 && text.codePointAt(pos - 1) != 10) {
                --pos;
            }
            if (select) {
                textArea.selectPositionCaret(pos);
            } else {
                textArea.positionCaret(pos);
            }
        }
    }

    public void paragraphEnd(boolean goPastInitialNewline, boolean goPastTrailingNewline, boolean select) {
        TextArea textArea = (TextArea)this.getSkinnable();
        String text = textArea.textProperty().getValueSafe();
        int pos = textArea.getCaretPosition();
        int len = text.length();
        boolean wentPastInitialNewline = false;
        if (pos < len) {
            if (goPastInitialNewline && text.codePointAt(pos) == 10) {
                ++pos;
                wentPastInitialNewline = true;
            }
            if (!goPastTrailingNewline || !wentPastInitialNewline) {
                while (pos < len && text.codePointAt(pos) != 10) {
                    ++pos;
                }
                if (goPastTrailingNewline && pos < len) {
                    ++pos;
                }
            }
            if (select) {
                textArea.selectPositionCaret(pos);
            } else {
                textArea.positionCaret(pos);
            }
        }
    }

    private void updateTextNodeCaretPos(int pos) {
        Text textNode = this.getTextNode();
        if (this.isForwardBias()) {
            textNode.setImpl_caretPosition(pos);
        } else {
            textNode.setImpl_caretPosition(pos - 1);
        }
        textNode.impl_caretBiasProperty().set(this.isForwardBias());
    }

    @Override
    protected PathElement[] getUnderlineShape(int start, int end) {
        int pStart = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            Text p = (Text)node;
            int pEnd = pStart + p.textProperty().getValueSafe().length();
            if (pEnd >= start) {
                return p.impl_getUnderlineShape(start - pStart, end - pStart);
            }
            pStart = pEnd + 1;
        }
        return null;
    }

    @Override
    protected PathElement[] getRangeShape(int start, int end) {
        int pStart = 0;
        for (Node node : this.paragraphNodes.getChildren()) {
            Text p = (Text)node;
            int pEnd = pStart + p.textProperty().getValueSafe().length();
            if (pEnd >= start) {
                return p.impl_getRangeShape(start - pStart, end - pStart);
            }
            pStart = pEnd + 1;
        }
        return null;
    }

    @Override
    protected void addHighlight(List<? extends Node> nodes, int start) {
        int pStart = 0;
        Node paragraphNode = null;
        for (Node node : this.paragraphNodes.getChildren()) {
            Text p = (Text)node;
            int pEnd = pStart + p.textProperty().getValueSafe().length();
            if (pEnd >= start) {
                paragraphNode = p;
                break;
            }
            pStart = pEnd + 1;
        }
        if (paragraphNode != null) {
            for (Node node : nodes) {
                node.setLayoutX(paragraphNode.getLayoutX());
                node.setLayoutY(paragraphNode.getLayoutY());
            }
        }
        this.contentView.getChildren().addAll((Collection<Node>)nodes);
    }

    @Override
    protected void removeHighlight(List<? extends Node> nodes) {
        this.contentView.getChildren().removeAll((Collection<?>)nodes);
    }

    public void deleteChar(boolean previous) {
        boolean shouldBeep;
        boolean bl = previous ? !((TextArea)this.getSkinnable()).deletePreviousChar() : (shouldBeep = !((TextArea)this.getSkinnable()).deleteNextChar());
        if (shouldBeep) {
            // empty if block
        }
    }

    @Override
    public Point2D getMenuPosition() {
        this.contentView.layoutChildren();
        Point2D p = super.getMenuPosition();
        if (p != null) {
            p = new Point2D(Math.max(0.0, p.getX() - this.contentView.snappedLeftInset() - ((TextArea)this.getSkinnable()).getScrollLeft()), Math.max(0.0, p.getY() - this.contentView.snappedTopInset() - ((TextArea)this.getSkinnable()).getScrollTop()));
        }
        return p;
    }

    public Bounds getCaretBounds() {
        return ((TextArea)this.getSkinnable()).sceneToLocal(this.caretPath.localToScene(this.caretPath.getBoundsInLocal()));
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case LINE_FOR_OFFSET: 
            case LINE_START: 
            case LINE_END: 
            case BOUNDS_FOR_RANGE: 
            case OFFSET_AT_POINT: {
                Text text = this.getTextNode();
                return text.queryAccessibleAttribute(attribute, parameters);
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    /* synthetic */ void lambda$scrollCharacterToVisible$251(int n) {
        if (((TextArea)this.getSkinnable()).getLength() == 0) {
            return;
        }
        Rectangle2D characterBounds = this.getCharacterBounds(n);
        this.scrollBoundsToVisible(characterBounds);
    }

    /* synthetic */ void lambda$addParagraphNode$250(ObservableValue observable, TextBoundsType oldValue, TextBoundsType newValue) {
        this.invalidateMetrics();
        this.updateFontMetrics();
    }

    /* synthetic */ void lambda$new$249(MouseEvent e) {
        Text textNode = this.getTextNode();
        Point2D tp = textNode.localToScene(0.0, 0.0);
        Point2D p = new Point2D(e.getSceneX() - tp.getX() + 10.0 - this.pressX + this.caretHandle.getWidth() / 2.0, e.getSceneY() - tp.getY() - this.pressY - 6.0);
        HitInfo hit = textNode.impl_hitTestChar(this.translateCaretPosition(p));
        int pos = hit.getCharIndex();
        if (pos > 0) {
            int oldPos = textNode.getImpl_caretPosition();
            textNode.setImpl_caretPosition(pos);
            PathElement element = textNode.getImpl_caretShape()[0];
            if (element instanceof MoveTo && ((MoveTo)element).getY() > e.getY() - this.getTextTranslateY()) {
                hit.setCharIndex(pos - 1);
            }
            textNode.setImpl_caretPosition(oldPos);
        }
        this.positionCaret(hit, false, false);
        e.consume();
    }

    /* synthetic */ void lambda$new$248(MouseEvent event) {
        this.handlePressed = false;
    }

    /* synthetic */ void lambda$new$247(MouseEvent e) {
        this.pressX = e.getX();
        this.pressY = e.getY();
        this.handlePressed = true;
        e.consume();
    }

    /* synthetic */ void lambda$new$246(TextArea textArea, Observable observable) {
        this.createPromptNode();
        textArea.requestLayout();
    }

    /* synthetic */ void lambda$new$245(TextArea textArea, Observable observable) {
        this.invalidateMetrics();
        ((Text)this.paragraphNodes.getChildren().get(0)).setText(textArea.textProperty().getValueSafe());
        this.contentView.requestLayout();
    }

    /* synthetic */ void lambda$new$244(ListChangeListener.Change change) {
        while (change.next()) {
            int from = change.getFrom();
            int to = change.getTo();
            List removed = change.getRemoved();
            if (from < to) {
                int i;
                int n;
                if (removed.isEmpty()) {
                    n = to;
                    for (i = from; i < n; ++i) {
                        this.addParagraphNode(i, ((CharSequence)change.getList().get(i)).toString());
                    }
                    continue;
                }
                n = to;
                for (i = from; i < n; ++i) {
                    Node node = (Node)this.paragraphNodes.getChildren().get(i);
                    Text paragraphNode = (Text)node;
                    paragraphNode.setText(((CharSequence)change.getList().get(i)).toString());
                }
                continue;
            }
            this.paragraphNodes.getChildren().subList(from, from + removed.size()).clear();
        }
    }

    /* synthetic */ void lambda$new$243(ObservableValue observable, Number oldValue, Number newValue) {
        double hValue = newValue.doubleValue() < this.getScrollLeftMax() ? newValue.doubleValue() / this.getScrollLeftMax() : 1.0;
        this.scrollPane.setHvalue(hValue);
    }

    /* synthetic */ void lambda$new$242(ObservableValue observable, Number oldValue, Number newValue) {
        double vValue = newValue.doubleValue() < this.getScrollTopMax() ? newValue.doubleValue() / this.getScrollTopMax() : 1.0;
        this.scrollPane.setVvalue(vValue);
    }

    /* synthetic */ void lambda$new$241(Observable valueModel) {
        if (this.scrollPane.getViewportBounds() != null) {
            Bounds newViewportBounds = this.scrollPane.getViewportBounds();
            if (this.oldViewportBounds == null || this.oldViewportBounds.getWidth() != newViewportBounds.getWidth() || this.oldViewportBounds.getHeight() != newViewportBounds.getHeight()) {
                this.invalidateMetrics();
                this.oldViewportBounds = newViewportBounds;
                this.contentView.requestLayout();
            }
        }
    }

    /* synthetic */ void lambda$new$240(Observable valueModel) {
        this.updatePrefViewportWidth();
        this.updatePrefViewportHeight();
    }

    /* synthetic */ void lambda$new$239(Observable valueModel) {
        this.updateFontMetrics();
    }

    /* synthetic */ void lambda$new$238(ObservableValue observable, Number oldValue, Number newValue) {
        this.invalidateMetrics();
        this.updatePrefViewportHeight();
    }

    /* synthetic */ void lambda$new$237(ObservableValue observable, Number oldValue, Number newValue) {
        this.invalidateMetrics();
        this.updatePrefViewportWidth();
    }

    /* synthetic */ void lambda$new$236(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        this.invalidateMetrics();
        this.scrollPane.setFitToWidth(newValue);
    }

    /* synthetic */ void lambda$new$235(TextArea textArea, ObservableValue observable, IndexRange oldValue, IndexRange newValue) {
        textArea.requestLayout();
        this.contentView.requestLayout();
    }

    /* synthetic */ void lambda$new$234(ObservableValue observable, Number oldValue, Number newValue) {
        ((TextArea)this.getSkinnable()).setScrollTop(newValue.doubleValue() * this.getScrollTopMax());
    }

    /* synthetic */ void lambda$new$233(ObservableValue observable, Number oldValue, Number newValue) {
        ((TextArea)this.getSkinnable()).setScrollLeft(newValue.doubleValue() * this.getScrollLeftMax());
    }

    /* synthetic */ void lambda$new$232(ScrollEvent event) {
        if (event.isDirect() && this.handlePressed) {
            event.consume();
        }
    }

    /* synthetic */ void lambda$new$231(TextArea textArea, Observable observable) {
        if (textArea.getWidth() > 0.0) {
            this.updateTextNodeCaretPos(textArea.getCaretPosition());
        }
    }

    /* synthetic */ void lambda$new$230(ObservableValue observable, Number oldValue, Number newValue) {
        this.targetCaretX = -1.0;
        if (newValue.intValue() > oldValue.intValue()) {
            this.setForwardBias(true);
        }
    }

    /* synthetic */ void lambda$new$229(ActionEvent event) {
        switch (this.scrollDirection) {
            case UP: {
                break;
            }
        }
    }

    private class ContentView
    extends Region {
        private ContentView() {
            this.getStyleClass().add("content");
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, TextAreaSkin$ContentView$$Lambda$1.lambdaFactory$(this));
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, TextAreaSkin$ContentView$$Lambda$2.lambdaFactory$(this));
            this.addEventHandler(MouseEvent.MOUSE_DRAGGED, TextAreaSkin$ContentView$$Lambda$3.lambdaFactory$(this));
        }

        @Override
        protected ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        @Override
        public Orientation getContentBias() {
            return Orientation.HORIZONTAL;
        }

        @Override
        protected double computePrefWidth(double height) {
            if (TextAreaSkin.this.computedPrefWidth < 0.0) {
                Bounds viewPortBounds;
                double prefWidth = 0.0;
                for (Node node : TextAreaSkin.this.paragraphNodes.getChildren()) {
                    Text paragraphNode = (Text)node;
                    prefWidth = Math.max(prefWidth, Utils.computeTextWidth(paragraphNode.getFont(), paragraphNode.getText(), 0.0));
                }
                TextAreaSkin.this.computedPrefWidth = Math.max(prefWidth += this.snappedLeftInset() + this.snappedRightInset(), (viewPortBounds = TextAreaSkin.this.scrollPane.getViewportBounds()) != null ? viewPortBounds.getWidth() : 0.0);
            }
            return TextAreaSkin.this.computedPrefWidth;
        }

        @Override
        protected double computePrefHeight(double width) {
            if (width != TextAreaSkin.this.widthForComputedPrefHeight) {
                TextAreaSkin.this.invalidateMetrics();
                TextAreaSkin.this.widthForComputedPrefHeight = width;
            }
            if (TextAreaSkin.this.computedPrefHeight < 0.0) {
                Bounds viewPortBounds;
                double wrappingWidth = width == -1.0 ? 0.0 : Math.max(width - (this.snappedLeftInset() + this.snappedRightInset()), 0.0);
                double prefHeight = 0.0;
                for (Node node : TextAreaSkin.this.paragraphNodes.getChildren()) {
                    Text paragraphNode = (Text)node;
                    prefHeight += Utils.computeTextHeight(paragraphNode.getFont(), paragraphNode.getText(), wrappingWidth, paragraphNode.getBoundsType());
                }
                TextAreaSkin.this.computedPrefHeight = Math.max(prefHeight += this.snappedTopInset() + this.snappedBottomInset(), (viewPortBounds = TextAreaSkin.this.scrollPane.getViewportBounds()) != null ? viewPortBounds.getHeight() : 0.0);
            }
            return TextAreaSkin.this.computedPrefHeight;
        }

        @Override
        protected double computeMinWidth(double height) {
            if (TextAreaSkin.this.computedMinWidth < 0.0) {
                double hInsets = this.snappedLeftInset() + this.snappedRightInset();
                TextAreaSkin.this.computedMinWidth = Math.min(TextAreaSkin.this.characterWidth + hInsets, this.computePrefWidth(height));
            }
            return TextAreaSkin.this.computedMinWidth;
        }

        @Override
        protected double computeMinHeight(double width) {
            if (TextAreaSkin.this.computedMinHeight < 0.0) {
                double vInsets = this.snappedTopInset() + this.snappedBottomInset();
                TextAreaSkin.this.computedMinHeight = Math.min(TextAreaSkin.this.lineHeight + vInsets, this.computePrefHeight(width));
            }
            return TextAreaSkin.this.computedMinHeight;
        }

        @Override
        public void layoutChildren() {
            Text paragraphNode;
            int paragraphOffset;
            int paragraphIndex;
            TextArea textArea = (TextArea)TextAreaSkin.this.getSkinnable();
            double width = this.getWidth();
            double topPadding = this.snappedTopInset();
            double leftPadding = this.snappedLeftInset();
            double wrappingWidth = Math.max(width - (leftPadding + this.snappedRightInset()), 0.0);
            double y = topPadding;
            ObservableList<Node> paragraphNodesChildren = TextAreaSkin.this.paragraphNodes.getChildren();
            for (int i = 0; i < paragraphNodesChildren.size(); ++i) {
                Node node = (Node)paragraphNodesChildren.get(i);
                Text paragraphNode2 = (Text)node;
                paragraphNode2.setWrappingWidth(wrappingWidth);
                Bounds bounds = paragraphNode2.getBoundsInLocal();
                paragraphNode2.setLayoutX(leftPadding);
                paragraphNode2.setLayoutY(y);
                y += bounds.getHeight();
            }
            if (TextAreaSkin.this.promptNode != null) {
                TextAreaSkin.this.promptNode.setLayoutX(leftPadding);
                TextAreaSkin.this.promptNode.setLayoutY(topPadding + TextAreaSkin.this.promptNode.getBaselineOffset());
                TextAreaSkin.this.promptNode.setWrappingWidth(wrappingWidth);
            }
            IndexRange selection = textArea.getSelection();
            Bounds oldCaretBounds = TextAreaSkin.this.caretPath.getBoundsInParent();
            TextAreaSkin.this.selectionHighlightGroup.getChildren().clear();
            int caretPos = textArea.getCaretPosition();
            int anchorPos = textArea.getAnchor();
            if (TextInputControlSkin.SHOW_HANDLES) {
                if (selection.getLength() > 0) {
                    TextAreaSkin.this.selectionHandle1.resize(TextAreaSkin.this.selectionHandle1.prefWidth(-1.0), TextAreaSkin.this.selectionHandle1.prefHeight(-1.0));
                    TextAreaSkin.this.selectionHandle2.resize(TextAreaSkin.this.selectionHandle2.prefWidth(-1.0), TextAreaSkin.this.selectionHandle2.prefHeight(-1.0));
                } else {
                    TextAreaSkin.this.caretHandle.resize(TextAreaSkin.this.caretHandle.prefWidth(-1.0), TextAreaSkin.this.caretHandle.prefHeight(-1.0));
                }
                if (selection.getLength() > 0) {
                    paragraphIndex = paragraphNodesChildren.size();
                    paragraphOffset = textArea.getLength() + 1;
                    paragraphNode = null;
                    while (anchorPos < (paragraphOffset -= (paragraphNode = (Text)paragraphNodesChildren.get(--paragraphIndex)).getText().length() + 1)) {
                    }
                    TextAreaSkin.this.updateTextNodeCaretPos(anchorPos - paragraphOffset);
                    TextAreaSkin.this.caretPath.getElements().clear();
                    TextAreaSkin.this.caretPath.getElements().addAll((PathElement[])paragraphNode.getImpl_caretShape());
                    TextAreaSkin.this.caretPath.setLayoutX(paragraphNode.getLayoutX());
                    TextAreaSkin.this.caretPath.setLayoutY(paragraphNode.getLayoutY());
                    Bounds b = TextAreaSkin.this.caretPath.getBoundsInParent();
                    if (caretPos < anchorPos) {
                        TextAreaSkin.this.selectionHandle2.setLayoutX(b.getMinX() - TextAreaSkin.this.selectionHandle2.getWidth() / 2.0);
                        TextAreaSkin.this.selectionHandle2.setLayoutY(b.getMaxY() - 1.0);
                    } else {
                        TextAreaSkin.this.selectionHandle1.setLayoutX(b.getMinX() - TextAreaSkin.this.selectionHandle1.getWidth() / 2.0);
                        TextAreaSkin.this.selectionHandle1.setLayoutY(b.getMinY() - TextAreaSkin.this.selectionHandle1.getHeight() + 1.0);
                    }
                }
            }
            paragraphIndex = paragraphNodesChildren.size();
            paragraphOffset = textArea.getLength() + 1;
            paragraphNode = null;
            while (caretPos < (paragraphOffset -= (paragraphNode = (Text)paragraphNodesChildren.get(--paragraphIndex)).getText().length() + 1)) {
            }
            TextAreaSkin.this.updateTextNodeCaretPos(caretPos - paragraphOffset);
            TextAreaSkin.this.caretPath.getElements().clear();
            TextAreaSkin.this.caretPath.getElements().addAll((PathElement[])paragraphNode.getImpl_caretShape());
            TextAreaSkin.this.caretPath.setLayoutX(paragraphNode.getLayoutX());
            paragraphNode.setLayoutX(2.0 * paragraphNode.getLayoutX() - paragraphNode.getBoundsInParent().getMinX());
            TextAreaSkin.this.caretPath.setLayoutY(paragraphNode.getLayoutY());
            if (oldCaretBounds == null || !oldCaretBounds.equals(TextAreaSkin.this.caretPath.getBoundsInParent())) {
                TextAreaSkin.this.scrollCaretToVisible();
            }
            int start = selection.getStart();
            int end = selection.getEnd();
            int max = paragraphNodesChildren.size();
            for (int i = 0; i < max; ++i) {
                Node paragraphNode3 = (Node)paragraphNodesChildren.get(i);
                Text textNode = (Text)paragraphNode3;
                int paragraphLength = textNode.getText().length() + 1;
                if (end > start && start < paragraphLength) {
                    textNode.setImpl_selectionStart(start);
                    textNode.setImpl_selectionEnd(Math.min(end, paragraphLength));
                    Path selectionHighlightPath = new Path();
                    selectionHighlightPath.setManaged(false);
                    selectionHighlightPath.setStroke(null);
                    PathElement[] selectionShape = textNode.getImpl_selectionShape();
                    if (selectionShape != null) {
                        selectionHighlightPath.getElements().addAll((PathElement[])selectionShape);
                    }
                    TextAreaSkin.this.selectionHighlightGroup.getChildren().add(selectionHighlightPath);
                    TextAreaSkin.this.selectionHighlightGroup.setVisible(true);
                    selectionHighlightPath.setLayoutX(textNode.getLayoutX());
                    selectionHighlightPath.setLayoutY(textNode.getLayoutY());
                    TextAreaSkin.this.updateHighlightFill();
                } else {
                    textNode.setImpl_selectionStart(-1);
                    textNode.setImpl_selectionEnd(-1);
                    TextAreaSkin.this.selectionHighlightGroup.setVisible(false);
                }
                start = Math.max(0, start - paragraphLength);
                end = Math.max(0, end - paragraphLength);
            }
            if (TextInputControlSkin.SHOW_HANDLES) {
                Bounds b = TextAreaSkin.this.caretPath.getBoundsInParent();
                if (selection.getLength() > 0) {
                    if (caretPos < anchorPos) {
                        TextAreaSkin.this.selectionHandle1.setLayoutX(b.getMinX() - TextAreaSkin.this.selectionHandle1.getWidth() / 2.0);
                        TextAreaSkin.this.selectionHandle1.setLayoutY(b.getMinY() - TextAreaSkin.this.selectionHandle1.getHeight() + 1.0);
                    } else {
                        TextAreaSkin.this.selectionHandle2.setLayoutX(b.getMinX() - TextAreaSkin.this.selectionHandle2.getWidth() / 2.0);
                        TextAreaSkin.this.selectionHandle2.setLayoutY(b.getMaxY() - 1.0);
                    }
                } else {
                    TextAreaSkin.this.caretHandle.setLayoutX(b.getMinX() - TextAreaSkin.this.caretHandle.getWidth() / 2.0 + 1.0);
                    TextAreaSkin.this.caretHandle.setLayoutY(b.getMaxY());
                }
            }
            if (TextAreaSkin.this.scrollPane.getPrefViewportWidth() == 0.0 || TextAreaSkin.this.scrollPane.getPrefViewportHeight() == 0.0) {
                TextAreaSkin.this.updatePrefViewportWidth();
                TextAreaSkin.this.updatePrefViewportHeight();
                if (this.getParent() != null && TextAreaSkin.this.scrollPane.getPrefViewportWidth() > 0.0 || TextAreaSkin.this.scrollPane.getPrefViewportHeight() > 0.0) {
                    this.getParent().requestLayout();
                }
            }
        }

        /* synthetic */ void lambda$new$228(MouseEvent event) {
            ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mouseDragged(event);
            event.consume();
        }

        /* synthetic */ void lambda$new$227(MouseEvent event) {
            ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mouseReleased(event);
            event.consume();
        }

        /* synthetic */ void lambda$new$226(MouseEvent event) {
            ((TextAreaBehavior)TextAreaSkin.this.getBehavior()).mousePressed(event);
            event.consume();
        }
    }
}

