/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.glass.ui.android.SoftwareKeyboard;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;

public class TextAreaSkinAndroid
extends TextAreaSkin {
    boolean isShowingSoftwareKeyboard = false;

    public TextAreaSkinAndroid(final TextArea textArea) {
        super(textArea);
        if (textArea.isFocused() && textArea.getScene() != null) {
            this.showSoftwareKeyboardFor(textArea);
        }
        textArea.sceneProperty().addListener(new ChangeListener<Scene>(){

            @Override
            public void changed(ObservableValue<? extends Scene> observable, Scene oldScene, Scene newScene) {
                if (newScene != null && textArea.isFocused()) {
                    TextAreaSkinAndroid.this.showSoftwareKeyboardFor(textArea);
                }
                if (newScene == null) {
                    TextAreaSkinAndroid.this.hideSoftwareKeyboardFor(textArea);
                }
            }
        });
        textArea.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    TextAreaSkinAndroid.this.showSoftwareKeyboardFor(textArea);
                } else {
                    TextAreaSkinAndroid.this.hideSoftwareKeyboardFor(textArea);
                }
            }
        });
    }

    private void showSoftwareKeyboardFor(TextArea textArea) {
        if (!textArea.isEditable()) {
            return;
        }
        if (this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.show();
        this.isShowingSoftwareKeyboard = true;
    }

    private void hideSoftwareKeyboardFor(TextArea textArea) {
        if (!textArea.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.hide();
        this.isShowingSoftwareKeyboard = false;
    }
}

