/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.glass.ui.android.SoftwareKeyboard;
import com.sun.javafx.scene.control.behavior.TextFieldBehavior;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.scene.control.TextField;

public class TextFieldSkinAndroid
extends TextFieldSkin {
    final int kh = 255;
    boolean isShowingSoftwareKeyboard = false;

    public TextFieldSkinAndroid(final TextField textField) {
        super(textField);
        if (textField.isFocused() && textField.getScene() != null) {
            this.showSoftwareKeyboardFor(textField);
        }
        textField.sceneProperty().addListener(new ChangeListener<Scene>(){

            @Override
            public void changed(ObservableValue<? extends Scene> observable, Scene oldScene, Scene newScene) {
                if (newScene != null && textField.isFocused()) {
                    TextFieldSkinAndroid.this.showSoftwareKeyboardFor(textField);
                }
                if (newScene == null) {
                    TextFieldSkinAndroid.this.hideSoftwareKeyboardFor(textField);
                }
            }
        });
        textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observable, Boolean wasFocused, Boolean isFocused) {
                if (isFocused.booleanValue()) {
                    TextFieldSkinAndroid.this.showSoftwareKeyboardFor(textField);
                } else {
                    TextFieldSkinAndroid.this.hideSoftwareKeyboardFor(textField);
                }
            }
        });
    }

    public TextFieldSkinAndroid(TextField textField, TextFieldBehavior behavior) {
        super(textField, behavior);
    }

    private void showSoftwareKeyboardFor(TextField textField) {
        if (!textField.isEditable()) {
            return;
        }
        if (this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.show();
        this.isShowingSoftwareKeyboard = true;
        double tTot = textField.getScene().getHeight();
        double ty = textField.getLocalToSceneTransform().getTy();
        if (ty > tTot - 255.0) {
            textField.getScene().getRoot().setTranslateY(tTot - ty - 255.0);
        }
    }

    private void hideSoftwareKeyboardFor(TextField textField) {
        if (!textField.isEditable()) {
            return;
        }
        if (!this.isShowingSoftwareKeyboard) {
            return;
        }
        SoftwareKeyboard.hide();
        this.isShowingSoftwareKeyboard = false;
        if (textField.getScene() != null) {
            textField.getScene().getRoot().setTranslateY(0.0);
        }
    }
}

