/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$1;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$10;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$11;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$12;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$13;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$14;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$15;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$2;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$3;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$4;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$5;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$6;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$7;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$8;
import com.sun.javafx.scene.control.skin.VirtualFlow$$Lambda$9;
import com.sun.javafx.scene.control.skin.VirtualFlow$ClippedContainer$$Lambda$1;
import com.sun.javafx.scene.control.skin.VirtualFlow$ClippedContainer$$Lambda$2;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;
import sun.util.logging.PlatformLogger;

public class VirtualFlow<T extends IndexedCell>
extends Region {
    private static final int MIN_SCROLLING_LINES_PER_PAGE = 8;
    private boolean touchDetected = false;
    private boolean mouseDown = false;
    private BooleanProperty vertical;
    private boolean pannable = true;
    private int cellCount;
    private double position;
    private double fixedCellSize = 0.0;
    private boolean fixedCellSizeEnabled = false;
    private Callback<VirtualFlow, T> createCell;
    private double maxPrefBreadth;
    private double viewportBreadth;
    private double viewportLength;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    int lastCellCount = 0;
    boolean lastVertical;
    double lastPosition;
    double lastCellBreadth = -1.0;
    double lastCellLength = -1.0;
    final ArrayLinkedList<T> cells = new ArrayLinkedList();
    final ArrayLinkedList<T> pile = new ArrayLinkedList();
    T accumCell;
    Group accumCellParent;
    final Group sheet;
    final ObservableList<Node> sheetChildren;
    private VirtualScrollBar hbar = new VirtualScrollBar(this);
    private VirtualScrollBar vbar = new VirtualScrollBar(this);
    ClippedContainer clipView;
    StackPane corner;
    private double lastX;
    private double lastY;
    private boolean isPanning = false;
    private final List<T> privateCells = new ArrayList<T>();
    private boolean needsReconfigureCells = false;
    private boolean needsRecreateCells = false;
    private boolean needsRebuildCells = false;
    private boolean needsCellsLayout = false;
    private boolean sizeChanged = false;
    private final BitSet dirtyCells = new BitSet();
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;
    Timeline sbTouchTimeline;
    KeyFrame sbTouchKF1;
    KeyFrame sbTouchKF2;
    private boolean needBreadthBar;
    private boolean needLengthBar;
    private boolean tempVisibility = false;

    public final void setVertical(boolean value) {
        this.verticalProperty().set(value);
    }

    public final boolean isVertical() {
        return this.vertical == null ? true : this.vertical.get();
    }

    public final BooleanProperty verticalProperty() {
        if (this.vertical == null) {
            this.vertical = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    VirtualFlow.this.pile.clear();
                    VirtualFlow.this.sheetChildren.clear();
                    VirtualFlow.this.cells.clear();
                    VirtualFlow.this.lastHeight = -1.0;
                    VirtualFlow.this.lastWidth = -1.0;
                    VirtualFlow.this.setMaxPrefBreadth(-1.0);
                    VirtualFlow.this.setViewportBreadth(0.0);
                    VirtualFlow.this.setViewportLength(0.0);
                    VirtualFlow.this.lastPosition = 0.0;
                    VirtualFlow.this.hbar.setValue(0.0);
                    VirtualFlow.this.vbar.setValue(0.0);
                    VirtualFlow.this.setPosition(0.0);
                    VirtualFlow.this.setNeedsLayout(true);
                    VirtualFlow.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VirtualFlow.this;
                }

                @Override
                public String getName() {
                    return "vertical";
                }
            };
        }
        return this.vertical;
    }

    public boolean isPannable() {
        return this.pannable;
    }

    public void setPannable(boolean value) {
        this.pannable = value;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public void setCellCount(int i) {
        boolean countChanged;
        int oldCount = this.cellCount;
        this.cellCount = i;
        boolean bl = countChanged = oldCount != this.cellCount;
        if (countChanged) {
            VirtualScrollBar lengthBar = this.isVertical() ? this.vbar : this.hbar;
            lengthBar.setMax(i);
        }
        if (countChanged) {
            this.layoutChildren();
            this.sheetChildren.clear();
            Parent parent = this.getParent();
            if (parent != null) {
                parent.requestLayout();
            }
        }
    }

    public double getPosition() {
        return this.position;
    }

    public void setPosition(double newPosition) {
        boolean needsUpdate = this.position != newPosition;
        this.position = Utils.clamp(0.0, newPosition, 1.0);
        if (needsUpdate) {
            this.requestLayout();
        }
    }

    public void setFixedCellSize(double value) {
        this.fixedCellSize = value;
        this.fixedCellSizeEnabled = this.fixedCellSize > 0.0;
        this.needsCellsLayout = true;
        this.layoutChildren();
    }

    public Callback<VirtualFlow, T> getCreateCell() {
        return this.createCell;
    }

    public void setCreateCell(Callback<VirtualFlow, T> cc) {
        this.createCell = cc;
        if (this.createCell != null) {
            this.accumCell = null;
            this.setNeedsLayout(true);
            this.recreateCells();
            if (this.getParent() != null) {
                this.getParent().requestLayout();
            }
        }
    }

    protected final void setMaxPrefBreadth(double value) {
        this.maxPrefBreadth = value;
    }

    protected final double getMaxPrefBreadth() {
        return this.maxPrefBreadth;
    }

    protected final void setViewportBreadth(double value) {
        this.viewportBreadth = value;
    }

    protected final double getViewportBreadth() {
        return this.viewportBreadth;
    }

    void setViewportLength(double value) {
        this.viewportLength = value;
    }

    protected double getViewportLength() {
        return this.viewportLength;
    }

    protected List<T> getCells() {
        return this.cells;
    }

    protected final VirtualScrollBar getHbar() {
        return this.hbar;
    }

    protected final VirtualScrollBar getVbar() {
        return this.vbar;
    }

    public VirtualFlow() {
        this.getStyleClass().add("virtual-flow");
        this.setId("virtual-flow");
        this.sheet = new Group();
        this.sheet.getStyleClass().add("sheet");
        this.sheet.setAutoSizeChildren(false);
        this.sheetChildren = this.sheet.getChildren();
        this.clipView = new ClippedContainer(this);
        this.clipView.setNode(this.sheet);
        this.getChildren().add(this.clipView);
        this.accumCellParent = new Group();
        this.accumCellParent.setVisible(false);
        this.getChildren().add(this.accumCellParent);
        EventDispatcher blockEventDispatcher = VirtualFlow$$Lambda$1.lambdaFactory$();
        EventDispatcher oldHsbEventDispatcher = this.hbar.getEventDispatcher();
        this.hbar.setEventDispatcher(VirtualFlow$$Lambda$2.lambdaFactory$(blockEventDispatcher, oldHsbEventDispatcher));
        EventDispatcher oldVsbEventDispatcher = this.vbar.getEventDispatcher();
        this.vbar.setEventDispatcher(VirtualFlow$$Lambda$3.lambdaFactory$(blockEventDispatcher, oldVsbEventDispatcher));
        this.setOnScroll((EventHandler<? super ScrollEvent>)new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent event) {
                VirtualScrollBar nonVirtualBar;
                double result;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED && !VirtualFlow.this.touchDetected && !VirtualFlow.this.mouseDown) {
                    VirtualFlow.this.startSBReleasedAnimation();
                }
                double virtualDelta = 0.0;
                if (VirtualFlow.this.isVertical()) {
                    switch (event.getTextDeltaYUnits()) {
                        case PAGES: {
                            virtualDelta = event.getTextDeltaY() * VirtualFlow.this.lastHeight;
                            break;
                        }
                        case LINES: {
                            double lineSize;
                            if (VirtualFlow.this.fixedCellSizeEnabled) {
                                lineSize = VirtualFlow.this.fixedCellSize;
                            } else {
                                IndexedCell lastCell = (IndexedCell)VirtualFlow.this.cells.getLast();
                                lineSize = (VirtualFlow.this.getCellPosition(lastCell) + VirtualFlow.this.getCellLength(lastCell) - VirtualFlow.this.getCellPosition((IndexedCell)VirtualFlow.this.cells.getFirst())) / (double)VirtualFlow.this.cells.size();
                            }
                            if (VirtualFlow.this.lastHeight / lineSize < 8.0) {
                                lineSize = VirtualFlow.this.lastHeight / 8.0;
                            }
                            virtualDelta = event.getTextDeltaY() * lineSize;
                            break;
                        }
                        case NONE: {
                            virtualDelta = event.getDeltaY();
                        }
                    }
                } else {
                    switch (event.getTextDeltaXUnits()) {
                        case CHARACTERS: 
                        case NONE: {
                            double dx = event.getDeltaX();
                            double dy = event.getDeltaY();
                            double d = virtualDelta = Math.abs(dx) > Math.abs(dy) ? dx : dy;
                        }
                    }
                }
                if (virtualDelta != 0.0 && (result = VirtualFlow.this.adjustPixels(-virtualDelta)) != 0.0) {
                    event.consume();
                }
                VirtualScrollBar virtualScrollBar = nonVirtualBar = VirtualFlow.this.isVertical() ? VirtualFlow.this.hbar : VirtualFlow.this.vbar;
                if (VirtualFlow.this.needBreadthBar) {
                    double nonVirtualDelta;
                    double d = nonVirtualDelta = VirtualFlow.this.isVertical() ? event.getDeltaX() : event.getDeltaY();
                    if (nonVirtualDelta != 0.0) {
                        double newValue = nonVirtualBar.getValue() - nonVirtualDelta;
                        if (newValue < nonVirtualBar.getMin()) {
                            nonVirtualBar.setValue(nonVirtualBar.getMin());
                        } else if (newValue > nonVirtualBar.getMax()) {
                            nonVirtualBar.setValue(nonVirtualBar.getMax());
                        } else {
                            nonVirtualBar.setValue(newValue);
                        }
                        event.consume();
                    }
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent e) {
                VirtualFlow.this.mouseDown = true;
                if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                    VirtualFlow.this.scrollBarOn();
                }
                if (VirtualFlow.this.isFocusTraversable()) {
                    boolean doFocusRequest = true;
                    Node focusOwner = VirtualFlow.this.getScene().getFocusOwner();
                    if (focusOwner != null) {
                        for (Parent parent = focusOwner.getParent(); parent != null; parent = parent.getParent()) {
                            if (!parent.equals(VirtualFlow.this)) continue;
                            doFocusRequest = false;
                            break;
                        }
                    }
                    if (doFocusRequest) {
                        VirtualFlow.this.requestFocus();
                    }
                }
                VirtualFlow.this.lastX = e.getX();
                VirtualFlow.this.lastY = e.getY();
                VirtualFlow.this.isPanning = !VirtualFlow.this.vbar.getBoundsInParent().contains(e.getX(), e.getY()) && !VirtualFlow.this.hbar.getBoundsInParent().contains(e.getX(), e.getY());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, VirtualFlow$$Lambda$4.lambdaFactory$(this));
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, VirtualFlow$$Lambda$5.lambdaFactory$(this));
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.vbar.addEventHandler(MouseEvent.ANY, VirtualFlow$$Lambda$6.lambdaFactory$());
        this.getChildren().add(this.vbar);
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.hbar.addEventHandler(MouseEvent.ANY, VirtualFlow$$Lambda$7.lambdaFactory$());
        this.getChildren().add(this.hbar);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.getChildren().add(this.corner);
        InvalidationListener listenerX = VirtualFlow$$Lambda$8.lambdaFactory$(this);
        this.verticalProperty().addListener(listenerX);
        this.hbar.valueProperty().addListener(listenerX);
        this.hbar.visibleProperty().addListener(listenerX);
        ChangeListener listenerY = VirtualFlow$$Lambda$9.lambdaFactory$(this);
        this.vbar.valueProperty().addListener(listenerY);
        super.heightProperty().addListener(VirtualFlow$$Lambda$10.lambdaFactory$(this));
        this.setOnTouchPressed(VirtualFlow$$Lambda$11.lambdaFactory$(this));
        this.setOnTouchReleased(VirtualFlow$$Lambda$12.lambdaFactory$(this));
        this.setImpl_traversalEngine(new ParentTraversalEngine(this, new Algorithm(){

            Node selectNextAfterIndex(int index, TraversalContext context) {
                Object nextCell;
                while ((nextCell = VirtualFlow.this.getVisibleCell(++index)) != null) {
                    if (((Node)nextCell).isFocusTraversable()) {
                        return nextCell;
                    }
                    Node n = context.selectFirstInParent((Parent)nextCell);
                    if (n == null) continue;
                    return n;
                }
                return null;
            }

            Node selectPreviousBeforeIndex(int index, TraversalContext context) {
                Object prevCell;
                while ((prevCell = VirtualFlow.this.getVisibleCell(--index)) != null) {
                    Node prev = context.selectLastInParent((Parent)prevCell);
                    if (prev != null) {
                        return prev;
                    }
                    if (!((Node)prevCell).isFocusTraversable()) continue;
                    return prevCell;
                }
                return null;
            }

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                IndexedCell cell;
                if (VirtualFlow.this.cells.isEmpty()) {
                    return null;
                }
                if (VirtualFlow.this.cells.contains(owner)) {
                    cell = (IndexedCell)owner;
                } else {
                    cell = this.findOwnerCell(owner);
                    Node next = context.selectInSubtree(cell, owner, dir);
                    if (next != null) {
                        return next;
                    }
                    if (dir == Direction.NEXT) {
                        dir = Direction.NEXT_IN_LINE;
                    }
                }
                int cellIndex = cell.getIndex();
                switch (dir) {
                    case PREVIOUS: {
                        return this.selectPreviousBeforeIndex(cellIndex, context);
                    }
                    case NEXT: {
                        Node n = context.selectFirstInParent(cell);
                        if (n != null) {
                            return n;
                        }
                    }
                    case NEXT_IN_LINE: {
                        return this.selectNextAfterIndex(cellIndex, context);
                    }
                }
                return null;
            }

            private T findOwnerCell(Node owner) {
                Parent p = owner.getParent();
                while (!VirtualFlow.this.cells.contains(p)) {
                    p = p.getParent();
                }
                return (IndexedCell)p;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                IndexedCell firstCell = (IndexedCell)VirtualFlow.this.cells.getFirst();
                if (firstCell == null) {
                    return null;
                }
                if (firstCell.isFocusTraversable()) {
                    return firstCell;
                }
                Node n = context.selectFirstInParent(firstCell);
                if (n != null) {
                    return n;
                }
                return this.selectNextAfterIndex(firstCell.getIndex(), context);
            }

            @Override
            public Node selectLast(TraversalContext context) {
                IndexedCell lastCell = (IndexedCell)VirtualFlow.this.cells.getLast();
                if (lastCell == null) {
                    return null;
                }
                Node p = context.selectLastInParent(lastCell);
                if (p != null) {
                    return p;
                }
                if (lastCell.isFocusTraversable()) {
                    return lastCell;
                }
                return this.selectPreviousBeforeIndex(lastCell.getIndex(), context);
            }
        }));
    }

    void updateHbar() {
        if (!this.isVisible() || this.getScene() == null) {
            return;
        }
        if (this.isVertical()) {
            if (this.hbar.isVisible()) {
                this.clipView.setClipX(this.hbar.getValue());
            } else {
                this.clipView.setClipX(0.0);
                this.hbar.setValue(0.0);
            }
        }
    }

    @Override
    public void requestLayout() {
        this.setNeedsLayout(true);
    }

    @Override
    protected void layoutChildren() {
        boolean rebuild;
        int i;
        if (this.needsRecreateCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            this.sheet.getChildren().clear();
            int max = this.cells.size();
            for (i = 0; i < max; ++i) {
                ((IndexedCell)this.cells.get(i)).updateIndex(-1);
            }
            this.cells.clear();
            this.pile.clear();
            this.releaseAllPrivateCells();
        } else if (this.needsRebuildCells) {
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
            this.releaseCell(this.accumCell);
            for (i = 0; i < this.cells.size(); ++i) {
                ((IndexedCell)this.cells.get(i)).updateIndex(-1);
            }
            this.addAllToPile();
            this.releaseAllPrivateCells();
        } else if (this.needsReconfigureCells) {
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        if (!this.dirtyCells.isEmpty()) {
            int index;
            int cellsSize = this.cells.size();
            while ((index = this.dirtyCells.nextSetBit(0)) != -1 && index < cellsSize) {
                IndexedCell cell = (IndexedCell)this.cells.get(index);
                if (cell != null) {
                    cell.requestLayout();
                }
                this.dirtyCells.clear(index);
            }
            this.setMaxPrefBreadth(-1.0);
            this.lastWidth = -1.0;
            this.lastHeight = -1.0;
        }
        boolean hasSizeChange = this.sizeChanged;
        boolean recreatedOrRebuilt = this.needsRebuildCells || this.needsRecreateCells || this.sizeChanged;
        this.needsRecreateCells = false;
        this.needsReconfigureCells = false;
        this.needsRebuildCells = false;
        this.sizeChanged = false;
        if (this.needsCellsLayout) {
            int max = this.cells.size();
            for (int i2 = 0; i2 < max; ++i2) {
                Cell cell = (Cell)this.cells.get(i2);
                if (cell == null) continue;
                cell.requestLayout();
            }
            this.needsCellsLayout = false;
            return;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        boolean isVertical = this.isVertical();
        double position = this.getPosition();
        if (width <= 0.0 || height <= 0.0) {
            this.addAllToPile();
            this.lastWidth = width;
            this.lastHeight = height;
            this.hbar.setVisible(false);
            this.vbar.setVisible(false);
            this.corner.setVisible(false);
            return;
        }
        boolean cellNeedsLayout = false;
        boolean thumbNeedsLayout = false;
        if (BehaviorSkinBase.IS_TOUCH_SUPPORTED && (this.tempVisibility && (!this.hbar.isVisible() || !this.vbar.isVisible()) || !this.tempVisibility && (this.hbar.isVisible() || this.vbar.isVisible()))) {
            thumbNeedsLayout = true;
        }
        if (!cellNeedsLayout) {
            Cell cell;
            for (int i3 = 0; i3 < this.cells.size() && !(cellNeedsLayout = (cell = (Cell)this.cells.get(i3)).isNeedsLayout()); ++i3) {
            }
        }
        T firstCell = this.getFirstVisibleCell();
        if (!cellNeedsLayout && !thumbNeedsLayout) {
            boolean cellSizeChanged = false;
            if (firstCell != null) {
                double breadth = this.getCellBreadth((Cell)firstCell);
                double length = this.getCellLength(firstCell);
                cellSizeChanged = breadth != this.lastCellBreadth || length != this.lastCellLength;
                this.lastCellBreadth = breadth;
                this.lastCellLength = length;
            }
            if (width == this.lastWidth && height == this.lastHeight && this.cellCount == this.lastCellCount && isVertical == this.lastVertical && position == this.lastPosition && !cellSizeChanged) {
                return;
            }
        }
        boolean needTrailingCells = false;
        boolean bl = rebuild = cellNeedsLayout || isVertical != this.lastVertical || this.cells.isEmpty() || this.getMaxPrefBreadth() == -1.0 || position != this.lastPosition || this.cellCount != this.lastCellCount || hasSizeChange || isVertical && height < this.lastHeight || !isVertical && width < this.lastWidth;
        if (!rebuild) {
            double maxPrefBreadth = this.getMaxPrefBreadth();
            boolean foundMax = false;
            for (int i4 = 0; i4 < this.cells.size(); ++i4) {
                double breadth = this.getCellBreadth((Cell)this.cells.get(i4));
                if (maxPrefBreadth == breadth) {
                    foundMax = true;
                    continue;
                }
                if (!(breadth > maxPrefBreadth)) continue;
                rebuild = true;
                break;
            }
            if (!foundMax) {
                rebuild = true;
            }
        }
        if (!rebuild && (isVertical && height > this.lastHeight || !isVertical && width > this.lastWidth)) {
            needTrailingCells = true;
        }
        this.initViewport();
        int currentIndex = this.computeCurrentIndex();
        if (this.lastCellCount != this.cellCount) {
            if (position != 0.0 && position != 1.0) {
                if (currentIndex >= this.cellCount) {
                    this.setPosition(1.0);
                } else if (firstCell != null) {
                    double firstCellOffset = this.getCellPosition(firstCell);
                    int firstCellIndex = this.getCellIndex(firstCell);
                    this.adjustPositionToIndex(firstCellIndex);
                    double viewportTopToCellTop = -this.computeOffsetForCell(firstCellIndex);
                    this.adjustByPixelAmount(viewportTopToCellTop - firstCellOffset);
                }
            }
            currentIndex = this.computeCurrentIndex();
        }
        if (rebuild) {
            this.setMaxPrefBreadth(-1.0);
            this.addAllToPile();
            double offset = -this.computeViewportOffset(this.getPosition());
            this.addLeadingCells(currentIndex, offset);
            this.addTrailingCells(true);
        } else if (needTrailingCells) {
            this.addTrailingCells(true);
        }
        this.computeBarVisiblity();
        this.updateScrollBarsAndCells(recreatedOrRebuilt);
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastCellCount = this.getCellCount();
        this.lastVertical = this.isVertical();
        this.lastPosition = this.getPosition();
        this.cleanPile();
    }

    protected void addLeadingCells(int currentIndex, double startOffset) {
        double offset = startOffset;
        boolean first = true;
        IndexedCell cell = null;
        for (int index = currentIndex; index >= 0 && (offset > 0.0 || first); --index) {
            cell = this.getAvailableCell(index);
            this.setCellIndex(cell, index);
            this.resizeCellSize(cell);
            this.cells.addFirst(cell);
            if (first) {
                first = false;
            } else {
                offset -= this.getCellLength(cell);
            }
            this.positionCell(cell, offset);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth(cell)));
            cell.setVisible(true);
        }
        cell = (IndexedCell)this.cells.getFirst();
        int firstIndex = this.getCellIndex(cell);
        double firstCellPos = this.getCellPosition(cell);
        if (firstIndex == 0 && firstCellPos > 0.0) {
            this.setPosition(0.0);
            offset = 0.0;
            for (int i = 0; i < this.cells.size(); ++i) {
                cell = (IndexedCell)this.cells.get(i);
                this.positionCell(cell, offset);
                offset += this.getCellLength(cell);
            }
        }
    }

    protected boolean addTrailingCells(boolean fillEmptyCells) {
        if (this.cells.isEmpty()) {
            return false;
        }
        IndexedCell startCell = (IndexedCell)this.cells.getLast();
        double offset = this.getCellPosition(startCell) + this.getCellLength(startCell);
        int index = this.getCellIndex(startCell) + 1;
        boolean filledWithNonEmpty = index <= this.cellCount;
        double viewportLength = this.getViewportLength();
        if (offset < 0.0 && !fillEmptyCells) {
            return false;
        }
        double maxCellCount = viewportLength - offset;
        while (offset < viewportLength) {
            if (index >= this.cellCount) {
                if (offset < viewportLength) {
                    filledWithNonEmpty = false;
                }
                if (!fillEmptyCells) {
                    return filledWithNonEmpty;
                }
                if ((double)index > maxCellCount) {
                    PlatformLogger logger = Logging.getControlsLogger();
                    if (logger.isLoggable(PlatformLogger.Level.INFO)) {
                        if (startCell != null) {
                            logger.info("index exceeds maxCellCount. Check size calculations for " + startCell.getClass());
                        } else {
                            logger.info("index exceeds maxCellCount");
                        }
                    }
                    return filledWithNonEmpty;
                }
            }
            T cell = this.getAvailableCell(index);
            this.setCellIndex(cell, index);
            this.resizeCellSize(cell);
            this.cells.addLast(cell);
            this.positionCell(cell, offset);
            this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)cell)));
            offset += this.getCellLength(cell);
            ((Node)cell).setVisible(true);
            ++index;
        }
        IndexedCell firstCell = (IndexedCell)this.cells.getFirst();
        index = this.getCellIndex(firstCell);
        T lastNonEmptyCell = this.getLastVisibleCell();
        double start = this.getCellPosition(firstCell);
        double end = this.getCellPosition(lastNonEmptyCell) + this.getCellLength(lastNonEmptyCell);
        if ((index != 0 || index == 0 && start < 0.0) && fillEmptyCells && lastNonEmptyCell != null && this.getCellIndex(lastNonEmptyCell) == this.cellCount - 1 && end < viewportLength) {
            double cellLength;
            double distance = viewportLength - end;
            for (double prospectiveEnd = end; prospectiveEnd < viewportLength && index != 0 && -start < distance; prospectiveEnd += cellLength) {
                T cell = this.getAvailableCell(--index);
                this.setCellIndex(cell, index);
                this.resizeCellSize(cell);
                this.cells.addFirst(cell);
                cellLength = this.getCellLength(cell);
                this.positionCell(cell, start -= cellLength);
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)cell)));
                ((Node)cell).setVisible(true);
            }
            firstCell = (IndexedCell)this.cells.getFirst();
            start = this.getCellPosition(firstCell);
            double delta = viewportLength - end;
            if (this.getCellIndex(firstCell) == 0 && delta > -start) {
                delta = -start;
            }
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell cell = (IndexedCell)this.cells.get(i);
                this.positionCell(cell, this.getCellPosition(cell) + delta);
            }
            start = this.getCellPosition(firstCell);
            if (this.getCellIndex(firstCell) == 0 && start == 0.0) {
                this.setPosition(0.0);
            } else if (this.getPosition() != 1.0) {
                this.setPosition(1.0);
            }
        }
        return filledWithNonEmpty;
    }

    private boolean computeBarVisiblity() {
        if (this.cells.isEmpty()) {
            this.needLengthBar = false;
            this.needBreadthBar = false;
            return true;
        }
        boolean isVertical = this.isVertical();
        boolean barVisibilityChanged = false;
        VirtualScrollBar breadthBar = isVertical ? this.hbar : this.vbar;
        VirtualScrollBar lengthBar = isVertical ? this.vbar : this.hbar;
        double breadthBarLength = this.snapSize(isVertical ? this.hbar.prefHeight(-1.0) : this.vbar.prefWidth(-1.0));
        double lengthBarBreadth = this.snapSize(isVertical ? this.vbar.prefWidth(-1.0) : this.hbar.prefHeight(-1.0));
        double viewportBreadth = this.getViewportBreadth();
        int cellsSize = this.cells.size();
        for (int i = 0; i < 2; ++i) {
            boolean breadthBarVisible;
            boolean lengthBarVisible;
            boolean bl = lengthBarVisible = this.getPosition() > 0.0 || this.cellCount > cellsSize || this.cellCount == cellsSize && this.getCellPosition((IndexedCell)this.cells.getLast()) + this.getCellLength((IndexedCell)this.cells.getLast()) > this.getViewportLength();
            if (lengthBarVisible ^ this.needLengthBar) {
                this.needLengthBar = lengthBarVisible;
                barVisibilityChanged = true;
            }
            boolean bl2 = breadthBarVisible = this.maxPrefBreadth > viewportBreadth;
            if (!(breadthBarVisible ^ this.needBreadthBar)) continue;
            this.needBreadthBar = breadthBarVisible;
            barVisibilityChanged = true;
        }
        if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
            this.setViewportLength((isVertical ? this.getHeight() : this.getWidth()) - (this.needBreadthBar ? breadthBarLength : 0.0));
            this.setViewportBreadth((isVertical ? this.getWidth() : this.getHeight()) - (this.needLengthBar ? lengthBarBreadth : 0.0));
            breadthBar.setVisible(this.needBreadthBar);
            lengthBar.setVisible(this.needLengthBar);
        } else {
            breadthBar.setVisible(this.needBreadthBar && this.tempVisibility);
            lengthBar.setVisible(this.needLengthBar && this.tempVisibility);
        }
        return barVisibilityChanged;
    }

    private void initViewport() {
        boolean isVertical = this.isVertical();
        double width = this.getWidth();
        double height = this.getHeight();
        this.setViewportLength(this.snapSize(isVertical ? height : width));
        this.setViewportBreadth(this.snapSize(isVertical ? width : height));
        VirtualScrollBar breadthBar = isVertical ? this.hbar : this.vbar;
        VirtualScrollBar lengthBar = isVertical ? this.vbar : this.hbar;
        breadthBar.setVirtual(false);
        lengthBar.setVirtual(true);
    }

    @Override
    protected void setWidth(double value) {
        if (value != this.lastWidth) {
            super.setWidth(value);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    @Override
    protected void setHeight(double value) {
        if (value != this.lastHeight) {
            super.setHeight(value);
            this.sizeChanged = true;
            this.setNeedsLayout(true);
            this.requestLayout();
        }
    }

    private void updateScrollBarsAndCells(boolean recreate) {
        VirtualScrollBar lengthBar;
        boolean isVertical = this.isVertical();
        VirtualScrollBar breadthBar = isVertical ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar = lengthBar = isVertical ? this.vbar : this.hbar;
        if (!this.cells.isEmpty()) {
            IndexedCell cell;
            int i;
            double currOffset = -this.computeViewportOffset(this.getPosition());
            int currIndex = this.computeCurrentIndex() - ((IndexedCell)this.cells.getFirst()).getIndex();
            int size = this.cells.size();
            double offset = currOffset;
            boolean first = true;
            for (i = currIndex; i >= 0 && i < size; --i) {
                cell = (IndexedCell)this.cells.get(i);
                double d = first ? 0.0 : this.getCellLength(cell);
                first = false;
                this.positionCell(cell, offset -= d);
            }
            offset = currOffset;
            for (i = currIndex; i >= 0 && i < size; ++i) {
                cell = (IndexedCell)this.cells.get(i);
                this.positionCell(cell, offset);
                offset += this.getCellLength(cell);
            }
        }
        this.corner.setVisible(breadthBar.isVisible() && lengthBar.isVisible());
        double sumCellLength = 0.0;
        double flowLength = (isVertical ? this.getHeight() : this.getWidth()) - (breadthBar.isVisible() ? breadthBar.prefHeight(-1.0) : 0.0);
        double viewportBreadth = this.getViewportBreadth();
        double viewportLength = this.getViewportLength();
        if (breadthBar.isVisible()) {
            double newMax;
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                if (isVertical) {
                    this.hbar.resizeRelocate(0.0, viewportLength, viewportBreadth, this.hbar.prefHeight(viewportBreadth));
                } else {
                    this.vbar.resizeRelocate(viewportLength, 0.0, this.vbar.prefWidth(viewportBreadth), viewportBreadth);
                }
            } else if (isVertical) {
                this.hbar.resizeRelocate(0.0, viewportLength - this.hbar.getHeight(), viewportBreadth, this.hbar.prefHeight(viewportBreadth));
            } else {
                this.vbar.resizeRelocate(viewportLength - this.vbar.getWidth(), 0.0, this.vbar.prefWidth(viewportBreadth), viewportBreadth);
            }
            if (this.getMaxPrefBreadth() != -1.0 && (newMax = Math.max(1.0, this.getMaxPrefBreadth() - viewportBreadth)) != breadthBar.getMax()) {
                boolean maxed;
                breadthBar.setMax(newMax);
                double breadthBarValue = breadthBar.getValue();
                boolean bl = maxed = breadthBarValue != 0.0 && newMax == breadthBarValue;
                if (maxed || breadthBarValue > newMax) {
                    breadthBar.setValue(newMax);
                }
                breadthBar.setVisibleAmount(viewportBreadth / this.getMaxPrefBreadth() * newMax);
            }
        }
        if (recreate && (lengthBar.isVisible() || BehaviorSkinBase.IS_TOUCH_SUPPORTED)) {
            int numCellsVisibleOnScreen = 0;
            int max = this.cells.size();
            for (int i = 0; i < max; ++i) {
                IndexedCell cell = (IndexedCell)this.cells.get(i);
                if (cell == null || cell.isEmpty()) continue;
                if ((sumCellLength += isVertical ? cell.getHeight() : cell.getWidth()) > flowLength) break;
                ++numCellsVisibleOnScreen;
            }
            lengthBar.setMax(1.0);
            if (numCellsVisibleOnScreen == 0 && this.cellCount == 1) {
                lengthBar.setVisibleAmount(flowLength / sumCellLength);
            } else {
                lengthBar.setVisibleAmount((float)numCellsVisibleOnScreen / (float)this.cellCount);
            }
        }
        if (lengthBar.isVisible()) {
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                if (isVertical) {
                    this.vbar.resizeRelocate(viewportBreadth, 0.0, this.vbar.prefWidth(viewportLength), viewportLength);
                } else {
                    this.hbar.resizeRelocate(0.0, viewportBreadth, viewportLength, this.hbar.prefHeight(-1.0));
                }
            } else if (isVertical) {
                this.vbar.resizeRelocate(viewportBreadth - this.vbar.getWidth(), 0.0, this.vbar.prefWidth(viewportLength), viewportLength);
            } else {
                this.hbar.resizeRelocate(0.0, viewportBreadth - this.hbar.getHeight(), viewportLength, this.hbar.prefHeight(-1.0));
            }
        }
        if (this.corner.isVisible()) {
            if (!BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + this.hbar.getWidth(), this.vbar.getLayoutY() + this.vbar.getHeight());
            } else {
                this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
                this.corner.relocate(this.hbar.getLayoutX() + (this.hbar.getWidth() - this.vbar.getWidth()), this.vbar.getLayoutY() + (this.vbar.getHeight() - this.hbar.getHeight()));
                this.hbar.resize(this.hbar.getWidth() - this.vbar.getWidth(), this.hbar.getHeight());
                this.vbar.resize(this.vbar.getWidth(), this.vbar.getHeight() - this.hbar.getHeight());
            }
        }
        this.clipView.resize(this.snapSize(isVertical ? viewportBreadth : viewportLength), this.snapSize(isVertical ? viewportLength : viewportBreadth));
        this.fitCells();
        if (this.getPosition() != lengthBar.getValue()) {
            lengthBar.setValue(this.getPosition());
        }
    }

    private void fitCells() {
        double size = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
        boolean isVertical = this.isVertical();
        for (int i = 0; i < this.cells.size(); ++i) {
            Cell cell = (Cell)this.cells.get(i);
            if (isVertical) {
                cell.resize(size, cell.getHeight());
                continue;
            }
            cell.resize(cell.getWidth(), size);
        }
    }

    private void cull() {
        double viewportLength = this.getViewportLength();
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell cell = (IndexedCell)this.cells.get(i);
            double cellSize = this.getCellLength(cell);
            double cellStart = this.getCellPosition(cell);
            double cellEnd = cellStart + cellSize;
            if (!(cellStart > viewportLength) && !(cellEnd < 0.0)) continue;
            this.addToPile((IndexedCell)this.cells.remove(i));
        }
    }

    protected int getCellIndex(T cell) {
        return ((IndexedCell)cell).getIndex();
    }

    public T getCell(int index) {
        Callback<VirtualFlow, T> createCell;
        T cell;
        if (!this.cells.isEmpty() && (cell = this.getVisibleCell(index)) != null) {
            return cell;
        }
        for (int i = 0; i < this.pile.size(); ++i) {
            IndexedCell cell2 = (IndexedCell)this.pile.get(i);
            if (this.getCellIndex(cell2) != index) continue;
            return (T)cell2;
        }
        if (this.pile.size() > 0) {
            return (T)((IndexedCell)this.pile.get(0));
        }
        if (this.accumCell == null && (createCell = this.getCreateCell()) != null) {
            this.accumCell = (IndexedCell)createCell.call(this);
            this.accumCellParent.getChildren().setAll((Node[])new Node[]{this.accumCell});
            ((Node)this.accumCell).setAccessibleRole(AccessibleRole.NODE);
            ((Parent)this.accumCell).getChildrenUnmodifiable().addListener(VirtualFlow$$Lambda$13.lambdaFactory$(this));
        }
        this.setCellIndex(this.accumCell, index);
        this.resizeCellSize(this.accumCell);
        return this.accumCell;
    }

    private void releaseCell(T cell) {
        if (this.accumCell != null && cell == this.accumCell) {
            ((IndexedCell)this.accumCell).updateIndex(-1);
        }
    }

    T getPrivateCell(int index) {
        Callback<VirtualFlow, T> createCell;
        Parent cell = null;
        if (!this.cells.isEmpty() && (cell = (Parent)this.getVisibleCell(index)) != null) {
            cell.layout();
            return (T)cell;
        }
        if (cell == null) {
            for (int i = 0; i < this.sheetChildren.size(); ++i) {
                IndexedCell _cell = (IndexedCell)this.sheetChildren.get(i);
                if (this.getCellIndex(_cell) != index) continue;
                return (T)_cell;
            }
        }
        if (cell == null && (createCell = this.getCreateCell()) != null) {
            cell = (IndexedCell)createCell.call(this);
        }
        if (cell != null) {
            this.setCellIndex(cell, index);
            this.resizeCellSize(cell);
            cell.setVisible(false);
            this.sheetChildren.add(cell);
            this.privateCells.add(cell);
        }
        return (T)cell;
    }

    private void releaseAllPrivateCells() {
        this.sheetChildren.removeAll((Collection<?>)this.privateCells);
    }

    protected double getCellLength(int index) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        T cell = this.getCell(index);
        double length = this.getCellLength(cell);
        this.releaseCell(cell);
        return length;
    }

    protected double getCellBreadth(int index) {
        T cell = this.getCell(index);
        double b = this.getCellBreadth((Cell)cell);
        this.releaseCell(cell);
        return b;
    }

    protected double getCellLength(T cell) {
        if (cell == null) {
            return 0.0;
        }
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return this.isVertical() ? ((Node)cell).getLayoutBounds().getHeight() : ((Node)cell).getLayoutBounds().getWidth();
    }

    protected double getCellBreadth(Cell cell) {
        return this.isVertical() ? cell.prefWidth(-1.0) : cell.prefHeight(-1.0);
    }

    protected double getCellPosition(T cell) {
        if (cell == null) {
            return 0.0;
        }
        return this.isVertical() ? ((Node)cell).getLayoutY() : ((Node)cell).getLayoutX();
    }

    protected void positionCell(T cell, double position) {
        if (this.isVertical()) {
            ((Node)cell).setLayoutX(0.0);
            ((Node)cell).setLayoutY(this.snapSize(position));
        } else {
            ((Node)cell).setLayoutX(this.snapSize(position));
            ((Node)cell).setLayoutY(0.0);
        }
    }

    protected void resizeCellSize(T cell) {
        if (cell == null) {
            return;
        }
        if (this.isVertical()) {
            double width = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
            ((Region)cell).resize(width, this.fixedCellSizeEnabled ? this.fixedCellSize : com.sun.javafx.scene.control.skin.Utils.boundedSize(((Region)cell).prefHeight(width), ((Region)cell).minHeight(width), ((Region)cell).maxHeight(width)));
        } else {
            double height = Math.max(this.getMaxPrefBreadth(), this.getViewportBreadth());
            ((Region)cell).resize(this.fixedCellSizeEnabled ? this.fixedCellSize : com.sun.javafx.scene.control.skin.Utils.boundedSize(((Region)cell).prefWidth(height), ((Region)cell).minWidth(height), ((Region)cell).maxWidth(height)), height);
        }
    }

    protected void setCellIndex(T cell, int index) {
        assert (cell != null);
        ((IndexedCell)cell).updateIndex(index);
        if (((Parent)cell).isNeedsLayout() && ((Node)cell).getScene() != null) {
            ((Node)cell).applyCss();
        }
    }

    protected T getAvailableCell(int prefIndex) {
        Node cell = null;
        int max = this.pile.size();
        for (int i = 0; i < max; ++i) {
            IndexedCell _cell = (IndexedCell)this.pile.get(i);
            assert (_cell != null);
            if (this.getCellIndex(_cell) == prefIndex) {
                cell = _cell;
                this.pile.remove(i);
                break;
            }
            cell = null;
        }
        if (cell == null) {
            if (this.pile.size() > 0) {
                boolean prefIndexIsEven = (prefIndex & 1) == 0;
                int max2 = this.pile.size();
                for (int i = 0; i < max2; ++i) {
                    IndexedCell c = (IndexedCell)this.pile.get(i);
                    int cellIndex = this.getCellIndex(c);
                    if ((cellIndex & 1) == 0 && prefIndexIsEven) {
                        cell = c;
                        this.pile.remove(i);
                        break;
                    }
                    if ((cellIndex & 1) != 1 || prefIndexIsEven) continue;
                    cell = c;
                    this.pile.remove(i);
                    break;
                }
                if (cell == null) {
                    cell = (IndexedCell)this.pile.removeFirst();
                }
            } else {
                cell = (IndexedCell)this.getCreateCell().call(this);
            }
        }
        if (cell.getParent() == null) {
            this.sheetChildren.add(cell);
        }
        return (T)cell;
    }

    protected void addAllToPile() {
        int max = this.cells.size();
        for (int i = 0; i < max; ++i) {
            this.addToPile((IndexedCell)this.cells.removeFirst());
        }
    }

    private void addToPile(T cell) {
        assert (cell != null);
        this.pile.addLast(cell);
    }

    private void cleanPile() {
        boolean wasFocusOwner = false;
        int max = this.pile.size();
        for (int i = 0; i < max; ++i) {
            IndexedCell cell = (IndexedCell)this.pile.get(i);
            wasFocusOwner = wasFocusOwner || this.doesCellContainFocus(cell);
            cell.setVisible(false);
        }
        if (wasFocusOwner) {
            this.requestFocus();
        }
    }

    private boolean doesCellContainFocus(Cell<?> c) {
        Node focusOwner;
        Scene scene = c.getScene();
        Node node = focusOwner = scene == null ? null : scene.getFocusOwner();
        if (focusOwner != null) {
            if (c.equals(focusOwner)) {
                return true;
            }
            for (Parent p = focusOwner.getParent(); p != null && !(p instanceof VirtualFlow); p = p.getParent()) {
                if (!c.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    public T getVisibleCell(int index) {
        IndexedCell cell;
        if (this.cells.isEmpty()) {
            return null;
        }
        IndexedCell lastCell = (IndexedCell)this.cells.getLast();
        int lastIndex = this.getCellIndex(lastCell);
        if (index == lastIndex) {
            return (T)lastCell;
        }
        IndexedCell firstCell = (IndexedCell)this.cells.getFirst();
        int firstIndex = this.getCellIndex(firstCell);
        if (index == firstIndex) {
            return (T)firstCell;
        }
        if (index > firstIndex && index < lastIndex && this.getCellIndex(cell = (IndexedCell)this.cells.get(index - firstIndex)) == index) {
            return (T)cell;
        }
        return null;
    }

    public T getLastVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell cell = (IndexedCell)this.cells.get(i);
            if (cell.isEmpty()) continue;
            return (T)cell;
        }
        return null;
    }

    public T getFirstVisibleCell() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        IndexedCell cell = (IndexedCell)this.cells.getFirst();
        return (T)(cell.isEmpty() ? null : cell);
    }

    public T getLastVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        double max = this.getViewportLength();
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            double cellStart;
            double cellEnd;
            IndexedCell cell = (IndexedCell)this.cells.get(i);
            if (cell.isEmpty() || !((cellEnd = (cellStart = this.getCellPosition(cell)) + this.getCellLength(cell)) <= max + 2.0)) continue;
            return (T)cell;
        }
        return null;
    }

    public T getFirstVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.getViewportLength() <= 0.0) {
            return null;
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            double cellStart;
            IndexedCell cell = (IndexedCell)this.cells.get(i);
            if (cell.isEmpty() || !((cellStart = this.getCellPosition(cell)) >= 0.0)) continue;
            return (T)cell;
        }
        return null;
    }

    public void showAsFirst(T firstCell) {
        if (firstCell != null) {
            this.adjustPixels(this.getCellPosition(firstCell));
        }
    }

    public void showAsLast(T lastCell) {
        if (lastCell != null) {
            this.adjustPixels(this.getCellPosition(lastCell) + this.getCellLength(lastCell) - this.getViewportLength());
        }
    }

    public void show(T cell) {
        if (cell != null) {
            double start = this.getCellPosition(cell);
            double length = this.getCellLength(cell);
            double end = start + length;
            double viewportLength = this.getViewportLength();
            if (start < 0.0) {
                this.adjustPixels(start);
            } else if (end > viewportLength) {
                this.adjustPixels(end - viewportLength);
            }
        }
    }

    public void show(int index) {
        T cell = this.getVisibleCell(index);
        if (cell != null) {
            this.show(cell);
        } else {
            T prev = this.getVisibleCell(index - 1);
            if (prev != null) {
                cell = this.getAvailableCell(index);
                this.setCellIndex(cell, index);
                this.resizeCellSize(cell);
                this.cells.addLast(cell);
                this.positionCell(cell, this.getCellPosition(prev) + this.getCellLength(prev));
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)cell)));
                ((Node)cell).setVisible(true);
                this.show(cell);
                return;
            }
            T next = this.getVisibleCell(index + 1);
            if (next != null) {
                cell = this.getAvailableCell(index);
                this.setCellIndex(cell, index);
                this.resizeCellSize(cell);
                this.cells.addFirst(cell);
                this.positionCell(cell, this.getCellPosition(next) - this.getCellLength(cell));
                this.setMaxPrefBreadth(Math.max(this.getMaxPrefBreadth(), this.getCellBreadth((Cell)cell)));
                ((Node)cell).setVisible(true);
                this.show(cell);
                return;
            }
            this.adjustPositionToIndex(index);
            this.addAllToPile();
            this.requestLayout();
        }
    }

    public void scrollTo(int index) {
        boolean posSet = false;
        if (index >= this.cellCount - 1) {
            this.setPosition(1.0);
            posSet = true;
        } else if (index < 0) {
            this.setPosition(0.0);
            posSet = true;
        }
        if (!posSet) {
            this.adjustPositionToIndex(index);
            double offset = -this.computeOffsetForCell(index);
            this.adjustByPixelAmount(offset);
        }
        this.requestLayout();
    }

    public void scrollToOffset(int offset) {
        this.adjustPixels((double)offset * this.getCellLength(0));
    }

    public double adjustPixels(double delta) {
        if (delta == 0.0) {
            return 0.0;
        }
        boolean isVertical = this.isVertical();
        if (isVertical && (!this.tempVisibility ? !this.vbar.isVisible() : !this.needLengthBar) || !isVertical && (this.tempVisibility ? !this.needLengthBar : !this.hbar.isVisible())) {
            return 0.0;
        }
        double pos = this.getPosition();
        if (pos == 0.0 && delta < 0.0) {
            return 0.0;
        }
        if (pos == 1.0 && delta > 0.0) {
            return 0.0;
        }
        this.adjustByPixelAmount(delta);
        if (pos == this.getPosition()) {
            return 0.0;
        }
        if (this.cells.size() > 0) {
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell cell = (IndexedCell)this.cells.get(i);
                assert (cell != null);
                this.positionCell(cell, this.getCellPosition(cell) - delta);
            }
            IndexedCell firstCell = (IndexedCell)this.cells.getFirst();
            double layoutY = firstCell == null ? 0.0 : this.getCellPosition(firstCell);
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell cell = (IndexedCell)this.cells.get(i);
                assert (cell != null);
                double actualLayoutY = this.getCellPosition(cell);
                if (actualLayoutY != layoutY) {
                    this.positionCell(cell, layoutY);
                }
                layoutY += this.getCellLength(cell);
            }
            if (firstCell != null) {
                int firstIndex = this.getCellIndex(firstCell);
                double prevIndexSize = this.getCellLength(firstIndex - 1);
                this.addLeadingCells(firstIndex - 1, this.getCellPosition(firstCell) - prevIndexSize);
            } else {
                int currentIndex = this.computeCurrentIndex();
                double offset = -this.computeViewportOffset(this.getPosition());
                this.addLeadingCells(currentIndex, offset);
            }
            if (!this.addTrailingCells(false)) {
                double viewportLength;
                T lastCell = this.getLastVisibleCell();
                double lastCellSize = this.getCellLength(lastCell);
                double cellEnd = this.getCellPosition(lastCell) + lastCellSize;
                if (cellEnd < (viewportLength = this.getViewportLength())) {
                    double emptySize = viewportLength - cellEnd;
                    for (int i = 0; i < this.cells.size(); ++i) {
                        IndexedCell cell = (IndexedCell)this.cells.get(i);
                        this.positionCell(cell, this.getCellPosition(cell) + emptySize);
                    }
                    this.setPosition(1.0);
                }
            }
        }
        this.cull();
        this.updateScrollBarsAndCells(false);
        this.lastPosition = this.getPosition();
        return delta;
    }

    public void reconfigureCells() {
        this.needsReconfigureCells = true;
        this.requestLayout();
    }

    public void recreateCells() {
        this.needsRecreateCells = true;
        this.requestLayout();
    }

    public void rebuildCells() {
        this.needsRebuildCells = true;
        this.requestLayout();
    }

    public void requestCellLayout() {
        this.needsCellsLayout = true;
        this.requestLayout();
    }

    public void setCellDirty(int index) {
        this.dirtyCells.set(index);
        this.requestLayout();
    }

    private double getPrefBreadth(double oppDimension) {
        double max = this.getMaxCellWidth(10);
        if (oppDimension > -1.0) {
            double prefLength = this.getPrefLength();
            max = Math.max(max, prefLength * 0.618033987);
        }
        return max;
    }

    private double getPrefLength() {
        double sum = 0.0;
        int rows = Math.min(10, this.cellCount);
        for (int i = 0; i < rows; ++i) {
            sum += this.getCellLength(i);
        }
        return sum;
    }

    @Override
    protected double computePrefWidth(double height) {
        double w = this.isVertical() ? this.getPrefBreadth(height) : this.getPrefLength();
        return w + this.vbar.prefWidth(-1.0);
    }

    @Override
    protected double computePrefHeight(double width) {
        double h = this.isVertical() ? this.getPrefLength() : this.getPrefBreadth(width);
        return h + this.hbar.prefHeight(-1.0);
    }

    double getMaxCellWidth(int rowsToCount) {
        double max = 0.0;
        int rows = Math.max(1, rowsToCount == -1 ? this.cellCount : rowsToCount);
        for (int i = 0; i < rows; ++i) {
            max = Math.max(max, this.getCellBreadth(i));
        }
        return max;
    }

    private double computeViewportOffset(double position) {
        double p = Utils.clamp(0.0, position, 1.0);
        double fractionalPosition = p * (double)this.getCellCount();
        int cellIndex = (int)fractionalPosition;
        double fraction = fractionalPosition - (double)cellIndex;
        double cellSize = this.getCellLength(cellIndex);
        double pixelOffset = cellSize * fraction;
        double viewportOffset = this.getViewportLength() * p;
        return pixelOffset - viewportOffset;
    }

    private void adjustPositionToIndex(int index) {
        int cellCount = this.getCellCount();
        if (cellCount <= 0) {
            this.setPosition(0.0);
        } else {
            this.setPosition((double)index / (double)cellCount);
        }
    }

    private void adjustByPixelAmount(double numPixels) {
        double n;
        if (numPixels == 0.0) {
            return;
        }
        boolean forward = numPixels > 0.0;
        int cellCount = this.getCellCount();
        double fractionalPosition = this.getPosition() * (double)cellCount;
        int cellIndex = (int)fractionalPosition;
        if (forward && cellIndex == cellCount) {
            return;
        }
        double cellSize = this.getCellLength(cellIndex);
        double fraction = fractionalPosition - (double)cellIndex;
        double pixelOffset = cellSize * fraction;
        double cellPercent = 1.0 / (double)cellCount;
        double start = this.computeOffsetForCell(cellIndex);
        double end = cellSize + this.computeOffsetForCell(cellIndex + 1);
        double remaining = end - start;
        double p = cellPercent * (double)cellIndex;
        for (n = forward ? numPixels + pixelOffset - this.getViewportLength() * this.getPosition() - start : -numPixels + end - (pixelOffset - this.getViewportLength() * this.getPosition()); n > remaining && (forward && cellIndex < cellCount - 1 || !forward && cellIndex > 0); n -= remaining) {
            cellIndex = forward ? ++cellIndex : --cellIndex;
            cellSize = this.getCellLength(cellIndex);
            start = this.computeOffsetForCell(cellIndex);
            end = cellSize + this.computeOffsetForCell(cellIndex + 1);
            remaining = end - start;
            p = cellPercent * (double)cellIndex;
        }
        if (n > remaining) {
            this.setPosition(forward ? 1.0 : 0.0);
        } else if (forward) {
            double rate = cellPercent / Math.abs(end - start);
            this.setPosition(p + rate * n);
        } else {
            double rate = cellPercent / Math.abs(end - start);
            this.setPosition(p + cellPercent - rate * n);
        }
    }

    private int computeCurrentIndex() {
        return (int)(this.getPosition() * (double)this.getCellCount());
    }

    private double computeOffsetForCell(int itemIndex) {
        double cellCount = this.getCellCount();
        double p = Utils.clamp(0.0, (double)itemIndex, cellCount) / cellCount;
        return -(this.getViewportLength() * p);
    }

    protected void startSBReleasedAnimation() {
        if (this.sbTouchTimeline == null) {
            this.sbTouchTimeline = new Timeline();
            this.sbTouchKF1 = new KeyFrame(Duration.millis(0.0), VirtualFlow$$Lambda$14.lambdaFactory$(this), new KeyValue[0]);
            this.sbTouchKF2 = new KeyFrame(Duration.millis(1000.0), VirtualFlow$$Lambda$15.lambdaFactory$(this), new KeyValue[0]);
            this.sbTouchTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{this.sbTouchKF1, this.sbTouchKF2});
        }
        this.sbTouchTimeline.playFromStart();
    }

    protected void scrollBarOn() {
        this.tempVisibility = true;
        this.requestLayout();
    }

    /* synthetic */ void lambda$startSBReleasedAnimation$101(ActionEvent event) {
        if (!this.touchDetected && !this.mouseDown) {
            this.tempVisibility = false;
            this.requestLayout();
        }
    }

    /* synthetic */ void lambda$startSBReleasedAnimation$100(ActionEvent event) {
        this.tempVisibility = true;
        this.requestLayout();
    }

    /* synthetic */ void lambda$getCell$97(Observable c) {
        for (Node n : ((Parent)this.accumCell).getChildrenUnmodifiable()) {
            n.setAccessibleRole(AccessibleRole.NODE);
        }
    }

    /* synthetic */ void lambda$new$96(TouchEvent e) {
        this.touchDetected = false;
        this.startSBReleasedAnimation();
    }

    /* synthetic */ void lambda$new$95(TouchEvent e) {
        this.touchDetected = true;
        this.scrollBarOn();
    }

    /* synthetic */ void lambda$new$94(ObservableValue observable, Number oldHeight, Number newHeight) {
        if (oldHeight.doubleValue() == 0.0 && newHeight.doubleValue() > 0.0) {
            this.recreateCells();
        }
    }

    /* synthetic */ void lambda$new$93(ObservableValue ov, Number t, Number t1) {
        this.clipView.setClipY(this.isVertical() ? 0.0 : this.vbar.getValue());
    }

    /* synthetic */ void lambda$new$92(Observable valueModel) {
        this.updateHbar();
    }

    static /* synthetic */ void lambda$new$91(MouseEvent event) {
        event.consume();
    }

    static /* synthetic */ void lambda$new$90(MouseEvent event) {
        event.consume();
    }

    /* synthetic */ void lambda$new$89(MouseEvent e) {
        VirtualScrollBar nonVirtualBar;
        if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
            this.scrollBarOn();
        }
        if (!this.isPanning || !this.isPannable()) {
            return;
        }
        double xDelta = this.lastX - e.getX();
        double yDelta = this.lastY - e.getY();
        double virtualDelta = this.isVertical() ? yDelta : xDelta;
        double actual = this.adjustPixels(virtualDelta);
        if (actual != 0.0) {
            if (this.isVertical()) {
                this.lastY = e.getY();
            } else {
                this.lastX = e.getX();
            }
        }
        double nonVirtualDelta = this.isVertical() ? xDelta : yDelta;
        VirtualScrollBar virtualScrollBar = nonVirtualBar = this.isVertical() ? this.hbar : this.vbar;
        if (nonVirtualBar.isVisible()) {
            double newValue = nonVirtualBar.getValue() + nonVirtualDelta;
            if (newValue < nonVirtualBar.getMin()) {
                nonVirtualBar.setValue(nonVirtualBar.getMin());
            } else if (newValue > nonVirtualBar.getMax()) {
                nonVirtualBar.setValue(nonVirtualBar.getMax());
            } else {
                nonVirtualBar.setValue(newValue);
                if (this.isVertical()) {
                    this.lastX = e.getX();
                } else {
                    this.lastY = e.getY();
                }
            }
        }
    }

    /* synthetic */ void lambda$new$88(MouseEvent e) {
        this.mouseDown = false;
        if (BehaviorSkinBase.IS_TOUCH_SUPPORTED) {
            this.startSBReleasedAnimation();
        }
    }

    static /* synthetic */ Event lambda$new$87(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain tail) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            tail = tail.prepend(eventDispatcher);
            tail = tail.prepend(eventDispatcher2);
            return tail.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, tail);
    }

    static /* synthetic */ Event lambda$new$86(EventDispatcher eventDispatcher, EventDispatcher eventDispatcher2, Event event, EventDispatchChain tail) {
        if (event.getEventType() == ScrollEvent.SCROLL && !((ScrollEvent)event).isDirect()) {
            tail = tail.prepend(eventDispatcher);
            tail = tail.prepend(eventDispatcher2);
            return tail.dispatchEvent(event);
        }
        return eventDispatcher2.dispatchEvent(event, tail);
    }

    static /* synthetic */ Event lambda$new$85(Event event, EventDispatchChain tail) {
        return event;
    }

    public static class ArrayLinkedList<T>
    extends AbstractList<T> {
        private final ArrayList<T> array = new ArrayList(50);
        private int firstIndex = -1;
        private int lastIndex = -1;

        public ArrayLinkedList() {
            for (int i = 0; i < 50; ++i) {
                this.array.add(null);
            }
        }

        @Override
        public T getFirst() {
            return this.firstIndex == -1 ? null : (T)this.array.get(this.firstIndex);
        }

        @Override
        public T getLast() {
            return this.lastIndex == -1 ? null : (T)this.array.get(this.lastIndex);
        }

        @Override
        public void addFirst(T cell) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.firstIndex, cell);
            } else if (this.firstIndex == 0) {
                this.array.add(0, cell);
                ++this.lastIndex;
            } else {
                this.array.set(--this.firstIndex, cell);
            }
        }

        @Override
        public void addLast(T cell) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.lastIndex, cell);
            } else if (this.lastIndex == this.array.size() - 1) {
                this.array.add(++this.lastIndex, cell);
            } else {
                this.array.set(++this.lastIndex, cell);
            }
        }

        @Override
        public int size() {
            return this.firstIndex == -1 ? 0 : this.lastIndex - this.firstIndex + 1;
        }

        @Override
        public boolean isEmpty() {
            return this.firstIndex == -1;
        }

        @Override
        public T get(int index) {
            if (index > this.lastIndex - this.firstIndex || index < 0) {
                return null;
            }
            return this.array.get(this.firstIndex + index);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.array.size(); ++i) {
                this.array.set(i, null);
            }
            this.lastIndex = -1;
            this.firstIndex = -1;
        }

        @Override
        public T removeFirst() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(0);
        }

        @Override
        public T removeLast() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(this.lastIndex - this.firstIndex);
        }

        @Override
        public T remove(int index) {
            if (index > this.lastIndex - this.firstIndex || index < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (index == 0) {
                T cell = this.array.get(this.firstIndex);
                this.array.set(this.firstIndex, null);
                if (this.firstIndex == this.lastIndex) {
                    this.lastIndex = -1;
                    this.firstIndex = -1;
                } else {
                    ++this.firstIndex;
                }
                return cell;
            }
            if (index == this.lastIndex - this.firstIndex) {
                T cell = this.array.get(this.lastIndex);
                this.array.set(this.lastIndex--, null);
                return cell;
            }
            T cell = this.array.get(this.firstIndex + index);
            this.array.set(this.firstIndex + index, null);
            for (int i = this.firstIndex + index + 1; i <= this.lastIndex; ++i) {
                this.array.set(i - 1, this.array.get(i));
            }
            this.array.set(this.lastIndex--, null);
            return cell;
        }
    }

    static class ClippedContainer
    extends Region {
        private Node node;
        private final Rectangle clipRect;

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node n) {
            this.node = n;
            this.getChildren().clear();
            this.getChildren().add(this.node);
        }

        public void setClipX(double clipX) {
            this.setLayoutX(-clipX);
            this.clipRect.setLayoutX(clipX);
        }

        public void setClipY(double clipY) {
            this.setLayoutY(-clipY);
            this.clipRect.setLayoutY(clipY);
        }

        public ClippedContainer(VirtualFlow<?> flow) {
            if (flow == null) {
                throw new IllegalArgumentException("VirtualFlow can not be null");
            }
            this.getStyleClass().add("clipped-container");
            this.clipRect = new Rectangle();
            this.clipRect.setSmooth(false);
            this.setClip(this.clipRect);
            super.widthProperty().addListener(VirtualFlow$ClippedContainer$$Lambda$1.lambdaFactory$(this));
            super.heightProperty().addListener(VirtualFlow$ClippedContainer$$Lambda$2.lambdaFactory$(this));
        }

        /* synthetic */ void lambda$new$99(Observable valueModel) {
            this.clipRect.setHeight(this.getHeight());
        }

        /* synthetic */ void lambda$new$98(Observable valueModel) {
            this.clipRect.setWidth(this.getWidth());
        }
    }
}

