/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.prism.GrowableDataBuffer;
import com.sun.javafx.sg.prism.NGCanvas$$Lambda$1;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrTexture;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.geometry.VPos;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;

public class NGCanvas
extends NGNode {
    public static final byte ATTR_BASE = 0;
    public static final byte GLOBAL_ALPHA = 0;
    public static final byte COMP_MODE = 1;
    public static final byte FILL_PAINT = 2;
    public static final byte STROKE_PAINT = 3;
    public static final byte LINE_WIDTH = 4;
    public static final byte LINE_CAP = 5;
    public static final byte LINE_JOIN = 6;
    public static final byte MITER_LIMIT = 7;
    public static final byte FONT = 8;
    public static final byte TEXT_ALIGN = 9;
    public static final byte TEXT_BASELINE = 10;
    public static final byte TRANSFORM = 11;
    public static final byte EFFECT = 12;
    public static final byte PUSH_CLIP = 13;
    public static final byte POP_CLIP = 14;
    public static final byte ARC_TYPE = 15;
    public static final byte FILL_RULE = 16;
    public static final byte DASH_ARRAY = 17;
    public static final byte DASH_OFFSET = 18;
    public static final byte FONT_SMOOTH = 19;
    public static final byte OP_BASE = 20;
    public static final byte FILL_RECT = 20;
    public static final byte STROKE_RECT = 21;
    public static final byte CLEAR_RECT = 22;
    public static final byte STROKE_LINE = 23;
    public static final byte FILL_OVAL = 24;
    public static final byte STROKE_OVAL = 25;
    public static final byte FILL_ROUND_RECT = 26;
    public static final byte STROKE_ROUND_RECT = 27;
    public static final byte FILL_ARC = 28;
    public static final byte STROKE_ARC = 29;
    public static final byte FILL_TEXT = 30;
    public static final byte STROKE_TEXT = 31;
    public static final byte PATH_BASE = 40;
    public static final byte PATHSTART = 40;
    public static final byte MOVETO = 41;
    public static final byte LINETO = 42;
    public static final byte QUADTO = 43;
    public static final byte CUBICTO = 44;
    public static final byte CLOSEPATH = 45;
    public static final byte PATHEND = 46;
    public static final byte FILL_PATH = 47;
    public static final byte STROKE_PATH = 48;
    public static final byte IMG_BASE = 50;
    public static final byte DRAW_IMAGE = 50;
    public static final byte DRAW_SUBIMAGE = 51;
    public static final byte PUT_ARGB = 52;
    public static final byte PUT_ARGBPRE_BUF = 53;
    public static final byte FX_BASE = 60;
    public static final byte FX_APPLY_EFFECT = 60;
    public static final byte UTIL_BASE = 70;
    public static final byte RESET = 70;
    public static final byte SET_DIMS = 71;
    public static final byte CAP_BUTT = 0;
    public static final byte CAP_ROUND = 1;
    public static final byte CAP_SQUARE = 2;
    public static final byte JOIN_MITER = 0;
    public static final byte JOIN_ROUND = 1;
    public static final byte JOIN_BEVEL = 2;
    public static final byte ARC_OPEN = 0;
    public static final byte ARC_CHORD = 1;
    public static final byte ARC_PIE = 2;
    public static final byte SMOOTH_GRAY = (byte)FontSmoothingType.GRAY.ordinal();
    public static final byte SMOOTH_LCD = (byte)FontSmoothingType.LCD.ordinal();
    public static final byte ALIGN_LEFT = 0;
    public static final byte ALIGN_CENTER = 1;
    public static final byte ALIGN_RIGHT = 2;
    public static final byte ALIGN_JUSTIFY = 3;
    public static final byte BASE_TOP = 0;
    public static final byte BASE_MIDDLE = 1;
    public static final byte BASE_ALPHABETIC = 2;
    public static final byte BASE_BOTTOM = 3;
    public static final byte FILL_RULE_NON_ZERO = 0;
    public static final byte FILL_RULE_EVEN_ODD = 1;
    private static Blend BLENDER = new MyBlend(Blend.Mode.SRC_OVER, null, null);
    private GrowableDataBuffer thebuf;
    private int tw;
    private int th;
    private int cw;
    private int ch;
    private RenderBuf cv;
    private RenderBuf temp;
    private RenderBuf clip;
    private float globalAlpha;
    private Blend.Mode blendmode;
    private Paint fillPaint;
    private Paint strokePaint;
    private float linewidth;
    private int linecap;
    private int linejoin;
    private float miterlimit;
    private double[] dashes;
    private float dashOffset;
    private BasicStroke stroke;
    private Path2D path;
    private NGText ngtext;
    private PrismTextLayout textLayout;
    private PGFont pgfont;
    private int smoothing;
    private int align;
    private int baseline;
    private Affine2D transform;
    private Affine2D inverseTransform;
    private boolean inversedirty;
    private LinkedList<Path2D> clipStack;
    private int clipsRendered;
    private boolean clipIsRect;
    private Rectangle clipRect;
    private Effect effect;
    private int arctype;
    static float[] TEMP_COORDS = new float[6];
    private static Arc2D TEMP_ARC = new Arc2D();
    private static RectBounds TEMP_RECTBOUNDS = new RectBounds();
    static final Affine2D TEMP_PATH_TX = new Affine2D();
    static final int[] numCoords = new int[]{2, 2, 4, 6, 0};
    Shape untransformedPath = new Shape(){

        @Override
        public RectBounds getBounds() {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                RectBounds rb = NGCanvas.this.path.getBounds();
                if (NGCanvas.this.transform.isIdentity()) {
                    return rb;
                }
                float tx = (float)NGCanvas.this.transform.getMxt();
                float ty = (float)NGCanvas.this.transform.getMyt();
                return new RectBounds(rb.getMinX() - tx, rb.getMinY() - ty, rb.getMaxX() - tx, rb.getMaxY() - ty);
            }
            float x0 = Float.POSITIVE_INFINITY;
            float y0 = Float.POSITIVE_INFINITY;
            float x1 = Float.NEGATIVE_INFINITY;
            float y1 = Float.NEGATIVE_INFINITY;
            PathIterator pi = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            while (!pi.isDone()) {
                int ncoords = numCoords[pi.currentSegment(TEMP_COORDS)];
                for (int i = 0; i < ncoords; i += 2) {
                    if (x0 > TEMP_COORDS[i + 0]) {
                        x0 = TEMP_COORDS[i + 0];
                    }
                    if (x1 < TEMP_COORDS[i + 0]) {
                        x1 = TEMP_COORDS[i + 0];
                    }
                    if (y0 > TEMP_COORDS[i + 1]) {
                        y0 = TEMP_COORDS[i + 1];
                    }
                    if (!(y1 < TEMP_COORDS[i + 1])) continue;
                    y1 = TEMP_COORDS[i + 1];
                }
                pi.next();
            }
            return new RectBounds(x0, y0, x1, y1);
        }

        @Override
        public boolean contains(float x, float y) {
            NGCanvas.TEMP_COORDS[0] = x;
            NGCanvas.TEMP_COORDS[1] = y;
            NGCanvas.this.transform.transform(TEMP_COORDS, 0, TEMP_COORDS, 0, 1);
            x = TEMP_COORDS[0];
            y = TEMP_COORDS[1];
            return NGCanvas.this.path.contains(x, y);
        }

        @Override
        public boolean intersects(float x, float y, float w, float h) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                x = (float)((double)x + NGCanvas.this.transform.getMxt());
                y = (float)((double)y + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.intersects(x, y, w, h);
            }
            PathIterator pi = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int crossings = Shape.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings != 0;
        }

        @Override
        public boolean contains(float x, float y, float w, float h) {
            if (NGCanvas.this.transform.isTranslateOrIdentity()) {
                x = (float)((double)x + NGCanvas.this.transform.getMxt());
                y = (float)((double)y + NGCanvas.this.transform.getMyt());
                return NGCanvas.this.path.contains(x, y, w, h);
            }
            PathIterator pi = NGCanvas.this.path.getPathIterator(NGCanvas.this.getInverseTransform());
            int crossings = Shape.rectCrossingsForPath(pi, x, y, x + w, y + h);
            return crossings != Integer.MIN_VALUE && crossings != 0;
        }

        public BaseTransform getCombinedTransform(BaseTransform tx) {
            if (NGCanvas.this.transform.isIdentity()) {
                return tx;
            }
            if (NGCanvas.this.transform.equals(tx)) {
                return null;
            }
            Affine2D inv = NGCanvas.this.getInverseTransform();
            if (tx == null || tx.isIdentity()) {
                return inv;
            }
            TEMP_PATH_TX.setTransform(tx);
            TEMP_PATH_TX.concatenate(inv);
            return TEMP_PATH_TX;
        }

        @Override
        public PathIterator getPathIterator(BaseTransform tx) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(tx));
        }

        @Override
        public PathIterator getPathIterator(BaseTransform tx, float flatness) {
            return NGCanvas.this.path.getPathIterator(this.getCombinedTransform(tx), flatness);
        }

        @Override
        public Shape copy() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private static final float CLIPRECT_TOLERANCE = 0.00390625f;
    private static final Rectangle TEMP_RECT = new Rectangle();
    private static final int[] prcaps = new int[]{0, 1, 2};
    private static final int[] prjoins = new int[]{0, 1, 2};
    private static final int[] prbases = new int[]{VPos.TOP.ordinal(), VPos.CENTER.ordinal(), VPos.BASELINE.ordinal(), VPos.BOTTOM.ordinal()};
    private static final Affine2D TEMP_TX = new Affine2D();

    public NGCanvas() {
        this.cv = new RenderBuf(InitType.PRESERVE_UPPER_LEFT);
        this.temp = new RenderBuf(InitType.CLEAR);
        this.clip = new RenderBuf(InitType.FILL_WHITE);
        this.path = new Path2D();
        this.ngtext = new NGText();
        this.textLayout = new PrismTextLayout();
        this.transform = new Affine2D();
        this.clipStack = new LinkedList();
        this.initAttributes();
    }

    private void initAttributes() {
        this.globalAlpha = 1.0f;
        this.blendmode = Blend.Mode.SRC_OVER;
        this.fillPaint = Color.BLACK;
        this.strokePaint = Color.BLACK;
        this.linewidth = 1.0f;
        this.linecap = 2;
        this.linejoin = 0;
        this.miterlimit = 10.0f;
        this.dashes = null;
        this.dashOffset = 0.0f;
        this.stroke = null;
        this.path.setWindingRule(1);
        this.pgfont = (PGFont)Font.getDefault().impl_getNativeFont();
        this.smoothing = SMOOTH_GRAY;
        this.align = 0;
        this.baseline = VPos.BASELINE.ordinal();
        this.transform.setToScale(highestPixelScale, highestPixelScale);
        this.clipStack.clear();
        this.resetClip(false);
    }

    private Affine2D getInverseTransform() {
        if (this.inverseTransform == null) {
            this.inverseTransform = new Affine2D();
            this.inversedirty = true;
        }
        if (this.inversedirty) {
            this.inverseTransform.setTransform(this.transform);
            try {
                this.inverseTransform.invert();
            }
            catch (NoninvertibleTransformException e) {
                this.inverseTransform.setToScale(0.0, 0.0);
            }
            this.inversedirty = false;
        }
        return this.inverseTransform;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return true;
    }

    private static void shapebounds(Shape shape, RectBounds bounds, BaseTransform transform) {
        NGCanvas.TEMP_COORDS[1] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
        NGCanvas.TEMP_COORDS[2] = Float.NEGATIVE_INFINITY;
        Shape.accumulate(TEMP_COORDS, shape, transform);
        bounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
    }

    private static void strokebounds(BasicStroke stroke, Shape shape, RectBounds bounds, BaseTransform transform) {
        NGCanvas.TEMP_COORDS[1] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[0] = Float.POSITIVE_INFINITY;
        NGCanvas.TEMP_COORDS[3] = Float.NEGATIVE_INFINITY;
        NGCanvas.TEMP_COORDS[2] = Float.NEGATIVE_INFINITY;
        stroke.accumulateShapeBounds(TEMP_COORDS, shape, transform);
        bounds.setBounds(TEMP_COORDS[0], TEMP_COORDS[1], TEMP_COORDS[2], TEMP_COORDS[3]);
    }

    private static void runOnRenderThread(Runnable r) {
        if (Thread.currentThread().getName().startsWith("QuantumRenderer")) {
            r.run();
        } else {
            FutureTask<Object> f = new FutureTask<Object>(r, null);
            Toolkit.getToolkit().addRenderJob(new RenderJob(f));
            try {
                f.get();
            }
            catch (ExecutionException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean printedCanvas(Graphics g) {
        RTTexture localTex = this.cv.tex;
        if (!(g instanceof PrinterGraphics) || localTex == null) {
            return false;
        }
        ResourceFactory factory = g.getResourceFactory();
        boolean isCompatTex = factory.isCompatibleTexture(localTex);
        if (isCompatTex) {
            return false;
        }
        int tw = localTex.getContentWidth();
        int th = localTex.getContentHeight();
        RTTexture tmpTex = factory.createRTTexture(tw, th, Texture.WrapMode.CLAMP_TO_ZERO);
        Graphics texg = tmpTex.createGraphics();
        texg.setCompositeMode(CompositeMode.SRC);
        if (this.cv.savedPixelData == null) {
            PixelData pd = new PixelData(this.cw, this.ch);
            NGCanvas.runOnRenderThread(NGCanvas$$Lambda$1.lambdaFactory$(pd, localTex, texg, tw, th));
        } else {
            this.cv.savedPixelData.restore(texg, tw, th);
        }
        g.drawTexture(tmpTex, 0.0f, 0.0f, tw, th);
        tmpTex.unlock();
        tmpTex.dispose();
        return true;
    }

    @Override
    protected void renderContent(Graphics g) {
        if (this.printedCanvas(g)) {
            return;
        }
        this.initCanvas(g);
        if (this.cv.tex != null) {
            if (this.thebuf != null) {
                this.renderStream(this.thebuf);
                GrowableDataBuffer.returnBuffer(this.thebuf);
                this.thebuf = null;
            }
            float dw = (float)this.tw / highestPixelScale;
            float dh = (float)this.th / highestPixelScale;
            g.drawTexture(this.cv.tex, 0.0f, 0.0f, dw, dh, 0.0f, 0.0f, this.tw, this.th);
            this.cv.save(this.tw, this.th);
        }
        this.cv.g = null;
        this.clip.g = null;
        this.temp.g = null;
    }

    @Override
    public void renderForcedContent(Graphics gOptional) {
        if (this.thebuf != null) {
            this.initCanvas(gOptional);
            if (this.cv.tex != null) {
                this.renderStream(this.thebuf);
                GrowableDataBuffer.returnBuffer(this.thebuf);
                this.thebuf = null;
                this.cv.save(this.tw, this.th);
            }
            this.cv.g = null;
            this.clip.g = null;
            this.temp.g = null;
        }
    }

    private void initCanvas(Graphics g) {
        if (this.tw <= 0 || this.th <= 0) {
            this.cv.dispose();
            return;
        }
        if (this.cv.validate(g, this.tw, this.th)) {
            this.cv.tex.contentsUseful();
            this.cv.tex.makePermanent();
            this.cv.tex.lock();
        }
    }

    private void clearCanvas(int x, int y, int w, int h) {
        this.cv.g.setCompositeMode(CompositeMode.CLEAR);
        this.cv.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.cv.g.fillQuad(x, y, x + w, y + h);
        this.cv.g.setCompositeMode(CompositeMode.SRC_OVER);
    }

    private void resetClip(boolean andDispose) {
        if (andDispose) {
            this.clip.dispose();
        }
        this.clipsRendered = 0;
        this.clipIsRect = true;
        this.clipRect = null;
    }

    private boolean initClip() {
        boolean clipValidated;
        if (this.clipIsRect) {
            clipValidated = false;
        } else {
            clipValidated = true;
            if (this.clip.validate(this.cv.g, this.tw, this.th)) {
                this.clip.tex.contentsUseful();
                this.resetClip(false);
            }
        }
        int clipSize = this.clipStack.size();
        while (this.clipsRendered < clipSize) {
            Path2D clippath = this.clipStack.get(this.clipsRendered++);
            if (this.clipIsRect) {
                if (clippath.checkAndGetIntRect(TEMP_RECT, 0.00390625f)) {
                    if (this.clipRect == null) {
                        this.clipRect = new Rectangle(TEMP_RECT);
                        continue;
                    }
                    this.clipRect.intersectWith(TEMP_RECT);
                    continue;
                }
                this.clipIsRect = false;
                if (!clipValidated) {
                    clipValidated = true;
                    if (this.clip.validate(this.cv.g, this.tw, this.th)) {
                        this.clip.tex.contentsUseful();
                    }
                }
                if (this.clipRect != null) {
                    this.renderClip(new RoundRectangle2D(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height, 0.0f, 0.0f));
                }
            }
            NGCanvas.shapebounds(clippath, TEMP_RECTBOUNDS, BaseTransform.IDENTITY_TRANSFORM);
            TEMP_RECT.setBounds(TEMP_RECTBOUNDS);
            if (this.clipRect == null) {
                this.clipRect = new Rectangle(TEMP_RECT);
            } else {
                this.clipRect.intersectWith(TEMP_RECT);
            }
            this.renderClip(clippath);
        }
        if (clipValidated && this.clipIsRect) {
            this.clip.tex.unlock();
        }
        return !this.clipIsRect;
    }

    private void renderClip(Shape clippath) {
        this.temp.validate(this.cv.g, this.tw, this.th);
        this.temp.g.setPaint(Color.WHITE);
        this.temp.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        this.temp.g.fill(clippath);
        this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.clip);
        this.temp.tex.unlock();
    }

    private Rectangle applyEffectOnAintoC(Effect definput, Effect effect, BaseTransform transform, Rectangle outputClip, CompositeMode comp, RenderBuf destbuf) {
        PrFilterContext fctx = PrFilterContext.getInstance(destbuf.tex.getAssociatedScreen());
        ImageData id = effect.filter(fctx, transform, outputClip, null, definput);
        Rectangle r = id.getUntransformedBounds();
        Filterable f = id.getUntransformedImage();
        Object tex = ((PrTexture)((Object)f)).getTextureObject();
        destbuf.g.setTransform(id.getTransform());
        destbuf.g.setCompositeMode(comp);
        destbuf.g.drawTexture((Texture)tex, r.x, r.y, r.width, r.height);
        destbuf.g.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        destbuf.g.setCompositeMode(CompositeMode.SRC_OVER);
        Rectangle resultBounds = id.getTransformedBounds(outputClip);
        id.unref();
        return resultBounds;
    }

    private void blendAthruBintoC(RenderBuf drawbuf, Blend.Mode mode, RenderBuf clipbuf, RectBounds bounds, CompositeMode comp, RenderBuf destbuf) {
        BLENDER.setTopInput(drawbuf.input);
        BLENDER.setBottomInput(clipbuf.input);
        BLENDER.setMode(mode);
        Rectangle blendclip = bounds != null ? new Rectangle(bounds) : null;
        this.applyEffectOnAintoC(null, BLENDER, BaseTransform.IDENTITY_TRANSFORM, blendclip, comp, destbuf);
    }

    private void setupFill(Graphics gr) {
        gr.setPaint(this.fillPaint);
    }

    private BasicStroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.linewidth, this.linecap, this.linejoin, this.miterlimit, this.dashes, this.dashOffset);
        }
        return this.stroke;
    }

    private void setupStroke(Graphics gr) {
        gr.setStroke(this.getStroke());
        gr.setPaint(this.strokePaint);
    }

    private void renderStream(GrowableDataBuffer buf) {
        block40: while (buf.hasValues()) {
            byte token = buf.getByte();
            switch (token) {
                case 70: {
                    this.initAttributes();
                    this.cw = this.tw;
                    this.ch = this.th;
                    this.clearCanvas(0, 0, this.tw, this.th);
                    continue block40;
                }
                case 71: {
                    int neww = (int)Math.ceil(buf.getFloat() * highestPixelScale);
                    int newh = (int)Math.ceil(buf.getFloat() * highestPixelScale);
                    int clearx = Math.min(neww, this.cw);
                    int cleary = Math.min(newh, this.ch);
                    if (clearx < this.tw) {
                        this.clearCanvas(clearx, 0, this.tw - clearx, this.th);
                    }
                    if (cleary < this.th) {
                        this.clearCanvas(0, cleary, this.tw, this.th - cleary);
                    }
                    this.cw = neww;
                    this.ch = newh;
                    continue block40;
                }
                case 40: {
                    this.path.reset();
                    continue block40;
                }
                case 41: {
                    this.path.moveTo(buf.getFloat(), buf.getFloat());
                    continue block40;
                }
                case 42: {
                    this.path.lineTo(buf.getFloat(), buf.getFloat());
                    continue block40;
                }
                case 43: {
                    this.path.quadTo(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
                    continue block40;
                }
                case 44: {
                    this.path.curveTo(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
                    continue block40;
                }
                case 45: {
                    this.path.closePath();
                    continue block40;
                }
                case 46: {
                    if (highestPixelScale == 1.0f) continue block40;
                    TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                    this.path.transform(TEMP_TX);
                    continue block40;
                }
                case 13: {
                    Path2D clippath = (Path2D)buf.getObject();
                    if (highestPixelScale != 1.0f) {
                        TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                        clippath.transform(TEMP_TX);
                    }
                    this.clipStack.addLast(clippath);
                    continue block40;
                }
                case 14: {
                    this.resetClip(true);
                    this.clipStack.removeLast();
                    continue block40;
                }
                case 15: {
                    byte type = buf.getByte();
                    switch (type) {
                        case 0: {
                            this.arctype = 0;
                            break;
                        }
                        case 1: {
                            this.arctype = 1;
                            break;
                        }
                        case 2: {
                            this.arctype = 2;
                        }
                    }
                    continue block40;
                }
                case 52: {
                    float dx1 = buf.getInt();
                    float dy1 = buf.getInt();
                    int argb = buf.getInt();
                    Graphics gr = this.cv.g;
                    gr.setExtraAlpha(1.0f);
                    gr.setCompositeMode(CompositeMode.SRC);
                    gr.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    dx1 *= highestPixelScale;
                    dy1 *= highestPixelScale;
                    float a = (float)(argb >>> 24) / 255.0f;
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    gr.setPaint(new Color(r, g, b, a));
                    gr.fillQuad(dx1, dy1, dx1 + highestPixelScale, dy1 + highestPixelScale);
                    gr.setCompositeMode(CompositeMode.SRC_OVER);
                    continue block40;
                }
                case 53: {
                    float dx1 = buf.getInt();
                    float dy1 = buf.getInt();
                    int w = buf.getInt();
                    int h = buf.getInt();
                    byte[] data = (byte[])buf.getObject();
                    Image img = Image.fromByteBgraPreData(data, w, h);
                    Graphics gr = this.cv.g;
                    ResourceFactory factory = gr.getResourceFactory();
                    Texture tex = factory.getCachedTexture(img, Texture.WrapMode.CLAMP_TO_EDGE);
                    gr.setTransform(BaseTransform.IDENTITY_TRANSFORM);
                    gr.setCompositeMode(CompositeMode.SRC);
                    float dx2 = dx1 + (float)w;
                    float dy2 = dy1 + (float)h;
                    gr.drawTexture(tex, dx1 *= highestPixelScale, dy1 *= highestPixelScale, dx2 *= highestPixelScale, dy2 *= highestPixelScale, 0.0f, 0.0f, w, h);
                    tex.contentsNotUseful();
                    tex.unlock();
                    gr.setCompositeMode(CompositeMode.SRC_OVER);
                    continue block40;
                }
                case 11: {
                    double mxx = buf.getDouble() * (double)highestPixelScale;
                    double mxy = buf.getDouble() * (double)highestPixelScale;
                    double mxt = buf.getDouble() * (double)highestPixelScale;
                    double myx = buf.getDouble() * (double)highestPixelScale;
                    double myy = buf.getDouble() * (double)highestPixelScale;
                    double myt = buf.getDouble() * (double)highestPixelScale;
                    this.transform.setTransform(mxx, myx, mxy, myy, mxt, myt);
                    this.inversedirty = true;
                    continue block40;
                }
                case 0: {
                    this.globalAlpha = buf.getFloat();
                    continue block40;
                }
                case 16: {
                    if (buf.getByte() == 0) {
                        this.path.setWindingRule(1);
                        continue block40;
                    }
                    this.path.setWindingRule(0);
                    continue block40;
                }
                case 1: {
                    this.blendmode = (Blend.Mode)((Object)buf.getObject());
                    continue block40;
                }
                case 2: {
                    this.fillPaint = (Paint)buf.getObject();
                    continue block40;
                }
                case 3: {
                    this.strokePaint = (Paint)buf.getObject();
                    continue block40;
                }
                case 4: {
                    this.linewidth = buf.getFloat();
                    this.stroke = null;
                    continue block40;
                }
                case 5: {
                    this.linecap = prcaps[buf.getUByte()];
                    this.stroke = null;
                    continue block40;
                }
                case 6: {
                    this.linejoin = prjoins[buf.getUByte()];
                    this.stroke = null;
                    continue block40;
                }
                case 7: {
                    this.miterlimit = buf.getFloat();
                    this.stroke = null;
                    continue block40;
                }
                case 17: {
                    this.dashes = (double[])buf.getObject();
                    this.stroke = null;
                    continue block40;
                }
                case 18: {
                    this.dashOffset = buf.getFloat();
                    this.stroke = null;
                    continue block40;
                }
                case 8: {
                    this.pgfont = (PGFont)buf.getObject();
                    continue block40;
                }
                case 19: {
                    this.smoothing = buf.getUByte();
                    continue block40;
                }
                case 9: {
                    this.align = buf.getUByte();
                    continue block40;
                }
                case 10: {
                    this.baseline = prbases[buf.getUByte()];
                    continue block40;
                }
                case 60: {
                    BaseTransform tx;
                    RenderBuf dest;
                    Effect e = (Effect)buf.getObject();
                    RenderBuf renderBuf = dest = this.clipStack.isEmpty() ? this.cv : this.temp;
                    if (highestPixelScale != 1.0f) {
                        TEMP_TX.setToScale(highestPixelScale, highestPixelScale);
                        tx = TEMP_TX;
                        this.cv.input.setPixelScale(highestPixelScale);
                    } else {
                        tx = BaseTransform.IDENTITY_TRANSFORM;
                    }
                    this.applyEffectOnAintoC(this.cv.input, e, tx, null, CompositeMode.SRC, dest);
                    this.cv.input.setPixelScale(1.0f);
                    if (dest == this.cv) continue block40;
                    this.blendAthruBintoC(dest, Blend.Mode.SRC_IN, this.clip, null, CompositeMode.SRC, this.cv);
                    continue block40;
                }
                case 12: {
                    this.effect = (Effect)buf.getObject();
                    continue block40;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 47: 
                case 48: 
                case 50: 
                case 51: {
                    RenderBuf dest;
                    boolean tempvalidated;
                    boolean clipvalidated = this.initClip();
                    if (clipvalidated) {
                        this.temp.validate(this.cv.g, this.tw, this.th);
                        tempvalidated = true;
                        dest = this.temp;
                    } else if (this.blendmode != Blend.Mode.SRC_OVER) {
                        this.temp.validate(this.cv.g, this.tw, this.th);
                        tempvalidated = true;
                        dest = this.temp;
                    } else {
                        tempvalidated = false;
                        dest = this.cv;
                    }
                    if (this.effect != null) {
                        buf.save();
                        this.handleRenderOp(token, buf, null, TEMP_RECTBOUNDS);
                        RenderInput ri = new RenderInput(token, buf, this.transform, TEMP_RECTBOUNDS);
                        Rectangle resultBounds = this.applyEffectOnAintoC(ri, this.effect, this.transform, this.clipRect, CompositeMode.SRC_OVER, dest);
                        if (dest != this.cv) {
                            TEMP_RECTBOUNDS.setBounds(resultBounds.x, resultBounds.y, resultBounds.x + resultBounds.width, resultBounds.y + resultBounds.height);
                        }
                    } else {
                        Graphics g = dest.g;
                        g.setExtraAlpha(this.globalAlpha);
                        g.setTransform(this.transform);
                        g.setClipRect(this.clipRect);
                        RectBounds optSaveBounds = dest != this.cv ? TEMP_RECTBOUNDS : null;
                        this.handleRenderOp(token, buf, g, optSaveBounds);
                        g.setClipRect(null);
                    }
                    if (clipvalidated) {
                        CompositeMode compmode;
                        if (this.blendmode == Blend.Mode.SRC_OVER) {
                            dest = this.cv;
                            compmode = CompositeMode.SRC_OVER;
                        } else {
                            compmode = CompositeMode.SRC;
                        }
                        if (this.clipRect != null) {
                            TEMP_RECTBOUNDS.intersectWith(this.clipRect);
                        }
                        if (!TEMP_RECTBOUNDS.isEmpty()) {
                            if (dest == this.cv && this.cv.g instanceof MaskTextureGraphics) {
                                MaskTextureGraphics mtg = (MaskTextureGraphics)this.cv.g;
                                int dx = (int)Math.floor(TEMP_RECTBOUNDS.getMinX());
                                int dy = (int)Math.floor(TEMP_RECTBOUNDS.getMinY());
                                int dw = (int)Math.ceil(TEMP_RECTBOUNDS.getMaxX()) - dx;
                                int dh = (int)Math.ceil(TEMP_RECTBOUNDS.getMaxY()) - dy;
                                mtg.drawPixelsMasked(this.temp.tex, this.clip.tex, dx, dy, dw, dh, dx, dy, dx, dy);
                            } else {
                                this.blendAthruBintoC(this.temp, Blend.Mode.SRC_IN, this.clip, TEMP_RECTBOUNDS, compmode, dest);
                            }
                        }
                    }
                    if (this.blendmode != Blend.Mode.SRC_OVER) {
                        if (this.clipRect != null) {
                            TEMP_RECTBOUNDS.intersectWith(this.clipRect);
                        }
                        this.blendAthruBintoC(this.temp, this.blendmode, this.cv, TEMP_RECTBOUNDS, CompositeMode.SRC, this.cv);
                    }
                    if (clipvalidated) {
                        this.clip.tex.unlock();
                    }
                    if (!tempvalidated) continue block40;
                    this.temp.tex.unlock();
                    continue block40;
                }
            }
            throw new InternalError("Unrecognized PGCanvas token: " + token);
        }
    }

    public void handleRenderOp(int token, GrowableDataBuffer buf, Graphics gr, RectBounds bounds) {
        boolean strokeBounds = false;
        boolean transformBounds = false;
        switch (token) {
            case 47: {
                if (bounds != null) {
                    NGCanvas.shapebounds(this.path, bounds, BaseTransform.IDENTITY_TRANSFORM);
                }
                if (gr == null) break;
                this.setupFill(gr);
                gr.fill(this.untransformedPath);
                break;
            }
            case 48: {
                if (bounds != null) {
                    NGCanvas.strokebounds(this.getStroke(), this.untransformedPath, bounds, this.transform);
                }
                if (gr == null) break;
                this.setupStroke(gr);
                gr.draw(this.untransformedPath);
                break;
            }
            case 23: {
                float x1 = buf.getFloat();
                float y1 = buf.getFloat();
                float x2 = buf.getFloat();
                float y2 = buf.getFloat();
                if (bounds != null) {
                    bounds.setBoundsAndSort(x1, y1, x2, y2);
                    strokeBounds = true;
                    transformBounds = true;
                }
                if (gr == null) break;
                this.setupStroke(gr);
                gr.drawLine(x1, y1, x2, y2);
                break;
            }
            case 21: 
            case 25: {
                strokeBounds = true;
            }
            case 20: 
            case 22: 
            case 24: {
                float x = buf.getFloat();
                float y = buf.getFloat();
                float w = buf.getFloat();
                float h = buf.getFloat();
                if (bounds != null) {
                    bounds.setBounds(x, y, x + w, y + h);
                    transformBounds = true;
                }
                if (gr == null) break;
                switch (token) {
                    case 20: {
                        this.setupFill(gr);
                        gr.fillRect(x, y, w, h);
                        break;
                    }
                    case 24: {
                        this.setupFill(gr);
                        gr.fillEllipse(x, y, w, h);
                        break;
                    }
                    case 21: {
                        this.setupStroke(gr);
                        gr.drawRect(x, y, w, h);
                        break;
                    }
                    case 25: {
                        this.setupStroke(gr);
                        gr.drawEllipse(x, y, w, h);
                        break;
                    }
                    case 22: {
                        gr.setCompositeMode(CompositeMode.CLEAR);
                        gr.fillRect(x, y, w, h);
                        gr.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                }
                break;
            }
            case 27: {
                strokeBounds = true;
            }
            case 26: {
                float x = buf.getFloat();
                float y = buf.getFloat();
                float w = buf.getFloat();
                float h = buf.getFloat();
                float aw = buf.getFloat();
                float ah = buf.getFloat();
                if (bounds != null) {
                    bounds.setBounds(x, y, x + w, y + h);
                    transformBounds = true;
                }
                if (gr == null) break;
                if (token == 26) {
                    this.setupFill(gr);
                    gr.fillRoundRect(x, y, w, h, aw, ah);
                    break;
                }
                this.setupStroke(gr);
                gr.drawRoundRect(x, y, w, h, aw, ah);
                break;
            }
            case 28: 
            case 29: {
                float x = buf.getFloat();
                float y = buf.getFloat();
                float w = buf.getFloat();
                float h = buf.getFloat();
                float as = buf.getFloat();
                float ae = buf.getFloat();
                TEMP_ARC.setArc(x, y, w, h, as, ae, this.arctype);
                if (token == 28) {
                    if (bounds != null) {
                        NGCanvas.shapebounds(TEMP_ARC, bounds, this.transform);
                    }
                    if (gr == null) break;
                    this.setupFill(gr);
                    gr.fill(TEMP_ARC);
                    break;
                }
                if (bounds != null) {
                    NGCanvas.strokebounds(this.getStroke(), TEMP_ARC, bounds, this.transform);
                }
                if (gr == null) break;
                this.setupStroke(gr);
                gr.draw(TEMP_ARC);
                break;
            }
            case 50: 
            case 51: {
                float sh;
                float sw;
                float sx;
                float sy;
                float dx = buf.getFloat();
                float dy = buf.getFloat();
                float dw = buf.getFloat();
                float dh = buf.getFloat();
                Image img = (Image)buf.getObject();
                if (token == 50) {
                    sy = 0.0f;
                    sx = 0.0f;
                    sw = img.getWidth();
                    sh = img.getHeight();
                } else {
                    sx = buf.getFloat();
                    sy = buf.getFloat();
                    sw = buf.getFloat();
                    sh = buf.getFloat();
                    float ps = img.getPixelScale();
                    if (ps != 1.0f) {
                        sx *= ps;
                        sy *= ps;
                        sw *= ps;
                        sh *= ps;
                    }
                }
                if (bounds != null) {
                    bounds.setBounds(dx, dy, dx + dw, dy + dh);
                    transformBounds = true;
                }
                if (gr == null) break;
                ResourceFactory factory = gr.getResourceFactory();
                Texture tex = factory.getCachedTexture(img, Texture.WrapMode.CLAMP_TO_EDGE);
                gr.drawTexture(tex, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh);
                tex.unlock();
                break;
            }
            case 30: 
            case 31: {
                float x = buf.getFloat();
                float y = buf.getFloat();
                float maxWidth = buf.getFloat();
                boolean rtl = buf.getBoolean();
                String string = (String)buf.getObject();
                int dir = rtl ? 2048 : 1024;
                this.textLayout.setContent(string, this.pgfont);
                this.textLayout.setAlignment(this.align);
                this.textLayout.setDirection(dir);
                float xAlign = 0.0f;
                float yAlign = 0.0f;
                BaseBounds layoutBounds = this.textLayout.getBounds();
                float layoutWidth = layoutBounds.getWidth();
                float layoutHeight = layoutBounds.getHeight();
                switch (this.align) {
                    case 2: {
                        xAlign = layoutWidth;
                        break;
                    }
                    case 1: {
                        xAlign = layoutWidth / 2.0f;
                    }
                }
                switch (this.baseline) {
                    case 2: {
                        yAlign = -layoutBounds.getMinY();
                        break;
                    }
                    case 1: {
                        yAlign = layoutHeight / 2.0f;
                        break;
                    }
                    case 3: {
                        yAlign = layoutHeight;
                    }
                }
                float scaleX = 1.0f;
                float layoutX = 0.0f;
                float layoutY = y - yAlign;
                if ((double)maxWidth > 0.0 && layoutWidth > maxWidth) {
                    float sx = maxWidth / layoutWidth;
                    if (rtl) {
                        layoutX = -((x + maxWidth) / sx - xAlign);
                        scaleX = -sx;
                    } else {
                        layoutX = x / sx - xAlign;
                        scaleX = sx;
                    }
                } else if (rtl) {
                    layoutX = -(x - xAlign + layoutWidth);
                    scaleX = -1.0f;
                } else {
                    layoutX = x - xAlign;
                }
                if (bounds != null) {
                    this.computeTextLayoutBounds(bounds, this.transform, scaleX, layoutX, layoutY, token);
                }
                if (gr == null) break;
                if (scaleX != 1.0f) {
                    gr.scale(scaleX, 1.0f);
                }
                this.ngtext.setLayoutLocation(-layoutX, -layoutY);
                if (token == 30) {
                    this.ngtext.setMode(NGShape.Mode.FILL);
                    this.ngtext.setFillPaint(this.fillPaint);
                    if (this.fillPaint.isProportional() || this.smoothing == SMOOTH_LCD) {
                        RectBounds textBounds = new RectBounds();
                        this.computeTextLayoutBounds(textBounds, BaseTransform.IDENTITY_TRANSFORM, 1.0f, layoutX, layoutY, token);
                        this.ngtext.setContentBounds(textBounds);
                    }
                } else {
                    if (this.strokePaint.isProportional()) {
                        RectBounds textBounds = new RectBounds();
                        this.computeTextLayoutBounds(textBounds, BaseTransform.IDENTITY_TRANSFORM, 1.0f, layoutX, layoutY, token);
                        this.ngtext.setContentBounds(textBounds);
                    }
                    this.ngtext.setMode(NGShape.Mode.STROKE);
                    this.ngtext.setDrawStroke(this.getStroke());
                    this.ngtext.setDrawPaint(this.strokePaint);
                }
                this.ngtext.setFont(this.pgfont);
                this.ngtext.setFontSmoothingType(this.smoothing);
                this.ngtext.setGlyphs(this.textLayout.getRuns());
                this.ngtext.renderContent(gr);
                break;
            }
            default: {
                throw new InternalError("Unrecognized PGCanvas rendering token: " + token);
            }
        }
        if (bounds != null) {
            BasicStroke s;
            if (strokeBounds && (s = this.getStroke()).getType() != 1) {
                float lw = s.getLineWidth();
                if (s.getType() == 0) {
                    lw /= 2.0f;
                }
                bounds.grow(lw, lw);
            }
            if (transformBounds) {
                NGCanvas.txBounds(bounds, this.transform);
            }
        }
    }

    void computeTextLayoutBounds(RectBounds bounds, BaseTransform transform, float scaleX, float layoutX, float layoutY, int token) {
        this.textLayout.getBounds(null, bounds);
        TEMP_TX.setTransform(transform);
        TEMP_TX.scale(scaleX, 1.0);
        TEMP_TX.translate(layoutX, layoutY);
        TEMP_TX.transform(bounds, bounds);
        if (token == 31) {
            int flag = 1;
            Shape textShape = this.textLayout.getShape(flag, null);
            RectBounds shapeBounds = new RectBounds();
            NGCanvas.strokebounds(this.getStroke(), textShape, shapeBounds, TEMP_TX);
            bounds.unionWith(shapeBounds);
        }
    }

    static void txBounds(RectBounds bounds, BaseTransform transform) {
        switch (transform.getType()) {
            case 0: {
                break;
            }
            case 1: {
                float tx = (float)transform.getMxt();
                float ty = (float)transform.getMyt();
                bounds.setBounds(bounds.getMinX() + tx, bounds.getMinY() + ty, bounds.getMaxX() + tx, bounds.getMaxY() + ty);
                break;
            }
            default: {
                BaseBounds txbounds = transform.transform(bounds, bounds);
                if (txbounds == bounds) break;
                bounds.setBounds(txbounds.getMinX(), txbounds.getMinY(), txbounds.getMaxX(), txbounds.getMaxY());
            }
        }
    }

    static void inverseTxBounds(RectBounds bounds, BaseTransform transform) {
        switch (transform.getType()) {
            case 0: {
                break;
            }
            case 1: {
                float tx = (float)transform.getMxt();
                float ty = (float)transform.getMyt();
                bounds.setBounds(bounds.getMinX() - tx, bounds.getMinY() - ty, bounds.getMaxX() - tx, bounds.getMaxY() - ty);
                break;
            }
            default: {
                try {
                    BaseBounds txbounds = transform.inverseTransform(bounds, bounds);
                    if (txbounds == bounds) break;
                    bounds.setBounds(txbounds.getMinX(), txbounds.getMinY(), txbounds.getMaxX(), txbounds.getMaxY());
                    break;
                }
                catch (NoninvertibleTransformException e) {
                    bounds.makeEmpty();
                }
            }
        }
    }

    public void updateBounds(float w, float h) {
        this.tw = (int)Math.ceil(w * highestPixelScale);
        this.th = (int)Math.ceil(h * highestPixelScale);
        this.geometryChanged();
    }

    public boolean updateRendering(GrowableDataBuffer buf) {
        GrowableDataBuffer retbuf;
        boolean reset;
        if (buf.isEmpty()) {
            GrowableDataBuffer.returnBuffer(buf);
            return this.thebuf != null;
        }
        boolean bl = reset = buf.peekByte(0) == 70;
        if (reset || this.thebuf == null) {
            retbuf = this.thebuf;
            this.thebuf = buf;
        } else {
            this.thebuf.append(buf);
            retbuf = buf;
        }
        this.geometryChanged();
        if (retbuf != null) {
            GrowableDataBuffer.returnBuffer(retbuf);
            return true;
        }
        return false;
    }

    static /* synthetic */ void lambda$printedCanvas$262(PixelData pixelData, RTTexture rTTexture, Graphics graphics, int n, int n2) {
        pixelData.save(rTTexture);
        pixelData.restore(graphics, n, n2);
    }

    static class EffectInput
    extends Effect {
        RTTexture tex;
        float pixelscale;

        EffectInput(RTTexture tex) {
            this.tex = tex;
            this.pixelscale = 1.0f;
        }

        public void setPixelScale(float scale) {
            this.pixelscale = scale;
        }

        @Override
        public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
            PrDrawable f = PrDrawable.create(fctx, this.tex);
            Rectangle r = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            f.lock();
            ImageData id = new ImageData(fctx, f, r);
            id.setReusable(true);
            if (this.pixelscale != 1.0f || !transform.isIdentity()) {
                Affine2D a2d = new Affine2D();
                a2d.scale(1.0f / this.pixelscale, 1.0f / this.pixelscale);
                a2d.concatenate(transform);
                id = id.transform(a2d);
            }
            return id;
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext fctx) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
            Rectangle r = new Rectangle(this.tex.getContentWidth(), this.tex.getContentHeight());
            return EffectInput.transformBounds(transform, new RectBounds(r));
        }

        @Override
        public boolean reducesOpaquePixels() {
            return false;
        }

        @Override
        public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
            return null;
        }
    }

    static class MyBlend
    extends Blend {
        public MyBlend(Blend.Mode mode, Effect bottomInput, Effect topInput) {
            super(mode, bottomInput, topInput);
        }

        @Override
        public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
            Rectangle r = super.getResultBounds(transform, outputClip, inputDatas);
            r.intersectWith(outputClip);
            return r;
        }
    }

    class RenderInput
    extends Effect {
        float x;
        float y;
        float w;
        float h;
        int token;
        GrowableDataBuffer buf;
        Affine2D savedBoundsTx = new Affine2D();

        public RenderInput(int token, GrowableDataBuffer buf, BaseTransform boundsTx, RectBounds rb) {
            this.token = token;
            this.buf = buf;
            this.savedBoundsTx.setTransform(boundsTx);
            this.x = rb.getMinX();
            this.y = rb.getMinY();
            this.w = rb.getWidth();
            this.h = rb.getHeight();
        }

        @Override
        public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
            PrDrawable ret;
            BaseBounds bounds = this.getBounds(transform, defaultInput);
            if (outputClip != null) {
                bounds.intersectWith(outputClip);
            }
            Rectangle r = new Rectangle(bounds);
            if (r.width < 1) {
                r.width = 1;
            }
            if (r.height < 1) {
                r.height = 1;
            }
            if ((ret = (PrDrawable)Effect.getCompatibleImage(fctx, r.width, r.height)) != null) {
                Graphics g = ret.createGraphics();
                g.setExtraAlpha(NGCanvas.this.globalAlpha);
                g.translate(-r.x, -r.y);
                if (transform != null) {
                    g.transform(transform);
                }
                this.buf.restore();
                NGCanvas.this.handleRenderOp(this.token, this.buf, g, null);
            }
            return new ImageData(fctx, ret, r);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext fctx) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
            RectBounds ret = new RectBounds(this.x, this.y, this.x + this.w, this.y + this.h);
            if (!transform.equals(this.savedBoundsTx)) {
                NGCanvas.inverseTxBounds(ret, this.savedBoundsTx);
                NGCanvas.txBounds(ret, transform);
            }
            return ret;
        }

        @Override
        public boolean reducesOpaquePixels() {
            return false;
        }

        @Override
        public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
            return null;
        }
    }

    private static class PixelData {
        private IntBuffer pixels = null;
        private boolean validPixels = false;
        private int cw;
        private int ch;

        private PixelData(int cw, int ch) {
            this.cw = cw;
            this.ch = ch;
            this.pixels = IntBuffer.allocate(cw * ch);
        }

        private void save(RTTexture tex) {
            int tw = tex.getContentWidth();
            int th = tex.getContentHeight();
            if (this.cw < tw || this.ch < th) {
                this.cw = tw;
                this.ch = th;
                this.pixels = IntBuffer.allocate(this.cw * this.ch);
            }
            this.pixels.rewind();
            tex.readPixels(this.pixels);
            this.validPixels = true;
        }

        private void restore(Graphics g, int tw, int th) {
            if (this.validPixels) {
                Image img = Image.fromIntArgbPreData(this.pixels, tw, th);
                ResourceFactory factory = g.getResourceFactory();
                Texture tempTex = factory.createTexture(img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
                g.drawTexture(tempTex, 0.0f, 0.0f, tw, th);
                tempTex.dispose();
            }
        }
    }

    static class RenderBuf {
        final InitType init_type;
        RTTexture tex;
        Graphics g;
        EffectInput input;
        private PixelData savedPixelData = null;

        public RenderBuf(InitType init_type) {
            this.init_type = init_type;
        }

        public void dispose() {
            if (this.tex != null) {
                this.tex.dispose();
            }
            this.tex = null;
            this.g = null;
            this.input = null;
        }

        public boolean validate(Graphics resg, int tw, int th) {
            boolean create;
            int cw;
            int ch;
            if (this.tex == null) {
                ch = 0;
                cw = 0;
                create = true;
            } else {
                cw = this.tex.getContentWidth();
                ch = this.tex.getContentHeight();
                this.tex.lock();
                boolean bl = create = this.tex.isSurfaceLost() || cw < tw || ch < th;
            }
            if (create) {
                RTTexture newtex;
                RTTexture oldtex = this.tex;
                ResourceFactory factory = resg == null ? GraphicsPipeline.getDefaultResourceFactory() : resg.getResourceFactory();
                this.tex = newtex = factory.createRTTexture(tw, th, Texture.WrapMode.CLAMP_TO_ZERO);
                this.g = newtex.createGraphics();
                this.input = new EffectInput(newtex);
                if (oldtex != null) {
                    if (this.init_type == InitType.PRESERVE_UPPER_LEFT) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        if (oldtex.isSurfaceLost()) {
                            if (this.savedPixelData != null) {
                                this.savedPixelData.restore(this.g, cw, ch);
                            }
                        } else {
                            this.g.drawTexture(oldtex, 0.0f, 0.0f, cw, ch);
                        }
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    }
                    oldtex.unlock();
                    oldtex.dispose();
                }
                if (this.init_type == InitType.FILL_WHITE) {
                    this.g.clear(Color.WHITE);
                }
                return true;
            }
            if (this.g == null) {
                this.g = this.tex.createGraphics();
                if (this.g == null) {
                    this.tex.dispose();
                    ResourceFactory factory = resg == null ? GraphicsPipeline.getDefaultResourceFactory() : resg.getResourceFactory();
                    this.tex = factory.createRTTexture(tw, th, Texture.WrapMode.CLAMP_TO_ZERO);
                    this.g = this.tex.createGraphics();
                    this.input = new EffectInput(this.tex);
                    if (this.savedPixelData != null) {
                        this.g.setCompositeMode(CompositeMode.SRC);
                        this.savedPixelData.restore(this.g, tw, th);
                        this.g.setCompositeMode(CompositeMode.SRC_OVER);
                    } else if (this.init_type == InitType.FILL_WHITE) {
                        this.g.clear(Color.WHITE);
                    }
                    return true;
                }
            }
            if (this.init_type == InitType.CLEAR) {
                this.g.clear();
            }
            return false;
        }

        private void save(int tw, int th) {
            if (this.tex.isVolatile()) {
                if (this.savedPixelData == null) {
                    this.savedPixelData = new PixelData(tw, th);
                }
                this.savedPixelData.save(this.tex);
            }
        }
    }

    static enum InitType {
        CLEAR,
        FILL_WHITE,
        PRESERVE_UPPER_LEFT;

    }
}

