/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.CacheFilter;
import com.sun.javafx.sg.prism.DirtyHint;
import com.sun.javafx.sg.prism.EffectFilter;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGRegion;
import com.sun.javafx.sg.prism.NodeEffectInput;
import com.sun.javafx.sg.prism.NodePath;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.CacheHint;

public abstract class NGNode {
    protected static float highestPixelScale;
    private static final GraphicsPipeline pipeline;
    private static final Boolean effectsSupported;
    private String name;
    private static final BoxBounds TEMP_BOUNDS;
    private static final RectBounds TEMP_RECT_BOUNDS;
    protected static final Affine3D TEMP_TRANSFORM;
    static final int DIRTY_REGION_INTERSECTS_NODE_BOUNDS = 1;
    static final int DIRTY_REGION_CONTAINS_NODE_BOUNDS = 2;
    static final int DIRTY_REGION_CONTAINS_OR_INTERSECTS_NODE_BOUNDS = 3;
    private BaseTransform transform = BaseTransform.IDENTITY_TRANSFORM;
    protected BaseBounds transformedBounds = new RectBounds();
    protected BaseBounds contentBounds = new RectBounds();
    BaseBounds dirtyBounds = new RectBounds();
    private boolean visible = true;
    protected DirtyFlag dirty = DirtyFlag.DIRTY;
    private NGNode parent;
    private boolean isClip;
    private NGNode clipNode;
    private float opacity = 1.0f;
    private Blend.Mode nodeBlendMode;
    private boolean depthTest = true;
    private CacheFilter cacheFilter;
    private EffectFilter effectFilter;
    protected boolean childDirty = false;
    protected int dirtyChildrenAccumulated = 0;
    protected static final int DIRTY_CHILDREN_ACCUMULATED_THRESHOLD = 12;
    protected int cullingBits = 0;
    private DirtyHint hint;
    private RectBounds opaqueRegion = null;
    private boolean opaqueRegionInvalid = true;
    private int painted = 0;
    private static Point2D[] TEMP_POINTS2D_4;

    protected NGNode() {
    }

    public void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.markDirty();
        }
    }

    public void setContentBounds(BaseBounds bounds) {
        this.contentBounds = this.contentBounds.deriveWithNewBounds(bounds);
    }

    public void setTransformedBounds(BaseBounds bounds, boolean byTransformChangeOnly) {
        if (this.transformedBounds.equals(bounds)) {
            return;
        }
        if (this.dirtyBounds.isEmpty()) {
            this.dirtyBounds = this.dirtyBounds.deriveWithNewBounds(this.transformedBounds);
            this.dirtyBounds = this.dirtyBounds.deriveWithUnion(bounds);
        } else {
            this.dirtyBounds = this.dirtyBounds.deriveWithUnion(this.transformedBounds);
        }
        this.transformedBounds = this.transformedBounds.deriveWithNewBounds(bounds);
        if (this.hasVisuals() && !byTransformChangeOnly) {
            this.markDirty();
        }
    }

    public void setTransformMatrix(BaseTransform tx) {
        if (this.transform.equals(tx)) {
            return;
        }
        boolean useHint = false;
        if (this.parent != null && this.parent.cacheFilter != null && PrismSettings.scrollCacheOpt) {
            if (this.hint == null) {
                this.hint = new DirtyHint();
            } else if (this.transform.getMxx() == tx.getMxx() && this.transform.getMxy() == tx.getMxy() && this.transform.getMyy() == tx.getMyy() && this.transform.getMyx() == tx.getMyx() && this.transform.getMxz() == tx.getMxz() && this.transform.getMyz() == tx.getMyz() && this.transform.getMzx() == tx.getMzx() && this.transform.getMzy() == tx.getMzy() && this.transform.getMzz() == tx.getMzz() && this.transform.getMzt() == tx.getMzt()) {
                useHint = true;
                this.hint.translateXDelta = tx.getMxt() - this.transform.getMxt();
                this.hint.translateYDelta = tx.getMyt() - this.transform.getMyt();
            }
        }
        this.transform = this.transform.deriveWithNewTransform(tx);
        if (useHint) {
            this.markDirtyByTranslation();
        } else {
            this.markDirty();
        }
        this.invalidateOpaqueRegion();
    }

    public void setClipNode(NGNode clipNode) {
        if (clipNode != this.clipNode) {
            if (this.clipNode != null) {
                this.clipNode.setParent(null);
            }
            if (clipNode != null) {
                clipNode.setParent(this, true);
            }
            this.clipNode = clipNode;
            this.visualsChanged();
            this.invalidateOpaqueRegion();
        }
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Internal Error: The opacity must be between 0 and 1");
        }
        if (opacity != this.opacity) {
            float old = this.opacity;
            this.opacity = opacity;
            this.markDirty();
            if (old < 1.0f && (opacity == 1.0f || opacity == 0.0f) || opacity < 1.0f && (old == 1.0f || old == 0.0f)) {
                this.invalidateOpaqueRegion();
            }
        }
    }

    public void setNodeBlendMode(Blend.Mode blendMode) {
        if (this.nodeBlendMode != blendMode) {
            this.nodeBlendMode = blendMode;
            this.markDirty();
            this.invalidateOpaqueRegion();
        }
    }

    public void setDepthTest(boolean depthTest) {
        if (depthTest != this.depthTest) {
            this.depthTest = depthTest;
            this.visualsChanged();
        }
    }

    public void setCachedAsBitmap(boolean cached, CacheHint cacheHint) {
        if (cacheHint == null) {
            throw new IllegalArgumentException("Internal Error: cacheHint must not be null");
        }
        if (cached) {
            if (this.cacheFilter == null) {
                this.cacheFilter = new CacheFilter(this, cacheHint);
                this.markDirty();
            } else if (!this.cacheFilter.matchesHint(cacheHint)) {
                this.cacheFilter.setHint(cacheHint);
                this.markDirty();
            }
        } else if (this.cacheFilter != null) {
            this.cacheFilter.dispose();
            this.cacheFilter = null;
            this.markDirty();
        }
    }

    public void setEffect(Effect effect) {
        Effect old = this.getEffect();
        if (PrismSettings.disableEffects) {
            effect = null;
        }
        if (this.effectFilter == null && effect != null) {
            this.effectFilter = new EffectFilter(effect, this);
            this.visualsChanged();
        } else if (this.effectFilter != null && this.effectFilter.getEffect() != effect) {
            this.effectFilter.dispose();
            this.effectFilter = null;
            if (effect != null) {
                this.effectFilter = new EffectFilter(effect, this);
            }
            this.visualsChanged();
        }
        if (old != effect && (old == null || effect == null)) {
            this.invalidateOpaqueRegion();
        }
    }

    public void effectChanged() {
        this.visualsChanged();
    }

    public boolean isContentBounds2D() {
        return this.contentBounds.is2D() || Affine3D.almostZero(this.contentBounds.getMaxZ()) && Affine3D.almostZero(this.contentBounds.getMinZ());
    }

    public NGNode getParent() {
        return this.parent;
    }

    public void setParent(NGNode parent) {
        this.setParent(parent, false);
    }

    private void setParent(NGNode parent, boolean isClip) {
        this.parent = parent;
        this.isClip = isClip;
    }

    public final void setName(String value) {
        this.name = value;
    }

    public final String getName() {
        return this.name;
    }

    protected final Effect getEffect() {
        return this.effectFilter == null ? null : this.effectFilter.getEffect();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public final BaseTransform getTransform() {
        return this.transform;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final Blend.Mode getNodeBlendMode() {
        return this.nodeBlendMode;
    }

    public final boolean isDepthTest() {
        return this.depthTest;
    }

    public final CacheFilter getCacheFilter() {
        return this.cacheFilter;
    }

    public final EffectFilter getEffectFilter() {
        return this.effectFilter;
    }

    public final NGNode getClipNode() {
        return this.clipNode;
    }

    public BaseBounds getContentBounds(BaseBounds bounds, BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            bounds = bounds.deriveWithNewBounds(this.contentBounds);
            if (!tx.isIdentity()) {
                float translateX = (float)tx.getMxt();
                float translateY = (float)tx.getMyt();
                float translateZ = (float)tx.getMzt();
                bounds = bounds.deriveWithNewBounds(bounds.getMinX() + translateX, bounds.getMinY() + translateY, bounds.getMinZ() + translateZ, bounds.getMaxX() + translateX, bounds.getMaxY() + translateY, bounds.getMaxZ() + translateZ);
            }
            return bounds;
        }
        return this.computeBounds(bounds, tx);
    }

    private BaseBounds computeBounds(BaseBounds bounds, BaseTransform tx) {
        bounds = bounds.deriveWithNewBounds(this.contentBounds);
        return tx.transform(this.contentBounds, bounds);
    }

    public final BaseBounds getClippedBounds(BaseBounds bounds, BaseTransform tx) {
        BaseBounds effectBounds = this.getEffectBounds(bounds, tx);
        if (this.clipNode != null) {
            float ex1 = effectBounds.getMinX();
            float ey1 = effectBounds.getMinY();
            float ez1 = effectBounds.getMinZ();
            float ex2 = effectBounds.getMaxX();
            float ey2 = effectBounds.getMaxY();
            float ez2 = effectBounds.getMaxZ();
            effectBounds = this.clipNode.getCompleteBounds(effectBounds, tx);
            effectBounds.intersectWith(ex1, ey1, ez1, ex2, ey2, ez2);
        }
        return effectBounds;
    }

    public final BaseBounds getEffectBounds(BaseBounds bounds, BaseTransform tx) {
        if (this.effectFilter != null) {
            return this.effectFilter.getBounds(bounds, tx);
        }
        return this.getContentBounds(bounds, tx);
    }

    public final BaseBounds getCompleteBounds(BaseBounds bounds, BaseTransform tx) {
        if (tx.isIdentity()) {
            bounds = bounds.deriveWithNewBounds(this.transformedBounds);
            return bounds;
        }
        if (this.transform.isIdentity()) {
            return this.getClippedBounds(bounds, tx);
        }
        double mxx = tx.getMxx();
        double mxy = tx.getMxy();
        double mxz = tx.getMxz();
        double mxt = tx.getMxt();
        double myx = tx.getMyx();
        double myy = tx.getMyy();
        double myz = tx.getMyz();
        double myt = tx.getMyt();
        double mzx = tx.getMzx();
        double mzy = tx.getMzy();
        double mzz = tx.getMzz();
        double mzt = tx.getMzt();
        BaseTransform boundsTx = tx.deriveWithConcatenation(this.transform);
        bounds = this.getClippedBounds(bounds, tx);
        if (boundsTx == tx) {
            tx.restoreTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        }
        return bounds;
    }

    protected void visualsChanged() {
        this.invalidateCache();
        this.markDirty();
    }

    protected void geometryChanged() {
        this.invalidateCache();
        this.invalidateOpaqueRegion();
        if (this.hasVisuals()) {
            this.markDirty();
        }
    }

    public final void markDirty() {
        if (this.dirty != DirtyFlag.DIRTY) {
            this.dirty = DirtyFlag.DIRTY;
            this.markTreeDirty();
        }
    }

    private void markDirtyByTranslation() {
        if (this.dirty == DirtyFlag.CLEAN) {
            if (this.parent != null && this.parent.dirty == DirtyFlag.CLEAN && !this.parent.childDirty) {
                this.dirty = DirtyFlag.DIRTY_BY_TRANSLATION;
                this.parent.childDirty = true;
                ++this.parent.dirtyChildrenAccumulated;
                this.parent.invalidateCacheByTranslation(this.hint);
                this.parent.markTreeDirty();
            } else {
                this.markDirty();
            }
        }
    }

    protected final void markTreeDirtyNoIncrement() {
        if (!(this.parent == null || this.parent.childDirty && this.dirty != DirtyFlag.DIRTY_BY_TRANSLATION)) {
            this.markTreeDirty();
        }
    }

    protected final void markTreeDirty() {
        boolean byTranslation;
        NGNode p = this.parent;
        boolean atClip = this.isClip;
        boolean bl = byTranslation = this.dirty == DirtyFlag.DIRTY_BY_TRANSLATION;
        while (p != null && p.dirty != DirtyFlag.DIRTY && (!p.childDirty || atClip || byTranslation)) {
            if (atClip) {
                p.dirty = DirtyFlag.DIRTY;
            } else if (!byTranslation) {
                p.childDirty = true;
                ++p.dirtyChildrenAccumulated;
            }
            p.invalidateCache();
            atClip = p.isClip;
            byTranslation = p.dirty == DirtyFlag.DIRTY_BY_TRANSLATION;
            p = p.parent;
        }
        if (p != null && p.dirty == DirtyFlag.CLEAN && !atClip && !byTranslation) {
            ++p.dirtyChildrenAccumulated;
        }
        if (p != null) {
            p.invalidateCache();
        }
    }

    public final boolean isClean() {
        return this.dirty == DirtyFlag.CLEAN && !this.childDirty;
    }

    protected void clearDirty() {
        this.dirty = DirtyFlag.CLEAN;
        this.childDirty = false;
        this.dirtyBounds.makeEmpty();
        this.dirtyChildrenAccumulated = 0;
    }

    public void clearPainted() {
        this.painted = 0;
        if (this instanceof NGGroup) {
            List<NGNode> children = ((NGGroup)this).getChildren();
            for (int i = 0; i < children.size(); ++i) {
                children.get(i).clearPainted();
            }
        }
    }

    public void clearDirtyTree() {
        this.clearDirty();
        if (this.getClipNode() != null) {
            this.getClipNode().clearDirtyTree();
        }
        if (this instanceof NGGroup) {
            List<NGNode> children = ((NGGroup)this).getChildren();
            for (int i = 0; i < children.size(); ++i) {
                NGNode child = children.get(i);
                if (child.dirty == DirtyFlag.CLEAN && !child.childDirty) continue;
                child.clearDirtyTree();
            }
        }
    }

    protected final void invalidateCache() {
        if (this.cacheFilter != null) {
            this.cacheFilter.invalidate();
        }
    }

    protected final void invalidateCacheByTranslation(DirtyHint hint) {
        if (this.cacheFilter != null) {
            this.cacheFilter.invalidateByTranslation(hint.translateXDelta, hint.translateYDelta);
        }
    }

    public int accumulateDirtyRegions(RectBounds clip, RectBounds dirtyRegionTemp, DirtyRegionPool regionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform tx, GeneralTransform3D pvTx) {
        if (clip == null || dirtyRegionTemp == null || regionPool == null || dirtyRegionContainer == null || tx == null || pvTx == null) {
            throw new NullPointerException();
        }
        if (this.dirty == DirtyFlag.CLEAN && !this.childDirty) {
            return 1;
        }
        if (this.dirty != DirtyFlag.CLEAN) {
            return this.accumulateNodeDirtyRegion(clip, dirtyRegionTemp, dirtyRegionContainer, tx, pvTx);
        }
        assert (this.childDirty);
        return this.accumulateGroupDirtyRegion(clip, dirtyRegionTemp, regionPool, dirtyRegionContainer, tx, pvTx);
    }

    int accumulateNodeDirtyRegion(RectBounds clip, RectBounds dirtyRegionTemp, DirtyRegionContainer dirtyRegionContainer, BaseTransform tx, GeneralTransform3D pvTx) {
        BaseBounds bb = this.computeDirtyRegion(dirtyRegionTemp, tx, pvTx);
        if (bb != dirtyRegionTemp) {
            bb.flattenInto(dirtyRegionTemp);
        }
        if (dirtyRegionTemp.isEmpty() || clip.disjoint(dirtyRegionTemp)) {
            return 1;
        }
        if (dirtyRegionTemp.contains(clip)) {
            return 0;
        }
        dirtyRegionTemp.intersectWith(clip);
        dirtyRegionContainer.addDirtyRegion(dirtyRegionTemp);
        return 1;
    }

    int accumulateGroupDirtyRegion(RectBounds clip, RectBounds dirtyRegionTemp, DirtyRegionPool regionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform tx, GeneralTransform3D pvTx) {
        NGNode child;
        assert (this.childDirty);
        assert (this.dirty == DirtyFlag.CLEAN);
        int status = 1;
        if (this.dirtyChildrenAccumulated > 12) {
            status = this.accumulateNodeDirtyRegion(clip, dirtyRegionTemp, dirtyRegionContainer, tx, pvTx);
            return status;
        }
        double mxx = tx.getMxx();
        double mxy = tx.getMxy();
        double mxz = tx.getMxz();
        double mxt = tx.getMxt();
        double myx = tx.getMyx();
        double myy = tx.getMyy();
        double myz = tx.getMyz();
        double myt = tx.getMyt();
        double mzx = tx.getMzx();
        double mzy = tx.getMzy();
        double mzz = tx.getMzz();
        double mzt = tx.getMzt();
        BaseTransform renderTx = tx;
        if (this.transform != null) {
            renderTx = renderTx.deriveWithConcatenation(this.transform);
        }
        RectBounds myClip = clip;
        DirtyRegionContainer originalDirtyRegion = null;
        BaseTransform originalRenderTx = null;
        if (this.effectFilter != null) {
            try {
                myClip = new RectBounds();
                BaseBounds myClipBaseBounds = renderTx.inverseTransform(clip, TEMP_BOUNDS);
                myClipBaseBounds.flattenInto(myClip);
            }
            catch (NoninvertibleTransformException ex) {
                return 1;
            }
            originalRenderTx = renderTx;
            renderTx = BaseTransform.IDENTITY_TRANSFORM;
            originalDirtyRegion = dirtyRegionContainer;
            dirtyRegionContainer = regionPool.checkOut();
        } else if (this.clipNode != null) {
            originalDirtyRegion = dirtyRegionContainer;
            myClip = new RectBounds();
            BaseBounds clipBounds = this.clipNode.getCompleteBounds(myClip, renderTx);
            pvTx.transform(clipBounds, clipBounds);
            clipBounds.flattenInto(myClip);
            myClip.intersectWith(clip);
            dirtyRegionContainer = regionPool.checkOut();
        }
        List<NGNode> removed = ((NGGroup)this).getRemovedChildren();
        if (removed != null) {
            for (int i = removed.size() - 1; i >= 0; --i) {
                NGNode removedChild = removed.get(i);
                removedChild.dirty = DirtyFlag.DIRTY;
                status = removedChild.accumulateDirtyRegions(myClip, dirtyRegionTemp, regionPool, dirtyRegionContainer, renderTx, pvTx);
                if (status == 0) break;
            }
        }
        List<NGNode> children = ((NGGroup)this).getChildren();
        int num = children.size();
        for (int i = 0; i < num && status == 1 && (status = (child = children.get(i)).accumulateDirtyRegions(myClip, dirtyRegionTemp, regionPool, dirtyRegionContainer, renderTx, pvTx)) != 0; ++i) {
        }
        if (this.effectFilter != null && status == 1) {
            this.applyEffect(this.effectFilter, dirtyRegionContainer, regionPool);
            if (this.clipNode != null) {
                myClip = new RectBounds();
                BaseBounds clipBounds = this.clipNode.getCompleteBounds(myClip, renderTx);
                this.applyClip(clipBounds, dirtyRegionContainer);
            }
            this.applyTransform(originalRenderTx, dirtyRegionContainer);
            renderTx = originalRenderTx;
            originalDirtyRegion.merge(dirtyRegionContainer);
            regionPool.checkIn(dirtyRegionContainer);
        }
        if (renderTx == tx) {
            tx.restoreTransform(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        }
        if (this.clipNode != null && this.effectFilter == null) {
            if (status == 0) {
                status = this.accumulateNodeDirtyRegion(clip, dirtyRegionTemp, originalDirtyRegion, tx, pvTx);
            } else {
                originalDirtyRegion.merge(dirtyRegionContainer);
            }
            regionPool.checkIn(dirtyRegionContainer);
        }
        return status;
    }

    private BaseBounds computeDirtyRegion(RectBounds dirtyRegionTemp, BaseTransform tx, GeneralTransform3D pvTx) {
        if (this.cacheFilter != null) {
            return this.cacheFilter.computeDirtyBounds(dirtyRegionTemp, tx, pvTx);
        }
        BaseBounds region = dirtyRegionTemp;
        region = !this.dirtyBounds.isEmpty() ? region.deriveWithNewBounds(this.dirtyBounds) : region.deriveWithNewBounds(this.transformedBounds);
        if (!region.isEmpty()) {
            region = this.computePadding(region);
            region = tx.transform(region, region);
            region = pvTx.transform(region, region);
        }
        return region;
    }

    protected BaseBounds computePadding(BaseBounds region) {
        return region;
    }

    protected boolean hasVisuals() {
        return true;
    }

    public final void doPreCulling(DirtyRegionContainer drc, BaseTransform tx, GeneralTransform3D pvTx) {
        if (drc == null || tx == null || pvTx == null) {
            throw new NullPointerException();
        }
        this.markCullRegions(drc, -1, tx, pvTx);
    }

    void markCullRegions(DirtyRegionContainer drc, int cullingRegionsBitsOfParent, BaseTransform tx, GeneralTransform3D pvTx) {
        RectBounds region;
        if (tx.isIdentity()) {
            TEMP_BOUNDS.deriveWithNewBounds(this.transformedBounds);
        } else {
            tx.transform(this.transformedBounds, TEMP_BOUNDS);
        }
        if (!pvTx.isIdentity()) {
            pvTx.transform(TEMP_BOUNDS, TEMP_BOUNDS);
        }
        TEMP_BOUNDS.flattenInto(TEMP_RECT_BOUNDS);
        this.cullingBits = 0;
        int mask = 1;
        for (int i = 0; i < drc.size() && (region = drc.getDirtyRegion(i)) != null && !region.isEmpty(); ++i) {
            if ((cullingRegionsBitsOfParent == -1 || (cullingRegionsBitsOfParent & mask) != 0) && region.intersects(TEMP_RECT_BOUNDS)) {
                int b = 1;
                if (region.contains(TEMP_RECT_BOUNDS)) {
                    b = 2;
                }
                this.cullingBits |= b << 2 * i;
            }
            mask <<= 2;
        }
        if (this.cullingBits == 0 && (this.dirty != DirtyFlag.CLEAN || this.childDirty)) {
            this.clearDirtyTree();
        }
    }

    public final void printDirtyOpts(StringBuilder s, List<NGNode> roots) {
        s.append("\n*=Render Root\n");
        s.append("d=Dirty\n");
        s.append("dt=Dirty By Translation\n");
        s.append("i=Dirty Region Intersects the NGNode\n");
        s.append("c=Dirty Region Contains the NGNode\n");
        s.append("ef=Effect Filter\n");
        s.append("cf=Cache Filter\n");
        s.append("cl=This node is a clip node\n");
        s.append("b=Blend mode is set\n");
        s.append("or=Opaque Region\n");
        this.printDirtyOpts(s, this, BaseTransform.IDENTITY_TRANSFORM, "", roots);
    }

    private final void printDirtyOpts(StringBuilder s, NGNode node, BaseTransform tx, String prefix, List<NGNode> roots) {
        int i;
        RectBounds opaqueRegion;
        if (!node.isVisible() || node.getOpacity() == 0.0f) {
            return;
        }
        BaseTransform copy = tx.copy();
        copy = copy.deriveWithConcatenation(node.getTransform());
        ArrayList<String> stuff = new ArrayList<String>();
        for (int i2 = 0; i2 < roots.size(); ++i2) {
            NGNode root = roots.get(i2);
            if (node != root) continue;
            stuff.add("*" + i2);
        }
        if (node.dirty != DirtyFlag.CLEAN) {
            stuff.add(node.dirty == DirtyFlag.DIRTY ? "d" : "dt");
        }
        if (node.cullingBits != 0) {
            int mask = 17;
            for (int i3 = 0; i3 < 15; ++i3) {
                int bits = node.cullingBits & mask;
                if (bits != 0) {
                    stuff.add(bits == 1 ? "i" + i3 : (bits == 0 ? "c" + i3 : "ci" + i3));
                }
                mask <<= 2;
            }
        }
        if (node.effectFilter != null) {
            stuff.add("ef");
        }
        if (node.cacheFilter != null) {
            stuff.add("cf");
        }
        if (node.nodeBlendMode != null) {
            stuff.add("b");
        }
        if ((opaqueRegion = node.getOpaqueRegion()) != null) {
            RectBounds or = new RectBounds();
            copy.transform(opaqueRegion, or);
            stuff.add("or=" + or.getMinX() + ", " + or.getMinY() + ", " + or.getWidth() + ", " + or.getHeight());
        }
        if (stuff.isEmpty()) {
            s.append(prefix + node.name + "\n");
        } else {
            String postfix = " [";
            for (i = 0; i < stuff.size(); ++i) {
                postfix = postfix + (String)stuff.get(i);
                if (i >= stuff.size() - 1) continue;
                postfix = postfix + " ";
            }
            s.append(prefix + node.name + postfix + "]\n");
        }
        if (node.getClipNode() != null) {
            this.printDirtyOpts(s, node.getClipNode(), copy, prefix + "  cl ", roots);
        }
        if (node instanceof NGGroup) {
            NGGroup g = (NGGroup)node;
            for (i = 0; i < g.getChildren().size(); ++i) {
                this.printDirtyOpts(s, g.getChildren().get(i), copy, prefix + "  ", roots);
            }
        }
    }

    public void drawDirtyOpts(BaseTransform tx, GeneralTransform3D pvTx, Rectangle clipBounds, int[] colorBuffer, int dirtyRegionIndex) {
        if ((this.painted & 1 << dirtyRegionIndex * 2) != 0) {
            tx.copy().deriveWithConcatenation(this.getTransform()).transform(this.contentBounds, TEMP_BOUNDS);
            if (pvTx != null) {
                pvTx.transform(TEMP_BOUNDS, TEMP_BOUNDS);
            }
            RectBounds bounds = new RectBounds();
            TEMP_BOUNDS.flattenInto(bounds);
            assert (clipBounds.width * clipBounds.height == colorBuffer.length);
            bounds.intersectWith(clipBounds);
            int x = (int)bounds.getMinX() - clipBounds.x;
            int y = (int)bounds.getMinY() - clipBounds.y;
            int w = (int)((double)bounds.getWidth() + 0.5);
            int h = (int)((double)bounds.getHeight() + 0.5);
            if (w == 0 || h == 0) {
                return;
            }
            for (int i = y; i < y + h; ++i) {
                for (int j = x; j < x + w; ++j) {
                    int index = i * clipBounds.width + j;
                    int color = colorBuffer[index];
                    if (color == 0) {
                        color = 134250240;
                    } else if ((this.painted & 3 << dirtyRegionIndex * 2) == 3) {
                        switch (color) {
                            case -2147451136: {
                                color = -2147450880;
                                break;
                            }
                            case -2147450880: {
                                color = -2139128064;
                                break;
                            }
                            case -2139128064: {
                                color = -2139062272;
                                break;
                            }
                            case -2139062272: {
                                color = -2139160576;
                                break;
                            }
                            default: {
                                color = -2139095040;
                            }
                        }
                    }
                    colorBuffer[index] = color;
                }
            }
        }
    }

    public final void getRenderRoot(NodePath path, RectBounds dirtyRegion, int cullingIndex, BaseTransform tx, GeneralTransform3D pvTx) {
        if (path == null || dirtyRegion == null || tx == null || pvTx == null) {
            throw new NullPointerException();
        }
        if (cullingIndex < -1 || cullingIndex > 15) {
            throw new IllegalArgumentException("cullingIndex cannot be < -1 or > 15");
        }
        RenderRootResult result = this.computeRenderRoot(path, dirtyRegion, cullingIndex, tx, pvTx);
        if (result == RenderRootResult.NO_RENDER_ROOT) {
            path.add(this);
        } else if (result == RenderRootResult.HAS_RENDER_ROOT_AND_IS_CLEAN) {
            path.clear();
        }
    }

    RenderRootResult computeRenderRoot(NodePath path, RectBounds dirtyRegion, int cullingIndex, BaseTransform tx, GeneralTransform3D pvTx) {
        return this.computeNodeRenderRoot(path, dirtyRegion, cullingIndex, tx, pvTx);
    }

    private static int ccw(double px, double py, Point2D a, Point2D b) {
        return (int)Math.signum((double)(b.x - a.x) * (py - (double)a.y) - (double)(b.y - a.y) * (px - (double)a.x));
    }

    private static boolean pointInConvexQuad(double x, double y, Point2D[] rect) {
        int union;
        int ccw01 = NGNode.ccw(x, y, rect[0], rect[1]);
        int ccw12 = NGNode.ccw(x, y, rect[1], rect[2]);
        int ccw23 = NGNode.ccw(x, y, rect[2], rect[3]);
        int ccw31 = NGNode.ccw(x, y, rect[3], rect[0]);
        return (union = (ccw01 ^= ccw01 >>> 1) | (ccw12 ^= ccw12 >>> 1) | (ccw23 ^= ccw23 >>> 1) | (ccw31 ^= ccw31 >>> 1)) == Integer.MIN_VALUE || union == 1;
    }

    final RenderRootResult computeNodeRenderRoot(NodePath path, RectBounds dirtyRegion, int cullingIndex, BaseTransform tx, GeneralTransform3D pvTx) {
        int bits;
        if (cullingIndex != -1 && ((bits = this.cullingBits >> cullingIndex * 2) & 3) == 0) {
            return RenderRootResult.NO_RENDER_ROOT;
        }
        if (!this.isVisible()) {
            return RenderRootResult.NO_RENDER_ROOT;
        }
        RectBounds opaqueRegion = this.getOpaqueRegion();
        if (opaqueRegion == null) {
            return RenderRootResult.NO_RENDER_ROOT;
        }
        BaseTransform localToParentTx = this.getTransform();
        Affine3D localToSceneTx = TEMP_TRANSFORM.deriveWithNewTransform(tx).deriveWithConcatenation(localToParentTx);
        if (NGNode.checkBoundsInQuad(opaqueRegion, dirtyRegion, localToSceneTx, pvTx)) {
            path.add(this);
            return this.isClean() ? RenderRootResult.HAS_RENDER_ROOT_AND_IS_CLEAN : RenderRootResult.HAS_RENDER_ROOT;
        }
        return RenderRootResult.NO_RENDER_ROOT;
    }

    static boolean checkBoundsInQuad(RectBounds untransformedQuad, RectBounds innerBounds, BaseTransform tx, GeneralTransform3D pvTx) {
        if (pvTx.isIdentity() && (tx.getType() & 0xFFFFFFF0) == 0) {
            if (tx.isIdentity()) {
                TEMP_BOUNDS.deriveWithNewBounds(untransformedQuad);
            } else {
                tx.transform(untransformedQuad, TEMP_BOUNDS);
            }
            TEMP_BOUNDS.flattenInto(TEMP_RECT_BOUNDS);
            return TEMP_RECT_BOUNDS.contains(innerBounds);
        }
        TEMP_POINTS2D_4[0].setLocation(untransformedQuad.getMinX(), untransformedQuad.getMinY());
        TEMP_POINTS2D_4[1].setLocation(untransformedQuad.getMaxX(), untransformedQuad.getMinY());
        TEMP_POINTS2D_4[2].setLocation(untransformedQuad.getMaxX(), untransformedQuad.getMaxY());
        TEMP_POINTS2D_4[3].setLocation(untransformedQuad.getMinX(), untransformedQuad.getMaxY());
        for (Point2D p : TEMP_POINTS2D_4) {
            tx.transform(p, p);
            if (pvTx.isIdentity()) continue;
            pvTx.transform(p, p);
        }
        return NGNode.pointInConvexQuad(innerBounds.getMinX(), innerBounds.getMinY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(innerBounds.getMaxX(), innerBounds.getMinY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(innerBounds.getMaxX(), innerBounds.getMaxY(), TEMP_POINTS2D_4) && NGNode.pointInConvexQuad(innerBounds.getMinX(), innerBounds.getMaxY(), TEMP_POINTS2D_4);
    }

    protected final void invalidateOpaqueRegion() {
        this.opaqueRegionInvalid = true;
        if (this.isClip) {
            this.parent.invalidateOpaqueRegion();
        }
    }

    final boolean isOpaqueRegionInvalid() {
        return this.opaqueRegionInvalid;
    }

    public final RectBounds getOpaqueRegion() {
        if (this.opaqueRegionInvalid || this.getEffect() != null) {
            this.opaqueRegionInvalid = false;
            if (this.supportsOpaqueRegions() && this.hasOpaqueRegion()) {
                this.opaqueRegion = this.computeOpaqueRegion(this.opaqueRegion == null ? new RectBounds() : this.opaqueRegion);
                assert (this.opaqueRegion != null);
                if (this.opaqueRegion == null) {
                    return null;
                }
                NGNode clip = this.getClipNode();
                if (clip != null) {
                    RectBounds clipOpaqueRegion = clip.getOpaqueRegion();
                    if (clipOpaqueRegion == null || (clip.getTransform().getType() & 0xFFFFFFF8) != 0) {
                        this.opaqueRegion = null;
                        return null;
                    }
                    BaseBounds b = clip.getTransform().transform(clipOpaqueRegion, TEMP_BOUNDS);
                    b.flattenInto(TEMP_RECT_BOUNDS);
                    this.opaqueRegion.intersectWith(TEMP_RECT_BOUNDS);
                }
            } else {
                this.opaqueRegion = null;
            }
        }
        return this.opaqueRegion;
    }

    protected boolean supportsOpaqueRegions() {
        return false;
    }

    protected boolean hasOpaqueRegion() {
        NGNode clip = this.getClipNode();
        Effect effect = this.getEffect();
        return !(effect != null && effect.reducesOpaquePixels() || this.getOpacity() != 1.0f || this.nodeBlendMode != null && this.nodeBlendMode != Blend.Mode.SRC_OVER || clip != null && (!clip.supportsOpaqueRegions() || !clip.hasOpaqueRegion()));
    }

    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        return null;
    }

    protected boolean isRectClip(BaseTransform xform, boolean permitRoundedRectangle) {
        return false;
    }

    public final void render(Graphics g) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("Nodes visited during render");
        }
        this.clearDirty();
        if (!this.visible || this.opacity == 0.0f) {
            return;
        }
        this.doRender(g);
    }

    public void renderForcedContent(Graphics gOptional) {
    }

    boolean isShape3D() {
        return false;
    }

    protected void doRender(Graphics g) {
        g.setState3D(this.isShape3D());
        boolean preCullingTurnedOff = false;
        if (PrismSettings.dirtyOptsEnabled && g.hasPreCullingBits()) {
            int bits = this.cullingBits >> g.getClipRectIndex() * 2;
            if ((bits & 3) == 0) {
                return;
            }
            if ((bits & 2) != 0) {
                g.setHasPreCullingBits(false);
                preCullingTurnedOff = true;
            }
        }
        boolean prevDepthTest = g.isDepthTest();
        g.setDepthTest(this.isDepthTest());
        BaseTransform prevXform = g.getTransformNoClone();
        double mxx = prevXform.getMxx();
        double mxy = prevXform.getMxy();
        double mxz = prevXform.getMxz();
        double mxt = prevXform.getMxt();
        double myx = prevXform.getMyx();
        double myy = prevXform.getMyy();
        double myz = prevXform.getMyz();
        double myt = prevXform.getMyt();
        double mzx = prevXform.getMzx();
        double mzy = prevXform.getMzy();
        double mzz = prevXform.getMzz();
        double mzt = prevXform.getMzt();
        g.transform(this.getTransform());
        boolean p = false;
        if (!this.isShape3D() && g instanceof ReadbackGraphics && this.needsBlending()) {
            this.renderNodeBlendMode(g);
            p = true;
        } else if (!this.isShape3D() && this.getOpacity() < 1.0f) {
            this.renderOpacity(g);
            p = true;
        } else if (!this.isShape3D() && this.getCacheFilter() != null) {
            this.renderCached(g);
            p = true;
        } else if (!this.isShape3D() && this.getClipNode() != null) {
            this.renderClip(g);
            p = true;
        } else if (!this.isShape3D() && this.getEffectFilter() != null && effectsSupported.booleanValue()) {
            this.renderEffect(g);
            p = true;
        } else {
            this.renderContent(g);
            if (PrismSettings.showOverdraw) {
                boolean bl = p = this instanceof NGRegion || !(this instanceof NGGroup);
            }
        }
        if (preCullingTurnedOff) {
            g.setHasPreCullingBits(true);
        }
        g.setTransform3D(mxx, mxy, mxz, mxt, myx, myy, myz, myt, mzx, mzy, mzz, mzt);
        g.setDepthTest(prevDepthTest);
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.incrementCounter("Nodes rendered");
        }
        if (PrismSettings.showOverdraw) {
            this.painted = p ? (this.painted |= 3 << g.getClipRectIndex() * 2) : (this.painted |= 1 << g.getClipRectIndex() * 2);
        }
    }

    protected boolean needsBlending() {
        Blend.Mode mode = this.getNodeBlendMode();
        return mode != null && mode != Blend.Mode.SRC_OVER;
    }

    private void renderNodeBlendMode(Graphics g) {
        BaseTransform curXform = g.getTransformNoClone();
        BaseBounds clipBounds = this.getClippedBounds(new RectBounds(), curXform);
        if (clipBounds.isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (!this.isReadbackSupported(g)) {
            if (this.getOpacity() < 1.0f) {
                this.renderOpacity(g);
            } else if (this.getClipNode() != null) {
                this.renderClip(g);
            } else {
                this.renderContent(g);
            }
            return;
        }
        Rectangle clipRect = new Rectangle(clipBounds);
        clipRect.intersectWith(PrEffectHelper.getGraphicsClipNoClone(g));
        FilterContext fctx = NGNode.getFilterContext(g);
        PrDrawable contentImg = (PrDrawable)Effect.getCompatibleImage(fctx, clipRect.width, clipRect.height);
        if (contentImg == null) {
            this.clearDirtyTree();
            return;
        }
        Graphics gContentImg = contentImg.createGraphics();
        gContentImg.setHasPreCullingBits(g.hasPreCullingBits());
        gContentImg.setClipRectIndex(g.getClipRectIndex());
        gContentImg.translate(-clipRect.x, -clipRect.y);
        gContentImg.transform(curXform);
        if (this.getOpacity() < 1.0f) {
            this.renderOpacity(gContentImg);
        } else if (this.getCacheFilter() != null) {
            this.renderCached(gContentImg);
        } else if (this.getClipNode() != null) {
            this.renderClip(g);
        } else if (this.getEffectFilter() != null) {
            this.renderEffect(gContentImg);
        } else {
            this.renderContent(gContentImg);
        }
        RTTexture bgRTT = ((ReadbackGraphics)g).readBack(clipRect);
        PrDrawable bgPrD = PrDrawable.create(fctx, bgRTT);
        Blend blend = new Blend(this.getNodeBlendMode(), new PassThrough(bgPrD, clipRect), new PassThrough(contentImg, clipRect));
        CompositeMode oldmode = g.getCompositeMode();
        g.setTransform(null);
        g.setCompositeMode(CompositeMode.SRC);
        PrEffectHelper.render(blend, g, 0.0f, 0.0f, null);
        g.setCompositeMode(oldmode);
        Effect.releaseCompatibleImage(fctx, contentImg);
        ((ReadbackGraphics)g).releaseReadBackBuffer(bgRTT);
    }

    private void renderRectClip(Graphics g, NGRectangle clipNode) {
        BaseBounds newClip = clipNode.getShape().getBounds();
        if (!clipNode.getTransform().isIdentity()) {
            newClip = clipNode.getTransform().transform(newClip, newClip);
        }
        BaseTransform curXform = g.getTransformNoClone();
        Rectangle curClip = g.getClipRectNoClone();
        newClip = curXform.transform(newClip, newClip);
        newClip.intersectWith(PrEffectHelper.getGraphicsClipNoClone(g));
        if (newClip.isEmpty() || newClip.getWidth() == 0.0f || newClip.getHeight() == 0.0f) {
            this.clearDirtyTree();
            return;
        }
        g.setClipRect(new Rectangle(newClip));
        this.renderForClip(g);
        g.setClipRect(curClip);
        clipNode.clearDirty();
    }

    void renderClip(Graphics g) {
        NGRectangle rectNode;
        if ((double)this.getClipNode().getOpacity() == 0.0) {
            this.clearDirtyTree();
            return;
        }
        BaseTransform curXform = g.getTransformNoClone();
        BaseBounds clipBounds = this.getClippedBounds(new RectBounds(), curXform);
        if (clipBounds.isEmpty()) {
            this.clearDirtyTree();
            return;
        }
        if (this.getClipNode() instanceof NGRectangle && (rectNode = (NGRectangle)this.getClipNode()).isRectClip(curXform, false)) {
            this.renderRectClip(g, rectNode);
            return;
        }
        Rectangle clipRect = new Rectangle(clipBounds);
        clipRect.intersectWith(PrEffectHelper.getGraphicsClipNoClone(g));
        if (!curXform.is2D()) {
            Rectangle savedClip = g.getClipRect();
            g.setClipRect(clipRect);
            NodeEffectInput clipInput = new NodeEffectInput(this.getClipNode(), NodeEffectInput.RenderType.FULL_CONTENT);
            NodeEffectInput nodeInput = new NodeEffectInput(this, NodeEffectInput.RenderType.CLIPPED_CONTENT);
            Blend blend = new Blend(Blend.Mode.SRC_IN, clipInput, nodeInput);
            PrEffectHelper.render(blend, g, 0.0f, 0.0f, null);
            clipInput.flush();
            nodeInput.flush();
            g.setClipRect(savedClip);
            this.clearDirtyTree();
            return;
        }
        FilterContext fctx = NGNode.getFilterContext(g);
        PrDrawable contentImg = (PrDrawable)Effect.getCompatibleImage(fctx, clipRect.width, clipRect.height);
        if (contentImg == null) {
            this.clearDirtyTree();
            return;
        }
        Graphics gContentImg = contentImg.createGraphics();
        gContentImg.setExtraAlpha(g.getExtraAlpha());
        gContentImg.setHasPreCullingBits(g.hasPreCullingBits());
        gContentImg.setClipRectIndex(g.getClipRectIndex());
        gContentImg.translate(-clipRect.x, -clipRect.y);
        gContentImg.transform(curXform);
        this.renderForClip(gContentImg);
        PrDrawable clipImg = (PrDrawable)Effect.getCompatibleImage(fctx, clipRect.width, clipRect.height);
        if (clipImg == null) {
            this.getClipNode().clearDirtyTree();
            Effect.releaseCompatibleImage(fctx, contentImg);
            return;
        }
        Graphics gClipImg = clipImg.createGraphics();
        gClipImg.translate(-clipRect.x, -clipRect.y);
        gClipImg.transform(curXform);
        this.getClipNode().render(gClipImg);
        g.setTransform(null);
        Blend blend = new Blend(Blend.Mode.SRC_IN, new PassThrough(clipImg, clipRect), new PassThrough(contentImg, clipRect));
        PrEffectHelper.render(blend, g, 0.0f, 0.0f, null);
        Effect.releaseCompatibleImage(fctx, contentImg);
        Effect.releaseCompatibleImage(fctx, clipImg);
    }

    void renderForClip(Graphics g) {
        if (this.getEffectFilter() != null) {
            this.renderEffect(g);
        } else {
            this.renderContent(g);
        }
    }

    private void renderOpacity(Graphics g) {
        if (this.getEffectFilter() != null || this.getCacheFilter() != null || this.getClipNode() != null || !this.hasOverlappingContents()) {
            float ea = g.getExtraAlpha();
            g.setExtraAlpha(ea * this.getOpacity());
            if (this.getCacheFilter() != null) {
                this.renderCached(g);
            } else if (this.getClipNode() != null) {
                this.renderClip(g);
            } else if (this.getEffectFilter() != null) {
                this.renderEffect(g);
            } else {
                this.renderContent(g);
            }
            g.setExtraAlpha(ea);
            return;
        }
        FilterContext fctx = NGNode.getFilterContext(g);
        BaseTransform curXform = g.getTransformNoClone();
        BaseBounds bounds = this.getContentBounds(new RectBounds(), curXform);
        Rectangle r = new Rectangle(bounds);
        r.intersectWith(PrEffectHelper.getGraphicsClipNoClone(g));
        PrDrawable img = (PrDrawable)Effect.getCompatibleImage(fctx, r.width, r.height);
        if (img == null) {
            return;
        }
        Graphics gImg = img.createGraphics();
        gImg.setHasPreCullingBits(g.hasPreCullingBits());
        gImg.setClipRectIndex(g.getClipRectIndex());
        gImg.translate(-r.x, -r.y);
        gImg.transform(curXform);
        this.renderContent(gImg);
        g.setTransform(null);
        float ea = g.getExtraAlpha();
        g.setExtraAlpha(this.getOpacity() * ea);
        g.drawTexture((Texture)img.getTextureObject(), r.x, r.y, r.width, r.height);
        g.setExtraAlpha(ea);
        Effect.releaseCompatibleImage(fctx, img);
    }

    private void renderCached(Graphics g) {
        if (this.isContentBounds2D() && g.getTransformNoClone().is2D() && !(g instanceof PrinterGraphics)) {
            this.getCacheFilter().render(g);
        } else {
            this.renderContent(g);
        }
    }

    protected void renderEffect(Graphics g) {
        this.getEffectFilter().render(g);
    }

    protected abstract void renderContent(Graphics var1);

    protected abstract boolean hasOverlappingContents();

    boolean isReadbackSupported(Graphics g) {
        return g instanceof ReadbackGraphics && ((ReadbackGraphics)g).canReadBack();
    }

    static FilterContext getFilterContext(Graphics g) {
        Screen s = g.getAssociatedScreen();
        if (s == null) {
            return PrFilterContext.getPrinterContext(g.getResourceFactory());
        }
        return PrFilterContext.getInstance(s);
    }

    public void release() {
    }

    public String toString() {
        return this.name == null ? super.toString() : this.name;
    }

    public void applyTransform(BaseTransform tx, DirtyRegionContainer drc) {
        for (int i = 0; i < drc.size(); ++i) {
            drc.setDirtyRegion(i, (RectBounds)tx.transform(drc.getDirtyRegion(i), drc.getDirtyRegion(i)));
            if (!drc.checkAndClearRegion(i)) continue;
            --i;
        }
    }

    public void applyClip(BaseBounds clipBounds, DirtyRegionContainer drc) {
        for (int i = 0; i < drc.size(); ++i) {
            drc.getDirtyRegion(i).intersectWith(clipBounds);
            if (!drc.checkAndClearRegion(i)) continue;
            --i;
        }
    }

    public void applyEffect(EffectFilter effectFilter, DirtyRegionContainer drc, DirtyRegionPool regionPool) {
        Effect effect = effectFilter.getEffect();
        EffectDirtyBoundsHelper helper = EffectDirtyBoundsHelper.getInstance();
        helper.setInputBounds(this.contentBounds);
        helper.setDirtyRegions(drc);
        DirtyRegionContainer effectDrc = effect.getDirtyRegions(helper, regionPool);
        drc.deriveWithNewContainer(effectDrc);
        regionPool.checkIn(effectDrc);
    }

    static {
        try {
            for (Screen s : Screen.getScreens()) {
                highestPixelScale = Math.max(s.getScale(), highestPixelScale);
            }
        }
        catch (RuntimeException ex) {
            System.err.println("WARNING: unable to get max pixel scale for screens");
            highestPixelScale = 1.0f;
        }
        pipeline = GraphicsPipeline.getPipeline();
        effectsSupported = pipeline == null ? false : pipeline.isEffectSupported();
        TEMP_BOUNDS = new BoxBounds();
        TEMP_RECT_BOUNDS = new RectBounds();
        TEMP_TRANSFORM = new Affine3D();
        TEMP_POINTS2D_4 = new Point2D[]{new Point2D(), new Point2D(), new Point2D(), new Point2D()};
    }

    private static class EffectDirtyBoundsHelper
    extends Effect {
        private BaseBounds bounds;
        private static EffectDirtyBoundsHelper instance = null;
        private DirtyRegionContainer drc;

        private EffectDirtyBoundsHelper() {
        }

        public void setInputBounds(BaseBounds inputBounds) {
            this.bounds = inputBounds;
        }

        @Override
        public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
            if (this.bounds.getBoundsType() == BaseBounds.BoundsType.RECTANGLE) {
                return this.bounds;
            }
            return new RectBounds(this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMaxX(), this.bounds.getMaxY());
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext fctx) {
            return null;
        }

        public static EffectDirtyBoundsHelper getInstance() {
            if (instance == null) {
                instance = new EffectDirtyBoundsHelper();
            }
            return instance;
        }

        @Override
        public boolean reducesOpaquePixels() {
            return true;
        }

        private void setDirtyRegions(DirtyRegionContainer drc) {
            this.drc = drc;
        }

        @Override
        public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
            DirtyRegionContainer ret = regionPool.checkOut();
            ret.deriveWithNewContainer(this.drc);
            return ret;
        }
    }

    private static class PassThrough
    extends Effect {
        private PrDrawable img;
        private Rectangle bounds;

        PassThrough(PrDrawable img, Rectangle bounds) {
            this.img = img;
            this.bounds = bounds;
        }

        @Override
        public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
            this.img.lock();
            ImageData id = new ImageData(fctx, this.img, new Rectangle(this.bounds));
            id.setReusable(true);
            return id;
        }

        @Override
        public RectBounds getBounds(BaseTransform transform, Effect defaultInput) {
            return new RectBounds(this.bounds);
        }

        @Override
        public Effect.AccelType getAccelType(FilterContext fctx) {
            return Effect.AccelType.INTRINSIC;
        }

        @Override
        public boolean reducesOpaquePixels() {
            return false;
        }

        @Override
        public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
            return null;
        }
    }

    protected static enum RenderRootResult {
        NO_RENDER_ROOT,
        HAS_RENDER_ROOT,
        HAS_RENDER_ROOT_AND_IS_CLEAN;

    }

    public static enum DirtyFlag {
        CLEAN,
        DIRTY_BY_TRANSLATION,
        DIRTY;

    }
}

