/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.paint.Paint;
import com.sun.prism.shape.ShapeRep;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public abstract class NGShape
extends NGNode {
    private RTTexture cached3D;
    private double cachedW;
    private double cachedH;
    protected Paint fillPaint;
    protected Paint drawPaint;
    protected BasicStroke drawStroke;
    protected Mode mode = Mode.FILL;
    protected ShapeRep shapeRep;
    static final double THRESHOLD = 0.00390625;

    public void setMode(Mode mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.geometryChanged();
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setSmooth(boolean smooth) {
    }

    public void setFillPaint(Object fillPaint) {
        if (fillPaint != this.fillPaint || this.fillPaint != null && this.fillPaint.isMutable()) {
            this.fillPaint = (Paint)fillPaint;
            this.visualsChanged();
            this.invalidateOpaqueRegion();
        }
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setDrawPaint(Object drawPaint) {
        if (drawPaint != this.drawPaint || this.drawPaint != null && this.drawPaint.isMutable()) {
            this.drawPaint = (Paint)drawPaint;
            this.visualsChanged();
        }
    }

    public void setDrawStroke(BasicStroke drawStroke) {
        if (this.drawStroke != drawStroke) {
            this.drawStroke = drawStroke;
            this.geometryChanged();
        }
    }

    public void setDrawStroke(float strokeWidth, StrokeType strokeType, StrokeLineCap lineCap, StrokeLineJoin lineJoin, float strokeMiterLimit, float[] strokeDashArray, float strokeDashOffset) {
        int type = strokeType == StrokeType.CENTERED ? 0 : (strokeType == StrokeType.INSIDE ? 1 : 2);
        int cap = lineCap == StrokeLineCap.BUTT ? 0 : (lineCap == StrokeLineCap.SQUARE ? 2 : 1);
        int join = lineJoin == StrokeLineJoin.BEVEL ? 2 : (lineJoin == StrokeLineJoin.MITER ? 0 : 1);
        if (this.drawStroke == null) {
            this.drawStroke = new BasicStroke(type, strokeWidth, cap, join, strokeMiterLimit);
        } else {
            this.drawStroke.set(type, strokeWidth, cap, join, strokeMiterLimit);
        }
        if (strokeDashArray.length > 0) {
            this.drawStroke.set(strokeDashArray, strokeDashOffset);
        } else {
            this.drawStroke.set((float[])null, 0.0f);
        }
        this.geometryChanged();
    }

    public abstract Shape getShape();

    protected ShapeRep createShapeRep(Graphics g) {
        return g.getResourceFactory().createPathRep();
    }

    @Override
    protected void visualsChanged() {
        super.visualsChanged();
        if (this.cached3D != null) {
            this.cached3D.dispose();
            this.cached3D = null;
        }
    }

    private static double hypot(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    @Override
    protected void renderContent(Graphics g) {
        boolean needs3D;
        if (this.mode == Mode.EMPTY) {
            return;
        }
        boolean printing = g instanceof PrinterGraphics;
        BaseTransform tx = g.getTransformNoClone();
        boolean bl = needs3D = !tx.is2D();
        if (needs3D) {
            double scaleX = NGShape.hypot(tx.getMxx(), tx.getMyx(), tx.getMzx());
            double scaleY = NGShape.hypot(tx.getMxy(), tx.getMyy(), tx.getMzy());
            double scaledW = scaleX * (double)this.contentBounds.getWidth();
            double scaledH = scaleY * (double)this.contentBounds.getHeight();
            if (this.cached3D != null) {
                this.cached3D.lock();
                if (this.cached3D.isSurfaceLost() || Math.max(Math.abs(scaledW - this.cachedW), Math.abs(scaledH - this.cachedH)) > 0.00390625) {
                    this.cached3D.unlock();
                    this.cached3D.dispose();
                    this.cached3D = null;
                }
            }
            if (this.cached3D == null) {
                int w = (int)Math.ceil(scaledW);
                int h = (int)Math.ceil(scaledH);
                this.cachedW = scaledW;
                this.cachedH = scaledH;
                if (w <= 0 || h <= 0) {
                    return;
                }
                this.cached3D = g.getResourceFactory().createRTTexture(w, h, Texture.WrapMode.CLAMP_TO_ZERO, false);
                this.cached3D.contentsUseful();
                Graphics textureGraphics = this.cached3D.createGraphics();
                textureGraphics.scale((float)scaleX, (float)scaleY);
                textureGraphics.translate(-this.contentBounds.getMinX(), -this.contentBounds.getMinY());
                this.renderContent2D(textureGraphics, printing);
            }
            int rtWidth = this.cached3D.getContentWidth();
            int rtHeight = this.cached3D.getContentHeight();
            float dx0 = this.contentBounds.getMinX();
            float dy0 = this.contentBounds.getMinY();
            float dx1 = dx0 + (float)((double)rtWidth / scaleX);
            float dy1 = dy0 + (float)((double)rtHeight / scaleY);
            g.drawTexture(this.cached3D, dx0, dy0, dx1, dy1, 0.0f, 0.0f, rtWidth, rtHeight);
            this.cached3D.unlock();
        } else {
            if (this.cached3D != null) {
                this.cached3D.dispose();
                this.cached3D = null;
            }
            this.renderContent2D(g, printing);
        }
    }

    protected void renderContent2D(Graphics g, boolean printing) {
        ShapeRep localShapeRep;
        ShapeRep shapeRep = localShapeRep = printing ? null : this.shapeRep;
        if (localShapeRep == null) {
            localShapeRep = this.createShapeRep(g);
        }
        Shape shape = this.getShape();
        if (this.mode != Mode.STROKE) {
            g.setPaint(this.fillPaint);
            localShapeRep.fill(g, shape, this.contentBounds);
        }
        if (this.mode != Mode.FILL && this.drawStroke.getLineWidth() > 0.0f) {
            g.setPaint(this.drawPaint);
            g.setStroke(this.drawStroke);
            localShapeRep.draw(g, shape, this.contentBounds);
        }
        if (!printing) {
            this.shapeRep = localShapeRep;
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return this.mode == Mode.STROKE_FILL;
    }

    protected Shape getStrokeShape() {
        return this.drawStroke.createStrokedShape(this.getShape());
    }

    @Override
    protected void geometryChanged() {
        super.geometryChanged();
        if (this.shapeRep != null) {
            this.shapeRep.invalidate(ShapeRep.InvalidationType.LOCATION_AND_GEOMETRY);
        }
        if (this.cached3D != null) {
            this.cached3D.dispose();
            this.cached3D = null;
        }
    }

    @Override
    protected boolean hasOpaqueRegion() {
        Mode mode = this.getMode();
        Paint fillPaint = this.getFillPaint();
        return super.hasOpaqueRegion() && (mode == Mode.FILL || mode == Mode.STROKE_FILL) && fillPaint != null && fillPaint.isOpaque();
    }

    public static enum Mode {
        EMPTY,
        FILL,
        STROKE,
        STROKE_FILL;

    }
}

