/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$1;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$2;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$3;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$4;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$5;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$6;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler$$Lambda$7;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.WindowStage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

class GlassWindowEventHandler
extends Window.EventHandler
implements PrivilegedAction<Void> {
    private final WindowStage stage;
    private Window window;
    private int type;

    public GlassWindowEventHandler(WindowStage stage) {
        this.stage = stage;
    }

    @Override
    public Void run() {
        if (this.stage == null || this.stage.stageListener == null) {
            return null;
        }
        switch (this.type) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                this.stage.stageListener.changedMaximized(true);
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                this.stage.stageListener.changedMaximized(false);
                break;
            }
            case 512: {
                this.stage.stageListener.changedLocation(this.window.getX(), this.window.getY());
                if (Application.GetApplication().hasWindowManager()) break;
                QuantumToolkit.runWithRenderLock(GlassWindowEventHandler$$Lambda$1.lambdaFactory$(this));
                break;
            }
            case 511: {
                this.stage.stageListener.changedSize(this.window.getWidth(), this.window.getHeight());
                break;
            }
            case 542: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                WindowStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
                break;
            }
            default: {
                if (!QuantumToolkit.verbose) break;
                System.err.println("GlassWindowEventHandler: unknown type: " + this.type);
            }
        }
        return null;
    }

    @Override
    public void handleLevelEvent(int level) {
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$2.lambdaFactory$(this, level));
    }

    @Override
    public void handleWindowEvent(Window window, long time, int type) {
        this.window = window;
        this.type = type;
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$3.lambdaFactory$(this));
    }

    @Override
    public void handleScreenChangedEvent(Window window, long time, Screen oldScreen, Screen newScreen) {
        GlassScene scene = this.stage.getScene();
        if (scene != null) {
            QuantumToolkit.runWithRenderLock(GlassWindowEventHandler$$Lambda$4.lambdaFactory$(scene));
        }
        QuantumToolkit.runWithoutRenderLock(GlassWindowEventHandler$$Lambda$5.lambdaFactory$(this, oldScreen, newScreen));
    }

    /* synthetic */ Void lambda$handleScreenChangedEvent$403(Screen screen, Screen screen2) {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return (Void)AccessController.doPrivileged(GlassWindowEventHandler$$Lambda$6.lambdaFactory$(this, screen, screen2), acc);
    }

    /* synthetic */ Void lambda$null$402(Screen screen, Screen screen2) {
        this.stage.stageListener.changedScreen(screen, screen2);
        return null;
    }

    static /* synthetic */ Object lambda$handleScreenChangedEvent$401(GlassScene glassScene) {
        glassScene.entireSceneNeedsRepaint();
        glassScene.updateSceneState();
        return null;
    }

    /* synthetic */ Void lambda$handleWindowEvent$400() {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return AccessController.doPrivileged(this, acc);
    }

    /* synthetic */ Void lambda$handleLevelEvent$399(int n) {
        AccessControlContext acc = this.stage.getAccessControlContext();
        return (Void)AccessController.doPrivileged(GlassWindowEventHandler$$Lambda$7.lambdaFactory$(this, n), acc);
    }

    /* synthetic */ Void lambda$null$398(int n) {
        this.stage.stageListener.changedAlwaysOnTop(n != 1);
        return null;
    }

    /* synthetic */ Object lambda$run$397() {
        GlassScene scene = this.stage.getScene();
        if (scene != null) {
            scene.updateSceneState();
        }
        return null;
    }
}

