/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PerformanceTrackerHelper$PerformanceTrackerDefaultImpl$$Lambda$1;
import com.sun.prism.impl.PrismSettings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

abstract class PerformanceTrackerHelper {
    private static final PerformanceTrackerHelper instance = PerformanceTrackerHelper.createInstance();

    public static PerformanceTrackerHelper getInstance() {
        return instance;
    }

    private PerformanceTrackerHelper() {
    }

    private static PerformanceTrackerHelper createInstance() {
        PerformanceTrackerHelper trackerImpl = AccessController.doPrivileged(new PrivilegedAction<PerformanceTrackerHelper>(){

            @Override
            public PerformanceTrackerHelper run() {
                try {
                    if (PrismSettings.perfLog != null) {
                        final PerformanceTrackerDefaultImpl trackerImpl = new PerformanceTrackerDefaultImpl();
                        if (PrismSettings.perfLogExitFlush) {
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    trackerImpl.outputLog();
                                }
                            });
                        }
                        return trackerImpl;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        if (trackerImpl == null) {
            trackerImpl = new PerformanceTrackerDummyImpl();
        }
        return trackerImpl;
    }

    public abstract void logEvent(String var1);

    public abstract void outputLog();

    public abstract boolean isPerfLoggingEnabled();

    public final long nanoTime() {
        return Toolkit.getToolkit().getMasterTimer().nanos();
    }

    private static final class PerformanceTrackerDummyImpl
    extends PerformanceTrackerHelper {
        private PerformanceTrackerDummyImpl() {
        }

        @Override
        public void logEvent(String s) {
        }

        @Override
        public void outputLog() {
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return false;
        }
    }

    private static final class PerformanceTrackerDefaultImpl
    extends PerformanceTrackerHelper {
        private long firstTime;
        private long lastTime;
        private final Method logEventMethod;
        private final Method outputLogMethod;
        private final Method getStartTimeMethod;
        private final Method setStartTimeMethod;

        public PerformanceTrackerDefaultImpl() throws ClassNotFoundException, NoSuchMethodException {
            Class<?> perfLoggerClass = Class.forName("sun.misc.PerformanceLogger", true, null);
            this.logEventMethod = perfLoggerClass.getMethod("setTime", String.class);
            this.outputLogMethod = perfLoggerClass.getMethod("outputLog", new Class[0]);
            this.getStartTimeMethod = perfLoggerClass.getMethod("getStartTime", new Class[0]);
            this.setStartTimeMethod = perfLoggerClass.getMethod("setStartTime", String.class, Long.TYPE);
        }

        @Override
        public void logEvent(String s) {
            long time = System.currentTimeMillis();
            if (this.firstTime == 0L) {
                this.firstTime = time;
            }
            try {
                this.logEventMethod.invoke(null, "JavaFX> " + s + " (" + (time - this.firstTime) + "ms total, " + (time - this.lastTime) + "ms)");
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            this.lastTime = time;
        }

        @Override
        public void outputLog() {
            this.logLaunchTime();
            try {
                this.outputLogMethod.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return true;
        }

        private void logLaunchTime() {
            try {
                String launchTimeString;
                if ((Long)this.getStartTimeMethod.invoke(null, new Object[0]) <= 0L && (launchTimeString = (String)AccessController.doPrivileged(PerformanceTrackerHelper$PerformanceTrackerDefaultImpl$$Lambda$1.lambdaFactory$())) != null && !launchTimeString.equals("")) {
                    long launchTime = Long.parseLong(launchTimeString);
                    this.setStartTimeMethod.invoke(null, "LaunchTime", launchTime);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        static /* synthetic */ String lambda$logLaunchTime$404() {
            return System.getProperty("launchTime");
        }
    }
}

