/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumRenderer$$Lambda$1;
import com.sun.javafx.tk.quantum.QuantumRenderer$$Lambda$2;
import com.sun.javafx.tk.quantum.QuantumRenderer$$Lambda$3;
import com.sun.javafx.tk.quantum.QuantumRenderer$$Lambda$4;
import com.sun.javafx.tk.quantum.QuantumRenderer$$Lambda$5;
import com.sun.javafx.tk.quantum.QuantumRenderer$QuantumThreadFactory$$Lambda$1;
import com.sun.javafx.tk.quantum.QuantumRenderer$QuantumThreadFactory$$Lambda$2;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class QuantumRenderer
extends ThreadPoolExecutor {
    private static boolean usePurgatory = (Boolean)AccessController.doPrivileged(QuantumRenderer$$Lambda$5.lambdaFactory$());
    private static final AtomicReference<QuantumRenderer> instanceReference = new AtomicReference<Object>(null);
    private Thread _renderer;
    private Throwable _initThrowable = null;
    private CountDownLatch initLatch = new CountDownLatch(1);

    private QuantumRenderer() {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(new QuantumThreadFactory());
    }

    protected Throwable initThrowable() {
        return this._initThrowable;
    }

    private void setInitThrowable(Throwable th) {
        this._initThrowable = th;
    }

    protected void createResourceFactory() {
        CountDownLatch createLatch = new CountDownLatch(1);
        CompletionListener createDone = QuantumRenderer$$Lambda$1.lambdaFactory$(createLatch);
        Runnable factoryCreator = QuantumRenderer$$Lambda$2.lambdaFactory$();
        RenderJob job = new RenderJob(factoryCreator, createDone);
        this.submit(job);
        try {
            createLatch.await();
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
    }

    protected void disposePresentable(Presentable presentable) {
        assert (!Thread.currentThread().equals(this._renderer));
        if (presentable instanceof GraphicsResource) {
            GraphicsResource resource = (GraphicsResource)((Object)presentable);
            Runnable presentableDisposer = QuantumRenderer$$Lambda$3.lambdaFactory$(resource);
            RenderJob job = new RenderJob(presentableDisposer, null);
            this.submit(job);
        }
    }

    protected void stopRenderer() {
        AccessController.doPrivileged(QuantumRenderer$$Lambda$4.lambdaFactory$(this));
        if (PrismSettings.verbose) {
            System.out.println("QuantumRenderer: shutdown");
        }
        assert (this.isShutdown());
        instanceReference.set(null);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return (RenderJob)runnable;
    }

    protected Future submitRenderJob(RenderJob r) {
        return this.submit(r);
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (usePurgatory) {
            Screen screen = Screen.getMainScreen();
            Renderer renderer = Renderer.getRenderer(PrFilterContext.getInstance(screen));
            renderer.releasePurgatory();
        }
    }

    void checkRendererIdle() {
        if (PrismSettings.threadCheck) {
            boolean busy;
            PaintCollector collector = PaintCollector.getInstance();
            boolean bl = busy = ViewPainter.renderLock.isLocked() && !ViewPainter.renderLock.isHeldByCurrentThread();
            if (busy) {
                System.err.println("ERROR: PrismPen / FX threads co-running: DIRTY: " + collector.hasDirty());
                for (StackTraceElement s : QuantumToolkit.getFxUserThread().getStackTrace()) {
                    System.err.println("FX: " + s);
                }
                for (StackTraceElement q : this._renderer.getStackTrace()) {
                    System.err.println("QR: " + q);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized QuantumRenderer getInstance() {
        if (instanceReference.get() != null) return instanceReference.get();
        Class<QuantumRenderer> clazz = QuantumRenderer.class;
        synchronized (QuantumRenderer.class) {
            QuantumRenderer newTk;
            block7: {
                newTk = null;
                try {
                    newTk = new QuantumRenderer();
                    newTk.prestartCoreThread();
                    newTk.initLatch.await();
                }
                catch (Throwable t) {
                    if (newTk != null) {
                        newTk.setInitThrowable(t);
                    }
                    if (!PrismSettings.verbose) break block7;
                    t.printStackTrace();
                }
            }
            if (newTk != null && newTk.initThrowable() != null) {
                if (!PrismSettings.noFallback) throw new RuntimeException(newTk.initThrowable());
                System.err.println("Cannot initialize a graphics pipeline, and Prism fallback is disabled");
                throw new InternalError("Could not initialize prism toolkit, and the fallback is disabled.");
            }
            instanceReference.set(newTk);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instanceReference.get();
        }
    }

    /* synthetic */ Void lambda$stopRenderer$393() {
        this.shutdown();
        return null;
    }

    static /* synthetic */ void lambda$disposePresentable$392(GraphicsResource graphicsResource) {
        graphicsResource.dispose();
    }

    static /* synthetic */ void lambda$createResourceFactory$391() {
        ResourceFactory factory = GraphicsPipeline.getDefaultResourceFactory();
        assert (factory != null);
    }

    static /* synthetic */ void lambda$createResourceFactory$390(CountDownLatch countDownLatch, RenderJob job) {
        countDownLatch.countDown();
    }

    static /* synthetic */ Boolean lambda$static$387() {
        return Boolean.getBoolean("decora.purgatory");
    }

    private class QuantumThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(0);

        private QuantumThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            PipelineRunnable pipeline = new PipelineRunnable(r);
            QuantumRenderer.this._renderer = (Thread)AccessController.doPrivileged(QuantumRenderer$QuantumThreadFactory$$Lambda$1.lambdaFactory$(this, pipeline));
            assert (this.threadNumber.get() == 1);
            return QuantumRenderer.this._renderer;
        }

        /* synthetic */ Thread lambda$newThread$389(PipelineRunnable pipelineRunnable) {
            Thread th = new Thread(pipelineRunnable);
            th.setName("QuantumRenderer-" + this.threadNumber.getAndIncrement());
            th.setDaemon(true);
            th.setUncaughtExceptionHandler(QuantumRenderer$QuantumThreadFactory$$Lambda$2.lambdaFactory$());
            return th;
        }

        static /* synthetic */ void lambda$null$388(Thread t, Throwable thr) {
            System.err.println(t.getName() + " uncaught: " + thr.getClass().getName());
            thr.printStackTrace();
        }
    }

    private class PipelineRunnable
    implements Runnable {
        private Runnable work;

        public PipelineRunnable(Runnable runner) {
            this.work = runner;
        }

        public void init() {
            try {
                if (GraphicsPipeline.createPipeline() == null) {
                    String MSG = "Error initializing QuantumRenderer: no suitable pipeline found";
                    System.err.println(MSG);
                    throw new RuntimeException(MSG);
                }
                HashMap<Object, Boolean> device = GraphicsPipeline.getPipeline().getDeviceDetails();
                if (device == null) {
                    device = new HashMap<Object, Boolean>();
                }
                device.put(View.Capability.kHiDPIAwareKey, PrismSettings.allowHiDPIScaling);
                Map map = Application.getDeviceDetails();
                if (map != null) {
                    device.putAll(map);
                }
                Application.setDeviceDetails(device);
            }
            catch (Throwable th) {
                QuantumRenderer.this.setInitThrowable(th);
            }
            finally {
                QuantumRenderer.this.initLatch.countDown();
            }
        }

        public void cleanup() {
            GraphicsPipeline pipeline = GraphicsPipeline.getPipeline();
            if (pipeline != null) {
                pipeline.dispose();
            }
        }

        @Override
        public void run() {
            try {
                this.init();
                this.work.run();
            }
            finally {
                this.cleanup();
            }
        }
    }
}

