/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.GestureRecognizer;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$1;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$2;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$3;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$4;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$5;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer$$Lambda$6;
import com.sun.javafx.tk.quantum.ViewScene;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.event.ActionEvent;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;

class ScrollGestureRecognizer
implements GestureRecognizer {
    private static double SCROLL_THRESHOLD = 10.0;
    private static boolean SCROLL_INERTIA_ENABLED = true;
    private static double MAX_INITIAL_VELOCITY = 1000.0;
    private static double SCROLL_INERTIA_MILLIS = 1500.0;
    private ViewScene scene;
    private ScrollRecognitionState state = ScrollRecognitionState.IDLE;
    private Timeline inertiaTimeline = new Timeline();
    private DoubleProperty inertiaScrollVelocity = new SimpleDoubleProperty();
    private double initialInertiaScrollVelocity = 0.0;
    private double scrollStartTime = 0.0;
    private double lastTouchEventTime = 0.0;
    private Map<Long, TouchPointTracker> trackers = new HashMap<Long, TouchPointTracker>();
    private int modifiers;
    private boolean direct;
    private int currentTouchCount = 0;
    private int lastTouchCount;
    private boolean touchPointsSetChanged;
    private boolean touchPointsPressed;
    private double centerX;
    private double centerY;
    private double centerAbsX;
    private double centerAbsY;
    private double lastCenterAbsX;
    private double lastCenterAbsY;
    private double deltaX;
    private double deltaY;
    private double totalDeltaX;
    private double totalDeltaY;
    private double factorX;
    private double factorY;
    double inertiaLastTime = 0.0;

    ScrollGestureRecognizer(ViewScene scene) {
        this.scene = scene;
        this.inertiaScrollVelocity.addListener(ScrollGestureRecognizer$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public void notifyBeginTouchEvent(long time, int modifiers, boolean isDirect, int touchEventCount) {
        this.params(modifiers, isDirect);
        this.touchPointsSetChanged = false;
        this.touchPointsPressed = false;
    }

    @Override
    public void notifyNextTouchEvent(long time, int type, long touchId, int x, int y, int xAbs, int yAbs) {
        switch (type) {
            case 811: {
                this.touchPointsSetChanged = true;
                this.touchPointsPressed = true;
                this.touchPressed(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 814: {
                break;
            }
            case 812: {
                this.touchMoved(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            case 813: {
                this.touchPointsSetChanged = true;
                this.touchReleased(touchId, time, x, y, xAbs, yAbs);
                break;
            }
            default: {
                throw new RuntimeException("Error in Scroll gesture recognition: unknown touch state: " + (Object)((Object)this.state));
            }
        }
    }

    private void calculateCenter() {
        if (this.currentTouchCount <= 0) {
            throw new RuntimeException("Error in Scroll gesture recognition: touch count is zero!");
        }
        double totalX = 0.0;
        double totalY = 0.0;
        double totalAbsX = 0.0;
        double totalAbsY = 0.0;
        for (TouchPointTracker tracker : this.trackers.values()) {
            totalX += tracker.getX();
            totalY += tracker.getY();
            totalAbsX += tracker.getAbsX();
            totalAbsY += tracker.getAbsY();
        }
        this.centerX = totalX / (double)this.currentTouchCount;
        this.centerY = totalY / (double)this.currentTouchCount;
        this.centerAbsX = totalAbsX / (double)this.currentTouchCount;
        this.centerAbsY = totalAbsY / (double)this.currentTouchCount;
    }

    @Override
    public void notifyEndTouchEvent(long time) {
        this.lastTouchEventTime = time;
        if (this.currentTouchCount != this.trackers.size()) {
            throw new RuntimeException("Error in Scroll gesture recognition: touch count is wrong: " + this.currentTouchCount);
        }
        if (this.currentTouchCount < 1) {
            if (this.state == ScrollRecognitionState.ACTIVE) {
                this.sendScrollFinishedEvent(this.lastCenterAbsX, this.lastCenterAbsY, this.lastTouchCount);
                if (SCROLL_INERTIA_ENABLED) {
                    double timeFromLastScroll = ((double)time - this.scrollStartTime) / 1000000.0;
                    if (timeFromLastScroll < 300.0) {
                        this.state = ScrollRecognitionState.INERTIA;
                        this.inertiaLastTime = 0.0;
                        if (this.initialInertiaScrollVelocity > MAX_INITIAL_VELOCITY) {
                            this.initialInertiaScrollVelocity = MAX_INITIAL_VELOCITY;
                        }
                        this.inertiaTimeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.millis(0.0), new KeyValue(this.inertiaScrollVelocity, this.initialInertiaScrollVelocity, Interpolator.LINEAR)), new KeyFrame(Duration.millis(SCROLL_INERTIA_MILLIS * Math.abs(this.initialInertiaScrollVelocity) / MAX_INITIAL_VELOCITY), ScrollGestureRecognizer$$Lambda$2.lambdaFactory$(this), new KeyValue(this.inertiaScrollVelocity, 0, Interpolator.LINEAR))});
                        this.inertiaTimeline.playFromStart();
                    } else {
                        this.reset();
                    }
                } else {
                    this.reset();
                }
            }
        } else {
            this.calculateCenter();
            if (this.touchPointsPressed && this.state == ScrollRecognitionState.INERTIA) {
                this.inertiaTimeline.stop();
                this.reset();
            }
            if (this.touchPointsSetChanged) {
                if (this.state == ScrollRecognitionState.IDLE) {
                    this.state = ScrollRecognitionState.TRACKING;
                }
                if (this.state == ScrollRecognitionState.ACTIVE) {
                    this.sendScrollFinishedEvent(this.lastCenterAbsX, this.lastCenterAbsY, this.lastTouchCount);
                    this.totalDeltaX = 0.0;
                    this.totalDeltaY = 0.0;
                    this.sendScrollStartedEvent(this.centerAbsX, this.centerAbsY, this.currentTouchCount);
                }
                this.lastTouchCount = this.currentTouchCount;
                this.lastCenterAbsX = this.centerAbsX;
                this.lastCenterAbsY = this.centerAbsY;
            } else {
                this.deltaX = this.centerAbsX - this.lastCenterAbsX;
                this.deltaY = this.centerAbsY - this.lastCenterAbsY;
                if (this.state == ScrollRecognitionState.TRACKING && (Math.abs(this.deltaX) > SCROLL_THRESHOLD || Math.abs(this.deltaY) > SCROLL_THRESHOLD)) {
                    this.state = ScrollRecognitionState.ACTIVE;
                    this.sendScrollStartedEvent(this.centerAbsX, this.centerAbsY, this.currentTouchCount);
                }
                if (this.state == ScrollRecognitionState.ACTIVE) {
                    this.totalDeltaX += this.deltaX;
                    this.totalDeltaY += this.deltaY;
                    this.sendScrollEvent(false, this.centerAbsX, this.centerAbsY, this.currentTouchCount);
                    double timePassed = ((double)time - this.scrollStartTime) / 1.0E9;
                    if (timePassed > 1.0E-4) {
                        double scrollMagnitude = Math.sqrt(this.deltaX * this.deltaX + this.deltaY * this.deltaY);
                        this.factorX = this.deltaX / scrollMagnitude;
                        this.factorY = this.deltaY / scrollMagnitude;
                        this.initialInertiaScrollVelocity = scrollMagnitude / timePassed;
                        this.scrollStartTime = time;
                    }
                    this.lastCenterAbsX = this.centerAbsX;
                    this.lastCenterAbsY = this.centerAbsY;
                }
            }
        }
    }

    private void sendScrollStartedEvent(double centerX, double centerY, int touchCount) {
        AccessController.doPrivileged(ScrollGestureRecognizer$$Lambda$3.lambdaFactory$(this, touchCount, centerX, centerY), this.scene.getAccessControlContext());
    }

    private void sendScrollEvent(boolean isInertia, double centerX, double centerY, int touchCount) {
        AccessController.doPrivileged(ScrollGestureRecognizer$$Lambda$4.lambdaFactory$(this, touchCount, centerX, centerY, isInertia), this.scene.getAccessControlContext());
    }

    private void sendScrollFinishedEvent(double centerX, double centerY, int touchCount) {
        AccessController.doPrivileged(ScrollGestureRecognizer$$Lambda$5.lambdaFactory$(this, touchCount, centerX, centerY), this.scene.getAccessControlContext());
    }

    public void params(int modifiers, boolean direct) {
        this.modifiers = modifiers;
        this.direct = direct;
    }

    public void touchPressed(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        ++this.currentTouchCount;
        TouchPointTracker tracker = new TouchPointTracker();
        tracker.update(nanos, x, y, xAbs, yAbs);
        this.trackers.put(id, tracker);
    }

    public void touchReleased(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state != ScrollRecognitionState.FAILURE) {
            TouchPointTracker tracker = this.trackers.get(id);
            if (tracker == null) {
                this.state = ScrollRecognitionState.FAILURE;
                throw new RuntimeException("Error in Scroll gesture recognition: released unknown touch point");
            }
            this.trackers.remove(id);
        }
        --this.currentTouchCount;
    }

    public void touchMoved(long id, long nanos, int x, int y, int xAbs, int yAbs) {
        if (this.state == ScrollRecognitionState.FAILURE) {
            return;
        }
        TouchPointTracker tracker = this.trackers.get(id);
        if (tracker == null) {
            this.state = ScrollRecognitionState.FAILURE;
            throw new RuntimeException("Error in scroll gesture recognition: reported unknown touch point");
        }
        tracker.update(nanos, x, y, xAbs, yAbs);
    }

    void reset() {
        this.state = ScrollRecognitionState.IDLE;
        this.totalDeltaX = 0.0;
        this.totalDeltaY = 0.0;
    }

    /* synthetic */ Void lambda$sendScrollFinishedEvent$420(int n, double d, double d2) {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL_FINISHED, 0.0, 0.0, this.totalDeltaX, this.totalDeltaY, 1.0, 1.0, n, 0, 0, 0, 0, d, d2, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
        }
        return null;
    }

    /* synthetic */ Void lambda$sendScrollEvent$419(int n, double d, double d2, boolean bl) {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, this.deltaX, this.deltaY, this.totalDeltaX, this.totalDeltaY, 1.0, 1.0, n, 0, 0, 0, 0, d, d2, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, bl);
        }
        return null;
    }

    /* synthetic */ Void lambda$sendScrollStartedEvent$418(int n, double d, double d2) {
        if (this.scene.sceneListener != null) {
            this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL_STARTED, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, n, 0, 0, 0, 0, d, d2, this.centerAbsX, this.centerAbsY, (this.modifiers & 1) != 0, (this.modifiers & 4) != 0, (this.modifiers & 8) != 0, (this.modifiers & 0x10) != 0, this.direct, false);
        }
        return null;
    }

    /* synthetic */ void lambda$notifyEndTouchEvent$417(ActionEvent event) {
        this.reset();
    }

    /* synthetic */ void lambda$new$416(Observable valueModel) {
        double currentTime = this.inertiaTimeline.getCurrentTime().toSeconds();
        double timePassed = currentTime - this.inertiaLastTime;
        this.inertiaLastTime = currentTime;
        double scrollVectorSize = timePassed * this.inertiaScrollVelocity.get();
        this.deltaX = scrollVectorSize * this.factorX;
        this.totalDeltaX += this.deltaX;
        this.deltaY = scrollVectorSize * this.factorY;
        this.totalDeltaY += this.deltaY;
        this.sendScrollEvent(true, this.centerAbsX, this.centerAbsY, this.currentTouchCount);
    }

    static /* synthetic */ Void lambda$static$415() {
        String s = System.getProperty("com.sun.javafx.gestures.scroll.threshold");
        if (s != null) {
            SCROLL_THRESHOLD = Double.valueOf(s);
        }
        if ((s = System.getProperty("com.sun.javafx.gestures.scroll.inertia")) != null) {
            SCROLL_INERTIA_ENABLED = Boolean.valueOf(s);
        }
        return null;
    }

    static {
        AccessController.doPrivileged(ScrollGestureRecognizer$$Lambda$6.lambdaFactory$());
    }

    private static enum ScrollRecognitionState {
        IDLE,
        TRACKING,
        ACTIVE,
        INERTIA,
        FAILURE;

    }

    private static class TouchPointTracker {
        double x;
        double y;
        double absX;
        double absY;

        private TouchPointTracker() {
        }

        public void update(long nanos, double x, double y, double absX, double absY) {
            this.x = x;
            this.y = y;
            this.absX = absX;
            this.absY = absY;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getAbsX() {
            return this.absX;
        }

        public double getAbsY() {
            return this.absY;
        }
    }
}

