/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.QueuedPixelSource;
import java.nio.IntBuffer;

final class UploadingPainter
extends ViewPainter
implements Runnable {
    private RTTexture rttexture;
    private RTTexture resolveRTT = null;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(true);
    private float penScale;
    private volatile float pixScaleFactor = 1.0f;

    UploadingPainter(GlassScene view) {
        super(view);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
        if (this.resolveRTT != null) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
    }

    public void setPixelScaleFactor(float scale) {
        this.pixScaleFactor = scale;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean errored = false;
        try {
            Graphics g;
            boolean needsReset;
            if (!this.validateStageGraphics()) {
                if (QuantumToolkit.verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                return;
            }
            float scale = this.pixScaleFactor;
            int bufWidth = Math.round((float)this.viewWidth * scale);
            int bufHeight = Math.round((float)this.viewHeight * scale);
            boolean bl = needsReset = this.penScale != scale || this.penWidth != this.viewWidth || this.penHeight != this.viewHeight || this.rttexture == null;
            if (!needsReset) {
                this.rttexture.lock();
                if (this.rttexture.isSurfaceLost()) {
                    this.rttexture.unlock();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    needsReset = true;
                }
            }
            if (needsReset) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(bufWidth, bufHeight, Texture.WrapMode.CLAMP_NOT_NEEDED, this.sceneState.isMSAA());
                if (this.rttexture == null) {
                    return;
                }
                this.penScale = scale;
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.freshBackBuffer = true;
            }
            if ((g = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            g.scale(scale, scale);
            this.paintImpl(g);
            this.freshBackBuffer = false;
            Pixels pix = this.pixelSource.getUnusedPixels(bufWidth, bufHeight, scale);
            IntBuffer bits = (IntBuffer)pix.getPixels();
            int[] rawbits = this.rttexture.getPixels();
            if (rawbits != null) {
                bits.put(rawbits, 0, bufWidth * bufHeight);
            } else {
                RTTexture rtt;
                RTTexture rTTexture = rtt = this.rttexture.isMSAA() ? this.resolveRenderTarget(g) : this.rttexture;
                if (!rtt.readPixels(bits)) {
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    this.disposeRTTexture();
                    pix = null;
                }
            }
            if (this.rttexture != null) {
                this.rttexture.unlock();
            }
            if (pix != null) {
                this.pixelSource.enqueuePixels(pix);
                this.sceneState.uploadPixels(this.pixelSource);
            }
        }
        catch (Throwable th) {
            errored = true;
            th.printStackTrace(System.err);
        }
        finally {
            if (this.rttexture != null && this.rttexture.isLocked()) {
                this.rttexture.unlock();
            }
            if (this.resolveRTT != null && this.resolveRTT.isLocked()) {
                this.resolveRTT.unlock();
            }
            Disposer.cleanUp();
            this.sceneState.getScene().setPainting(false);
            if (this.factory != null) {
                this.factory.getTextureResourcePool().freeDisposalRequestedAndCheckResources(errored);
            }
            renderLock.unlock();
        }
    }

    private RTTexture resolveRenderTarget(Graphics g) {
        int width = this.rttexture.getContentWidth();
        int height = this.rttexture.getContentHeight();
        if (this.resolveRTT != null && (this.resolveRTT.getContentWidth() != width || this.resolveRTT.getContentHeight() != height)) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
        if (this.resolveRTT == null || this.resolveRTT.isSurfaceLost()) {
            this.resolveRTT = g.getResourceFactory().createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED, false);
        } else {
            this.resolveRTT.lock();
        }
        g.blit(this.rttexture, this.resolveRTT, 0, 0, width, height, 0, 0, width, height);
        return this.resolveRTT;
    }
}

