/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.gstreamer;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMedia;
import com.sun.media.jfxmediaimpl.platform.gstreamer.GSTMediaPlayer;

public final class GSTPlatform
extends Platform {
    private static final String[] CONTENT_TYPES = new String[]{"audio/x-aiff", "audio/mp3", "audio/mpeg", "audio/x-wav", "video/x-javafx", "video/x-flv", "video/x-fxm", "video/mp4", "audio/x-m4a", "video/x-m4v", "application/vnd.apple.mpegurl", "audio/mpegurl"};
    private static GSTPlatform globalInstance = null;
    private static final String[] contentTypes;

    @Override
    public boolean loadPlatform() {
        MediaError ret;
        try {
            ret = MediaError.getFromCode(GSTPlatform.gstInitPlatform());
        }
        catch (UnsatisfiedLinkError ule) {
            ret = MediaError.ERROR_MANAGER_ENGINEINIT_FAIL;
        }
        if (ret != MediaError.ERROR_NONE) {
            MediaUtils.nativeError(GSTPlatform.class, ret);
        }
        return true;
    }

    public static synchronized Platform getPlatformInstance() {
        if (null == globalInstance) {
            globalInstance = new GSTPlatform();
        }
        return globalInstance;
    }

    private GSTPlatform() {
    }

    @Override
    public String[] getSupportedContentTypes() {
        String[] contentTypesCopy = new String[contentTypes.length];
        System.arraycopy(contentTypes, 0, contentTypesCopy, 0, contentTypes.length);
        return contentTypesCopy;
    }

    @Override
    public Media createMedia(Locator source) {
        return new GSTMedia(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaPlayer createMediaPlayer(Locator source) {
        String contentType;
        GSTMediaPlayer player;
        try {
            player = new GSTMediaPlayer(source);
        }
        catch (Exception e) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "GSTPlatform caught exception while creating media player: " + e);
            }
            return null;
        }
        if (HostUtils.isMacOSX() && ("video/mp4".equals(contentType = source.getContentType()) || "video/x-m4v".equals(contentType) || source.getStringLocation().endsWith(".m3u8"))) {
            long timeout = source.getURI().getScheme().equals("http") ? 60000L : 5000L;
            long iterationTime = 50L;
            long timeWaited = 0L;
            Object lock = new Object();
            PlayerStateEvent.PlayerState state = player.getState();
            while (timeWaited < timeout && (state == PlayerStateEvent.PlayerState.UNKNOWN || state == PlayerStateEvent.PlayerState.STALLED)) {
                try {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(50L);
                        timeWaited += 50L;
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                state = player.getState();
            }
            if (player.getState() != PlayerStateEvent.PlayerState.READY) {
                player.dispose();
                player = null;
            }
        }
        return player;
    }

    private static native int gstInitPlatform();

    static {
        if (!HostUtils.isMacOSX()) {
            contentTypes = new String[CONTENT_TYPES.length];
            System.arraycopy(CONTENT_TYPES, 0, contentTypes, 0, CONTENT_TYPES.length);
        } else {
            contentTypes = CONTENT_TYPES;
        }
    }
}

