/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl.platform.osx;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.platform.Platform;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMedia;
import com.sun.media.jfxmediaimpl.platform.osx.OSXMediaPlayer;
import com.sun.media.jfxmediaimpl.platform.osx.OSXPlatform$OSXPlatformInitializer$$Lambda$1;
import java.security.AccessController;

public final class OSXPlatform
extends Platform {
    private static final String[] CONTENT_TYPES = new String[]{"audio/x-aiff", "audio/mp3", "audio/mpeg", "audio/x-m4a", "video/mp4", "video/x-m4v", "application/vnd.apple.mpegurl", "audio/mpegurl"};

    public static Platform getPlatformInstance() {
        return OSXPlatformInitializer.globalInstance;
    }

    private OSXPlatform() {
    }

    @Override
    public boolean loadPlatform() {
        if (!HostUtils.isMacOSX()) {
            return false;
        }
        try {
            return OSXPlatform.osxPlatformInit();
        }
        catch (UnsatisfiedLinkError ule) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Unable to load OSX platform.");
            }
            return false;
        }
    }

    @Override
    public String[] getSupportedContentTypes() {
        String[] contentTypesCopy = new String[CONTENT_TYPES.length];
        System.arraycopy(CONTENT_TYPES, 0, contentTypesCopy, 0, CONTENT_TYPES.length);
        return contentTypesCopy;
    }

    @Override
    public Media createMedia(Locator source) {
        return new OSXMedia(source);
    }

    @Override
    public MediaPlayer createMediaPlayer(Locator source) {
        try {
            return new OSXMediaPlayer(source);
        }
        catch (Exception ex) {
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "OSXPlatform caught exception while creating media player: " + ex);
                ex.printStackTrace();
            }
            return null;
        }
    }

    private static native boolean osxPlatformInit();

    private static final class OSXPlatformInitializer {
        private static final OSXPlatform globalInstance;

        private OSXPlatformInitializer() {
        }

        static /* synthetic */ Boolean lambda$static$9() {
            boolean avf = false;
            boolean qtk = false;
            try {
                NativeLibLoader.loadLibrary("jfxmedia_avf");
                avf = true;
            }
            catch (UnsatisfiedLinkError ule) {
                // empty catch block
            }
            try {
                NativeLibLoader.loadLibrary("jfxmedia_qtkit");
                qtk = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            return avf || qtk;
        }

        static {
            boolean isLoaded = false;
            try {
                isLoaded = (Boolean)AccessController.doPrivileged(OSXPlatform$OSXPlatformInitializer$$Lambda$1.lambdaFactory$());
            }
            catch (Exception exception) {
                // empty catch block
            }
            globalInstance = isLoaded ? new OSXPlatform() : null;
        }
    }
}

