/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Mesh;
import com.sun.prism.es2.ES2MeshView;
import com.sun.prism.es2.ES2PhongMaterial;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2RTTexture;
import com.sun.prism.es2.ES2Shader;
import com.sun.prism.es2.ES2SwapChain;
import com.sun.prism.es2.ES2Texture;
import com.sun.prism.es2.ES2VramPool;
import com.sun.prism.es2.GLFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ES2ResourceFactory
extends BaseShaderFactory {
    private ES2Context context;
    private final int maxTextureSize;

    ES2ResourceFactory(Screen screen) {
        this.context = new ES2Context(screen, this);
        this.maxTextureSize = this.computeMaxTextureSize();
        if (PrismSettings.verbose) {
            int maxVC;
            int maxFUC;
            int maxVUC;
            System.out.println("Non power of two texture support = " + this.context.getGLContext().canCreateNonPowTwoTextures());
            System.out.println("Maximum number of vertex attributes = " + this.context.getGLContext().getIntParam(124));
            if (PlatformUtil.isEmbedded()) {
                maxVUC = this.context.getGLContext().getIntParam(129) * 4;
                maxFUC = this.context.getGLContext().getIntParam(121) * 4;
                maxVC = this.context.getGLContext().getIntParam(126) * 4;
            } else {
                maxVUC = this.context.getGLContext().getIntParam(128);
                maxFUC = this.context.getGLContext().getIntParam(120);
                maxVC = this.context.getGLContext().getIntParam(125);
            }
            System.out.println("Maximum number of uniform vertex components = " + maxVUC);
            System.out.println("Maximum number of uniform fragment components = " + maxFUC);
            System.out.println("Maximum number of varying components = " + maxVC);
            System.out.println("Maximum number of texture units usable in a vertex shader = " + this.context.getGLContext().getIntParam(127));
            System.out.println("Maximum number of texture units usable in a fragment shader = " + this.context.getGLContext().getIntParam(122));
        }
    }

    @Override
    public TextureResourcePool getTextureResourcePool() {
        return ES2VramPool.instance;
    }

    @Override
    public Presentable createPresentable(PresentableState pState) {
        return new ES2SwapChain(this.context, pState);
    }

    @Override
    public boolean isCompatibleTexture(Texture tex) {
        return tex instanceof ES2Texture;
    }

    @Override
    protected boolean canClampToZero() {
        return this.context.getGLContext().canClampToZero();
    }

    @Override
    protected boolean canRepeat() {
        return this.context.getGLContext().canCreateNonPowTwoTextures();
    }

    @Override
    protected boolean canClampToEdge() {
        return this.context.getGLContext().canCreateNonPowTwoTextures();
    }

    @Override
    public Texture createTexture(PixelFormat formatHint, Texture.Usage usageHint, Texture.WrapMode wrapMode, int w, int h) {
        return this.createTexture(formatHint, usageHint, wrapMode, w, h, false);
    }

    @Override
    public Texture createTexture(PixelFormat formatHint, Texture.Usage usageHint, Texture.WrapMode wrapMode, int w, int h, boolean useMipmap) {
        return ES2Texture.create(this.context, formatHint, wrapMode, w, h, useMipmap);
    }

    @Override
    public Texture createTexture(MediaFrame frame) {
        return ES2Texture.create(this.context, frame);
    }

    @Override
    public int getRTTWidth(int w, Texture.WrapMode wrapMode) {
        return ES2RTTexture.getCompatibleDimension(this.context, w, wrapMode);
    }

    @Override
    public int getRTTHeight(int h, Texture.WrapMode wrapMode) {
        return ES2RTTexture.getCompatibleDimension(this.context, h, wrapMode);
    }

    @Override
    public RTTexture createRTTexture(int width, int height, Texture.WrapMode wrapMode) {
        return this.createRTTexture(width, height, wrapMode, false);
    }

    @Override
    public RTTexture createRTTexture(int width, int height, Texture.WrapMode wrapMode, boolean msaa) {
        return ES2RTTexture.create(this.context, width, height, wrapMode, msaa);
    }

    @Override
    public boolean isFormatSupported(PixelFormat format) {
        GLFactory glFactory = ES2Pipeline.glFactory;
        switch (format) {
            case BYTE_RGB: 
            case BYTE_GRAY: 
            case BYTE_ALPHA: 
            case MULTI_YCbCr_420: {
                return true;
            }
            case BYTE_BGRA_PRE: 
            case INT_ARGB_PRE: {
                if (glFactory.isGL2() || PlatformUtil.isIOS()) {
                    return true;
                }
                return glFactory.isGLExtensionSupported("GL_EXT_texture_format_BGRA8888");
            }
            case FLOAT_XYZW: {
                return glFactory.isGL2();
            }
            case BYTE_APPLE_422: {
                return glFactory.isGLExtensionSupported("GL_APPLE_ycbcr_422");
            }
        }
        return false;
    }

    private int computeMaxTextureSize() {
        int size = this.context.getGLContext().getMaxTextureSize();
        if (PrismSettings.verbose) {
            System.out.println("Maximum supported texture size: " + size);
        }
        if (size > PrismSettings.maxTextureSize) {
            size = PrismSettings.maxTextureSize;
            if (PrismSettings.verbose) {
                System.out.println("Maximum texture size clamped to " + size);
            }
        }
        return size;
    }

    @Override
    public int getMaximumTextureSize() {
        return this.maxTextureSize;
    }

    @Override
    public Shader createShader(InputStream pixelShaderCode, Map<String, Integer> samplers, Map<String, Integer> params, int maxTexCoordIndex, boolean isPixcoordUsed, boolean isPerVertexColorUsed) {
        Map<String, Integer> attributes = this.getVertexAttributes(isPerVertexColorUsed, maxTexCoordIndex);
        String vertexShaderCode = ES2ResourceFactory.createVertexShaderCode(isPerVertexColorUsed, maxTexCoordIndex);
        ES2Shader shader = ES2Shader.createFromSource(this.context, vertexShaderCode, pixelShaderCode, samplers, attributes, maxTexCoordIndex, isPixcoordUsed);
        return shader;
    }

    private static String createVertexShaderCode(boolean includePerVertexColor, int maxTexCoordIndex) {
        StringBuilder vsAttr = new StringBuilder();
        StringBuilder vsVary = new StringBuilder();
        StringBuilder vsMain = new StringBuilder();
        vsMain.append("void main() {\n");
        boolean includePosition = true;
        if (includePosition) {
            vsAttr.append("attribute vec2 positionAttr;\n");
            vsMain.append("    vec4 tmp = vec4(positionAttr, 0, 1);\n");
            vsMain.append("    gl_Position = mvpMatrix * tmp;\n");
        }
        if (includePerVertexColor) {
            vsAttr.append("attribute vec4 colorAttr;\n");
            vsVary.append("varying lowp vec4 perVertexColor;\n");
            vsMain.append("    perVertexColor = colorAttr;\n");
        }
        if (maxTexCoordIndex >= 0) {
            vsAttr.append("attribute vec2 texCoord0Attr;\n");
            vsVary.append("varying vec2 texCoord0;\n");
            vsMain.append("    texCoord0 = texCoord0Attr;\n");
        }
        if (maxTexCoordIndex >= 1) {
            vsAttr.append("attribute vec2 texCoord1Attr;\n");
            vsVary.append("varying vec2 texCoord1;\n");
            vsMain.append("    texCoord1 = texCoord1Attr;\n");
        }
        vsMain.append("}\n");
        StringBuilder vs = new StringBuilder();
        vs.append("#ifdef GL_ES\n");
        vs.append("#else\n");
        vs.append("#define lowp\n");
        vs.append("#endif\n");
        vs.append("uniform mat4 mvpMatrix;\n");
        vs.append((CharSequence)vsAttr);
        vs.append((CharSequence)vsVary);
        vs.append((CharSequence)vsMain);
        return vs.toString();
    }

    private Map<String, Integer> getVertexAttributes(boolean includePerVertexColor, int maxTexCoordIndex) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        boolean includePosition = true;
        if (includePosition) {
            attributes.put("positionAttr", 0);
        }
        if (includePerVertexColor) {
            attributes.put("colorAttr", 1);
        }
        if (maxTexCoordIndex >= 0) {
            attributes.put("texCoord0Attr", 2);
        }
        if (maxTexCoordIndex >= 1) {
            attributes.put("texCoord1Attr", 3);
        }
        return attributes;
    }

    @Override
    public Shader createStockShader(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            InputStream stream = ES2ResourceFactory.class.getResourceAsStream("glsl/" + name + ".frag");
            Class<?> klass = Class.forName("com.sun.prism.shader." + name + "_Loader");
            if (PrismSettings.verbose) {
                System.out.println("ES2ResourceFactory: Prism - createStockShader: " + name + ".frag");
            }
            Method m = klass.getMethod("loadShader", ShaderFactory.class, InputStream.class);
            return (Shader)m.invoke(null, this, stream);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalError("Error loading stock shader " + name);
        }
    }

    @Override
    public VertexBuffer createVertexBuffer(int maxQuads) {
        return new VertexBuffer(maxQuads);
    }

    @Override
    public void dispose() {
        this.context.clearContext();
    }

    @Override
    public PhongMaterial createPhongMaterial() {
        return ES2PhongMaterial.create(this.context);
    }

    @Override
    public MeshView createMeshView(Mesh mesh) {
        return ES2MeshView.create(this.context, (ES2Mesh)mesh);
    }

    @Override
    public Mesh createMesh() {
        return ES2Mesh.create(this.context);
    }
}

