/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.VertexBuffer;

class ES2VertexBuffer
extends VertexBuffer {
    private GLContext glCtx;
    protected static final int BYTES_PER_FLOAT = 4;

    ES2VertexBuffer(int maxQuads) {
        super(maxQuads);
    }

    void disableVertexAttributes(GLContext glCtx) {
        this.glCtx = glCtx;
        glCtx.disableVertexAttributes();
    }

    void enableVertexAttributes(GLContext glCtx) {
        this.glCtx = glCtx;
        glCtx.enableVertexAttributes();
    }

    @Override
    protected void drawQuads(int numVertices) {
        this.glCtx.drawIndexedQuads(this.coordArray, this.colorArray, numVertices);
    }

    @Override
    protected void drawTriangles(int numTriangles, float[] fData, byte[] cData) {
        this.glCtx.drawTriangleList(numTriangles, fData, cData);
    }

    public static short[] getQuadIndices16bit(int numQuads) {
        short[] data = new short[numQuads * 6];
        for (int i = 0; i != numQuads; ++i) {
            int vtx = i * 4;
            int idx = i * 6;
            data[idx + 0] = (short)(vtx + 0);
            data[idx + 1] = (short)(vtx + 1);
            data[idx + 2] = (short)(vtx + 2);
            data[idx + 3] = (short)(vtx + 2);
            data[idx + 4] = (short)(vtx + 1);
            data[idx + 5] = (short)(vtx + 3);
        }
        return data;
    }

    public int genQuadsIndexBuffer(int numQuads) {
        if (numQuads * 6 > 65536) {
            throw new IllegalArgumentException("vertex indices overflow");
        }
        return this.glCtx.createIndexBuffer16(ES2VertexBuffer.getQuadIndices16bit(numQuads));
    }
}

