/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.paint.PaintUtil;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Gradient;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseContext {
    private final Screen screen;
    private final ResourceFactory factory;
    private final VertexBuffer vertexBuffer;
    private Texture maskTex;
    private Texture paintTex;
    private int[] paintPixels;
    private ByteBuffer paintBuffer;
    private Texture rectTex;
    private int rectTexMax;
    private Texture wrapRectTex;
    private Texture ovalTex;
    private final Map<FontStrike, GlyphCache> greyGlyphCaches = new HashMap<FontStrike, GlyphCache>();
    private final Map<FontStrike, GlyphCache> lcdGlyphCaches = new HashMap<FontStrike, GlyphCache>();

    protected BaseContext(Screen screen, ResourceFactory factory, VertexBuffer vb) {
        this.screen = screen;
        this.factory = factory;
        this.vertexBuffer = vb;
    }

    protected void setDeviceParametersFor2D() {
    }

    protected void setDeviceParametersFor3D() {
    }

    public Screen getAssociatedScreen() {
        return this.screen;
    }

    public ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void flushVertexBuffer() {
        this.vertexBuffer.flush();
    }

    public void setRenderTarget(BaseGraphics g) {
        if (g != null) {
            this.setRenderTarget(g.getRenderTarget(), g.getCameraNoClone(), g.isDepthTest() && g.isDepthBuffer(), g.isState3D());
        } else {
            this.releaseRenderTarget();
        }
    }

    protected void releaseRenderTarget() {
    }

    protected abstract void setRenderTarget(RenderTarget var1, NGCamera var2, boolean var3, boolean var4);

    public abstract void validateClearOp(BaseGraphics var1);

    public abstract void validatePaintOp(BaseGraphics var1, BaseTransform var2, Texture var3, float var4, float var5, float var6, float var7);

    public abstract void validateTextureOp(BaseGraphics var1, BaseTransform var2, Texture var3, PixelFormat var4);

    public void clearGlyphCaches() {
        this.clearCaches(this.greyGlyphCaches);
        this.clearCaches(this.lcdGlyphCaches);
    }

    private void clearCaches(Map<FontStrike, GlyphCache> glyphCaches) {
        Iterator<FontStrike> iter = glyphCaches.keySet().iterator();
        while (iter.hasNext()) {
            iter.next().clearDesc();
        }
        for (GlyphCache cache : glyphCaches.values()) {
            if (cache == null) continue;
            cache.clear();
        }
        glyphCaches.clear();
    }

    public abstract RTTexture getLCDBuffer();

    public GlyphCache getGlyphCache(FontStrike strike) {
        Map<FontStrike, GlyphCache> glyphCaches = strike.getAAMode() == 1 ? this.lcdGlyphCaches : this.greyGlyphCaches;
        return this.getGlyphCache(strike, glyphCaches);
    }

    public boolean isSuperShaderEnabled() {
        return false;
    }

    private GlyphCache getGlyphCache(FontStrike strike, Map<FontStrike, GlyphCache> glyphCaches) {
        GlyphCache glyphCache = glyphCaches.get(strike);
        if (glyphCache == null) {
            glyphCache = new GlyphCache(this, strike);
            glyphCaches.put(strike, glyphCache);
        }
        return glyphCache;
    }

    public Texture getMaskTexture(MaskData maskData, boolean canScale) {
        int maskW = maskData.getWidth();
        int maskH = maskData.getHeight();
        if (this.maskTex != null) {
            this.maskTex.lock();
            if (this.maskTex.isSurfaceLost()) {
                this.maskTex = null;
            }
        }
        if (this.maskTex == null || this.maskTex.getContentWidth() < maskW || this.maskTex.getContentHeight() < maskH) {
            int newTexW = maskW;
            int newTexH = maskH;
            if (this.maskTex != null) {
                newTexW = Math.max(maskW, this.maskTex.getContentWidth());
                newTexH = Math.max(maskH, this.maskTex.getContentHeight());
                this.maskTex.dispose();
            }
            this.maskTex = this.getResourceFactory().createMaskTexture(newTexW, newTexH, canScale ? Texture.WrapMode.CLAMP_TO_ZERO : Texture.WrapMode.CLAMP_NOT_NEEDED);
        }
        maskData.uploadToTexture(this.maskTex, 0, 0, false);
        return this.maskTex;
    }

    public int getRectTextureMaxSize() {
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        return this.rectTexMax;
    }

    public Texture getRectTexture() {
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        this.rectTex.lock();
        return this.rectTex;
    }

    private void createRectTexture() {
        int texMax = PrismSettings.primTextureSize;
        if (texMax < 0) {
            texMax = this.getResourceFactory().getMaximumTextureSize();
        }
        int texDim = 3;
        int nextCellSize = 2;
        while (texDim + nextCellSize + 1 <= texMax) {
            this.rectTexMax = nextCellSize++;
            texDim += nextCellSize;
        }
        byte[] mask = new byte[texDim * texDim];
        int cellY = 1;
        for (int cellH = 1; cellH <= this.rectTexMax; ++cellH) {
            int cellX = 1;
            for (int cellW = 1; cellW <= this.rectTexMax; ++cellW) {
                int index = cellY * texDim + cellX;
                for (int y = 0; y < cellH; ++y) {
                    for (int x = 0; x < cellW; ++x) {
                        mask[index + x] = -1;
                    }
                    index += texDim;
                }
                cellX += cellW + 1;
            }
            cellY += cellH + 1;
        }
        if (PrismSettings.verbose) {
            System.out.println("max rectangle texture cell size = " + this.rectTexMax);
        }
        Texture tex = this.getResourceFactory().createMaskTexture(texDim, texDim, Texture.WrapMode.CLAMP_NOT_NEEDED);
        tex.contentsUseful();
        tex.makePermanent();
        PixelFormat pf = tex.getPixelFormat();
        int scan = texDim * pf.getBytesPerPixelUnit();
        tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, texDim, texDim, scan, false);
        this.rectTex = tex;
    }

    public Texture getWrapRectTexture() {
        if (this.wrapRectTex == null) {
            Texture tex = this.getResourceFactory().createMaskTexture(2, 2, Texture.WrapMode.CLAMP_TO_EDGE);
            tex.contentsUseful();
            tex.makePermanent();
            int w = tex.getPhysicalWidth();
            int h = tex.getPhysicalHeight();
            if (PrismSettings.verbose) {
                System.out.println("wrap rectangle texture = " + w + " x " + h);
            }
            byte[] mask = new byte[w * h];
            int off = w;
            for (int y = 1; y < h; ++y) {
                for (int x = 1; x < h; ++x) {
                    mask[off + x] = -1;
                }
                off += w;
            }
            PixelFormat pf = tex.getPixelFormat();
            int scan = w * pf.getBytesPerPixelUnit();
            tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, w, h, scan, false);
            this.wrapRectTex = tex;
        }
        this.wrapRectTex.lock();
        return this.wrapRectTex;
    }

    public Texture getOvalTexture() {
        if (this.ovalTex == null) {
            int cellMax = this.getRectTextureMaxSize();
            int texDim = cellMax * (cellMax + 1) / 2;
            byte[] mask = new byte[(texDim += cellMax + 1) * texDim];
            int cellY = 1;
            for (int cellH = 1; cellH <= cellMax; ++cellH) {
                int cellX = 1;
                for (int cellW = 1; cellW <= cellMax; ++cellW) {
                    int index = cellY * texDim + cellX;
                    for (int y = 0; y < cellH; ++y) {
                        int x;
                        if (y * 2 >= cellH) {
                            int reflecty = cellH - 1 - y;
                            int rindex = index + (reflecty - y) * texDim;
                            for (x = 0; x < cellW; ++x) {
                                mask[index + x] = mask[rindex + x];
                            }
                        } else {
                            float ovalY = (float)y + 0.0625f;
                            for (int i = 0; i < 8; ++i) {
                                float ovalX = ovalY / (float)cellH - 0.5f;
                                ovalX = (float)Math.sqrt(0.25f - ovalX * ovalX);
                                int oxi = Math.round((float)cellW * 4.0f * (1.0f - ovalX * 2.0f));
                                int edgeX = oxi >> 3;
                                int subX = oxi & 7;
                                int n = index + edgeX;
                                mask[n] = (byte)(mask[n] + (8 - subX));
                                int n2 = index + edgeX + 1;
                                mask[n2] = (byte)(mask[n2] + subX);
                                ovalY += 0.125f;
                            }
                            int accum = 0;
                            for (x = 0; x < cellW; ++x) {
                                mask[index + x] = x * 2 >= cellW ? mask[index + cellW - 1 - x] : (byte)(((accum += mask[index + x]) * 255 + 32) / 64);
                            }
                            mask[index + cellW] = 0;
                        }
                        index += texDim;
                    }
                    cellX += cellW + 1;
                }
                cellY += cellH + 1;
            }
            Texture tex = this.getResourceFactory().createMaskTexture(texDim, texDim, Texture.WrapMode.CLAMP_NOT_NEEDED);
            tex.contentsUseful();
            tex.makePermanent();
            PixelFormat pf = tex.getPixelFormat();
            int scan = texDim * pf.getBytesPerPixelUnit();
            tex.update(ByteBuffer.wrap(mask), pf, 0, 0, 0, 0, texDim, texDim, scan, false);
            this.ovalTex = tex;
        }
        this.ovalTex.lock();
        return this.ovalTex;
    }

    public Texture getGradientTexture(Gradient grad, BaseTransform xform, int paintW, int paintH, MaskData maskData, float bx, float by, float bw, float bh) {
        int sizeInPixels = paintW * paintH;
        int sizeInBytes = sizeInPixels * 4;
        if (this.paintBuffer == null || this.paintBuffer.capacity() < sizeInBytes) {
            this.paintPixels = new int[sizeInPixels];
            this.paintBuffer = ByteBuffer.wrap(new byte[sizeInBytes]);
        }
        if (this.paintTex != null) {
            this.paintTex.lock();
            if (this.paintTex.isSurfaceLost()) {
                this.paintTex = null;
            }
        }
        if (this.paintTex == null || this.paintTex.getContentWidth() < paintW || this.paintTex.getContentHeight() < paintH) {
            int newTexW = paintW;
            int newTexH = paintH;
            if (this.paintTex != null) {
                newTexW = Math.max(paintW, this.paintTex.getContentWidth());
                newTexH = Math.max(paintH, this.paintTex.getContentHeight());
                this.paintTex.dispose();
            }
            this.paintTex = this.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_NOT_NEEDED, newTexW, newTexH);
        }
        PaintUtil.fillImageWithGradient(this.paintPixels, grad, xform, 0, 0, paintW, paintH, bx, by, bw, bh);
        byte[] bytePixels = this.paintBuffer.array();
        if (maskData != null) {
            byte[] maskPixels = maskData.getMaskBuffer().array();
            int j = 0;
            for (int i = 0; i < sizeInPixels; ++i) {
                int pixel = this.paintPixels[i];
                int maskA = maskPixels[i] & 0xFF;
                bytePixels[j++] = (byte)((pixel & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >> 8 & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >> 16 & 0xFF) * maskA / 255);
                bytePixels[j++] = (byte)((pixel >>> 24) * maskA / 255);
            }
        } else {
            int j = 0;
            for (int i = 0; i < sizeInPixels; ++i) {
                int pixel = this.paintPixels[i];
                bytePixels[j++] = (byte)(pixel & 0xFF);
                bytePixels[j++] = (byte)(pixel >> 8 & 0xFF);
                bytePixels[j++] = (byte)(pixel >> 16 & 0xFF);
                bytePixels[j++] = (byte)(pixel >>> 24);
            }
        }
        this.paintTex.update(this.paintBuffer, PixelFormat.BYTE_BGRA_PRE, 0, 0, 0, 0, paintW, paintH, paintW * 4, false);
        return this.paintTex;
    }
}

