/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class BaseResourceFactory
implements ResourceFactory {
    private static final Map<Image, Texture> clampTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> repeatTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> mipmapTexCache = new WeakHashMap<Image, Texture>();
    private final WeakHashMap<ResourceFactoryListener, Boolean> listenerMap = new WeakHashMap();
    private Texture regionTexture;
    private Texture glyphTexture;
    private boolean superShaderAllowed;

    @Override
    public void addFactoryListener(ResourceFactoryListener l) {
        this.listenerMap.put(l, Boolean.TRUE);
    }

    @Override
    public void removeFactoryListener(ResourceFactoryListener l) {
        this.listenerMap.remove(l);
    }

    @Override
    public boolean isDeviceReady() {
        return true;
    }

    protected void clearTextureCache() {
        this.clearTextureCache(clampTexCache);
        this.clearTextureCache(repeatTexCache);
        this.clearTextureCache(mipmapTexCache);
    }

    protected void clearTextureCache(Map<Image, Texture> texCache) {
        Collection<Texture> texAll = texCache.values();
        for (Texture i : texAll) {
            i.dispose();
        }
        texCache.clear();
    }

    protected ResourceFactoryListener[] getFactoryListeners() {
        return this.listenerMap.keySet().toArray(new ResourceFactoryListener[0]);
    }

    protected void notifyReset() {
        ResourceFactoryListener[] notifyList;
        clampTexCache.clear();
        repeatTexCache.clear();
        mipmapTexCache.clear();
        for (ResourceFactoryListener listener : notifyList = this.getFactoryListeners()) {
            if (null == listener) continue;
            listener.factoryReset();
        }
    }

    protected void notifyReleased() {
        ResourceFactoryListener[] notifyList;
        clampTexCache.clear();
        repeatTexCache.clear();
        mipmapTexCache.clear();
        for (ResourceFactoryListener listener : notifyList = this.getFactoryListeners()) {
            if (null == listener) continue;
            listener.factoryReleased();
        }
    }

    static long sizeWithMipMap(int w, int h, PixelFormat format) {
        long size = 0L;
        int bytesPerPixel = format.getBytesPerPixelUnit();
        while (w > 1 && h > 1) {
            size += (long)w * (long)h;
            w = w + 1 >> 1;
            h = h + 1 >> 1;
        }
        return ++size * (long)bytesPerPixel;
    }

    @Override
    public Texture getCachedTexture(Image image, Texture.WrapMode wrapMode) {
        return this.getCachedTexture(image, wrapMode, false);
    }

    @Override
    public Texture getCachedTexture(Image image, Texture.WrapMode wrapMode, boolean useMipmap) {
        Texture othertex;
        Map<Image, Texture> texCache;
        if (image == null) {
            throw new IllegalArgumentException("Image must be non-null");
        }
        if (wrapMode == Texture.WrapMode.CLAMP_TO_EDGE) {
            if (useMipmap) {
                throw new IllegalArgumentException("Mipmap not supported with CLAMP mode: useMipmap = " + useMipmap + ", wrapMode = " + (Object)((Object)wrapMode));
            }
            texCache = clampTexCache;
        } else if (wrapMode == Texture.WrapMode.REPEAT) {
            texCache = useMipmap ? mipmapTexCache : repeatTexCache;
        } else {
            throw new IllegalArgumentException("no caching for " + (Object)((Object)wrapMode));
        }
        Texture tex = texCache.get(image);
        if (tex != null) {
            tex.lock();
            if (tex.isSurfaceLost()) {
                texCache.remove(image);
                tex = null;
            }
        }
        int serial = image.getSerial();
        if (!useMipmap && tex == null && (othertex = (wrapMode == Texture.WrapMode.REPEAT ? clampTexCache : repeatTexCache).get(image)) != null) {
            othertex.lock();
            if (!othertex.isSurfaceLost() && (tex = othertex.getSharedTexture(wrapMode)) != null) {
                tex.contentsUseful();
                texCache.put(image, tex);
            }
            othertex.unlock();
        }
        if (tex == null) {
            long size;
            int w = image.getWidth();
            int h = image.getHeight();
            TextureResourcePool pool = this.getTextureResourcePool();
            long l = size = useMipmap ? BaseResourceFactory.sizeWithMipMap(w, h, image.getPixelFormat()) : pool.estimateTextureSize(w, h, image.getPixelFormat());
            if (!pool.prepareForAllocation(size)) {
                return null;
            }
            tex = this.createTexture(image, Texture.Usage.DEFAULT, wrapMode, useMipmap);
            if (tex != null) {
                tex.setLastImageSerial(serial);
                texCache.put(image, tex);
            }
        } else if (tex.getLastImageSerial() != serial) {
            tex.update(image, 0, 0, image.getWidth(), image.getHeight(), false);
            tex.setLastImageSerial(serial);
        }
        return tex;
    }

    @Override
    public Texture createTexture(Image image, Texture.Usage usageHint, Texture.WrapMode wrapMode) {
        return this.createTexture(image, usageHint, wrapMode, false);
    }

    @Override
    public Texture createTexture(Image image, Texture.Usage usageHint, Texture.WrapMode wrapMode, boolean useMipmap) {
        int h;
        int w;
        PixelFormat format = image.getPixelFormat();
        Texture tex = this.createTexture(format, usageHint, wrapMode, w = image.getWidth(), h = image.getHeight(), useMipmap);
        if (tex != null) {
            tex.update(image, 0, 0, w, h, true);
            tex.contentsUseful();
        }
        return tex;
    }

    @Override
    public Texture createMaskTexture(int width, int height, Texture.WrapMode wrapMode) {
        return this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DEFAULT, wrapMode, width, height);
    }

    @Override
    public Texture createFloatTexture(int width, int height) {
        return this.createTexture(PixelFormat.FLOAT_XYZW, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_ZERO, width, height);
    }

    @Override
    public void setRegionTexture(Texture texture) {
        this.regionTexture = texture;
        this.superShaderAllowed = PrismSettings.superShader && this.regionTexture != null && this.glyphTexture != null;
    }

    @Override
    public Texture getRegionTexture() {
        return this.regionTexture;
    }

    @Override
    public void setGlyphTexture(Texture texture) {
        this.glyphTexture = texture;
        this.superShaderAllowed = PrismSettings.superShader && this.regionTexture != null && this.glyphTexture != null;
    }

    @Override
    public Texture getGlyphTexture() {
        return this.glyphTexture;
    }

    @Override
    public boolean isSuperShaderAllowed() {
        return this.superShaderAllowed;
    }

    protected boolean canClampToZero() {
        return true;
    }

    protected boolean canClampToEdge() {
        return true;
    }

    protected boolean canRepeat() {
        return true;
    }

    @Override
    public boolean isWrapModeSupported(Texture.WrapMode mode) {
        switch (mode) {
            case CLAMP_NOT_NEEDED: {
                return true;
            }
            case CLAMP_TO_EDGE: {
                return this.canClampToEdge();
            }
            case REPEAT: {
                return this.canRepeat();
            }
            case CLAMP_TO_ZERO: {
                return this.canClampToZero();
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_ZERO_SIMULATED: 
            case REPEAT_SIMULATED: {
                throw new InternalError("Cannot test support for simulated wrap modes");
            }
        }
        throw new InternalError("Unrecognized wrap mode: " + (Object)((Object)mode));
    }
}

