/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.BaseShaderGraphics$$Lambda$1;
import com.sun.prism.impl.ps.PaintHelper;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import java.security.AccessController;

public abstract class BaseShaderGraphics
extends BaseGraphics
implements ShaderGraphics,
ReadbackGraphics,
MaskTextureGraphics {
    private static Affine2D TEMP_TX2D = new Affine2D();
    private static Affine3D TEMP_TX3D = new Affine3D();
    private final BaseShaderContext context;
    private Shader externalShader;
    private boolean isComplexPaint;
    private NGLightBase[] lights = null;
    private static final float FRINGE_FACTOR;
    private static final double SQRT_2;
    private boolean lcdSampleInvalid = false;

    protected BaseShaderGraphics(BaseShaderContext context, RenderTarget renderTarget) {
        super(context, renderTarget);
        this.context = context;
    }

    BaseShaderContext getContext() {
        return this.context;
    }

    boolean isComplexPaint() {
        return this.isComplexPaint;
    }

    @Override
    public void getPaintShaderTransform(Affine3D ret) {
        ret.setTransform(this.getTransformNoClone());
    }

    public Shader getExternalShader() {
        return this.externalShader;
    }

    @Override
    public void setExternalShader(Shader shader) {
        this.externalShader = shader;
        this.context.setExternalShader(this, shader);
    }

    @Override
    public void setPaint(Paint paint) {
        Gradient grad;
        this.isComplexPaint = paint.getType().isGradient() ? (grad = (Gradient)paint).getNumStops() > 12 : false;
        super.setPaint(paint);
    }

    @Override
    public void setLights(NGLightBase[] lights) {
        this.lights = lights;
    }

    @Override
    public final NGLightBase[] getLights() {
        return this.lights;
    }

    @Override
    public void drawTexture(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        if (tex instanceof MultiTexture) {
            this.drawMultiTexture((MultiTexture)tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        } else {
            super.drawTexture(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        }
    }

    @Override
    public void drawTexture3SliceH(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dh2, float sh1, float sh2) {
        if (!(tex instanceof MultiTexture)) {
            super.drawTexture3SliceH(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, dh1, dh2, sh1, sh2);
            return;
        }
        MultiTexture mtex = (MultiTexture)tex;
        this.drawMultiTexture(mtex, dx1, dy1, dh1, dy2, sx1, sy1, sh1, sy2);
        this.drawMultiTexture(mtex, dh1, dy1, dh2, dy2, sh1, sy1, sh2, sy2);
        this.drawMultiTexture(mtex, dh2, dy1, dx2, dy2, sh2, sy1, sx2, sy2);
    }

    @Override
    public void drawTexture3SliceV(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dv1, float dv2, float sv1, float sv2) {
        if (!(tex instanceof MultiTexture)) {
            super.drawTexture3SliceV(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, dv1, dv2, sv1, sv2);
            return;
        }
        MultiTexture mtex = (MultiTexture)tex;
        this.drawMultiTexture(mtex, dx1, dy1, dx2, dv1, sx1, sy1, sx2, sv1);
        this.drawMultiTexture(mtex, dx1, dv1, dx2, dv2, sx1, sv1, sx2, sv2);
        this.drawMultiTexture(mtex, dx1, dv2, dx2, dy2, sx1, sv2, sx2, sy2);
    }

    @Override
    public void drawTexture9Slice(Texture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2, float dh1, float dv1, float dh2, float dv2, float sh1, float sv1, float sh2, float sv2) {
        if (!(tex instanceof MultiTexture)) {
            super.drawTexture9Slice(tex, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, dh1, dv1, dh2, dv2, sh1, sv1, sh2, sv2);
            return;
        }
        MultiTexture mtex = (MultiTexture)tex;
        this.drawMultiTexture(mtex, dx1, dy1, dh1, dv1, sx1, sy1, sh1, sv1);
        this.drawMultiTexture(mtex, dh1, dy1, dh2, dv1, sh1, sy1, sh2, sv1);
        this.drawMultiTexture(mtex, dh2, dy1, dx2, dv1, sh2, sy1, sx2, sv1);
        this.drawMultiTexture(mtex, dx1, dv1, dh1, dv2, sx1, sv1, sh1, sv2);
        this.drawMultiTexture(mtex, dh1, dv1, dh2, dv2, sh1, sv1, sh2, sv2);
        this.drawMultiTexture(mtex, dh2, dv1, dx2, dv2, sh2, sv1, sx2, sv2);
        this.drawMultiTexture(mtex, dx1, dv2, dh1, dy2, sx1, sv2, sh1, sy2);
        this.drawMultiTexture(mtex, dh1, dv2, dh2, dy2, sh1, sv2, sh2, sy2);
        this.drawMultiTexture(mtex, dh2, dv2, dx2, dy2, sh2, sv2, sx2, sy2);
    }

    private static float calculateScaleFactor(float contentDim, float physicalDim) {
        if (contentDim == physicalDim) {
            return 1.0f;
        }
        return (contentDim - 1.0f) / physicalDim;
    }

    protected void drawMultiTexture(MultiTexture tex, float dx1, float dy1, float dx2, float dy2, float sx1, float sy1, float sx2, float sy2) {
        float alphaScaleY;
        float alphaScaleX;
        float lumaScaleY;
        float lumaScaleX;
        float imgHeight;
        float imgWidth;
        Texture crTex;
        Texture cbTex;
        Texture[] textures;
        Shader shader;
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            xform = IDENT;
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        if (null == (shader = this.context.validateTextureOp(this, xform, textures = tex.getTextures(), tex.getPixelFormat()))) {
            return;
        }
        if (tex.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            Texture lumaTex = textures[0];
            cbTex = textures[2];
            crTex = textures[1];
            imgWidth = tex.getContentWidth();
            imgHeight = tex.getContentHeight();
            lumaScaleX = BaseShaderGraphics.calculateScaleFactor(imgWidth, lumaTex.getPhysicalWidth());
            lumaScaleY = BaseShaderGraphics.calculateScaleFactor(imgHeight, lumaTex.getPhysicalHeight());
            if (textures.length > 3) {
                Texture alphaTex = textures[3];
                alphaScaleX = BaseShaderGraphics.calculateScaleFactor(imgWidth, alphaTex.getPhysicalWidth());
                alphaScaleY = BaseShaderGraphics.calculateScaleFactor(imgHeight, alphaTex.getPhysicalHeight());
            } else {
                alphaScaleY = 0.0f;
                alphaScaleX = 0.0f;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported multitexture format " + (Object)((Object)tex.getPixelFormat()));
        }
        float chromaWidth = (float)Math.floor((double)imgWidth / 2.0);
        float chromaHeight = (float)Math.floor((double)imgHeight / 2.0);
        float cbScaleX = BaseShaderGraphics.calculateScaleFactor(chromaWidth, cbTex.getPhysicalWidth());
        float cbScaleY = BaseShaderGraphics.calculateScaleFactor(chromaHeight, cbTex.getPhysicalHeight());
        float crScaleX = BaseShaderGraphics.calculateScaleFactor(chromaWidth, crTex.getPhysicalWidth());
        float crScaleY = BaseShaderGraphics.calculateScaleFactor(chromaHeight, crTex.getPhysicalHeight());
        shader.setConstant("lumaAlphaScale", lumaScaleX, lumaScaleY, alphaScaleX, alphaScaleY);
        shader.setConstant("cbCrScale", cbScaleX, cbScaleY, crScaleX, crScaleY);
        float tx1 = sx1 / imgWidth;
        float ty1 = sy1 / imgHeight;
        float tx2 = sx2 / imgWidth;
        float ty2 = sy2 / imgHeight;
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
    }

    @Override
    public void drawTextureRaw2(Texture src1, Texture src2, float dx1, float dy1, float dx2, float dy2, float t1x1, float t1y1, float t1x2, float t1y2, float t2x1, float t2y1, float t2x2, float t2y2) {
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            xform = IDENT;
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        this.context.validateTextureOp(this, xform, src1, src2, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(dx1, dy1, dx2, dy2, t1x1, t1y1, t1x2, t1y2, t2x1, t2y1, t2x2, t2y2);
    }

    @Override
    public void drawMappedTextureRaw2(Texture src1, Texture src2, float dx1, float dy1, float dx2, float dy2, float t1x11, float t1y11, float t1x21, float t1y21, float t1x12, float t1y12, float t1x22, float t1y22, float t2x11, float t2y11, float t2x21, float t2y21, float t2x12, float t2y12, float t2x22, float t2y22) {
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            xform = IDENT;
            dx1 += this.transX;
            dy1 += this.transY;
            dx2 += this.transX;
            dy2 += this.transY;
        }
        this.context.validateTextureOp(this, xform, src1, src2, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addMappedQuad(dx1, dy1, dx2, dy2, t1x11, t1y11, t1x21, t1y21, t1x12, t1y12, t1x22, t1y22, t2x11, t2y11, t2x21, t2y21, t2x12, t2y12, t2x22, t2y22);
    }

    @Override
    public void drawPixelsMasked(RTTexture imgtex, RTTexture masktex, int dx, int dy, int dw, int dh, int ix, int iy, int mx, int my) {
        if (dw <= 0 || dh <= 0) {
            return;
        }
        float iw = imgtex.getPhysicalWidth();
        float ih = imgtex.getPhysicalHeight();
        float mw = masktex.getPhysicalWidth();
        float mh = masktex.getPhysicalHeight();
        float dx1 = dx;
        float dy1 = dy;
        float dx2 = dx + dw;
        float dy2 = dy + dh;
        float ix1 = (float)ix / iw;
        float iy1 = (float)iy / ih;
        float ix2 = (float)(ix + dw) / iw;
        float iy2 = (float)(iy + dh) / ih;
        float mx1 = (float)mx / mw;
        float my1 = (float)my / mh;
        float mx2 = (float)(mx + dw) / mw;
        float my2 = (float)(my + dh) / mh;
        this.context.validateMaskTextureOp(this, IDENT, imgtex, masktex, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(dx1, dy1, dx2, dy2, ix1, iy1, ix2, iy2, mx1, my1, mx2, my2);
    }

    @Override
    public void maskInterpolatePixels(RTTexture imgtex, RTTexture masktex, int dx, int dy, int dw, int dh, int ix, int iy, int mx, int my) {
        if (dw <= 0 || dh <= 0) {
            return;
        }
        float iw = imgtex.getPhysicalWidth();
        float ih = imgtex.getPhysicalHeight();
        float mw = masktex.getPhysicalWidth();
        float mh = masktex.getPhysicalHeight();
        float dx1 = dx;
        float dy1 = dy;
        float dx2 = dx + dw;
        float dy2 = dy + dh;
        float ix1 = (float)ix / iw;
        float iy1 = (float)iy / ih;
        float ix2 = (float)(ix + dw) / iw;
        float iy2 = (float)(iy + dh) / ih;
        float mx1 = (float)mx / mw;
        float my1 = (float)my / mh;
        float mx2 = (float)(mx + dw) / mw;
        float my2 = (float)(my + dh) / mh;
        CompositeMode oldmode = this.getCompositeMode();
        this.setCompositeMode(CompositeMode.DST_OUT);
        this.context.validateTextureOp((BaseGraphics)this, IDENT, masktex, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(dx1, dy1, dx2, dy2, mx1, my1, mx2, my2);
        this.setCompositeMode(CompositeMode.ADD);
        this.context.validateMaskTextureOp(this, IDENT, imgtex, masktex, PixelFormat.INT_ARGB_PRE);
        vb.addQuad(dx1, dy1, dx2, dy2, ix1, iy1, ix2, iy2, mx1, my1, mx2, my2);
        this.setCompositeMode(oldmode);
    }

    private void renderWithComplexPaint(Shape shape, BasicStroke stroke, float bx, float by, float bw, float bh) {
        this.context.flushVertexBuffer();
        BaseTransform xform = this.getTransformNoClone();
        MaskData maskData = ShapeUtil.rasterizeShape(shape, stroke, this.getFinalClipNoClone(), xform, true);
        int maskW = maskData.getWidth();
        int maskH = maskData.getHeight();
        float dx1 = maskData.getOriginX();
        float dy1 = maskData.getOriginY();
        float dx2 = dx1 + (float)maskW;
        float dy2 = dy1 + (float)maskH;
        Gradient grad = (Gradient)this.paint;
        TEMP_TX2D.setToTranslation(-dx1, -dy1);
        TEMP_TX2D.concatenate(xform);
        Texture tex = this.context.getGradientTexture(grad, TEMP_TX2D, maskW, maskH, maskData, bx, by, bw, bh);
        float tx1 = 0.0f;
        float ty1 = 0.0f;
        float tx2 = tx1 + (float)maskW / (float)tex.getPhysicalWidth();
        float ty2 = ty1 + (float)maskH / (float)tex.getPhysicalHeight();
        VertexBuffer vb = this.context.getVertexBuffer();
        this.context.validateTextureOp(this, IDENT, tex, null, tex.getPixelFormat());
        vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        tex.unlock();
    }

    @Override
    protected void renderShape(Shape shape, BasicStroke stroke, float bx, float by, float bw, float bh) {
        if (this.isComplexPaint) {
            this.renderWithComplexPaint(shape, stroke, bx, by, bw, bh);
            return;
        }
        this.context.flushVertexBuffer();
        BaseTransform xform = this.getTransformNoClone();
        MaskData maskData = ShapeUtil.rasterizeShape(shape, stroke, this.getFinalClipNoClone(), xform, true);
        Texture maskTex = this.context.getMaskTexture(maskData, false);
        int maskW = maskData.getWidth();
        int maskH = maskData.getHeight();
        float dx1 = maskData.getOriginX();
        float dy1 = maskData.getOriginY();
        float dx2 = dx1 + (float)maskW;
        float dy2 = dy1 + (float)maskH;
        float tx1 = 0.0f;
        float ty1 = 0.0f;
        float tx2 = tx1 + (float)maskW / (float)maskTex.getPhysicalWidth();
        float ty2 = ty1 + (float)maskH / (float)maskTex.getPhysicalHeight();
        if (PrismSettings.primTextureSize != 0) {
            Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext.MaskType.ALPHA_TEXTURE, maskTex, bx, by, bw, bh);
            VertexBuffer vb = this.context.getVertexBuffer();
            vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2, this.getPaintTextureTx(xform, shader, bx, by, bw, bh));
        } else {
            this.context.validatePaintOp(this, IDENT, maskTex, bx, by, bw, bh);
            VertexBuffer vb = this.context.getVertexBuffer();
            vb.addQuad(dx1, dy1, dx2, dy2, tx1, ty1, tx2, ty2);
        }
        maskTex.unlock();
    }

    private static float getStrokeExpansionFactor(BasicStroke stroke) {
        if (stroke.getType() == 2) {
            return 1.0f;
        }
        if (stroke.getType() == 0) {
            return 0.5f;
        }
        return 0.0f;
    }

    private BaseTransform extract3Dremainder(BaseTransform xform) {
        if (xform.is2D()) {
            return IDENT;
        }
        TEMP_TX3D.setTransform(xform);
        TEMP_TX2D.setTransform(xform.getMxx(), xform.getMyx(), xform.getMxy(), xform.getMyy(), xform.getMxt(), xform.getMyt());
        try {
            TEMP_TX2D.invert();
            TEMP_TX3D.concatenate(TEMP_TX2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return TEMP_TX3D;
    }

    private void renderGeneralRoundedRect(float rx, float ry, float rw, float rh, float arcw, float arch, BaseShaderContext.MaskType type, BasicStroke stroke) {
        BaseTransform rendertx;
        float oy;
        float ox;
        float wdy;
        float hdx;
        float wdx;
        float hdy;
        float ifractw;
        float ifracth;
        float bh;
        float bw;
        float by;
        float bx;
        if (stroke == null) {
            bx = rx;
            by = ry;
            bw = rw;
            bh = rh;
            ifracth = 0.0f;
            ifractw = 0.0f;
        } else {
            float sw = stroke.getLineWidth();
            float ow = BaseShaderGraphics.getStrokeExpansionFactor(stroke) * sw;
            bx = rx - ow;
            by = ry - ow;
            bw = rw + (ow *= 2.0f);
            bh = rh + ow;
            if (arcw > 0.0f && arch > 0.0f) {
                arcw += ow;
                arch += ow;
            } else if (stroke.getLineJoin() == 1) {
                arcw = arch = ow;
                type = BaseShaderContext.MaskType.DRAW_ROUNDRECT;
            } else {
                arch = 0.0f;
                arcw = 0.0f;
            }
            ifractw = (bw - sw * 2.0f) / bw;
            ifracth = (bh - sw * 2.0f) / bh;
            if (ifractw <= 0.0f || ifracth <= 0.0f) {
                type = type.getFillType();
            }
        }
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            hdy = 1.0f;
            wdx = 1.0f;
            hdx = 0.0f;
            wdy = 0.0f;
            ox = bx + this.transX;
            oy = by + this.transY;
            rendertx = IDENT;
        } else {
            rendertx = this.extract3Dremainder(xform);
            wdx = (float)xform.getMxx();
            hdx = (float)xform.getMxy();
            wdy = (float)xform.getMyx();
            hdy = (float)xform.getMyy();
            ox = bx * wdx + by * hdx + (float)xform.getMxt();
            oy = bx * wdy + by * hdy + (float)xform.getMyt();
        }
        float arcfractw = arcw / bw;
        float arcfracth = arch / bh;
        this.renderGeneralRoundedPgram(ox, oy, wdx *= bw, wdy *= bw, hdx *= bh, hdy *= bh, arcfractw, arcfracth, ifractw, ifracth, rendertx, type, rx, ry, rw, rh);
    }

    private void renderGeneralRoundedPgram(float ox, float oy, float wvecx, float wvecy, float hvecx, float hvecy, float arcfractw, float arcfracth, float ifractw, float ifracth, BaseTransform rendertx, BaseShaderContext.MaskType type, float rx, float ry, float rw, float rh) {
        float wlen = BaseShaderGraphics.len(wvecx, wvecy);
        float hlen = BaseShaderGraphics.len(hvecx, hvecy);
        if (wlen == 0.0f || hlen == 0.0f) {
            return;
        }
        float xUL = ox;
        float yUL = oy;
        float xUR = ox + wvecx;
        float yUR = oy + wvecy;
        float xLL = ox + hvecx;
        float yLL = oy + hvecy;
        float xLR = xUR + hvecx;
        float yLR = yUR + hvecy;
        float halfarea = (wvecx * hvecy - wvecy * hvecx) * 0.5f;
        float pwdist = halfarea / hlen;
        float phdist = halfarea / wlen;
        if (pwdist < 0.0f) {
            pwdist = -pwdist;
        }
        if (phdist < 0.0f) {
            phdist = -phdist;
        }
        float nwvecx = wvecx / wlen;
        float nwvecy = wvecy / wlen;
        float nhvecx = hvecx / hlen;
        float nhvecy = hvecy / hlen;
        float num = -hvecx * (nwvecx + nhvecx) - hvecy * (nwvecy + nhvecy);
        float den = hvecy * wvecx - hvecx * wvecy;
        float t = num / den;
        float factor = FRINGE_FACTOR * Math.signum(t);
        float offx = (t * wvecx + nwvecy) * factor;
        float offy = (t * wvecy - nwvecx) * factor;
        xUL += offx;
        yUL += offy;
        xLR -= offx;
        yLR -= offy;
        num = wvecy * (nhvecy - nwvecy) - wvecx * (nwvecx - nhvecx);
        t = num / den;
        factor = FRINGE_FACTOR * Math.signum(t);
        offx = (t * hvecx + nhvecy) * factor;
        offy = (t * hvecy - nhvecx) * factor;
        xUR += offx;
        yUR += offy;
        xLL -= offx;
        yLL -= offy;
        float xC = (xUL + xLR) * 0.5f;
        float yC = (yUL + yLR) * 0.5f;
        float uC = xC * nhvecy - yC * nhvecx;
        float vC = xC * nwvecy - yC * nwvecx;
        float uUL = xUL * nhvecy - yUL * nhvecx - uC;
        float vUL = xUL * nwvecy - yUL * nwvecx - vC;
        float uUR = xUR * nhvecy - yUR * nhvecx - uC;
        float vUR = xUR * nwvecy - yUR * nwvecx - vC;
        float uLL = xLL * nhvecy - yLL * nhvecx - uC;
        float vLL = xLL * nwvecy - yLL * nwvecx - vC;
        float uLR = xLR * nhvecy - yLR * nhvecx - uC;
        float vLR = xLR * nwvecy - yLR * nwvecx - vC;
        if (type == BaseShaderContext.MaskType.DRAW_ROUNDRECT || type == BaseShaderContext.MaskType.FILL_ROUNDRECT) {
            float oarcw = pwdist * arcfractw;
            float oarch = phdist * arcfracth;
            if ((double)oarcw < 0.5 || (double)oarch < 0.5) {
                type = type == BaseShaderContext.MaskType.DRAW_ROUNDRECT ? BaseShaderContext.MaskType.DRAW_PGRAM : BaseShaderContext.MaskType.FILL_PGRAM;
            } else {
                float ivalh;
                float ivalw;
                float flatw = pwdist - oarcw;
                float flath = phdist - oarch;
                if (type == BaseShaderContext.MaskType.DRAW_ROUNDRECT) {
                    float iwdist = pwdist * ifractw;
                    float ihdist = phdist * ifracth;
                    ivalw = iwdist - flatw;
                    ivalh = ihdist - flath;
                    if (ivalw < 0.5f || ivalh < 0.5f) {
                        ivalw = iwdist;
                        ivalh = ihdist;
                        type = BaseShaderContext.MaskType.DRAW_SEMIROUNDRECT;
                    } else {
                        ivalw = 1.0f / ivalw;
                        ivalh = 1.0f / ivalh;
                    }
                } else {
                    ivalh = 0.0f;
                    ivalw = 0.0f;
                }
                oarcw = 1.0f / oarcw;
                oarch = 1.0f / oarch;
                Shader shader = this.context.validatePaintOp(this, rendertx, type, rx, ry, rw, rh, oarcw, oarch, ivalw, ivalh, 0.0f, 0.0f);
                shader.setConstant("oinvarcradii", oarcw, oarch);
                if (type == BaseShaderContext.MaskType.DRAW_ROUNDRECT) {
                    shader.setConstant("iinvarcradii", ivalw, ivalh);
                } else if (type == BaseShaderContext.MaskType.DRAW_SEMIROUNDRECT) {
                    shader.setConstant("idim", ivalw, ivalh);
                }
                pwdist = flatw;
                phdist = flath;
            }
        }
        if (type == BaseShaderContext.MaskType.DRAW_PGRAM || type == BaseShaderContext.MaskType.DRAW_ELLIPSE) {
            float idimw = pwdist * ifractw;
            float idimh = phdist * ifracth;
            if (type == BaseShaderContext.MaskType.DRAW_ELLIPSE) {
                if ((double)Math.abs(pwdist - phdist) < 0.01) {
                    type = BaseShaderContext.MaskType.DRAW_CIRCLE;
                    phdist = (float)Math.min(1.0, (double)(phdist * phdist) * Math.PI);
                    idimh = (float)Math.min(1.0, (double)(idimh * idimh) * Math.PI);
                } else {
                    pwdist = 1.0f / pwdist;
                    phdist = 1.0f / phdist;
                    idimw = 1.0f / idimw;
                    idimh = 1.0f / idimh;
                }
            }
            Shader shader = this.context.validatePaintOp(this, rendertx, type, rx, ry, rw, rh, idimw, idimh, 0.0f, 0.0f, 0.0f, 0.0f);
            shader.setConstant("idim", idimw, idimh);
        } else if (type == BaseShaderContext.MaskType.FILL_ELLIPSE) {
            if ((double)Math.abs(pwdist - phdist) < 0.01) {
                type = BaseShaderContext.MaskType.FILL_CIRCLE;
                phdist = (float)Math.min(1.0, (double)(phdist * phdist) * Math.PI);
            } else {
                pwdist = 1.0f / pwdist;
                phdist = 1.0f / phdist;
                uUL *= pwdist;
                vUL *= phdist;
                uUR *= pwdist;
                vUR *= phdist;
                uLL *= pwdist;
                vLL *= phdist;
                uLR *= pwdist;
                vLR *= phdist;
            }
            this.context.validatePaintOp(this, rendertx, type, rx, ry, rw, rh);
        } else if (type == BaseShaderContext.MaskType.FILL_PGRAM) {
            this.context.validatePaintOp(this, rendertx, type, rx, ry, rw, rh);
        }
        this.context.getVertexBuffer().addMappedPgram(xUL, yUL, xUR, yUR, xLL, yLL, xLR, yLR, uUL, vUL, uUR, vUR, uLL, vLL, uLR, vLR, pwdist, phdist);
    }

    AffineBase getPaintTextureTx(BaseTransform renderTx, Shader shader, float rx, float ry, float rw, float rh) {
        switch (this.paint.getType()) {
            case COLOR: {
                return null;
            }
            case LINEAR_GRADIENT: {
                return PaintHelper.getLinearGradientTx((LinearGradient)this.paint, shader, renderTx, rx, ry, rw, rh);
            }
            case RADIAL_GRADIENT: {
                return PaintHelper.getRadialGradientTx((RadialGradient)this.paint, shader, renderTx, rx, ry, rw, rh);
            }
            case IMAGE_PATTERN: {
                return PaintHelper.getImagePatternTx(this, (ImagePattern)this.paint, shader, renderTx, rx, ry, rw, rh);
            }
        }
        throw new InternalError("Unrecogized paint type: " + this.paint);
    }

    boolean fillPrimRect(float x, float y, float w, float h, Texture rectTex, Texture wrapTex, float bx, float by, float bw, float bh) {
        BaseTransform xform = this.getTransformNoClone();
        float mxx = (float)xform.getMxx();
        float mxy = (float)xform.getMxy();
        float mxt = (float)xform.getMxt();
        float myx = (float)xform.getMyx();
        float myy = (float)xform.getMyy();
        float myt = (float)xform.getMyt();
        float dxdist = BaseShaderGraphics.len(mxx, myx);
        float dydist = BaseShaderGraphics.len(mxy, myy);
        if (dxdist == 0.0f || dydist == 0.0f) {
            return true;
        }
        float pixelw = 1.0f / dxdist;
        float pixelh = 1.0f / dydist;
        float x0 = x - pixelw * 0.5f;
        float y0 = y - pixelh * 0.5f;
        float x1 = x + w + pixelw * 0.5f;
        float y1 = y + h + pixelh * 0.5f;
        int cellw = (int)Math.ceil(w * dxdist - 0.001953125f);
        int cellh = (int)Math.ceil(h * dydist - 0.001953125f);
        VertexBuffer vb = this.context.getVertexBuffer();
        int max = this.context.getRectTextureMaxSize();
        if (cellw <= max && cellh <= max) {
            float u0 = (float)(cellw * (cellw + 1) / 2) - 0.5f;
            float v0 = (float)(cellh * (cellh + 1) / 2) - 0.5f;
            float u1 = u0 + (float)cellw + 1.0f;
            float v1 = v0 + (float)cellh + 1.0f;
            u0 /= (float)rectTex.getPhysicalWidth();
            v0 /= (float)rectTex.getPhysicalHeight();
            u1 /= (float)rectTex.getPhysicalWidth();
            v1 /= (float)rectTex.getPhysicalHeight();
            if (xform.isTranslateOrIdentity()) {
                x0 += mxt;
                y0 += myt;
                x1 += mxt;
                y1 += myt;
                xform = IDENT;
            } else {
                if (xform.is2D()) {
                    Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext.MaskType.ALPHA_TEXTURE, rectTex, bx, by, bw, bh);
                    AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, bx, by, bw, bh);
                    if (paintTx == null) {
                        vb.addMappedPgram(x0 * mxx + y0 * mxy + mxt, x0 * myx + y0 * myy + myt, x1 * mxx + y0 * mxy + mxt, x1 * myx + y0 * myy + myt, x0 * mxx + y1 * mxy + mxt, x0 * myx + y1 * myy + myt, x1 * mxx + y1 * mxy + mxt, x1 * myx + y1 * myy + myt, u0, v0, u1, v0, u0, v1, u1, v1, 0.0f, 0.0f);
                    } else {
                        vb.addMappedPgram(x0 * mxx + y0 * mxy + mxt, x0 * myx + y0 * myy + myt, x1 * mxx + y0 * mxy + mxt, x1 * myx + y0 * myy + myt, x0 * mxx + y1 * mxy + mxt, x0 * myx + y1 * myy + myt, x1 * mxx + y1 * mxy + mxt, x1 * myx + y1 * myy + myt, u0, v0, u1, v0, u0, v1, u1, v1, x0, y0, x1, y1, paintTx);
                    }
                    return true;
                }
                System.out.println("Not a 2d transform!");
                myt = 0.0f;
                mxt = 0.0f;
            }
            Shader shader = this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, rectTex, bx, by, bw, bh);
            AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, bx, by, bw, bh);
            if (paintTx == null) {
                vb.addQuad(x0, y0, x1, y1, u0, v0, u1, v1);
            } else {
                paintTx.translate(-mxt, -myt);
                vb.addQuad(x0, y0, x1, y1, u0, v0, u1, v1, paintTx);
            }
            return true;
        }
        if (wrapTex == null) {
            return false;
        }
        float u0 = 0.5f / (float)wrapTex.getPhysicalWidth();
        float v0 = 0.5f / (float)wrapTex.getPhysicalHeight();
        float uc = ((float)cellw * 0.5f + 1.0f) / (float)wrapTex.getPhysicalWidth();
        float vc = ((float)cellh * 0.5f + 1.0f) / (float)wrapTex.getPhysicalHeight();
        float xc = x + w * 0.5f;
        float yc = y + h * 0.5f;
        if (xform.isTranslateOrIdentity()) {
            x0 += mxt;
            y0 += myt;
            xc += mxt;
            yc += myt;
            x1 += mxt;
            y1 += myt;
            xform = IDENT;
        } else {
            if (xform.is2D()) {
                Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext.MaskType.ALPHA_TEXTURE, wrapTex, bx, by, bw, bh);
                AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, bx, by, bw, bh);
                float mxx_x0 = mxx * x0;
                float myx_x0 = myx * x0;
                float mxy_y0 = mxy * y0;
                float myy_y0 = myy * y0;
                float mxx_xc = mxx * xc;
                float myx_xc = myx * xc;
                float mxy_yc = mxy * yc;
                float myy_yc = myy * yc;
                float mxx_x1 = mxx * x1;
                float myx_x1 = myx * x1;
                float mxy_y1 = mxy * y1;
                float myy_y1 = myy * y1;
                float xcc = mxx_xc + mxy_yc + mxt;
                float ycc = myx_xc + myy_yc + myt;
                float xc0 = mxx_xc + mxy_y0 + mxt;
                float yc0 = myx_xc + myy_y0 + myt;
                float x0c = mxx_x0 + mxy_yc + mxt;
                float y0c = myx_x0 + myy_yc + myt;
                float xc1 = mxx_xc + mxy_y1 + mxt;
                float yc1 = myx_xc + myy_y1 + myt;
                float x1c = mxx_x1 + mxy_yc + mxt;
                float y1c = myx_x1 + myy_yc + myt;
                if (paintTx == null) {
                    vb.addMappedPgram(x0 * mxx + y0 * mxy + mxt, x0 * myx + y0 * myy + myt, xc0, yc0, x0c, y0c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
                    vb.addMappedPgram(x1 * mxx + y0 * mxy + mxt, x1 * myx + y0 * myy + myt, xc0, yc0, x1c, y1c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
                    vb.addMappedPgram(x0 * mxx + y1 * mxy + mxt, x0 * myx + y1 * myy + myt, xc1, yc1, x0c, y0c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
                    vb.addMappedPgram(x1 * mxx + y1 * mxy + mxt, x1 * myx + y1 * myy + myt, xc1, yc1, x1c, y1c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
                } else {
                    vb.addMappedPgram(x0 * mxx + y0 * mxy + mxt, x0 * myx + y0 * myy + myt, xc0, yc0, x0c, y0c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, x0, y0, xc, yc, paintTx);
                    vb.addMappedPgram(x1 * mxx + y0 * mxy + mxt, x1 * myx + y0 * myy + myt, xc0, yc0, x1c, y1c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, x1, y0, xc, yc, paintTx);
                    vb.addMappedPgram(x0 * mxx + y1 * mxy + mxt, x0 * myx + y1 * myy + myt, xc1, yc1, x0c, y0c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, x0, y1, xc, yc, paintTx);
                    vb.addMappedPgram(x1 * mxx + y1 * mxy + mxt, x1 * myx + y1 * myy + myt, xc1, yc1, x1c, y1c, xcc, ycc, u0, v0, uc, v0, u0, vc, uc, vc, x1, y1, xc, yc, paintTx);
                }
                return true;
            }
            System.out.println("Not a 2d transform!");
            myt = 0.0f;
            mxt = 0.0f;
        }
        Shader shader = this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, wrapTex, bx, by, bw, bh);
        AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, bx, by, bw, bh);
        if (paintTx != null) {
            paintTx.translate(-mxt, -myt);
        }
        vb.addQuad(x0, y0, xc, yc, u0, v0, uc, vc, paintTx);
        vb.addQuad(x1, y0, xc, yc, u0, v0, uc, vc, paintTx);
        vb.addQuad(x0, y1, xc, yc, u0, v0, uc, vc, paintTx);
        vb.addQuad(x1, y1, xc, yc, u0, v0, uc, vc, paintTx);
        return true;
    }

    boolean drawPrimRect(float x, float y, float w, float h) {
        float lw = this.stroke.getLineWidth();
        float pad = BaseShaderGraphics.getStrokeExpansionFactor(this.stroke) * lw;
        BaseTransform xform = this.getTransformNoClone();
        float mxx = (float)xform.getMxx();
        float mxy = (float)xform.getMxy();
        float mxt = (float)xform.getMxt();
        float myx = (float)xform.getMyx();
        float myy = (float)xform.getMyy();
        float myt = (float)xform.getMyt();
        float dxdist = BaseShaderGraphics.len(mxx, myx);
        float dydist = BaseShaderGraphics.len(mxy, myy);
        if (dxdist == 0.0f || dydist == 0.0f) {
            return true;
        }
        float pixelw = 1.0f / dxdist;
        float pixelh = 1.0f / dydist;
        float x0 = x - pad - pixelw * 0.5f;
        float y0 = y - pad - pixelh * 0.5f;
        float xc = x + w * 0.5f;
        float yc = y + h * 0.5f;
        float x1 = x + w + pad + pixelw * 0.5f;
        float y1 = y + h + pad + pixelh * 0.5f;
        Texture rTex = this.context.getWrapRectTexture();
        float wscale = 1.0f / (float)rTex.getPhysicalWidth();
        float hscale = 1.0f / (float)rTex.getPhysicalHeight();
        float ou0 = 0.5f * wscale;
        float ov0 = 0.5f * hscale;
        float ouc = ((w * 0.5f + pad) * dxdist + 1.0f) * wscale;
        float ovc = ((h * 0.5f + pad) * dydist + 1.0f) * hscale;
        float offsetx = lw * dxdist * wscale;
        float offsety = lw * dydist * hscale;
        VertexBuffer vb = this.context.getVertexBuffer();
        if (xform.isTranslateOrIdentity()) {
            x0 += mxt;
            y0 += myt;
            xc += mxt;
            yc += myt;
            x1 += mxt;
            y1 += myt;
            xform = IDENT;
        } else {
            if (xform.is2D()) {
                Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext.MaskType.ALPHA_TEXTURE_DIFF, rTex, x, y, w, h, offsetx, offsety, 0.0f, 0.0f, 0.0f, 0.0f);
                shader.setConstant("innerOffset", offsetx, offsety);
                AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, x, y, w, h);
                float mxx_x0 = mxx * x0;
                float myx_x0 = myx * x0;
                float mxy_y0 = mxy * y0;
                float myy_y0 = myy * y0;
                float mxx_xc = mxx * xc;
                float myx_xc = myx * xc;
                float mxy_yc = mxy * yc;
                float myy_yc = myy * yc;
                float mxx_x1 = mxx * x1;
                float myx_x1 = myx * x1;
                float mxy_y1 = mxy * y1;
                float myy_y1 = myy * y1;
                float xcc = mxx_xc + mxy_yc + mxt;
                float ycc = myx_xc + myy_yc + myt;
                float xc0 = mxx_xc + mxy_y0 + mxt;
                float yc0 = myx_xc + myy_y0 + myt;
                float x0c = mxx_x0 + mxy_yc + mxt;
                float y0c = myx_x0 + myy_yc + myt;
                float xc1 = mxx_xc + mxy_y1 + mxt;
                float yc1 = myx_xc + myy_y1 + myt;
                float x1c = mxx_x1 + mxy_yc + mxt;
                float y1c = myx_x1 + myy_yc + myt;
                if (paintTx == null) {
                    vb.addMappedPgram(mxx_x0 + mxy_y0 + mxt, myx_x0 + myy_y0 + myt, xc0, yc0, x0c, y0c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, 0.0f, 0.0f);
                    vb.addMappedPgram(mxx_x1 + mxy_y0 + mxt, myx_x1 + myy_y0 + myt, xc0, yc0, x1c, y1c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, 0.0f, 0.0f);
                    vb.addMappedPgram(mxx_x0 + mxy_y1 + mxt, myx_x0 + myy_y1 + myt, xc1, yc1, x0c, y0c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, 0.0f, 0.0f);
                    vb.addMappedPgram(mxx_x1 + mxy_y1 + mxt, myx_x1 + myy_y1 + myt, xc1, yc1, x1c, y1c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, 0.0f, 0.0f);
                } else {
                    vb.addMappedPgram(mxx_x0 + mxy_y0 + mxt, myx_x0 + myy_y0 + myt, xc0, yc0, x0c, y0c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, x0, y0, xc, yc, paintTx);
                    vb.addMappedPgram(mxx_x1 + mxy_y0 + mxt, myx_x1 + myy_y0 + myt, xc0, yc0, x1c, y1c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, x1, y0, xc, yc, paintTx);
                    vb.addMappedPgram(mxx_x0 + mxy_y1 + mxt, myx_x0 + myy_y1 + myt, xc1, yc1, x0c, y0c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, x0, y1, xc, yc, paintTx);
                    vb.addMappedPgram(mxx_x1 + mxy_y1 + mxt, myx_x1 + myy_y1 + myt, xc1, yc1, x1c, y1c, xcc, ycc, ou0, ov0, ouc, ov0, ou0, ovc, ouc, ovc, x1, y1, xc, yc, paintTx);
                }
                rTex.unlock();
                return true;
            }
            System.out.println("Not a 2d transform!");
            myt = 0.0f;
            mxt = 0.0f;
        }
        Shader shader = this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE_DIFF, rTex, x, y, w, h, offsetx, offsety, 0.0f, 0.0f, 0.0f, 0.0f);
        shader.setConstant("innerOffset", offsetx, offsety);
        AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, x, y, w, h);
        if (paintTx != null) {
            paintTx.translate(-mxt, -myt);
        }
        vb.addQuad(x0, y0, xc, yc, ou0, ov0, ouc, ovc, paintTx);
        vb.addQuad(x1, y0, xc, yc, ou0, ov0, ouc, ovc, paintTx);
        vb.addQuad(x0, y1, xc, yc, ou0, ov0, ouc, ovc, paintTx);
        vb.addQuad(x1, y1, xc, yc, ou0, ov0, ouc, ovc, paintTx);
        rTex.unlock();
        return true;
    }

    boolean drawPrimDiagonal(float x1, float y1, float x2, float y2, float lw, int cap, float bx, float by, float bw, float bh) {
        int cellh;
        int cellw;
        float vdy;
        float vdx;
        float hdy;
        float hdx;
        if (this.stroke.getType() == 0) {
            lw *= 0.5f;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        float len = BaseShaderGraphics.len(dx, dy);
        float ldx = (dx /= len) * lw;
        float ldy = (dy /= len) * lw;
        float xUL = x1 + ldy;
        float yUL = y1 - ldx;
        float xUR = x2 + ldy;
        float yUR = y2 - ldx;
        float xLL = x1 - ldy;
        float yLL = y1 + ldx;
        float xLR = x2 - ldy;
        float yLR = y2 + ldx;
        if (cap == 2) {
            xUL -= ldx;
            yUL -= ldy;
            xLL -= ldx;
            yLL -= ldy;
            xUR += ldx;
            yUR += ldy;
            xLR += ldx;
            yLR += ldy;
        }
        BaseTransform xform = this.getTransformNoClone();
        float mxt = (float)xform.getMxt();
        float myt = (float)xform.getMyt();
        if (xform.isTranslateOrIdentity()) {
            hdx = dx;
            hdy = dy;
            vdx = dy;
            vdy = -dx;
            cellw = (int)Math.ceil(BaseShaderGraphics.len(xUR - xUL, yUR - yUL));
            cellh = (int)Math.ceil(BaseShaderGraphics.len(xLL - xUL, yLL - yUL));
            xform = IDENT;
        } else if (xform.is2D()) {
            float mxx = (float)xform.getMxx();
            float mxy = (float)xform.getMxy();
            float myx = (float)xform.getMyx();
            float myy = (float)xform.getMyy();
            float tx = mxx * xUL + mxy * yUL;
            float ty = myx * xUL + myy * yUL;
            xUL = tx;
            yUL = ty;
            tx = mxx * xUR + mxy * yUR;
            ty = myx * xUR + myy * yUR;
            xUR = tx;
            yUR = ty;
            tx = mxx * xLL + mxy * yLL;
            ty = myx * xLL + myy * yLL;
            xLL = tx;
            yLL = ty;
            tx = mxx * xLR + mxy * yLR;
            ty = myx * xLR + myy * yLR;
            xLR = tx;
            yLR = ty;
            hdx = mxx * dx + mxy * dy;
            hdy = myx * dx + myy * dy;
            float dlen = BaseShaderGraphics.len(hdx, hdy);
            if (dlen == 0.0f) {
                return true;
            }
            hdx /= dlen;
            hdy /= dlen;
            vdx = mxx * dy - mxy * dx;
            vdy = myx * dy - myy * dx;
            dlen = BaseShaderGraphics.len(vdx, vdy);
            if (dlen == 0.0f) {
                return true;
            }
            cellw = (int)Math.ceil(Math.abs((xUR - xUL) * hdx + (yUR - yUL) * hdy));
            cellh = (int)Math.ceil(Math.abs((xLL - xUL) * (vdx /= dlen) + (yLL - yUL) * (vdy /= dlen)));
            xform = IDENT;
        } else {
            System.out.println("Not a 2d transform!");
            return false;
        }
        xUL = xUL + mxt + (vdx *= 0.5f) - (hdx *= 0.5f);
        yUL = yUL + myt + (vdy *= 0.5f) - (hdy *= 0.5f);
        xUR = xUR + mxt + vdx + hdx;
        yUR = yUR + myt + vdy + hdy;
        xLL = xLL + mxt - vdx - hdx;
        yLL = yLL + myt - vdy - hdy;
        xLR = xLR + mxt - vdx + hdx;
        yLR = yLR + myt - vdy + hdy;
        VertexBuffer vb = this.context.getVertexBuffer();
        int cellmax = this.context.getRectTextureMaxSize();
        if (cellh <= cellmax) {
            float u1;
            float u0;
            float v0 = (float)(cellh * (cellh + 1) / 2) - 0.5f;
            float v1 = v0 + (float)cellh + 1.0f;
            Texture rTex = this.context.getRectTexture();
            v0 /= (float)rTex.getPhysicalHeight();
            v1 /= (float)rTex.getPhysicalHeight();
            if (cellw <= cellmax) {
                u0 = (float)(cellw * (cellw + 1) / 2) - 0.5f;
                u1 = u0 + (float)cellw + 1.0f;
                this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, rTex, bx, by, bw, bh);
                vb.addMappedPgram(xUL, yUL, xUR, yUR, xLL, yLL, xLR, yLR, u0 /= (float)rTex.getPhysicalWidth(), v0, u1 /= (float)rTex.getPhysicalWidth(), v0, u0, v1, u1, v1, 0.0f, 0.0f);
                rTex.unlock();
                return true;
            }
            if (cellw <= cellmax * 2 - 1) {
                float xUC = (xUL + xUR) * 0.5f;
                float yUC = (yUL + yUR) * 0.5f;
                float xLC = (xLL + xLR) * 0.5f;
                float yLC = (yLL + yLR) * 0.5f;
                float u02 = (float)(cellmax * (cellmax + 1) / 2) - 0.5f;
                float u12 = u02 + 0.5f + (float)cellw * 0.5f;
                this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, rTex, bx, by, bw, bh);
                vb.addMappedPgram(xUL, yUL, xUC, yUC, xLL, yLL, xLC, yLC, u02 /= (float)rTex.getPhysicalWidth(), v0, u12 /= (float)rTex.getPhysicalWidth(), v0, u02, v1, u12, v1, 0.0f, 0.0f);
                vb.addMappedPgram(xUR, yUR, xUC, yUC, xLR, yLR, xLC, yLC, u02, v0, u12, v0, u02, v1, u12, v1, 0.0f, 0.0f);
                rTex.unlock();
                return true;
            }
            u0 = 0.5f / (float)rTex.getPhysicalWidth();
            u1 = 1.5f / (float)rTex.getPhysicalWidth();
            float xUl = xUL + (hdx *= 2.0f);
            float yUl = yUL + (hdy *= 2.0f);
            float xUr = xUR - hdx;
            float yUr = yUR - hdy;
            float xLl = xLL + hdx;
            float yLl = yLL + hdy;
            float xLr = xLR - hdx;
            float yLr = yLR - hdy;
            this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, rTex, bx, by, bw, bh);
            vb.addMappedPgram(xUL, yUL, xUl, yUl, xLL, yLL, xLl, yLl, u0, v0, u1, v0, u0, v1, u1, v1, 0.0f, 0.0f);
            vb.addMappedPgram(xUl, yUl, xUr, yUr, xLl, yLl, xLr, yLr, u1, v0, u1, v0, u1, v1, u1, v1, 0.0f, 0.0f);
            vb.addMappedPgram(xUr, yUr, xUR, yUR, xLr, yLr, xLR, yLR, u1, v0, u0, v0, u1, v1, u0, v1, 0.0f, 0.0f);
            rTex.unlock();
            return true;
        }
        float xUC = (xUL + xUR) * 0.5f;
        float yUC = (yUL + yUR) * 0.5f;
        float xLC = (xLL + xLR) * 0.5f;
        float yLC = (yLL + yLR) * 0.5f;
        float xCL = (xUL + xLL) * 0.5f;
        float yCL = (yUL + yLL) * 0.5f;
        float xCR = (xUR + xLR) * 0.5f;
        float yCR = (yUR + yLR) * 0.5f;
        float xCC = (xUC + xLC) * 0.5f;
        float yCC = (yUC + yLC) * 0.5f;
        Texture rTex = this.context.getWrapRectTexture();
        float u0 = 0.5f / (float)rTex.getPhysicalWidth();
        float v0 = 0.5f / (float)rTex.getPhysicalHeight();
        float uc = ((float)cellw * 0.5f + 1.0f) / (float)rTex.getPhysicalWidth();
        float vc = ((float)cellh * 0.5f + 1.0f) / (float)rTex.getPhysicalHeight();
        this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_TEXTURE, rTex, bx, by, bw, bh);
        vb.addMappedPgram(xUL, yUL, xUC, yUC, xCL, yCL, xCC, yCC, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
        vb.addMappedPgram(xUR, yUR, xUC, yUC, xCR, yCR, xCC, yCC, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
        vb.addMappedPgram(xLL, yLL, xLC, yLC, xCL, yCL, xCC, yCC, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
        vb.addMappedPgram(xLR, yLR, xLC, yLC, xCR, yCR, xCC, yCC, u0, v0, uc, v0, u0, vc, uc, vc, 0.0f, 0.0f);
        rTex.unlock();
        return true;
    }

    @Override
    public void fillRect(float x, float y, float w, float h) {
        if (w <= 0.0f || h <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(x, y, w, h, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, x, y, w, h);
            return;
        }
        if (PrismSettings.primTextureSize != 0) {
            Texture rTex = this.context.getRectTexture();
            Texture wTex = this.context.getWrapRectTexture();
            boolean success = this.fillPrimRect(x, y, w, h, rTex, wTex, x, y, w, h);
            rTex.unlock();
            wTex.unlock();
            if (success) {
                return;
            }
        }
        this.renderGeneralRoundedRect(x, y, w, h, 0.0f, 0.0f, BaseShaderContext.MaskType.FILL_PGRAM, null);
    }

    @Override
    public void fillEllipse(float x, float y, float w, float h) {
        if (w <= 0.0f || h <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchEllipse.setFrame(x, y, w, h);
            this.renderWithComplexPaint(scratchEllipse, null, x, y, w, h);
            return;
        }
        if (PrismSettings.primTextureSize != 0 && this.fillPrimRect(x, y, w, h, this.context.getOvalTexture(), null, x, y, w, h)) {
            return;
        }
        this.renderGeneralRoundedRect(x, y, w, h, w, h, BaseShaderContext.MaskType.FILL_ELLIPSE, null);
    }

    @Override
    public void fillRoundRect(float x, float y, float w, float h, float arcw, float arch) {
        arcw = Math.min(Math.abs(arcw), w);
        arch = Math.min(Math.abs(arch), h);
        if (w <= 0.0f || h <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(x, y, w, h, arcw, arch);
            this.renderWithComplexPaint(scratchRRect, null, x, y, w, h);
            return;
        }
        this.renderGeneralRoundedRect(x, y, w, h, arcw, arch, BaseShaderContext.MaskType.FILL_ROUNDRECT, null);
    }

    @Override
    public void fillQuad(float x1, float y1, float x2, float y2) {
        float bh;
        float by;
        float bw;
        float bx;
        if (x1 <= x2) {
            bx = x1;
            bw = x2 - x1;
        } else {
            bx = x2;
            bw = x1 - x2;
        }
        if (y1 <= y2) {
            by = y1;
            bh = y2 - y1;
        } else {
            by = y2;
            bh = y1 - y2;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(bx, by, bw, bh, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, bx, by, bw, bh);
            return;
        }
        BaseTransform xform = this.getTransformNoClone();
        if (PrismSettings.primTextureSize != 0) {
            float myt;
            float mxt;
            if (xform.isTranslateOrIdentity()) {
                mxt = (float)xform.getMxt();
                myt = (float)xform.getMyt();
                xform = IDENT;
                x1 += mxt;
                y1 += myt;
                x2 += mxt;
                y2 += myt;
            } else {
                myt = 0.0f;
                mxt = 0.0f;
            }
            Shader shader = this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.ALPHA_ONE, null, bx, by, bw, bh);
            AffineBase paintTx = this.getPaintTextureTx(IDENT, shader, bx, by, bw, bh);
            if (paintTx != null) {
                paintTx.translate(-mxt, -myt);
            }
            this.context.getVertexBuffer().addQuad(x1, y1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f, paintTx);
            return;
        }
        if (this.isSimpleTranslate) {
            xform = IDENT;
            bx += this.transX;
            by += this.transY;
        }
        this.context.validatePaintOp(this, xform, BaseShaderContext.MaskType.SOLID, bx, by, bw, bh);
        VertexBuffer vb = this.context.getVertexBuffer();
        vb.addQuad(bx, by, bx + bw, by + bh);
    }

    private static boolean canUseStrokeShader(BasicStroke bs) {
        return !bs.isDashed() && (bs.getType() == 1 || bs.getLineJoin() == 1 || bs.getLineJoin() == 0 && (double)bs.getMiterLimit() >= SQRT_2);
    }

    @Override
    public void blit(RTTexture srcTex, RTTexture dstTex, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1) {
        if (dstTex == null) {
            this.context.setRenderTarget(this);
        } else {
            this.context.setRenderTarget((BaseGraphics)dstTex.createGraphics());
        }
        this.context.blit(srcTex, dstTex, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1);
    }

    @Override
    public void drawRect(float x, float y, float w, float h) {
        if (w < 0.0f || h < 0.0f) {
            return;
        }
        if (w == 0.0f || h == 0.0f) {
            this.drawLine(x, y, x + w, y + h);
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(x, y, w, h, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, this.stroke, x, y, w, h);
            return;
        }
        if (BaseShaderGraphics.canUseStrokeShader(this.stroke)) {
            if (PrismSettings.primTextureSize != 0 && this.stroke.getLineJoin() != 1 && this.drawPrimRect(x, y, w, h)) {
                return;
            }
            this.renderGeneralRoundedRect(x, y, w, h, 0.0f, 0.0f, BaseShaderContext.MaskType.DRAW_PGRAM, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(x, y, w, h, 0.0f, 0.0f);
        this.renderShape(scratchRRect, this.stroke, x, y, w, h);
    }

    private boolean checkInnerCurvature(float arcw, float arch) {
        float inset = this.stroke.getLineWidth() * (1.0f - BaseShaderGraphics.getStrokeExpansionFactor(this.stroke));
        return (arcw -= inset) <= 0.0f || (arch -= inset) <= 0.0f || arcw * 2.0f > arch && arch * 2.0f > arcw;
    }

    @Override
    public void drawEllipse(float x, float y, float w, float h) {
        if (w < 0.0f || h < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(w, h)) {
            this.renderGeneralRoundedRect(x, y, w, h, w, h, BaseShaderContext.MaskType.DRAW_ELLIPSE, this.stroke);
            return;
        }
        scratchEllipse.setFrame(x, y, w, h);
        this.renderShape(scratchEllipse, this.stroke, x, y, w, h);
    }

    @Override
    public void drawRoundRect(float x, float y, float w, float h, float arcw, float arch) {
        arcw = Math.min(Math.abs(arcw), w);
        arch = Math.min(Math.abs(arch), h);
        if (w < 0.0f || h < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(arcw, arch)) {
            this.renderGeneralRoundedRect(x, y, w, h, arcw, arch, BaseShaderContext.MaskType.DRAW_ROUNDRECT, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(x, y, w, h, arcw, arch);
        this.renderShape(scratchRRect, this.stroke, x, y, w, h);
    }

    @Override
    public void drawLine(float x1, float y1, float x2, float y2) {
        BaseShaderContext.MaskType type;
        float arcfracth;
        float arcfractw;
        BaseTransform rendertx;
        float pdy;
        float pdx;
        float ldy;
        float ldx;
        float dy;
        float dx;
        float len;
        float bh;
        float by;
        float bw;
        float bx;
        if (x1 <= x2) {
            bx = x1;
            bw = x2 - x1;
        } else {
            bx = x2;
            bw = x1 - x2;
        }
        if (y1 <= y2) {
            by = y1;
            bh = y2 - y1;
        } else {
            by = y2;
            bh = y1 - y2;
        }
        if (this.stroke.getType() == 1) {
            return;
        }
        if (this.isComplexPaint) {
            scratchLine.setLine(x1, y1, x2, y2);
            this.renderWithComplexPaint(scratchLine, this.stroke, bx, by, bw, bh);
            return;
        }
        int cap = this.stroke.getEndCap();
        if (this.stroke.isDashed()) {
            scratchLine.setLine(x1, y1, x2, y2);
            this.renderShape(scratchLine, this.stroke, bx, by, bw, bh);
            return;
        }
        float lw = this.stroke.getLineWidth();
        if (PrismSettings.primTextureSize != 0 && cap != 1) {
            float pad = lw;
            if (this.stroke.getType() == 0) {
                pad *= 0.5f;
            }
            if (bw == 0.0f || bh == 0.0f) {
                float padx;
                float pady;
                if (cap == 2) {
                    padx = pady = pad;
                } else if (bw != 0.0f) {
                    padx = 0.0f;
                    pady = pad;
                } else if (bh != 0.0f) {
                    padx = pad;
                    pady = 0.0f;
                } else {
                    return;
                }
                Texture rTex = this.context.getRectTexture();
                Texture wTex = this.context.getWrapRectTexture();
                boolean success = this.fillPrimRect(bx - padx, by - pady, bw + padx + padx, bh + pady + pady, rTex, wTex, bx, by, bw, bh);
                rTex.unlock();
                wTex.unlock();
                if (success) {
                    return;
                }
            } else if (this.drawPrimDiagonal(x1, y1, x2, y2, lw, cap, bx, by, bw, bh)) {
                return;
            }
        }
        if (this.stroke.getType() == 2) {
            lw *= 2.0f;
        }
        if ((len = BaseShaderGraphics.len(dx = x2 - x1, dy = y2 - y1)) == 0.0f) {
            if (cap == 0) {
                return;
            }
            ldx = lw;
            ldy = 0.0f;
        } else {
            ldx = lw * dx / len;
            ldy = lw * dy / len;
        }
        BaseTransform xform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            double tx = xform.getMxt();
            double ty = xform.getMyt();
            x1 = (float)((double)x1 + tx);
            y1 = (float)((double)y1 + ty);
            x2 = (float)((double)x2 + tx);
            y2 = (float)((double)y2 + ty);
            pdx = ldy;
            pdy = -ldx;
            rendertx = IDENT;
        } else {
            rendertx = this.extract3Dremainder(xform);
            double[] coords = new double[]{x1, y1, x2, y2};
            xform.transform(coords, 0, coords, 0, 2);
            x1 = (float)coords[0];
            y1 = (float)coords[1];
            x2 = (float)coords[2];
            y2 = (float)coords[3];
            dx = x2 - x1;
            dy = y2 - y1;
            coords[0] = ldx;
            coords[1] = ldy;
            coords[2] = ldy;
            coords[3] = -ldx;
            xform.deltaTransform(coords, 0, coords, 0, 2);
            ldx = (float)coords[0];
            ldy = (float)coords[1];
            pdx = (float)coords[2];
            pdy = (float)coords[3];
        }
        float px = x1 - pdx / 2.0f;
        float py = y1 - pdy / 2.0f;
        if (cap != 0) {
            px -= ldx / 2.0f;
            py -= ldy / 2.0f;
            dx += ldx;
            dy += ldy;
            if (cap == 1) {
                arcfractw = BaseShaderGraphics.len(ldx, ldy) / BaseShaderGraphics.len(dx, dy);
                arcfracth = 1.0f;
                type = BaseShaderContext.MaskType.FILL_ROUNDRECT;
            } else {
                arcfracth = 0.0f;
                arcfractw = 0.0f;
                type = BaseShaderContext.MaskType.FILL_PGRAM;
            }
        } else {
            arcfracth = 0.0f;
            arcfractw = 0.0f;
            type = BaseShaderContext.MaskType.FILL_PGRAM;
        }
        this.renderGeneralRoundedPgram(px, py, dx, dy, pdx, pdy, arcfractw, arcfracth, 0.0f, 0.0f, rendertx, type, bx, by, bw, bh);
    }

    private static float len(float x, float y) {
        return x == 0.0f ? Math.abs(y) : (y == 0.0f ? Math.abs(x) : (float)Math.sqrt(x * x + y * y));
    }

    @Override
    public void setNodeBounds(RectBounds bounds) {
        this.nodeBounds = bounds;
        this.lcdSampleInvalid = bounds != null;
    }

    private void initLCDSampleRT() {
        if (this.lcdSampleInvalid) {
            RectBounds textBounds = new RectBounds();
            this.getTransformNoClone().transform(this.nodeBounds, textBounds);
            Rectangle clipRect = this.getClipRectNoClone();
            if (clipRect != null && !clipRect.isEmpty()) {
                textBounds.intersectWith(clipRect);
            }
            float bx = textBounds.getMinX() - 1.0f;
            float by = textBounds.getMinY();
            float bw = textBounds.getWidth() + 2.0f;
            float bh = textBounds.getHeight() + 1.0f;
            this.context.validateLCDBuffer(this.getRenderTarget());
            BaseShaderGraphics bsg = (BaseShaderGraphics)this.context.getLCDBuffer().createGraphics();
            bsg.setCompositeMode(CompositeMode.SRC);
            this.context.validateLCDOp(bsg, IDENT, (Texture)((Object)this.getRenderTarget()), null, true, null);
            int srch = this.getRenderTarget().getPhysicalHeight();
            int srcw = this.getRenderTarget().getPhysicalWidth();
            float tx1 = bx / (float)srcw;
            float ty1 = by / (float)srch;
            float tx2 = (bx + bw) / (float)srcw;
            float ty2 = (by + bh) / (float)srch;
            bsg.drawLCDBuffer(bx, by, bw, bh, tx1, ty1, tx2, ty2);
            this.context.setRenderTarget(this);
        }
        this.lcdSampleInvalid = false;
    }

    @Override
    public void drawString(GlyphList gl, FontStrike strike, float x, float y, Color selectColor, int selectStart, int selectEnd) {
        boolean lcdSupported;
        if (this.isComplexPaint || this.paint.getType().isImagePattern() || strike.drawAsShapes()) {
            BaseTransform xform = BaseTransform.getTranslateInstance(x, y);
            Shape shape = strike.getOutline(gl, xform);
            this.fill(shape);
            return;
        }
        BaseTransform xform = this.getTransformNoClone();
        Paint textPaint = this.getPaint();
        Color textColor = textPaint.getType() == Paint.Type.COLOR ? (Color)textPaint : null;
        CompositeMode blendMode = this.getCompositeMode();
        boolean bl = lcdSupported = blendMode == CompositeMode.SRC_OVER && textColor != null && xform.is2D() && !this.getRenderTarget().isMSAA();
        if (strike.getAAMode() == 1 && !lcdSupported) {
            FontResource fr = strike.getFontResource();
            float size = strike.getSize();
            BaseTransform tx = strike.getTransform();
            strike = fr.getStrike(size, tx, 0);
        }
        float bx = 0.0f;
        float by = 0.0f;
        float bw = 0.0f;
        float bh = 0.0f;
        if (this.paint.getType().isGradient() && ((Gradient)this.paint).isProportional()) {
            RectBounds textBounds = this.nodeBounds;
            if (textBounds == null) {
                Metrics m = strike.getMetrics();
                float pad = -m.getAscent() * 0.4f;
                textBounds = new RectBounds(-pad, m.getAscent(), gl.getWidth() + 2.0f * pad, m.getDescent() + m.getLineGap());
                bx = x;
                by = y;
            }
            bx += textBounds.getMinX();
            by += textBounds.getMinY();
            bw = textBounds.getWidth();
            bh = textBounds.getHeight();
        }
        RectBounds clip = null;
        Point2D p2d = new Point2D(x, y);
        if (this.isSimpleTranslate) {
            clip = this.getFinalClipNoClone();
            xform = IDENT;
            p2d.x += this.transX;
            p2d.y += this.transY;
        }
        GlyphCache glyphCache = this.context.getGlyphCache(strike);
        Texture cacheTex = glyphCache.getBackingStore();
        if (strike.getAAMode() == 1) {
            if (this.nodeBounds == null) {
                Metrics m = strike.getMetrics();
                RectBounds textBounds = new RectBounds(x - 2.0f, y + m.getAscent(), x + 2.0f + gl.getWidth(), y + 1.0f + m.getDescent() + m.getLineGap());
                this.setNodeBounds(textBounds);
                this.initLCDSampleRT();
                this.setNodeBounds(null);
            } else {
                this.initLCDSampleRT();
            }
            float invgamma = PrismFontFactory.getLCDContrast();
            float gamma = 1.0f / invgamma;
            textColor = new Color((float)Math.pow(textColor.getRed(), invgamma), (float)Math.pow(textColor.getGreen(), invgamma), (float)Math.pow(textColor.getBlue(), invgamma), (float)Math.pow(textColor.getAlpha(), invgamma));
            if (selectColor != null) {
                selectColor = new Color((float)Math.pow(selectColor.getRed(), invgamma), (float)Math.pow(selectColor.getGreen(), invgamma), (float)Math.pow(selectColor.getBlue(), invgamma), (float)Math.pow(selectColor.getAlpha(), invgamma));
            }
            this.setCompositeMode(CompositeMode.SRC);
            Shader shader = this.context.validateLCDOp(this, IDENT, this.context.getLCDBuffer(), cacheTex, false, textColor);
            float unitXCoord = 1.0f / (float)cacheTex.getPhysicalWidth();
            shader.setConstant("gamma", gamma, invgamma, unitXCoord);
            this.setCompositeMode(blendMode);
        } else {
            this.context.validatePaintOp(this, IDENT, cacheTex, bx, by, bw, bh);
        }
        if (this.isSimpleTranslate) {
            p2d.y = Math.round(p2d.y);
            p2d.x = Math.round(p2d.x);
        }
        glyphCache.render(this.context, gl, p2d.x, p2d.y, selectStart, selectEnd, selectColor, textColor, xform, clip);
    }

    private void drawLCDBuffer(float bx, float by, float bw, float bh, float tx1, float ty1, float tx2, float ty2) {
        this.context.setRenderTarget(this);
        this.context.getVertexBuffer().addQuad(bx, by, bx + bw, by + bh, tx1, ty1, tx2, ty2);
    }

    @Override
    public boolean canReadBack() {
        RenderTarget rt = this.getRenderTarget();
        return rt instanceof ReadbackRenderTarget && ((ReadbackRenderTarget)rt).getBackBuffer() != null;
    }

    @Override
    public RTTexture readBack(Rectangle view) {
        RenderTarget rt = this.getRenderTarget();
        this.context.flushVertexBuffer();
        this.context.validateLCDBuffer(rt);
        RTTexture lcdrtt = this.context.getLCDBuffer();
        Texture bbtex = ((ReadbackRenderTarget)rt).getBackBuffer();
        float x1 = view.x;
        float y1 = view.y;
        float x2 = x1 + (float)view.width;
        float y2 = y1 + (float)view.height;
        BaseShaderGraphics bsg = (BaseShaderGraphics)lcdrtt.createGraphics();
        bsg.setCompositeMode(CompositeMode.SRC);
        this.context.validateTextureOp((BaseGraphics)bsg, IDENT, bbtex, bbtex.getPixelFormat());
        bsg.drawTexture(bbtex, 0.0f, 0.0f, view.width, view.height, x1, y1, x2, y2);
        this.context.flushVertexBuffer();
        this.context.setRenderTarget(this);
        return lcdrtt;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture rtt) {
    }

    @Override
    public void setup3DRendering() {
        this.context.setRenderTarget(this);
    }

    static /* synthetic */ Object lambda$static$429() {
        return System.getProperty("prism.primshaderpad");
    }

    static {
        String v = (String)AccessController.doPrivileged(BaseShaderGraphics$$Lambda$1.lambdaFactory$());
        if (v == null) {
            FRINGE_FACTOR = -0.5f;
        } else {
            FRINGE_FACTOR = -Float.valueOf(v).floatValue();
            System.out.println("Prism ShaderGraphics primitive shader pad = " + FRINGE_FACTOR);
        }
        SQRT_2 = Math.sqrt(2.0);
    }
}

