/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.TickCalculation;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AbstractMasterTimer$$Lambda$1;
import com.sun.scenario.animation.AnimationPulse;
import com.sun.scenario.animation.shared.PulseReceiver;
import com.sun.scenario.animation.shared.TimerReceiver;
import java.util.Arrays;
import javafx.util.Callback;

public abstract class AbstractMasterTimer {
    protected static final String FULLSPEED_PROP = "javafx.animation.fullspeed";
    private static boolean fullspeed = Settings.getBoolean("javafx.animation.fullspeed");
    protected static final String ADAPTIVE_PULSE_PROP = "com.sun.scenario.animation.adaptivepulse";
    private static boolean useAdaptivePulse = Settings.getBoolean("com.sun.scenario.animation.adaptivepulse");
    protected static final String PULSE_PROP = "javafx.animation.pulse";
    protected static final String FRAMERATE_PROP = "javafx.animation.framerate";
    protected static final String FIXED_PULSE_LENGTH_PROP = "com.sun.scenario.animation.fixed.pulse.length";
    protected static final String ANIMATION_MBEAN_ENABLED = "com.sun.scenario.animation.AnimationMBean.enabled";
    protected static final boolean enableAnimationMBean = false;
    private final int PULSE_DURATION_NS = this.getPulseDuration(1000000000);
    private final int PULSE_DURATION_TICKS = this.getPulseDuration((int)TickCalculation.fromMillis(1000.0));
    private static Callback<String, Void> pcl = AbstractMasterTimer$$Lambda$1.lambdaFactory$();
    private boolean paused = false;
    private long totalPausedTime;
    private long startPauseTime;
    private PulseReceiver[] receivers = new PulseReceiver[2];
    private int receiversLength;
    private boolean receiversLocked;
    private TimerReceiver[] animationTimers = new TimerReceiver[2];
    private int animationTimersLength;
    private boolean animationTimersLocked;
    private final long fixedPulseLength = Boolean.getBoolean("com.sun.scenario.animation.fixed.pulse.length") ? (long)this.PULSE_DURATION_NS : 0L;
    private long debugNanos = 0L;
    private final MainLoop theMaster = new MainLoop();

    boolean isPaused() {
        return this.paused;
    }

    long getTotalPausedTime() {
        return this.totalPausedTime;
    }

    long getStartPauseTime() {
        return this.startPauseTime;
    }

    public int getDefaultResolution() {
        return this.PULSE_DURATION_TICKS;
    }

    public void pause() {
        if (!this.paused) {
            this.startPauseTime = this.nanos();
            this.paused = true;
        }
    }

    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.totalPausedTime += this.nanos() - this.startPauseTime;
        }
    }

    public long nanos() {
        if (this.fixedPulseLength > 0L) {
            return this.debugNanos;
        }
        return this.paused ? this.startPauseTime : System.nanoTime() - this.totalPausedTime;
    }

    public boolean isFullspeed() {
        return fullspeed;
    }

    protected AbstractMasterTimer() {
    }

    public void addPulseReceiver(PulseReceiver target) {
        boolean needMoreSize;
        boolean bl = needMoreSize = this.receiversLength == this.receivers.length;
        if (this.receiversLocked || needMoreSize) {
            this.receivers = Arrays.copyOf(this.receivers, needMoreSize ? this.receivers.length * 3 / 2 + 1 : this.receivers.length);
            this.receiversLocked = false;
        }
        this.receivers[this.receiversLength++] = target;
        if (this.receiversLength == 1) {
            this.theMaster.updateAnimationRunnable();
        }
    }

    public void removePulseReceiver(PulseReceiver target) {
        if (this.receiversLocked) {
            this.receivers = (PulseReceiver[])this.receivers.clone();
            this.receiversLocked = false;
        }
        for (int i = 0; i < this.receiversLength; ++i) {
            if (target != this.receivers[i]) continue;
            if (i == this.receiversLength - 1) {
                this.receivers[i] = null;
            } else {
                System.arraycopy(this.receivers, i + 1, this.receivers, i, this.receiversLength - i - 1);
                this.receivers[this.receiversLength - 1] = null;
            }
            --this.receiversLength;
            break;
        }
        if (this.receiversLength == 0) {
            this.theMaster.updateAnimationRunnable();
        }
    }

    public void addAnimationTimer(TimerReceiver timer) {
        boolean needMoreSize;
        boolean bl = needMoreSize = this.animationTimersLength == this.animationTimers.length;
        if (this.animationTimersLocked || needMoreSize) {
            this.animationTimers = Arrays.copyOf(this.animationTimers, needMoreSize ? this.animationTimers.length * 3 / 2 + 1 : this.animationTimers.length);
            this.animationTimersLocked = false;
        }
        this.animationTimers[this.animationTimersLength++] = timer;
        if (this.animationTimersLength == 1) {
            this.theMaster.updateAnimationRunnable();
        }
    }

    public void removeAnimationTimer(TimerReceiver timer) {
        if (this.animationTimersLocked) {
            this.animationTimers = (TimerReceiver[])this.animationTimers.clone();
            this.animationTimersLocked = false;
        }
        for (int i = 0; i < this.animationTimersLength; ++i) {
            if (timer != this.animationTimers[i]) continue;
            if (i == this.animationTimersLength - 1) {
                this.animationTimers[i] = null;
            } else {
                System.arraycopy(this.animationTimers, i + 1, this.animationTimers, i, this.animationTimersLength - i - 1);
                this.animationTimers[this.animationTimersLength - 1] = null;
            }
            --this.animationTimersLength;
            break;
        }
        if (this.animationTimersLength == 0) {
            this.theMaster.updateAnimationRunnable();
        }
    }

    protected void recordStart(long shiftMillis) {
    }

    protected void recordEnd() {
    }

    protected void recordAnimationEnd() {
    }

    protected abstract void postUpdateAnimationRunnable(DelayedRunnable var1);

    protected abstract int getPulseDuration(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timePulseImpl(long now) {
        if (this.fixedPulseLength > 0L) {
            this.debugNanos += this.fixedPulseLength;
            now = this.debugNanos;
        }
        PulseReceiver[] receiversSnapshot = this.receivers;
        int rLength = this.receiversLength;
        try {
            this.receiversLocked = true;
            for (int i = 0; i < rLength; ++i) {
                receiversSnapshot[i].timePulse(TickCalculation.fromNano(now));
            }
        }
        finally {
            this.receiversLocked = false;
        }
        this.recordAnimationEnd();
        TimerReceiver[] animationTimersSnapshot = this.animationTimers;
        int aTLength = this.animationTimersLength;
        try {
            this.animationTimersLocked = true;
            for (int i = 0; i < aTLength; ++i) {
                animationTimersSnapshot[i].handle(now);
            }
        }
        finally {
            this.animationTimersLocked = false;
        }
    }

    static /* synthetic */ Void lambda$static$34(String key) {
        switch (key) {
            case "javafx.animation.fullspeed": {
                fullspeed = Settings.getBoolean(FULLSPEED_PROP);
                break;
            }
            case "com.sun.scenario.animation.adaptivepulse": {
                useAdaptivePulse = Settings.getBoolean(ADAPTIVE_PULSE_PROP);
                break;
            }
            case "com.sun.scenario.animation.AnimationMBean.enabled": {
                AnimationPulse.getDefaultBean().setEnabled(Settings.getBoolean(ANIMATION_MBEAN_ENABLED));
            }
        }
        return null;
    }

    static {
        Settings.addPropertyChangeListener(pcl);
        int pulse = Settings.getInt(PULSE_PROP, -1);
        if (pulse != -1) {
            System.err.println("Setting PULSE_DURATION to " + pulse + " hz");
        }
    }

    private final class MainLoop
    implements DelayedRunnable {
        private boolean inactive = true;
        private long nextPulseTime = AbstractMasterTimer.this.nanos();
        private long lastPulseDuration = Integer.MIN_VALUE;

        private MainLoop() {
        }

        @Override
        public void run() {
            if (AbstractMasterTimer.this.paused) {
                return;
            }
            long now = AbstractMasterTimer.this.nanos();
            AbstractMasterTimer.this.recordStart((this.nextPulseTime - now) / 1000000L);
            AbstractMasterTimer.this.timePulseImpl(now);
            AbstractMasterTimer.this.recordEnd();
            this.updateNextPulseTime(now);
            this.updateAnimationRunnable();
        }

        @Override
        public long getDelay() {
            long now = AbstractMasterTimer.this.nanos();
            long timeUntilPulse = (this.nextPulseTime - now) / 1000000L;
            return Math.max(0L, timeUntilPulse);
        }

        private void updateNextPulseTime(long pulseStarted) {
            long now = AbstractMasterTimer.this.nanos();
            if (fullspeed) {
                this.nextPulseTime = now;
            } else if (useAdaptivePulse) {
                this.nextPulseTime += (long)AbstractMasterTimer.this.PULSE_DURATION_NS;
                long pulseDuration = now - pulseStarted;
                if (pulseDuration - this.lastPulseDuration > 500000L) {
                    pulseDuration /= 2L;
                }
                if (pulseDuration < 2000000L) {
                    pulseDuration = 2000000L;
                }
                if (pulseDuration >= (long)AbstractMasterTimer.this.PULSE_DURATION_NS) {
                    pulseDuration = 3 * AbstractMasterTimer.this.PULSE_DURATION_NS / 4;
                }
                this.lastPulseDuration = pulseDuration;
                this.nextPulseTime -= pulseDuration;
            } else {
                this.nextPulseTime = (this.nextPulseTime + (long)AbstractMasterTimer.this.PULSE_DURATION_NS) / (long)AbstractMasterTimer.this.PULSE_DURATION_NS * (long)AbstractMasterTimer.this.PULSE_DURATION_NS;
            }
        }

        private void updateAnimationRunnable() {
            boolean newInactive;
            boolean bl = newInactive = AbstractMasterTimer.this.animationTimersLength == 0 && AbstractMasterTimer.this.receiversLength == 0;
            if (this.inactive != newInactive) {
                this.inactive = newInactive;
                MainLoop animationRunnable = this.inactive ? null : this;
                AbstractMasterTimer.this.postUpdateAnimationRunnable(animationRunnable);
            }
        }
    }
}

