/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.GaussianShadow;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.light.Light;

public class PhongLighting
extends CoreEffect<RenderState> {
    private float surfaceScale = 1.0f;
    private float diffuseConstant = 1.0f;
    private float specularConstant = 1.0f;
    private float specularExponent = 1.0f;
    private Light light;

    public PhongLighting(Light light) {
        this(light, new GaussianShadow(10.0f), DefaultInput);
    }

    public PhongLighting(Light light, Effect bumpInput, Effect contentInput) {
        super(bumpInput, contentInput);
        this.setLight(light);
    }

    public final Effect getBumpInput() {
        return this.getInputs().get(0);
    }

    public void setBumpInput(Effect bumpInput) {
        this.setInput(0, bumpInput);
    }

    public final Effect getContentInput() {
        return this.getInputs().get(1);
    }

    private Effect getContentInput(Effect defaultInput) {
        return this.getDefaultedInput(1, defaultInput);
    }

    public void setContentInput(Effect contentInput) {
        this.setInput(1, contentInput);
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        if (light == null) {
            throw new IllegalArgumentException("Light must be non-null");
        }
        this.light = light;
        this.updatePeerKey("PhongLighting_" + light.getType().name());
    }

    public float getDiffuseConstant() {
        return this.diffuseConstant;
    }

    public void setDiffuseConstant(float diffuseConstant) {
        if (diffuseConstant < 0.0f || diffuseConstant > 2.0f) {
            throw new IllegalArgumentException("Diffuse constant must be in the range [0,2]");
        }
        float old = this.diffuseConstant;
        this.diffuseConstant = diffuseConstant;
    }

    public float getSpecularConstant() {
        return this.specularConstant;
    }

    public void setSpecularConstant(float specularConstant) {
        if (specularConstant < 0.0f || specularConstant > 2.0f) {
            throw new IllegalArgumentException("Specular constant must be in the range [0,2]");
        }
        float old = this.specularConstant;
        this.specularConstant = specularConstant;
    }

    public float getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(float specularExponent) {
        if (specularExponent < 0.0f || specularExponent > 40.0f) {
            throw new IllegalArgumentException("Specular exponent must be in the range [0,40]");
        }
        float old = this.specularExponent;
        this.specularExponent = specularExponent;
    }

    public float getSurfaceScale() {
        return this.surfaceScale;
    }

    public void setSurfaceScale(float surfaceScale) {
        if (surfaceScale < 0.0f || surfaceScale > 10.0f) {
            throw new IllegalArgumentException("Surface scale must be in the range [0,10]");
        }
        float old = this.surfaceScale;
        this.surfaceScale = surfaceScale;
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        return this.getContentInput(defaultInput).getBounds(transform, defaultInput);
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        return super.getResultBounds(transform, outputClip, inputDatas[1]);
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        return this.getContentInput(defaultInput).transform(p, defaultInput);
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        return this.getContentInput(defaultInput).untransform(p, defaultInput);
    }

    @Override
    public RenderState getRenderState(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        return new RenderState(){

            @Override
            public RenderState.EffectCoordinateSpace getEffectTransformSpace() {
                return RenderState.EffectCoordinateSpace.RenderSpace;
            }

            @Override
            public BaseTransform getInputTransform(BaseTransform filterTransform) {
                return filterTransform;
            }

            @Override
            public BaseTransform getResultTransform(BaseTransform filterTransform) {
                return BaseTransform.IDENTITY_TRANSFORM;
            }

            @Override
            public Rectangle getInputClip(int i, Rectangle filterClip) {
                if (i == 0) {
                    Rectangle r = new Rectangle(filterClip);
                    r.grow(1, 1);
                    return r;
                }
                return filterClip;
            }
        };
    }

    @Override
    public boolean reducesOpaquePixels() {
        Effect contentInput = this.getContentInput();
        return contentInput != null && contentInput.reducesOpaquePixels();
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect bump = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc1 = bump.getDirtyRegions(defaultInput, regionPool);
        drc1.grow(1, 1);
        Effect content = this.getDefaultedInput(1, defaultInput);
        DirtyRegionContainer drc2 = content.getDirtyRegions(defaultInput, regionPool);
        drc1.merge(drc2);
        regionPool.checkIn(drc2);
        return drc1;
    }
}

