/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.ImagePool;
import com.sun.scenario.effect.impl.PoolFilterable;
import com.sun.scenario.effect.impl.Renderer$$Lambda$1;
import com.sun.scenario.effect.impl.RendererFactory;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Renderer {
    public static final String rootPkg = "com.sun.scenario.effect";
    private static final Map<FilterContext, Renderer> rendererMap = new HashMap<FilterContext, Renderer>(1);
    private Map<String, EffectPeer> peerCache = Collections.synchronizedMap(new HashMap(5));
    private final ImagePool imagePool = new ImagePool();
    protected static final boolean verbose = (Boolean)AccessController.doPrivileged(Renderer$$Lambda$1.lambdaFactory$());

    protected Renderer() {
    }

    public abstract Effect.AccelType getAccelType();

    public abstract int getCompatibleWidth(int var1);

    public abstract int getCompatibleHeight(int var1);

    public abstract PoolFilterable createCompatibleImage(int var1, int var2);

    public PoolFilterable getCompatibleImage(int w, int h) {
        return this.imagePool.checkOut(this, w, h);
    }

    public void releaseCompatibleImage(Filterable image) {
        ImagePool pool;
        if (image instanceof PoolFilterable && (pool = ((PoolFilterable)image).getImagePool()) != null) {
            pool.checkIn((PoolFilterable)image);
            return;
        }
        image.unlock();
    }

    public void releasePurgatory() {
        this.imagePool.releasePurgatory();
    }

    public abstract void clearImage(Filterable var1);

    public abstract ImageData createImageData(FilterContext var1, Filterable var2);

    public ImageData transform(FilterContext fctx, ImageData img, int xpow2scales, int ypow2scales) {
        if (!img.getTransform().isIdentity()) {
            throw new InternalError("transform by powers of 2 requires untransformed source");
        }
        if ((xpow2scales | ypow2scales) == 0) {
            return img;
        }
        Affine2D at = new Affine2D();
        while (xpow2scales < -1 || ypow2scales < -1) {
            Rectangle origbounds = img.getUntransformedBounds();
            Rectangle newbounds = new Rectangle(origbounds);
            double xscale = 1.0;
            double yscale = 1.0;
            if (xpow2scales < 0) {
                xscale = 0.5;
                newbounds.width = (origbounds.width + 1) / 2;
                newbounds.x /= 2;
                ++xpow2scales;
            }
            if (ypow2scales < 0) {
                yscale = 0.5;
                newbounds.height = (origbounds.height + 1) / 2;
                newbounds.y /= 2;
                ++ypow2scales;
            }
            at.setToScale(xscale, yscale);
            img = this.transform(fctx, img, (BaseTransform)at, origbounds, newbounds);
        }
        if ((xpow2scales | ypow2scales) != 0) {
            double xscale = xpow2scales < 0 ? 0.5 : (double)(1 << xpow2scales);
            double yscale = ypow2scales < 0 ? 0.5 : (double)(1 << ypow2scales);
            at.setToScale(xscale, yscale);
            img = img.transform(at);
        }
        return img;
    }

    public abstract Filterable transform(FilterContext var1, Filterable var2, BaseTransform var3, Rectangle var4, Rectangle var5);

    public abstract ImageData transform(FilterContext var1, ImageData var2, BaseTransform var3, Rectangle var4, Rectangle var5);

    public LockableResource createFloatTexture(int w, int h) {
        throw new InternalError();
    }

    public void updateFloatTexture(LockableResource texture, FloatMap map) {
        throw new InternalError();
    }

    public final synchronized EffectPeer getPeerInstance(FilterContext fctx, String name, int unrollCount) {
        EffectPeer peer = this.peerCache.get(name);
        if (peer != null) {
            return peer;
        }
        if (unrollCount > 0 && (peer = this.peerCache.get(name + "_" + unrollCount)) != null) {
            return peer;
        }
        peer = this.createPeer(fctx, name, unrollCount);
        if (peer == null) {
            throw new RuntimeException("Could not create peer  " + name + " for renderer " + this);
        }
        this.peerCache.put(peer.getUniqueName(), peer);
        return peer;
    }

    public abstract RendererState getRendererState();

    protected abstract EffectPeer createPeer(FilterContext var1, String var2, int var3);

    protected Collection<EffectPeer> getPeers() {
        return this.peerCache.values();
    }

    protected static Renderer getSoftwareRenderer() {
        return RendererFactory.getSoftwareRenderer();
    }

    protected abstract Renderer getBackupRenderer();

    protected Renderer getRendererForSize(Effect effect, int approxW, int approxH) {
        return this;
    }

    public static synchronized Renderer getRenderer(FilterContext fctx) {
        if (fctx == null) {
            throw new IllegalArgumentException("FilterContext must be non-null");
        }
        Renderer r = rendererMap.get(fctx);
        if (r != null) {
            if (r.getRendererState() == RendererState.OK) {
                return r;
            }
            if (r.getRendererState() == RendererState.LOST) {
                return r.getBackupRenderer();
            }
            if (r.getRendererState() == RendererState.DISPOSED) {
                r = null;
            }
        }
        if (r == null) {
            Collection<Renderer> renderers = rendererMap.values();
            Iterator<Renderer> iter = renderers.iterator();
            while (iter.hasNext()) {
                Renderer ren = iter.next();
                if (ren.getRendererState() != RendererState.DISPOSED) continue;
                ren.imagePool.dispose();
                iter.remove();
            }
            r = RendererFactory.createRenderer(fctx);
            if (r == null) {
                throw new RuntimeException("Error creating a Renderer");
            }
            if (verbose) {
                String klassName = r.getClass().getName();
                String rname = klassName.substring(klassName.lastIndexOf(".") + 1);
                Object screen = fctx.getReferent();
                System.out.println("Created " + rname + " (AccelType=" + (Object)((Object)r.getAccelType()) + ") for " + screen);
            }
            rendererMap.put(fctx, r);
        }
        return r;
    }

    public static Renderer getRenderer(FilterContext fctx, Effect effect, int approxW, int approxH) {
        return Renderer.getRenderer(fctx).getRendererForSize(effect, approxW, approxH);
    }

    public abstract boolean isImageDataCompatible(ImageData var1);

    static /* synthetic */ Boolean lambda$static$35() {
        return Boolean.getBoolean("decora.verbose");
    }

    public static enum RendererState {
        OK,
        LOST,
        DISPOSED;

    }
}

