/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.sun.webkit.DisposerRecord;
import com.sun.webkit.Invoker;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;

public final class Disposer
implements Runnable {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Disposer disposerInstance = new Disposer();
    private static final Set<WeakDisposerRecord> records = new HashSet<WeakDisposerRecord>();

    public static void addRecord(Object target, DisposerRecord rec) {
        disposerInstance.add(target, rec);
    }

    private synchronized void add(Object target, DisposerRecord rec) {
        records.add(new WeakDisposerRecord(target, rec));
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    WeakDisposerRecord obj = (WeakDisposerRecord)queue.remove();
                    obj.clear();
                    DisposerRunnable.getInstance().enqueue(obj);
                }
            }
            catch (Exception e) {
                System.out.println("Exception while removing reference: " + e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        Thread t = new Thread((Runnable)disposerInstance, "Disposer");
        t.setDaemon(true);
        t.setPriority(10);
        t.start();
    }

    public static class WeakDisposerRecord
    extends WeakReference
    implements DisposerRecord {
        private final DisposerRecord record;

        protected WeakDisposerRecord(Object referent) {
            super(referent, queue);
            this.record = null;
        }

        private WeakDisposerRecord(Object referent, DisposerRecord record) {
            super(referent, queue);
            this.record = record;
        }

        @Override
        public void dispose() {
            this.record.dispose();
        }
    }

    private static final class DisposerRunnable
    implements Runnable {
        private static final DisposerRunnable theInstance = new DisposerRunnable();
        private boolean isRunning = false;
        private final Object disposerLock = new Object();
        private final LinkedBlockingQueue<WeakDisposerRecord> disposerQueue = new LinkedBlockingQueue();

        private DisposerRunnable() {
        }

        private static DisposerRunnable getInstance() {
            return theInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueueAll(Collection<WeakDisposerRecord> objs) {
            Object object = this.disposerLock;
            synchronized (object) {
                this.disposerQueue.addAll(objs);
                if (!this.isRunning) {
                    Invoker.getInvoker().invokeOnEventThread(this);
                    this.isRunning = true;
                }
            }
        }

        private void enqueue(WeakDisposerRecord obj) {
            this.enqueueAll(Arrays.asList(obj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WeakDisposerRecord obj;
                Object object = this.disposerLock;
                synchronized (object) {
                    obj = this.disposerQueue.poll();
                    if (obj == null) {
                        this.isRunning = false;
                        break;
                    }
                }
                if (!records.contains(obj)) continue;
                records.remove(obj);
                obj.dispose();
            }
        }
    }
}

