/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.beans.WeakListener;
import javafx.collections.MapChangeListener;

public final class WeakMapChangeListener<K, V>
implements MapChangeListener<K, V>,
WeakListener {
    private final WeakReference<MapChangeListener<K, V>> ref;

    public WeakMapChangeListener(@NamedArg(value="listener") MapChangeListener<K, V> listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must be specified.");
        }
        this.ref = new WeakReference<MapChangeListener<K, V>>(listener);
    }

    @Override
    public boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    @Override
    public void onChanged(MapChangeListener.Change<? extends K, ? extends V> change) {
        MapChangeListener listener = (MapChangeListener)this.ref.get();
        if (listener != null) {
            listener.onChanged(change);
        } else {
            change.getMap().removeListener(this);
        }
    }
}

