/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.function.Predicate;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList$$Lambda$1;
import javafx.collections.transformation.TransformationList;

public final class FilteredList<E>
extends TransformationList<E, E> {
    private int[] filtered;
    private int size;
    private SortHelper helper;
    private static final Predicate ALWAYS_TRUE = FilteredList$$Lambda$1.lambdaFactory$();
    private final ObjectProperty<Predicate<? super E>> predicate = new ObjectPropertyBase<Predicate<? super E>>(){

        @Override
        protected void invalidated() {
            if (this.get() == null) {
                if (this.isBound()) {
                    this.unbind();
                }
                this.set(ALWAYS_TRUE);
                throw new IllegalArgumentException("Predicate cannot be null.");
            }
            FilteredList.this.refilter();
        }

        @Override
        public Object getBean() {
            return FilteredList.this;
        }

        @Override
        public String getName() {
            return "predicate";
        }
    };

    public FilteredList(@NamedArg(value="source") ObservableList<E> source, @NamedArg(value="predicate") Predicate<? super E> predicate) {
        super(source);
        if (predicate == null) {
            throw new NullPointerException();
        }
        this.filtered = new int[source.size() * 3 / 2 + 1];
        this.predicate.set(predicate);
    }

    public FilteredList(@NamedArg(value="source") ObservableList<E> source) {
        this(source, ALWAYS_TRUE);
    }

    public final ObjectProperty<Predicate<? super E>> predicateProperty() {
        return this.predicate;
    }

    public final Predicate<? super E> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public final void setPredicate(Predicate<? super E> predicate) {
        this.predicate.set(predicate);
    }

    @Override
    protected void sourceChanged(ListChangeListener.Change<? extends E> c) {
        this.beginChange();
        while (c.next()) {
            if (c.wasPermutated()) {
                this.permutate(c);
                continue;
            }
            if (c.wasUpdated()) {
                this.update(c);
                continue;
            }
            this.addRemove(c);
        }
        this.endChange();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSource().get(this.filtered[index]);
    }

    @Override
    public int getSourceIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.filtered[index];
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    private int findPosition(int p) {
        if (this.filtered.length == 0) {
            return 0;
        }
        if (p == 0) {
            return 0;
        }
        int pos = Arrays.binarySearch(this.filtered, 0, this.size, p);
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
        }
        return pos;
    }

    private void ensureSize(int size) {
        if (this.filtered.length < size) {
            int[] replacement = new int[size * 3 / 2 + 1];
            System.arraycopy(this.filtered, 0, replacement, 0, this.size);
            this.filtered = replacement;
        }
    }

    private void updateIndexes(int from, int delta) {
        int i = from;
        while (i < this.size) {
            int n = i++;
            this.filtered[n] = this.filtered[n] + delta;
        }
    }

    private void permutate(ListChangeListener.Change<? extends E> c) {
        int from = this.findPosition(c.getFrom());
        int to = this.findPosition(c.getTo());
        if (to > from) {
            for (int i = from; i < to; ++i) {
                this.filtered[i] = c.getPermutation(this.filtered[i]);
            }
            int[] perm = this.getSortHelper().sort(this.filtered, from, to);
            this.nextPermutation(from, to, perm);
        }
    }

    private void update(ListChangeListener.Change<? extends E> c) {
        int from = this.findPosition(c.getFrom());
        int to = this.findPosition(c.getTo());
        for (int i = from; i < to; ++i) {
            this.nextUpdate(i);
        }
        this.updateFilter(c.getFrom(), c.getTo());
    }

    private void addRemove(ListChangeListener.Change<? extends E> c) {
        Predicate pred = (Predicate)this.predicate.get();
        this.ensureSize(this.getSource().size());
        int from = this.findPosition(c.getFrom());
        int to = this.findPosition(c.getFrom() + c.getRemovedSize());
        for (int i = from; i < to; ++i) {
            this.nextRemove(from, c.getRemoved().get(this.filtered[i] - c.getFrom()));
        }
        this.updateIndexes(to, c.getAddedSize() - c.getRemovedSize());
        int fpos = from;
        int pos = c.getFrom();
        ListIterator it = this.getSource().listIterator(pos);
        while (fpos < to && it.nextIndex() < c.getTo()) {
            if (!pred.test(it.next())) continue;
            this.filtered[fpos] = it.previousIndex();
            this.nextAdd(fpos, fpos + 1);
            ++fpos;
        }
        if (fpos < to) {
            System.arraycopy(this.filtered, to, this.filtered, fpos, this.size - to);
            this.size -= to - fpos;
        } else {
            while (it.nextIndex() < c.getTo()) {
                if (pred.test(it.next())) {
                    System.arraycopy(this.filtered, fpos, this.filtered, fpos + 1, this.size - fpos);
                    this.filtered[fpos] = it.previousIndex();
                    this.nextAdd(fpos, fpos + 1);
                    ++fpos;
                    ++this.size;
                }
                ++pos;
            }
        }
    }

    private void updateFilter(int sourceFrom, int sourceTo) {
        block8: {
            Predicate pred;
            block6: {
                Object sourceFromElement;
                int pos;
                block7: {
                    pred = (Predicate)this.predicate.get();
                    this.beginChange();
                    if (sourceFrom != sourceTo - 1) break block6;
                    pos = this.findPosition(sourceFrom);
                    sourceFromElement = this.getSource().get(sourceFrom);
                    if (this.filtered[pos] != sourceFrom) break block7;
                    if (!pred.test(sourceFromElement)) {
                        this.nextRemove(pos, sourceFromElement);
                        System.arraycopy(this.filtered, pos + 1, this.filtered, pos, this.size - pos - 1);
                        --this.size;
                    }
                    break block8;
                }
                this.ensureSize(this.getSource().size());
                if (!pred.test(sourceFromElement)) break block8;
                this.nextAdd(pos, pos + 1);
                System.arraycopy(this.filtered, pos, this.filtered, pos + 1, this.size - pos);
                this.filtered[pos] = sourceFrom;
                ++this.size;
                break block8;
            }
            this.ensureSize(this.getSource().size());
            int filterFrom = this.findPosition(sourceFrom);
            int filterTo = this.findPosition(sourceTo);
            int i = filterFrom;
            if (i == 0) {
                int jTo = this.size == 0 ? sourceTo : this.filtered[0];
                ListIterator it = this.getSource().listIterator(sourceFrom);
                while (it.nextIndex() < jTo) {
                    Object el = it.next();
                    if (!pred.test(el)) continue;
                    this.nextAdd(i, i + 1);
                    System.arraycopy(this.filtered, i, this.filtered, i + 1, this.size - i);
                    this.filtered[i] = it.previousIndex();
                    ++this.size;
                    ++filterTo;
                    ++i;
                }
            }
            ListIterator it = this.getSource().listIterator(this.filtered[i]);
            while (i < filterTo) {
                int jTo;
                FilteredList.advanceTo(it, this.filtered[i]);
                Object el = it.next();
                if (!pred.test(el)) {
                    this.nextRemove(i, el);
                    System.arraycopy(this.filtered, i + 1, this.filtered, i, this.size - i - 1);
                    --this.size;
                    --filterTo;
                    --i;
                }
                int n = jTo = i == filterTo - 1 ? sourceTo : this.filtered[i + 1];
                while (it.nextIndex() < jTo) {
                    Object midEl = it.next();
                    if (!pred.test(midEl)) continue;
                    this.nextAdd(i + 1, i + 2);
                    System.arraycopy(this.filtered, i + 1, this.filtered, i + 2, this.size - i - 1);
                    this.filtered[i + 1] = it.previousIndex();
                    ++this.size;
                    ++filterTo;
                    ++i;
                }
                ++i;
            }
        }
        this.endChange();
    }

    private static void advanceTo(ListIterator<?> it, int index) {
        while (it.nextIndex() < index) {
            it.next();
        }
    }

    private void refilter() {
        this.ensureSize(this.getSource().size());
        ArrayList removed = null;
        if (this.hasListeners()) {
            removed = new ArrayList(this);
        }
        this.size = 0;
        int i = 0;
        Predicate pred = (Predicate)this.predicate.get();
        for (Object next : this.getSource()) {
            if (pred.test(next)) {
                this.filtered[this.size++] = i;
            }
            ++i;
        }
        if (this.hasListeners()) {
            this.fireChange(new NonIterableChange.GenericAddRemoveChange(0, this.size, removed, this));
        }
    }

    static /* synthetic */ boolean lambda$static$59(Object t) {
        return true;
    }
}

