/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.converters.EnumConverter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory$$Lambda$1;
import javafx.css.StyleablePropertyFactory$$Lambda$10;
import javafx.css.StyleablePropertyFactory$$Lambda$11;
import javafx.css.StyleablePropertyFactory$$Lambda$2;
import javafx.css.StyleablePropertyFactory$$Lambda$3;
import javafx.css.StyleablePropertyFactory$$Lambda$4;
import javafx.css.StyleablePropertyFactory$$Lambda$5;
import javafx.css.StyleablePropertyFactory$$Lambda$6;
import javafx.css.StyleablePropertyFactory$$Lambda$7;
import javafx.css.StyleablePropertyFactory$$Lambda$8;
import javafx.css.StyleablePropertyFactory$$Lambda$9;
import javafx.geometry.Insets;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import javafx.util.Pair;

public class StyleablePropertyFactory<S extends Styleable> {
    private final Map<String, Pair<Class, CssMetaData<S, ?>>> metaDataMap;
    private final List<CssMetaData<? extends Styleable, ?>> unmodifiableMetaDataList;
    private final List<CssMetaData<? extends Styleable, ?>> metaDataList = new ArrayList();

    public StyleablePropertyFactory(List<CssMetaData<? extends Styleable, ?>> parentCssMetaData) {
        this.unmodifiableMetaDataList = Collections.unmodifiableList(this.metaDataList);
        if (parentCssMetaData != null) {
            this.metaDataList.addAll(parentCssMetaData);
        }
        this.metaDataMap = new HashMap();
    }

    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.unmodifiableMetaDataList;
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Boolean>> function, boolean initialValue, boolean inherits) {
        CssMetaData<S, Boolean> cssMetaData = this.createBooleanCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableBooleanProperty(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Boolean>> function, boolean initialValue) {
        return this.createStyleableBooleanProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Boolean>> function) {
        return this.createStyleableBooleanProperty(styleable, propertyName, cssProperty, function, false, false);
    }

    public final StyleableProperty<Boolean> createStyleableBooleanProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Boolean.class, cssProperty);
        return new SimpleStyleableBooleanProperty(cssMetaData, styleable, propertyName, (Boolean)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Color>> function, Color initialValue, boolean inherits) {
        CssMetaData<S, Color> cssMetaData = this.createColorCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Color>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Color>> function, Color initialValue) {
        return this.createStyleableColorProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Color>> function) {
        return this.createStyleableColorProperty(styleable, propertyName, cssProperty, function, Color.BLACK, false);
    }

    public final StyleableProperty<Color> createStyleableColorProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Color.class, cssProperty);
        return new SimpleStyleableObjectProperty<Color>((CssMetaData<Styleable, Color>)cssMetaData, styleable, propertyName, (Color)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Duration>> function, Duration initialValue, boolean inherits) {
        CssMetaData<S, Duration> cssMetaData = this.createDurationCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Duration>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Duration>> function, Duration initialValue) {
        return this.createStyleableDurationProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Duration>> function) {
        return this.createStyleableDurationProperty(styleable, propertyName, cssProperty, function, Duration.UNKNOWN, false);
    }

    public final StyleableProperty<Duration> createStyleableDurationProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Duration.class, cssProperty);
        return new SimpleStyleableObjectProperty<Duration>((CssMetaData<Styleable, Duration>)cssMetaData, styleable, propertyName, (Duration)cssMetaData.getInitialValue(styleable));
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function, E initialValue, boolean inherits) {
        CssMetaData<S, E> cssMetaData = this.createEffectCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<E>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function, E initialValue) {
        return this.createStyleableEffectProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final <E extends Effect> StyleableProperty<E> createStyleableEffectProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function) {
        return this.createStyleableEffectProperty(styleable, propertyName, cssProperty, function, null, false);
    }

    public final StyleableProperty<Effect> createStyleableEffectProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Effect.class, cssProperty);
        return new SimpleStyleableObjectProperty<Effect>((CssMetaData<Styleable, Effect>)cssMetaData, styleable, propertyName, (Effect)cssMetaData.getInitialValue(styleable));
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function, Class<E> enumClass, E initialValue, boolean inherits) {
        CssMetaData<S, E> cssMetaData = this.createEnumCssMetaData(enumClass, cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<E>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function, Class<E> enumClass, E initialValue) {
        return this.createStyleableEnumProperty(styleable, propertyName, cssProperty, function, enumClass, initialValue, false);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEnumProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<E>> function, Class<E> enumClass) {
        return this.createStyleableEnumProperty(styleable, propertyName, cssProperty, function, enumClass, null, false);
    }

    public final <E extends Enum<E>> StyleableProperty<E> createStyleableEffectProperty(S styleable, String propertyName, String cssProperty, Class<E> enumClass) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(enumClass, cssProperty);
        return new SimpleStyleableObjectProperty(cssMetaData, styleable, propertyName, cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Font>> function, Font initialValue, boolean inherits) {
        CssMetaData<S, Font> cssMetaData = this.createFontCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Font>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Font>> function, Font initialValue) {
        return this.createStyleableFontProperty(styleable, propertyName, cssProperty, function, initialValue, true);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Font>> function) {
        return this.createStyleableFontProperty(styleable, propertyName, cssProperty, function, Font.getDefault(), true);
    }

    public final StyleableProperty<Font> createStyleableFontProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Font.class, cssProperty);
        return new SimpleStyleableObjectProperty<Font>((CssMetaData<Styleable, Font>)cssMetaData, styleable, propertyName, (Font)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Insets>> function, Insets initialValue, boolean inherits) {
        CssMetaData<S, Insets> cssMetaData = this.createInsetsCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Insets>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Insets>> function, Insets initialValue) {
        return this.createStyleableInsetsProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Insets>> function) {
        return this.createStyleableInsetsProperty(styleable, propertyName, cssProperty, function, Insets.EMPTY, false);
    }

    public final StyleableProperty<Insets> createStyleableInsetsProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Insets.class, cssProperty);
        return new SimpleStyleableObjectProperty<Insets>((CssMetaData<Styleable, Insets>)cssMetaData, styleable, propertyName, (Insets)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Paint>> function, Paint initialValue, boolean inherits) {
        CssMetaData<S, Paint> cssMetaData = this.createPaintCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Paint>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Paint>> function, Paint initialValue) {
        return this.createStyleablePaintProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Paint>> function) {
        return this.createStyleablePaintProperty(styleable, propertyName, cssProperty, function, Color.BLACK, false);
    }

    public final StyleableProperty<Paint> createStyleablePaintProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Paint.class, cssProperty);
        return new SimpleStyleableObjectProperty<Paint>((CssMetaData<Styleable, Paint>)cssMetaData, styleable, propertyName, (Paint)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Number>> function, Number initialValue, boolean inherits) {
        CssMetaData<S, Number> cssMetaData = this.createSizeCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableObjectProperty<Number>(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Number>> function, Number initialValue) {
        return this.createStyleableNumberProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<Number>> function) {
        return this.createStyleableNumberProperty(styleable, propertyName, cssProperty, function, 0.0, false);
    }

    public final StyleableProperty<Number> createStyleableNumberProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Number.class, cssProperty);
        return new SimpleStyleableObjectProperty<Number>((CssMetaData<Styleable, Number>)cssMetaData, styleable, propertyName, (Number)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<String> createStyleableStringProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function, String initialValue, boolean inherits) {
        CssMetaData<S, String> cssMetaData = this.createStringCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableStringProperty(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function, String initialValue) {
        return this.createStyleableStringProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function) {
        return this.createStyleableStringProperty(styleable, propertyName, cssProperty, function, null, false);
    }

    public final StyleableProperty<String> createStyleableStringProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(String.class, cssProperty);
        return new SimpleStyleableStringProperty(cssMetaData, styleable, propertyName, (String)cssMetaData.getInitialValue(styleable));
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function, String initialValue, boolean inherits) {
        CssMetaData<S, String> cssMetaData = this.createUrlCssMetaData(cssProperty, function, initialValue, inherits);
        return new SimpleStyleableStringProperty(cssMetaData, styleable, propertyName, initialValue);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function, String initialValue) {
        return this.createStyleableUrlProperty(styleable, propertyName, cssProperty, function, initialValue, false);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S styleable, String propertyName, String cssProperty, Function<S, StyleableProperty<String>> function) {
        return this.createStyleableUrlProperty(styleable, propertyName, cssProperty, function, null, false);
    }

    public final StyleableProperty<String> createStyleableUrlProperty(S styleable, String propertyName, String cssProperty) {
        if (cssProperty == null || cssProperty.isEmpty()) {
            throw new IllegalArgumentException("cssProperty cannot be null or empty string");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(String.class, cssProperty);
        return new SimpleStyleableStringProperty(cssMetaData, styleable, propertyName, (String)cssMetaData.getInitialValue(styleable));
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String property, Function<S, StyleableProperty<Boolean>> function, boolean initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Boolean.class, property, StyleablePropertyFactory$$Lambda$1.lambdaFactory$(function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String property, Function<S, StyleableProperty<Boolean>> function, boolean initialValue) {
        return this.createBooleanCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Boolean> createBooleanCssMetaData(String property, Function<S, StyleableProperty<Boolean>> function) {
        return this.createBooleanCssMetaData(property, function, false, false);
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String property, Function<S, StyleableProperty<Color>> function, Color initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Color.class, property, StyleablePropertyFactory$$Lambda$2.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String property, Function<S, StyleableProperty<Color>> function, Color initialValue) {
        return this.createColorCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Color> createColorCssMetaData(String property, Function<S, StyleableProperty<Color>> function) {
        return this.createColorCssMetaData(property, function, Color.BLACK, false);
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String property, Function<S, StyleableProperty<Duration>> function, Duration initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Duration.class, property, StyleablePropertyFactory$$Lambda$3.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String property, Function<S, StyleableProperty<Duration>> function, Duration initialValue) {
        return this.createDurationCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Duration> createDurationCssMetaData(String property, Function<S, StyleableProperty<Duration>> function) {
        return this.createDurationCssMetaData(property, function, Duration.UNKNOWN, false);
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String property, Function<S, StyleableProperty<E>> function, E initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Effect.class, property, StyleablePropertyFactory$$Lambda$4.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String property, Function<S, StyleableProperty<E>> function, E initialValue) {
        return this.createEffectCssMetaData(property, function, initialValue, false);
    }

    public final <E extends Effect> CssMetaData<S, E> createEffectCssMetaData(String property, Function<S, StyleableProperty<E>> function) {
        return this.createEffectCssMetaData(property, function, null, false);
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> enumClass, String property, Function<S, StyleableProperty<E>> function, E initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(enumClass, property, StyleablePropertyFactory$$Lambda$5.lambdaFactory$(enumClass, property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> enumClass, String property, Function<S, StyleableProperty<E>> function, E initialValue) {
        return this.createEnumCssMetaData(enumClass, property, function, initialValue, false);
    }

    public final <E extends Enum<E>> CssMetaData<S, E> createEnumCssMetaData(Class<? extends Enum> enumClass, String property, Function<S, StyleableProperty<E>> function) {
        return this.createEnumCssMetaData(enumClass, property, function, null, false);
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String property, Function<S, StyleableProperty<Font>> function, Font initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Font.class, property, StyleablePropertyFactory$$Lambda$6.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String property, Function<S, StyleableProperty<Font>> function, Font initialValue) {
        return this.createFontCssMetaData(property, function, initialValue, true);
    }

    public final CssMetaData<S, Font> createFontCssMetaData(String property, Function<S, StyleableProperty<Font>> function) {
        return this.createFontCssMetaData(property, function, Font.getDefault(), true);
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String property, Function<S, StyleableProperty<Insets>> function, Insets initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Insets.class, property, StyleablePropertyFactory$$Lambda$7.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String property, Function<S, StyleableProperty<Insets>> function, Insets initialValue) {
        return this.createInsetsCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Insets> createInsetsCssMetaData(String property, Function<S, StyleableProperty<Insets>> function) {
        return this.createInsetsCssMetaData(property, function, Insets.EMPTY, false);
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String property, Function<S, StyleableProperty<Paint>> function, Paint initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Paint.class, property, StyleablePropertyFactory$$Lambda$8.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String property, Function<S, StyleableProperty<Paint>> function, Paint initialValue) {
        return this.createPaintCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Paint> createPaintCssMetaData(String property, Function<S, StyleableProperty<Paint>> function) {
        return this.createPaintCssMetaData(property, function, Color.BLACK, false);
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String property, Function<S, StyleableProperty<Number>> function, Number initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(Number.class, property, StyleablePropertyFactory$$Lambda$9.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String property, Function<S, StyleableProperty<Number>> function, Number initialValue) {
        return this.createSizeCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, Number> createSizeCssMetaData(String property, Function<S, StyleableProperty<Number>> function) {
        return this.createSizeCssMetaData(property, function, 0.0, false);
    }

    public final CssMetaData<S, String> createStringCssMetaData(String property, Function<S, StyleableProperty<String>> function, String initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(String.class, property, StyleablePropertyFactory$$Lambda$10.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, String> createStringCssMetaData(String property, Function<S, StyleableProperty<String>> function, String initialValue) {
        return this.createStringCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, String> createStringCssMetaData(String property, Function<S, StyleableProperty<String>> function) {
        return this.createStringCssMetaData(property, function, null, false);
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String property, Function<S, StyleableProperty<String>> function, String initialValue, boolean inherits) {
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property cannot be null or empty string");
        }
        if (function == null) {
            throw new IllegalArgumentException("function cannot be null");
        }
        CssMetaData<S, ?> cssMetaData = this.getCssMetaData(URL.class, property, StyleablePropertyFactory$$Lambda$11.lambdaFactory$(property, function, initialValue, inherits));
        return cssMetaData;
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String property, Function<S, StyleableProperty<String>> function, String initialValue) {
        return this.createUrlCssMetaData(property, function, initialValue, false);
    }

    public final CssMetaData<S, String> createUrlCssMetaData(String property, Function<S, StyleableProperty<String>> function) {
        return this.createUrlCssMetaData(property, function, null, false);
    }

    void clearDataForTesting() {
        this.metaDataMap.clear();
        this.metaDataList.clear();
    }

    private CssMetaData<S, ?> getCssMetaData(Class ofClass, String property) {
        return this.getCssMetaData(ofClass, property, null);
    }

    private CssMetaData<S, ?> getCssMetaData(Class ofClass, String property, Function<String, CssMetaData<S, ?>> createFunction) {
        String key = property.toLowerCase();
        Pair<Class, CssMetaData<S, ?>> entry = this.metaDataMap.get(key);
        if (entry != null) {
            if (entry.getKey() == ofClass) {
                return entry.getValue();
            }
            throw new ClassCastException("CssMetaData value is not " + ofClass + ": " + entry.getValue());
        }
        if (createFunction == null) {
            throw new NoSuchElementException("No CssMetaData for " + key);
        }
        CssMetaData<S, ?> cssMetaData = createFunction.apply(key);
        this.metaDataMap.put(key, new Pair(ofClass, cssMetaData));
        this.metaDataList.add(cssMetaData);
        return cssMetaData;
    }

    static /* synthetic */ CssMetaData lambda$createUrlCssMetaData$488(String string, Function function, String string2, boolean bl, String key) {
        StyleConverter<ParsedValue[], String> converter = StyleConverter.getUrlConverter();
        return new SimpleCssMetaData(string, function, converter, string2, bl);
    }

    static /* synthetic */ CssMetaData lambda$createStringCssMetaData$487(String string, Function function, String string2, boolean bl, String key) {
        StyleConverter<String, String> converter = StyleConverter.getStringConverter();
        return new SimpleCssMetaData(string, function, converter, string2, bl);
    }

    static /* synthetic */ CssMetaData lambda$createSizeCssMetaData$486(String string, Function function, Number number, boolean bl, String key) {
        StyleConverter<?, Number> converter = StyleConverter.getSizeConverter();
        return new SimpleCssMetaData(string, function, converter, number, bl);
    }

    static /* synthetic */ CssMetaData lambda$createPaintCssMetaData$485(String string, Function function, Paint paint, boolean bl, String key) {
        StyleConverter<ParsedValue<?, Paint>, Paint> converter = StyleConverter.getPaintConverter();
        return new SimpleCssMetaData(string, function, converter, paint, bl);
    }

    static /* synthetic */ CssMetaData lambda$createInsetsCssMetaData$484(String string, Function function, Insets insets, boolean bl, String key) {
        StyleConverter<ParsedValue[], Insets> converter = StyleConverter.getInsetsConverter();
        return new SimpleCssMetaData(string, function, converter, insets, bl);
    }

    static /* synthetic */ CssMetaData lambda$createFontCssMetaData$483(String string, Function function, Font font, boolean bl, String key) {
        StyleConverter<ParsedValue[], Font> converter = StyleConverter.getFontConverter();
        return new SimpleCssMetaData(string, function, converter, font, bl);
    }

    static /* synthetic */ CssMetaData lambda$createEnumCssMetaData$482(Class clazz, String string, Function function, Enum enum_, boolean bl, String key) {
        EnumConverter converter = new EnumConverter(clazz);
        return new SimpleCssMetaData(string, function, converter, enum_, bl);
    }

    static /* synthetic */ CssMetaData lambda$createEffectCssMetaData$481(String string, Function function, Effect effect, boolean bl, String key) {
        StyleConverter<ParsedValue[], Effect> converter = StyleConverter.getEffectConverter();
        return new SimpleCssMetaData(string, function, converter, effect, bl);
    }

    static /* synthetic */ CssMetaData lambda$createDurationCssMetaData$480(String string, Function function, Duration duration, boolean bl, String key) {
        StyleConverter<?, Duration> converter = StyleConverter.getDurationConverter();
        return new SimpleCssMetaData(string, function, converter, duration, bl);
    }

    static /* synthetic */ CssMetaData lambda$createColorCssMetaData$479(String string, Function function, Color color, boolean bl, String key) {
        StyleConverter<String, Color> converter = StyleConverter.getColorConverter();
        return new SimpleCssMetaData(string, function, converter, color, bl);
    }

    static /* synthetic */ CssMetaData lambda$createBooleanCssMetaData$478(Function function, boolean bl, boolean bl2, String key) {
        StyleConverter<String, Boolean> converter = StyleConverter.getBooleanConverter();
        return new SimpleCssMetaData(key, function, converter, Boolean.valueOf(bl), bl2);
    }

    private static class SimpleCssMetaData<S extends Styleable, V>
    extends CssMetaData<S, V> {
        private final Function<S, StyleableProperty<V>> function;

        SimpleCssMetaData(String property, Function<S, StyleableProperty<V>> function, StyleConverter<?, V> converter, V initialValue, boolean inherits) {
            super(property, converter, initialValue, inherits);
            this.function = function;
        }

        @Override
        public final boolean isSettable(S styleable) {
            StyleableProperty<V> prop = this.getStyleableProperty(styleable);
            if (prop instanceof Property) {
                return !((Property)((Object)prop)).isBound();
            }
            return prop != null;
        }

        @Override
        public final StyleableProperty<V> getStyleableProperty(S styleable) {
            if (styleable != null) {
                StyleableProperty<V> property = this.function.apply(styleable);
                return property;
            }
            return null;
        }
    }
}

