/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.BeanAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.util.Builder;
import sun.reflect.misc.MethodUtil;

final class JavaFXBuilder {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class<?>[] NO_SIG = new Class[0];
    private final Class<?> builderClass;
    private final Method createMethod;
    private final Method buildMethod;
    private final Map<String, Method> methods = new HashMap<String, Method>();
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();

    JavaFXBuilder() {
        this.builderClass = null;
        this.createMethod = null;
        this.buildMethod = null;
    }

    JavaFXBuilder(Class<?> builderClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.builderClass = builderClass;
        this.createMethod = MethodUtil.getMethod(builderClass, "create", NO_SIG);
        this.buildMethod = MethodUtil.getMethod(builderClass, "build", NO_SIG);
        assert (Modifier.isStatic(this.createMethod.getModifiers()));
        assert (!Modifier.isStatic(this.buildMethod.getModifiers()));
    }

    Builder<Object> createBuilder() {
        return new ObjectBuilder();
    }

    private Method findMethod(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        for (Method m : MethodUtil.getMethods(this.builderClass)) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        throw new IllegalArgumentException("Method " + name + " could not be found at class " + this.builderClass.getName());
    }

    public Class<?> getTargetClass() {
        return this.buildMethod.getReturnType();
    }

    final class ObjectBuilder
    extends AbstractMap<String, Object>
    implements Builder<Object> {
        private final Map<String, Object> containers = new HashMap<String, Object>();
        private Object builder = null;
        private Map<Object, Object> properties;

        private ObjectBuilder() {
            try {
                this.builder = MethodUtil.invoke(JavaFXBuilder.this.createMethod, null, NO_ARGS);
            }
            catch (Exception e) {
                throw new RuntimeException("Creation of the builder " + JavaFXBuilder.this.builderClass.getName() + " failed.", e);
            }
        }

        @Override
        public Object build() {
            Object res;
            for (Map.Entry<String, Object> entry : this.containers.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            try {
                res = MethodUtil.invoke(JavaFXBuilder.this.buildMethod, this.builder, NO_ARGS);
                if (this.properties != null && res instanceof Node) {
                    ((Node)res).getProperties().putAll(this.properties);
                }
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            finally {
                this.builder = null;
            }
            return res;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getTemporaryContainer(key.toString()) != null;
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            return this.getTemporaryContainer(key.toString());
        }

        @Override
        public Object put(String key, Object value) {
            if (Node.class.isAssignableFrom(JavaFXBuilder.this.getTargetClass()) && "properties".equals(key)) {
                this.properties = (Map)value;
                return null;
            }
            try {
                Method m = (Method)JavaFXBuilder.this.methods.get(key);
                if (m == null) {
                    m = JavaFXBuilder.this.findMethod(key);
                    JavaFXBuilder.this.methods.put(key, m);
                }
                try {
                    Class<?> type = m.getParameterTypes()[0];
                    if (type.isArray()) {
                        List<String> list = value instanceof List ? (List<String>)value : Arrays.asList(value.toString().split(","));
                        Class<?> componentType = type.getComponentType();
                        Object array = Array.newInstance(componentType, list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            Array.set(array, i, BeanAdapter.coerce(list.get(i), componentType));
                        }
                        value = array;
                    }
                    MethodUtil.invoke(m, this.builder, new Object[]{BeanAdapter.coerce(value, type)});
                }
                catch (Exception e) {
                    Logger.getLogger(JavaFXBuilder.class.getName()).log(Level.WARNING, "Method " + m.getName() + " failed", e);
                }
                return null;
            }
            catch (Exception e) {
                Logger.getLogger(JavaFXBuilder.class.getName()).log(Level.WARNING, "Failed to set " + JavaFXBuilder.this.getTargetClass() + "." + key + " using " + JavaFXBuilder.this.builderClass, e);
                return null;
            }
        }

        Object getReadOnlyProperty(String propName) {
            Class<Object> type;
            if (JavaFXBuilder.this.setters.get(propName) != null) {
                return null;
            }
            Method getter = (Method)JavaFXBuilder.this.getters.get(propName);
            if (getter == null) {
                Method setter = null;
                Class<?> target = JavaFXBuilder.this.getTargetClass();
                String suffix = Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
                try {
                    getter = MethodUtil.getMethod(target, "get" + suffix, NO_SIG);
                    setter = MethodUtil.getMethod(target, "set" + suffix, new Class[]{getter.getReturnType()});
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (getter != null) {
                    JavaFXBuilder.this.getters.put(propName, getter);
                    JavaFXBuilder.this.setters.put(propName, setter);
                }
                if (setter != null) {
                    return null;
                }
            }
            if (getter == null) {
                Method m = JavaFXBuilder.this.findMethod(propName);
                if (m == null) {
                    return null;
                }
                type = m.getParameterTypes()[0];
                if (type.isArray()) {
                    type = List.class;
                }
            } else {
                type = getter.getReturnType();
            }
            if (ObservableMap.class.isAssignableFrom(type)) {
                return FXCollections.observableMap(new HashMap());
            }
            if (Map.class.isAssignableFrom(type)) {
                return new HashMap();
            }
            if (ObservableList.class.isAssignableFrom(type)) {
                return FXCollections.observableArrayList();
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(type)) {
                return new HashSet();
            }
            return null;
        }

        public Object getTemporaryContainer(String propName) {
            Object o = this.containers.get(propName);
            if (o == null && (o = this.getReadOnlyProperty(propName)) != null) {
                this.containers.put(propName, o);
            }
            return o;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

