/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.builder.JavaFXFontBuilder;
import com.sun.javafx.fxml.builder.JavaFXImageBuilder;
import com.sun.javafx.fxml.builder.JavaFXSceneBuilder;
import com.sun.javafx.fxml.builder.ProxyBuilder;
import com.sun.javafx.fxml.builder.TriangleMeshBuilder;
import com.sun.javafx.fxml.builder.URLBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilder;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.text.Font;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import sun.reflect.misc.ConstructorUtil;

public final class JavaFXBuilderFactory
implements BuilderFactory {
    private final JavaFXBuilder NO_BUILDER = new JavaFXBuilder();
    private final Map<Class<?>, JavaFXBuilder> builders = new HashMap();
    private final ClassLoader classLoader;
    private final boolean alwaysUseBuilders;
    private final boolean webSupported;

    public JavaFXBuilderFactory() {
        this(FXMLLoader.getDefaultClassLoader(), false);
    }

    public JavaFXBuilderFactory(boolean alwaysUseBuilders) {
        this(FXMLLoader.getDefaultClassLoader(), alwaysUseBuilders);
    }

    public JavaFXBuilderFactory(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public JavaFXBuilderFactory(ClassLoader classLoader, boolean alwaysUseBuilders) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        this.classLoader = classLoader;
        this.alwaysUseBuilders = alwaysUseBuilders;
        this.webSupported = Platform.isSupported(ConditionalFeature.WEB);
    }

    @Override
    public Builder<?> getBuilder(Class<?> type) {
        Builder<Scene> builder;
        if (type == Scene.class) {
            builder = new JavaFXSceneBuilder();
        } else if (type == Font.class) {
            builder = new JavaFXFontBuilder();
        } else if (type == Image.class) {
            builder = new JavaFXImageBuilder();
        } else if (type == URL.class) {
            builder = new URLBuilder(this.classLoader);
        } else if (type == TriangleMesh.class) {
            builder = new TriangleMeshBuilder();
        } else if (this.scanForConstructorAnnotations(type)) {
            builder = new ProxyBuilder(type);
        } else {
            Builder<Object> objectBuilder = null;
            JavaFXBuilder typeBuilder = this.builders.get(type);
            if (typeBuilder != this.NO_BUILDER) {
                if (typeBuilder == null) {
                    boolean hasDefaultConstructor;
                    try {
                        ConstructorUtil.getConstructor(type, new Class[0]);
                        if (this.alwaysUseBuilders) {
                            throw new Exception();
                        }
                        hasDefaultConstructor = true;
                    }
                    catch (Exception x) {
                        hasDefaultConstructor = false;
                    }
                    if (!hasDefaultConstructor || this.webSupported && type.getName().equals("javafx.scene.web.WebView")) {
                        try {
                            typeBuilder = this.createTypeBuilder(type);
                        }
                        catch (ClassNotFoundException ex) {
                            // empty catch block
                        }
                    }
                    this.builders.put(type, typeBuilder == null ? this.NO_BUILDER : typeBuilder);
                }
                if (typeBuilder != null) {
                    objectBuilder = typeBuilder.createBuilder();
                }
            }
            builder = objectBuilder;
        }
        return builder;
    }

    JavaFXBuilder createTypeBuilder(Class<?> type) throws ClassNotFoundException {
        JavaFXBuilder typeBuilder = null;
        Class<?> builderClass = this.classLoader.loadClass(type.getName() + "Builder");
        try {
            typeBuilder = new JavaFXBuilder(builderClass);
        }
        catch (Exception ex) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.WARNING, "Failed to instantiate JavaFXBuilder for " + builderClass, ex);
        }
        if (!this.alwaysUseBuilders) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.FINER, "class {0} requires a builder.", type);
        }
        return typeBuilder;
    }

    private boolean scanForConstructorAnnotations(Class<?> type) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = ConstructorUtil.getConstructors(type)) {
            Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
            for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
                for (Annotation annotation : paramAnnotations[i]) {
                    if (!(annotation instanceof NamedArg)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

