/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart$$Lambda$1;
import javafx.scene.chart.AreaChart$$Lambda$2;
import javafx.scene.chart.AreaChart$$Lambda$3;
import javafx.scene.chart.AreaChart$$Lambda$4;
import javafx.scene.chart.AreaChart$$Lambda$5;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class AreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart.Series<X, Y>, DoubleProperty>();
    private Legend legend = new Legend();
    private BooleanProperty createSymbols = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            for (int seriesIndex = 0; seriesIndex < AreaChart.this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)AreaChart.this.getData().get(seriesIndex);
                for (int itemIndex = 0; itemIndex < series.getData().size(); ++itemIndex) {
                    XYChart.Data item = (XYChart.Data)series.getData().get(itemIndex);
                    Node symbol = item.getNode();
                    if (this.get() && symbol == null) {
                        symbol = AreaChart.this.createSymbol(series, AreaChart.this.getData().indexOf(series), item, itemIndex);
                        if (null == symbol) continue;
                        AreaChart.this.getPlotChildren().add(symbol);
                        continue;
                    }
                    if (this.get() || symbol == null) continue;
                    AreaChart.this.getPlotChildren().remove(symbol);
                    symbol = null;
                    item.setNode(null);
                }
            }
            AreaChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "createSymbols";
        }

        @Override
        public CssMetaData<AreaChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.CREATE_SYMBOLS;
        }
    };

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean value) {
        this.createSymbols.setValue(value);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public AreaChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public AreaChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        this.setLegend(this.legend);
        this.setData(data);
    }

    private static double doubleValue(Number number) {
        return AreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double nullDefault) {
        return number == null ? nullDefault : number.doubleValue();
    }

    @Override
    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList xData = null;
        ArrayList yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList();
        }
        if (xData != null || yData != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        xData.add(data.getXValue());
                    }
                    if (yData == null) continue;
                    yData.add(data.getYValue());
                }
            }
            if (xData != null && (xData.size() != 1 || this.getXAxis().toNumericValue(xData.get(0)) != 0.0)) {
                xa.invalidateRange(xData);
            }
            if (yData != null && (yData.size() != 1 || this.getYAxis().toNumericValue(yData.get(0)) != 0.0)) {
                ya.invalidateRange(yData);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        Node symbol = this.createSymbol(series, this.getData().indexOf(series), item, itemIndex);
        if (this.shouldAnimate()) {
            boolean animate = false;
            if (itemIndex > 0 && itemIndex < series.getData().size() - 1) {
                animate = true;
                XYChart.Data p1 = (XYChart.Data)series.getData().get(itemIndex - 1);
                XYChart.Data p2 = (XYChart.Data)series.getData().get(itemIndex + 1);
                double x1 = this.getXAxis().toNumericValue(p1.getXValue());
                double y1 = this.getYAxis().toNumericValue(p1.getYValue());
                double x3 = this.getXAxis().toNumericValue(p2.getXValue());
                double y3 = this.getYAxis().toNumericValue(p2.getYValue());
                double x2 = this.getXAxis().toNumericValue(item.getXValue());
                double y2 = this.getYAxis().toNumericValue(item.getYValue());
                double y = (y3 - y1) / (x3 - x1) * x2 + (x3 * y1 - y3 * x1) / (x3 - x1);
                item.setCurrentY(this.getYAxis().toRealValue(y));
                item.setCurrentX(this.getXAxis().toRealValue(x2));
            } else if (itemIndex == 0 && series.getData().size() > 1) {
                animate = true;
                item.setCurrentX(((XYChart.Data)series.getData().get(1)).getXValue());
                item.setCurrentY(((XYChart.Data)series.getData().get(1)).getYValue());
            } else if (itemIndex == series.getData().size() - 1 && series.getData().size() > 1) {
                animate = true;
                int last = series.getData().size() - 2;
                item.setCurrentX(((XYChart.Data)series.getData().get(last)).getXValue());
                item.setCurrentY(((XYChart.Data)series.getData().get(last)).getYValue());
            }
            if (symbol != null) {
                symbol.setOpacity(0.0);
                this.getPlotChildren().add(symbol);
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
                ft.setToValue(1.0);
                ft.play();
            }
            if (animate) {
                this.animate(new KeyFrame(Duration.ZERO, AreaChart$$Lambda$1.lambdaFactory$(this, symbol), new KeyValue(item.currentYProperty(), item.getCurrentY()), new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(800.0), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else if (symbol != null) {
            this.getPlotChildren().add(symbol);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node symbol = item.getNode();
        int itemIndex = series.getItemIndex(item);
        if (this.shouldAnimate()) {
            boolean animate = false;
            int dataSize = series.getDataSize();
            int dataListSize = series.getData().size();
            if (itemIndex > 0 && itemIndex < dataSize - 1) {
                animate = true;
                XYChart.Data<X, Y> p1 = series.getItem(itemIndex - 1);
                XYChart.Data<X, Y> p2 = series.getItem(itemIndex + 1);
                double x1 = this.getXAxis().toNumericValue(p1.getXValue());
                double y1 = this.getYAxis().toNumericValue(p1.getYValue());
                double x3 = this.getXAxis().toNumericValue(p2.getXValue());
                double y3 = this.getYAxis().toNumericValue(p2.getYValue());
                double x2 = this.getXAxis().toNumericValue(item.getXValue());
                double y2 = this.getYAxis().toNumericValue(item.getYValue());
                double y = (y3 - y1) / (x3 - x1) * x2 + (x3 * y1 - y3 * x1) / (x3 - x1);
                item.setCurrentX(this.getXAxis().toRealValue(x2));
                item.setCurrentY(this.getYAxis().toRealValue(y2));
                item.setXValue(this.getXAxis().toRealValue(x2));
                item.setYValue(this.getYAxis().toRealValue(y));
            } else if (itemIndex == 0 && dataListSize > 1) {
                animate = true;
                item.setXValue(((XYChart.Data)series.getData().get(0)).getXValue());
                item.setYValue(((XYChart.Data)series.getData().get(0)).getYValue());
            } else if (itemIndex == dataSize - 1 && dataListSize > 1) {
                animate = true;
                int last = dataListSize - 1;
                item.setXValue(((XYChart.Data)series.getData().get(last)).getXValue());
                item.setYValue(((XYChart.Data)series.getData().get(last)).getYValue());
            } else {
                symbol.setOpacity(0.0);
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
                ft.setToValue(0.0);
                ft.setOnFinished(AreaChart$$Lambda$2.lambdaFactory$(this, symbol, series, item));
                ft.play();
            }
            if (animate) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY()), new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(800.0), AreaChart$$Lambda$3.lambdaFactory$(this, item, symbol, series), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else {
            item.setSeries(null);
            this.getPlotChildren().remove(symbol);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
    }

    @Override
    protected void seriesChanged(ListChangeListener.Change<? extends XYChart.Series> c) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series s = (XYChart.Series)this.getData().get(i);
            Path seriesLine = (Path)((Group)s.getNode()).getChildren().get(1);
            Path fillPath = (Path)((Group)s.getNode()).getChildren().get(0);
            seriesLine.getStyleClass().setAll((String[])new String[]{"chart-series-area-line", "series" + i, s.defaultColorStyleClass});
            fillPath.getStyleClass().setAll((String[])new String[]{"chart-series-area-fill", "series" + i, s.defaultColorStyleClass});
            for (int j = 0; j < s.getData().size(); ++j) {
                XYChart.Data item = (XYChart.Data)s.getData().get(j);
                Node node = item.getNode();
                if (node == null) continue;
                node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + i, "data" + j, s.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        Path seriesLine = new Path();
        Path fillPath = new Path();
        seriesLine.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        Group areaGroup = new Group(fillPath, seriesLine);
        series.setNode(areaGroup);
        SimpleDoubleProperty seriesYAnimMultiplier = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(series, seriesYAnimMultiplier);
        if (this.shouldAnimate()) {
            seriesYAnimMultiplier.setValue(0.0);
        } else {
            seriesYAnimMultiplier.setValue(1.0);
        }
        this.getPlotChildren().add(areaGroup);
        ArrayList<KeyFrame> keyFrames = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            keyFrames.add(new KeyFrame(Duration.ZERO, new KeyValue(areaGroup.opacityProperty(), 0), new KeyValue(seriesYAnimMultiplier, 0)));
            keyFrames.add(new KeyFrame(Duration.millis(200.0), new KeyValue(areaGroup.opacityProperty(), 1)));
            keyFrames.add(new KeyFrame(Duration.millis(500.0), new KeyValue(seriesYAnimMultiplier, 1)));
        }
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node symbol = this.createSymbol(series, seriesIndex, item, j);
            if (symbol == null) continue;
            if (this.shouldAnimate()) {
                symbol.setOpacity(0.0);
                this.getPlotChildren().add(symbol);
                keyFrames.add(new KeyFrame(Duration.ZERO, new KeyValue(symbol.opacityProperty(), 0)));
                keyFrames.add(new KeyFrame(Duration.millis(200.0), new KeyValue(symbol.opacityProperty(), 1)));
                continue;
            }
            this.getPlotChildren().add(symbol);
        }
        if (this.shouldAnimate()) {
            this.animate(keyFrames.toArray(new KeyFrame[keyFrames.size()]));
        }
    }

    private void updateDefaultColorIndex(XYChart.Series<X, Y> series) {
        int clearIndex = (Integer)this.seriesColorMap.get(series);
        Path seriesLine = (Path)((Group)series.getNode()).getChildren().get(1);
        Path fillPath = (Path)((Group)series.getNode()).getChildren().get(0);
        if (seriesLine != null) {
            seriesLine.getStyleClass().remove(DEFAULT_COLOR + clearIndex);
        }
        if (fillPath != null) {
            fillPath.getStyleClass().remove(DEFAULT_COLOR + clearIndex);
        }
        for (int j = 0; j < series.getData().size(); ++j) {
            Node node = ((XYChart.Data)series.getData().get(j)).getNode();
            if (node == null) continue;
            node.getStyleClass().remove(DEFAULT_COLOR + clearIndex);
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        this.updateDefaultColorIndex(series);
        this.seriesYMultiplierMap.remove(series);
        if (this.shouldAnimate()) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(series.getNode());
            if (this.getCreateSymbols()) {
                for (XYChart.Data data : series.getData()) {
                    nodes.add(data.getNode());
                }
            }
            KeyValue[] keyValueArray = new KeyValue[nodes.size()];
            KeyValue[] keyValueArray2 = new KeyValue[nodes.size()];
            for (int j = 0; j < nodes.size(); ++j) {
                keyValueArray[j] = new KeyValue(((Node)nodes.get(j)).opacityProperty(), 1);
                keyValueArray2[j] = new KeyValue(((Node)nodes.get(j)).opacityProperty(), 0);
            }
            Timeline tl = new Timeline();
            tl.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, keyValueArray), new KeyFrame(Duration.millis(400.0), AreaChart$$Lambda$4.lambdaFactory$(this, nodes, series), keyValueArray2)});
            tl.play();
        } else {
            this.getPlotChildren().remove(series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove(data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<LineTo> constructedPath = new ArrayList<LineTo>(this.getDataSize());
        for (int seriesIndex = 0; seriesIndex < this.getDataSize(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            DoubleProperty seriesYAnimMultiplier = this.seriesYMultiplierMap.get(series);
            double lastX = 0.0;
            ObservableList<Node> children = ((Group)series.getNode()).getChildren();
            ObservableList<PathElement> seriesLine = ((Path)children.get(1)).getElements();
            ObservableList<PathElement> fillPath = ((Path)children.get(0)).getElements();
            seriesLine.clear();
            fillPath.clear();
            constructedPath.clear();
            Iterator it = this.getDisplayedDataIterator(series);
            while (it.hasNext()) {
                XYChart.Data item = it.next();
                double x = this.getXAxis().getDisplayPosition(item.getCurrentX());
                double y = this.getYAxis().getDisplayPosition(this.getYAxis().toRealValue(this.getYAxis().toNumericValue(item.getCurrentY()) * seriesYAnimMultiplier.getValue()));
                constructedPath.add(new LineTo(x, y));
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                lastX = x;
                Node symbol = item.getNode();
                if (symbol == null) continue;
                double w = symbol.prefWidth(-1.0);
                double h = symbol.prefHeight(-1.0);
                symbol.resizeRelocate(x - w / 2.0, y - h / 2.0, w, h);
            }
            if (constructedPath.isEmpty()) continue;
            Collections.sort(constructedPath, AreaChart$$Lambda$5.lambdaFactory$());
            LineTo first = (LineTo)constructedPath.get(0);
            seriesLine.add(new MoveTo(first.getX(), first.getY()));
            fillPath.add(new MoveTo(first.getX(), this.getYAxis().getHeight()));
            seriesLine.addAll((Collection<PathElement>)constructedPath);
            fillPath.addAll((Collection<PathElement>)constructedPath);
            fillPath.add(new LineTo(lastX, this.getYAxis().getHeight()));
            fillPath.add(new ClosePath());
        }
    }

    private Node createSymbol(XYChart.Series<X, Y> series, int seriesIndex, XYChart.Data<X, Y> item, int itemIndex) {
        Node symbol = item.getNode();
        if (symbol == null && this.getCreateSymbols()) {
            symbol = new StackPane();
            symbol.setAccessibleRole(AccessibleRole.TEXT);
            symbol.setAccessibleRoleDescription("Point");
            symbol.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            item.setNode(symbol);
        }
        if (symbol != null) {
            symbol.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + seriesIndex, "data" + itemIndex, series.defaultColorStyleClass});
        }
        return symbol;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                legenditem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-area-symbol", "series" + seriesIndex, "area-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return AreaChart.getClassCssMetaData();
    }

    static /* synthetic */ int lambda$layoutPlotChildren$557(LineTo e1, LineTo e2) {
        return Double.compare(e1.getX(), e2.getX());
    }

    /* synthetic */ void lambda$seriesRemoved$556(List list, XYChart.Series series, ActionEvent actionEvent) {
        this.getPlotChildren().removeAll(list);
        this.removeSeriesFromDisplay(series);
    }

    /* synthetic */ void lambda$dataItemRemoved$555(XYChart.Data data, Node node, XYChart.Series series, ActionEvent actionEvent) {
        data.setSeries(null);
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(series, data);
    }

    /* synthetic */ void lambda$dataItemRemoved$554(Node node, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(series, data);
    }

    /* synthetic */ void lambda$dataItemAdded$553(Node node, ActionEvent e) {
        if (node != null && !this.getPlotChildren().contains(node)) {
            this.getPlotChildren().add(node);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<AreaChart<?, ?>, Boolean> CREATE_SYMBOLS = new CssMetaData<AreaChart<?, ?>, Boolean>("-fx-create-symbols", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(AreaChart<?, ?> node) {
                return ((AreaChart)node).createSymbols == null || !((AreaChart)node).createSymbols.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(AreaChart<?, ?> node) {
                return (StyleableProperty)((Object)node.createSymbolsProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(XYChart.getClassCssMetaData());
            styleables.add(CREATE_SYMBOLS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

