/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.StringConverter;

public abstract class ValueAxis<T extends Number>
extends Axis<T> {
    private final Path minorTickPath = new Path();
    private double offset;
    double dataMinValue;
    double dataMaxValue;
    private List<T> minorTickMarkValues = null;
    protected final DoubleProperty currentLowerBound = new SimpleDoubleProperty(this, "currentLowerBound");
    private BooleanProperty minorTickVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            ValueAxis.this.minorTickPath.setVisible(this.get());
            ValueAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "minorTickVisible";
        }

        @Override
        public CssMetaData<ValueAxis<? extends Number>, Boolean> getCssMetaData() {
            return StyleableProperties.MINOR_TICK_VISIBLE;
        }
    };
    private ReadOnlyDoubleWrapper scale = new ReadOnlyDoubleWrapper(this, "scale", 0.0){

        @Override
        protected void invalidated() {
            ValueAxis.this.requestAxisLayout();
            ValueAxis.this.measureInvalid = true;
        }
    };
    private DoubleProperty upperBound = new DoublePropertyBase(100.0){

        @Override
        protected void invalidated() {
            if (!ValueAxis.this.isAutoRanging()) {
                ValueAxis.this.invalidateRange();
                ValueAxis.this.requestAxisLayout();
            }
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "upperBound";
        }
    };
    private DoubleProperty lowerBound = new DoublePropertyBase(0.0){

        @Override
        protected void invalidated() {
            if (!ValueAxis.this.isAutoRanging()) {
                ValueAxis.this.invalidateRange();
                ValueAxis.this.requestAxisLayout();
            }
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "lowerBound";
        }
    };
    private final ObjectProperty<StringConverter<T>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<T>>(null){

        @Override
        protected void invalidated() {
            ValueAxis.this.invalidateRange();
            ValueAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "tickLabelFormatter";
        }
    };
    private DoubleProperty minorTickLength = new StyleableDoubleProperty(5.0){

        @Override
        protected void invalidated() {
            ValueAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "minorTickLength";
        }

        @Override
        public CssMetaData<ValueAxis<? extends Number>, Number> getCssMetaData() {
            return StyleableProperties.MINOR_TICK_LENGTH;
        }
    };
    private IntegerProperty minorTickCount = new StyleableIntegerProperty(5){

        @Override
        protected void invalidated() {
            ValueAxis.this.invalidateRange();
            ValueAxis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return ValueAxis.this;
        }

        @Override
        public String getName() {
            return "minorTickCount";
        }

        @Override
        public CssMetaData<ValueAxis<? extends Number>, Number> getCssMetaData() {
            return StyleableProperties.MINOR_TICK_COUNT;
        }
    };

    public final boolean isMinorTickVisible() {
        return this.minorTickVisible.get();
    }

    public final void setMinorTickVisible(boolean value) {
        this.minorTickVisible.set(value);
    }

    public final BooleanProperty minorTickVisibleProperty() {
        return this.minorTickVisible;
    }

    public final double getScale() {
        return this.scale.get();
    }

    protected final void setScale(double scale) {
        this.scale.set(scale);
    }

    public final ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    public final double getUpperBound() {
        return this.upperBound.get();
    }

    public final void setUpperBound(double value) {
        this.upperBound.set(value);
    }

    public final DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }

    public final double getLowerBound() {
        return this.lowerBound.get();
    }

    public final void setLowerBound(double value) {
        this.lowerBound.set(value);
    }

    public final DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    public final StringConverter<T> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public final void setTickLabelFormatter(StringConverter<T> value) {
        this.tickLabelFormatter.setValue(value);
    }

    public final ObjectProperty<StringConverter<T>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public final double getMinorTickLength() {
        return this.minorTickLength.get();
    }

    public final void setMinorTickLength(double value) {
        this.minorTickLength.set(value);
    }

    public final DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    public final int getMinorTickCount() {
        return this.minorTickCount.get();
    }

    public final void setMinorTickCount(int value) {
        this.minorTickCount.set(value);
    }

    public final IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    public ValueAxis() {
        this.minorTickPath.getStyleClass().add("axis-minor-tick-mark");
        this.getChildren().add(this.minorTickPath);
    }

    public ValueAxis(double lowerBound, double upperBound) {
        this();
        this.setAutoRanging(false);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
    }

    @Override
    protected final Object autoRange(double length) {
        if (this.isAutoRanging()) {
            double labelSize = this.getTickLabelFont().getSize() * 2.0;
            return this.autoRange(this.dataMinValue, this.dataMaxValue, length, labelSize);
        }
        return this.getRange();
    }

    protected final double calculateNewScale(double length, double lowerBound, double upperBound) {
        double newScale = 1.0;
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            this.offset = length;
            newScale = upperBound - lowerBound == 0.0 ? -length : -(length / (upperBound - lowerBound));
        } else {
            this.offset = 0.0;
            newScale = upperBound - lowerBound == 0.0 ? length : length / (upperBound - lowerBound);
        }
        return newScale;
    }

    protected Object autoRange(double minValue, double maxValue, double length, double labelSize) {
        return null;
    }

    protected abstract List<T> calculateMinorTickMarks();

    @Override
    protected void tickMarksUpdated() {
        super.tickMarksUpdated();
        this.minorTickMarkValues = this.calculateMinorTickMarks();
    }

    @Override
    protected void layoutChildren() {
        block11: {
            double length;
            Side side = this.getEffectiveSide();
            double d = length = side.isVertical() ? this.getHeight() : this.getWidth();
            if (!this.isAutoRanging()) {
                this.setScale(this.calculateNewScale(length, this.getLowerBound(), this.getUpperBound()));
                this.currentLowerBound.set(this.getLowerBound());
            }
            super.layoutChildren();
            this.minorTickPath.getElements().clear();
            double minorTickLength = Math.max(0.0, this.getMinorTickLength());
            if (!(minorTickLength > 0.0) || !(length > (double)(2 * this.getTickMarks().size()))) break block11;
            int stripFactor = (int)Math.ceil((double)(2 * this.minorTickMarkValues.size()) / (length - (double)(2 * this.getTickMarks().size())));
            if (Side.LEFT.equals((Object)side)) {
                this.minorTickPath.setLayoutX(-0.5);
                this.minorTickPath.setLayoutY(0.5);
                for (int i = 0; i < this.minorTickMarkValues.size(); i += stripFactor) {
                    Number value = (Number)this.minorTickMarkValues.get(i);
                    double y = this.getDisplayPosition((T)value);
                    if (!(y >= 0.0) || !(y <= length)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(this.getWidth() - minorTickLength, y), new LineTo(this.getWidth() - 1.0, y)});
                }
            } else if (Side.RIGHT.equals((Object)side)) {
                this.minorTickPath.setLayoutX(0.5);
                this.minorTickPath.setLayoutY(0.5);
                for (int i = 0; i < this.minorTickMarkValues.size(); i += stripFactor) {
                    Number value = (Number)this.minorTickMarkValues.get(i);
                    double y = this.getDisplayPosition((T)value);
                    if (!(y >= 0.0) || !(y <= length)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(1.0, y), new LineTo(minorTickLength, y)});
                }
            } else if (Side.TOP.equals((Object)side)) {
                this.minorTickPath.setLayoutX(0.5);
                this.minorTickPath.setLayoutY(-0.5);
                for (int i = 0; i < this.minorTickMarkValues.size(); i += stripFactor) {
                    Number value = (Number)this.minorTickMarkValues.get(i);
                    double x = this.getDisplayPosition((T)value);
                    if (!(x >= 0.0) || !(x <= length)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(x, this.getHeight() - 1.0), new LineTo(x, this.getHeight() - minorTickLength)});
                }
            } else {
                this.minorTickPath.setLayoutX(0.5);
                this.minorTickPath.setLayoutY(0.5);
                for (int i = 0; i < this.minorTickMarkValues.size(); i += stripFactor) {
                    Number value = (Number)this.minorTickMarkValues.get(i);
                    double x = this.getDisplayPosition((T)value);
                    if (!(x >= 0.0) || !(x <= length)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(x, 1.0), new LineTo(x, minorTickLength)});
                }
            }
        }
    }

    @Override
    public void invalidateRange(List<T> data) {
        if (data.isEmpty()) {
            this.dataMaxValue = this.getUpperBound();
            this.dataMinValue = this.getLowerBound();
        } else {
            this.dataMinValue = Double.MAX_VALUE;
            this.dataMaxValue = -1.7976931348623157E308;
        }
        for (Number dataValue : data) {
            this.dataMinValue = Math.min(this.dataMinValue, dataValue.doubleValue());
            this.dataMaxValue = Math.max(this.dataMaxValue, dataValue.doubleValue());
        }
        super.invalidateRange(data);
    }

    @Override
    public double getDisplayPosition(T value) {
        return Math.round(this.offset + (((Number)value).doubleValue() - this.currentLowerBound.get()) * this.getScale());
    }

    @Override
    public T getValueForDisplay(double displayPosition) {
        return (T)this.toRealValue((displayPosition - this.offset) / this.getScale() + this.currentLowerBound.get());
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getLowerBound() || 0.0 > this.getUpperBound()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    @Override
    public boolean isValueOnAxis(T value) {
        double num = ((Number)value).doubleValue();
        return num >= this.getLowerBound() && num <= this.getUpperBound();
    }

    @Override
    public double toNumericValue(T value) {
        return value == null ? Double.NaN : ((Number)value).doubleValue();
    }

    @Override
    public T toRealValue(double value) {
        return (T)new Double(value);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ValueAxis.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<ValueAxis<? extends Number>, Number> MINOR_TICK_LENGTH = new CssMetaData<ValueAxis<? extends Number>, Number>("-fx-minor-tick-length", SizeConverter.getInstance(), (Number)5.0){

            @Override
            public boolean isSettable(ValueAxis<? extends Number> n) {
                return ((ValueAxis)n).minorTickLength == null || !((ValueAxis)n).minorTickLength.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ValueAxis<? extends Number> n) {
                return (StyleableProperty)((Object)n.minorTickLengthProperty());
            }
        };
        private static final CssMetaData<ValueAxis<? extends Number>, Number> MINOR_TICK_COUNT = new CssMetaData<ValueAxis<? extends Number>, Number>("-fx-minor-tick-count", SizeConverter.getInstance(), (Number)5){

            @Override
            public boolean isSettable(ValueAxis<? extends Number> n) {
                return ((ValueAxis)n).minorTickCount == null || !((ValueAxis)n).minorTickCount.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ValueAxis<? extends Number> n) {
                return (StyleableProperty)((Object)n.minorTickCountProperty());
            }
        };
        private static final CssMetaData<ValueAxis<? extends Number>, Boolean> MINOR_TICK_VISIBLE = new CssMetaData<ValueAxis<? extends Number>, Boolean>("-fx-minor-tick-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(ValueAxis<? extends Number> n) {
                return ((ValueAxis)n).minorTickVisible == null || !((ValueAxis)n).minorTickVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(ValueAxis<? extends Number> n) {
                return (StyleableProperty)((Object)n.minorTickVisibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Axis.getClassCssMetaData());
            styleables.add(MINOR_TICK_COUNT);
            styleables.add(MINOR_TICK_LENGTH);
            styleables.add(MINOR_TICK_COUNT);
            styleables.add(MINOR_TICK_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

