/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert$$Lambda$1;
import javafx.scene.control.Alert$$Lambda$2;
import javafx.scene.control.Alert$$Lambda$3;
import javafx.scene.control.Alert$$Lambda$4;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

public class Alert
extends Dialog<ButtonType> {
    private WeakReference<DialogPane> dialogPaneRef;
    private boolean installingDefaults = false;
    private boolean hasCustomButtons = false;
    private boolean hasCustomTitle = false;
    private boolean hasCustomHeaderText = false;
    private final InvalidationListener headerTextListener = Alert$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener titleListener = Alert$$Lambda$2.lambdaFactory$(this);
    private final ListChangeListener<ButtonType> buttonsListener = Alert$$Lambda$3.lambdaFactory$(this);
    private final ObjectProperty<AlertType> alertType = new SimpleObjectProperty<AlertType>(null){
        final String[] styleClasses;
        {
            this.styleClasses = new String[]{"information", "warning", "error", "confirmation"};
        }

        @Override
        protected void invalidated() {
            DialogPane dialogPane;
            String newTitle = "";
            String newHeader = "";
            String styleClass = "";
            ButtonType[] newButtons = new ButtonType[]{ButtonType.OK};
            switch (Alert.this.getAlertType()) {
                case NONE: {
                    newButtons = new ButtonType[]{};
                    break;
                }
                case INFORMATION: {
                    newTitle = ControlResources.getString("Dialog.info.title");
                    newHeader = ControlResources.getString("Dialog.info.header");
                    styleClass = "information";
                    break;
                }
                case WARNING: {
                    newTitle = ControlResources.getString("Dialog.warning.title");
                    newHeader = ControlResources.getString("Dialog.warning.header");
                    styleClass = "warning";
                    break;
                }
                case ERROR: {
                    newTitle = ControlResources.getString("Dialog.error.title");
                    newHeader = ControlResources.getString("Dialog.error.header");
                    styleClass = "error";
                    break;
                }
                case CONFIRMATION: {
                    newTitle = ControlResources.getString("Dialog.confirm.title");
                    newHeader = ControlResources.getString("Dialog.confirm.header");
                    styleClass = "confirmation";
                    newButtons = new ButtonType[]{ButtonType.OK, ButtonType.CANCEL};
                }
            }
            Alert.this.installingDefaults = true;
            if (!Alert.this.hasCustomTitle) {
                Alert.this.setTitle(newTitle);
            }
            if (!Alert.this.hasCustomHeaderText) {
                Alert.this.setHeaderText(newHeader);
            }
            if (!Alert.this.hasCustomButtons) {
                Alert.this.getButtonTypes().setAll((ButtonType[])newButtons);
            }
            if ((dialogPane = Alert.this.getDialogPane()) != null) {
                ArrayList<String> toRemove = new ArrayList<String>(Arrays.asList(this.styleClasses));
                toRemove.remove(styleClass);
                dialogPane.getStyleClass().removeAll((Collection<?>)toRemove);
                if (!dialogPane.getStyleClass().contains(styleClass)) {
                    dialogPane.getStyleClass().add(styleClass);
                }
            }
            Alert.this.installingDefaults = false;
        }
    };

    public Alert(@NamedArg(value="alertType") AlertType alertType) {
        this(alertType, "", new ButtonType[0]);
    }

    public Alert(@NamedArg(value="alertType") AlertType alertType, @NamedArg(value="contentText") String contentText, ButtonType ... buttons) {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContentText(contentText);
        this.getDialogPane().getStyleClass().add("alert");
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
        boolean bl = this.hasCustomButtons = buttons != null && buttons.length > 0;
        if (this.hasCustomButtons) {
            for (ButtonType btnType : buttons) {
                dialogPane.getButtonTypes().addAll((ButtonType[])new ButtonType[]{btnType});
            }
        }
        this.setAlertType(alertType);
        this.dialogPaneProperty().addListener(Alert$$Lambda$4.lambdaFactory$(this));
        this.titleProperty().addListener(this.titleListener);
        this.updateListeners();
    }

    public final AlertType getAlertType() {
        return (AlertType)((Object)this.alertType.get());
    }

    public final void setAlertType(AlertType alertType) {
        this.alertType.setValue(alertType);
    }

    public final ObjectProperty<AlertType> alertTypeProperty() {
        return this.alertType;
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.getDialogPane().getButtonTypes();
    }

    private void updateListeners() {
        DialogPane newPane;
        DialogPane oldPane = (DialogPane)this.dialogPaneRef.get();
        if (oldPane != null) {
            oldPane.headerTextProperty().removeListener(this.headerTextListener);
            oldPane.getButtonTypes().removeListener(this.buttonsListener);
        }
        if ((newPane = this.getDialogPane()) != null) {
            newPane.headerTextProperty().addListener(this.headerTextListener);
            newPane.getButtonTypes().addListener(this.buttonsListener);
        }
        this.dialogPaneRef = new WeakReference<DialogPane>(newPane);
    }

    /* synthetic */ void lambda$new$596(Observable o) {
        this.updateListeners();
    }

    /* synthetic */ void lambda$new$595(ListChangeListener.Change change) {
        if (!this.installingDefaults) {
            this.hasCustomButtons = true;
        }
    }

    /* synthetic */ void lambda$new$594(Observable o) {
        if (!this.installingDefaults) {
            this.hasCustomTitle = true;
        }
    }

    /* synthetic */ void lambda$new$593(Observable o) {
        if (!this.installingDefaults) {
            this.hasCustomHeaderText = true;
        }
    }

    public static enum AlertType {
        NONE,
        INFORMATION,
        WARNING,
        CONFIRMATION,
        ERROR;

    }
}

