/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ChoiceBoxSkin;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ChoiceBox$$Lambda$1;
import javafx.scene.control.ChoiceBox$$Lambda$2;
import javafx.scene.control.ChoiceBox$$Lambda$3;
import javafx.scene.control.ChoiceBox$ChoiceBoxSelectionModel$$Lambda$1;
import javafx.scene.control.ChoiceBox$ChoiceBoxSelectionModel$$Lambda$2;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.util.StringConverter;

@DefaultProperty(value="items")
public class ChoiceBox<T>
extends Control {
    private ObjectProperty<SingleSelectionModel<T>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<T>>(this, "selectionModel"){
        private SelectionModel<T> oldSM;
        {
            this.oldSM = null;
        }

        @Override
        protected void invalidated() {
            SelectionModel sm;
            if (this.oldSM != null) {
                this.oldSM.selectedItemProperty().removeListener(ChoiceBox.this.selectedItemListener);
            }
            this.oldSM = sm = (SelectionModel)this.get();
            if (sm != null) {
                sm.selectedItemProperty().addListener(ChoiceBox.this.selectedItemListener);
            }
        }
    };
    private ChangeListener<T> selectedItemListener = ChoiceBox$$Lambda$1.lambdaFactory$(this);
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(){

        @Override
        protected void invalidated() {
            ChoiceBox.this.pseudoClassStateChanged(SHOWING_PSEUDOCLASS_STATE, this.get());
            ChoiceBox.this.notifyAccessibleAttributeChanged(AccessibleAttribute.EXPANDED);
        }

        @Override
        public Object getBean() {
            return ChoiceBox.this;
        }

        @Override
        public String getName() {
            return "showing";
        }
    };
    private ObjectProperty<ObservableList<T>> items = new ObjectPropertyBase<ObservableList<T>>(){
        ObservableList<T> old;

        @Override
        protected void invalidated() {
            ObservableList newItems = (ObservableList)this.get();
            if (this.old != newItems) {
                SingleSelectionModel sm;
                if (this.old != null) {
                    this.old.removeListener(ChoiceBox.this.itemsListener);
                }
                if (newItems != null) {
                    newItems.addListener(ChoiceBox.this.itemsListener);
                }
                if ((sm = ChoiceBox.this.getSelectionModel()) != null) {
                    if (newItems != null && newItems.isEmpty()) {
                        sm.clearSelection();
                    } else if (sm.getSelectedIndex() == -1 && sm.getSelectedItem() != null) {
                        int newIndex = ChoiceBox.this.getItems().indexOf(sm.getSelectedItem());
                        if (newIndex != -1) {
                            sm.setSelectedIndex(newIndex);
                        }
                    } else {
                        sm.clearSelection();
                    }
                }
                this.old = newItems;
            }
        }

        @Override
        public Object getBean() {
            return ChoiceBox.this;
        }

        @Override
        public String getName() {
            return "items";
        }
    };
    private final ListChangeListener<T> itemsListener = ChoiceBox$$Lambda$2.lambdaFactory$(this);
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<Object>(this, "converter", null);
    private ObjectProperty<T> value = new SimpleObjectProperty<T>(this, "value"){

        @Override
        protected void invalidated() {
            super.invalidated();
            ChoiceBox.this.fireEvent(new ActionEvent());
            SingleSelectionModel sm = ChoiceBox.this.getSelectionModel();
            if (sm != null) {
                sm.select(super.getValue());
            }
            ChoiceBox.this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        }
    };
    private static final PseudoClass SHOWING_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("showing");

    public ChoiceBox() {
        this(FXCollections.observableArrayList());
    }

    public ChoiceBox(ObservableList<T> items) {
        this.getStyleClass().setAll((String[])new String[]{"choice-box"});
        this.setAccessibleRole(AccessibleRole.COMBO_BOX);
        this.setItems(items);
        this.setSelectionModel(new ChoiceBoxSelectionModel(this));
        this.valueProperty().addListener(ChoiceBox$$Lambda$3.lambdaFactory$(this));
    }

    public final void setSelectionModel(SingleSelectionModel<T> value) {
        this.selectionModel.set(value);
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final void setItems(ObservableList<T> value) {
        this.items.set(value);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final void setValue(T value) {
        this.valueProperty().set(value);
    }

    public final T getValue() {
        return this.valueProperty().get();
    }

    public void show() {
        if (!this.isDisabled()) {
            this.showing.set(true);
        }
    }

    public void hide() {
        this.showing.set(false);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ChoiceBoxSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                Object title = super.queryAccessibleAttribute(attribute, parameters);
                if (title != null) {
                    return title;
                }
                StringConverter<T> converter = this.getConverter();
                if (converter == null) {
                    return this.getValue() != null ? this.getValue().toString() : "";
                }
                return converter.toString(this.getValue());
            }
            case EXPANDED: {
                return this.isShowing();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case COLLAPSE: {
                this.hide();
                break;
            }
            case EXPAND: {
                this.show();
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }

    /* synthetic */ void lambda$new$138(ListChangeListener.Change c) {
        SingleSelectionModel<T> sm = this.getSelectionModel();
        if (sm != null) {
            if (this.getItems() == null || this.getItems().isEmpty()) {
                sm.clearSelection();
            } else {
                int newIndex = this.getItems().indexOf(sm.getSelectedItem());
                sm.setSelectedIndex(newIndex);
            }
        }
        if (sm != null) {
            Object selectedItem = sm.getSelectedItem();
            while (c.next()) {
                if (selectedItem == null || !c.getRemoved().contains(selectedItem)) continue;
                sm.clearSelection();
                break;
            }
        }
    }

    /* synthetic */ void lambda$new$137(ObservableValue ov, Object t, Object t1) {
        if (!this.valueProperty().isBound()) {
            this.setValue(t1);
        }
    }

    /* synthetic */ void lambda$new$136(ObservableValue ov, Object t, Object t1) {
        if (this.getItems() == null) {
            return;
        }
        int index = this.getItems().indexOf(t1);
        if (index > -1) {
            this.getSelectionModel().select(index);
        }
    }

    static class ChoiceBoxSelectionModel<T>
    extends SingleSelectionModel<T> {
        private final ChoiceBox<T> choiceBox;

        public ChoiceBoxSelectionModel(ChoiceBox<T> cb) {
            if (cb == null) {
                throw new NullPointerException("ChoiceBox can not be null");
            }
            this.choiceBox = cb;
            ListChangeListener itemsContentObserver = ChoiceBox$ChoiceBoxSelectionModel$$Lambda$1.lambdaFactory$(this);
            if (this.choiceBox.getItems() != null) {
                this.choiceBox.getItems().addListener(itemsContentObserver);
            }
            ChangeListener itemsObserver = ChoiceBox$ChoiceBoxSelectionModel$$Lambda$2.lambdaFactory$(this, itemsContentObserver);
            this.choiceBox.itemsProperty().addListener(itemsObserver);
        }

        @Override
        protected T getModelItem(int index) {
            ObservableList<T> items = this.choiceBox.getItems();
            if (items == null) {
                return null;
            }
            if (index < 0 || index >= items.size()) {
                return null;
            }
            return (T)items.get(index);
        }

        @Override
        protected int getItemCount() {
            ObservableList<T> items = this.choiceBox.getItems();
            return items == null ? 0 : items.size();
        }

        @Override
        public void select(int index) {
            T value = this.getModelItem(index);
            if (value instanceof Separator) {
                this.select(++index);
            } else {
                super.select(index);
            }
            if (this.choiceBox.isShowing()) {
                this.choiceBox.hide();
            }
        }

        /* synthetic */ void lambda$new$140(ListChangeListener listChangeListener, ObservableValue valueModel, ObservableList oldList, ObservableList newList) {
            int newIndex;
            if (oldList != null) {
                oldList.removeListener(listChangeListener);
            }
            if (newList != null) {
                newList.addListener(listChangeListener);
            }
            this.setSelectedIndex(-1);
            if (this.getSelectedItem() != null && (newIndex = this.choiceBox.getItems().indexOf(this.getSelectedItem())) != -1) {
                this.setSelectedIndex(newIndex);
            }
        }

        /* synthetic */ void lambda$new$139(ListChangeListener.Change c) {
            int newIndex;
            if (this.choiceBox.getItems() == null || this.choiceBox.getItems().isEmpty()) {
                this.setSelectedIndex(-1);
            } else if (this.getSelectedIndex() == -1 && this.getSelectedItem() != null && (newIndex = this.choiceBox.getItems().indexOf(this.getSelectedItem())) != -1) {
                this.setSelectedIndex(newIndex);
            }
        }
    }
}

