/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.Utils;
import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.scene.control.skin.ContextMenuSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.Window;

@IDProperty(value="id")
public class ContextMenu
extends PopupControl {
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            ContextMenu.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return ContextMenu.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };
    private final ObservableList<MenuItem> items = new TrackableObservableList<MenuItem>(){

        @Override
        protected void onChanged(ListChangeListener.Change<MenuItem> c) {
            while (c.next()) {
                for (MenuItem item : c.getRemoved()) {
                    item.setParentPopup(null);
                }
                for (MenuItem item : c.getAddedSubList()) {
                    if (item.getParentPopup() != null) {
                        item.getParentPopup().getItems().remove(item);
                    }
                    item.setParentPopup(ContextMenu.this);
                }
            }
        }
    };
    @Deprecated
    private final BooleanProperty impl_showRelativeToWindow = new SimpleBooleanProperty(false);
    private static final String DEFAULT_STYLE_CLASS = "context-menu";

    public ContextMenu() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAutoHide(true);
    }

    public ContextMenu(MenuItem ... items) {
        this();
        this.items.addAll((MenuItem[])items);
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public final boolean isImpl_showRelativeToWindow() {
        return this.impl_showRelativeToWindow.get();
    }

    public final void setImpl_showRelativeToWindow(boolean value) {
        this.impl_showRelativeToWindow.set(value);
    }

    public final BooleanProperty impl_showRelativeToWindowProperty() {
        return this.impl_showRelativeToWindow;
    }

    public void show(Node anchor, Side side, double dx, double dy) {
        HPos hpos;
        if (anchor == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(anchor.getEffectiveNodeOrientation());
        HPos hPos = side == Side.LEFT ? HPos.LEFT : (hpos = side == Side.RIGHT ? HPos.RIGHT : HPos.CENTER);
        VPos vpos = side == Side.TOP ? VPos.TOP : (side == Side.BOTTOM ? VPos.BOTTOM : VPos.CENTER);
        Point2D point = Utils.pointRelativeTo(anchor, this.prefWidth(-1.0), this.prefHeight(-1.0), hpos, vpos, dx, dy, true);
        this.doShow(anchor, point.getX(), point.getY());
    }

    @Override
    public void show(Node anchor, double screenX, double screenY) {
        if (anchor == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(anchor.getEffectiveNodeOrientation());
        this.doShow(anchor, screenX, screenY);
    }

    private void doShow(Node anchor, double screenX, double screenY) {
        Event.fireEvent(this, new Event(Menu.ON_SHOWING));
        if (this.isImpl_showRelativeToWindow()) {
            Window win;
            Scene scene = anchor == null ? null : anchor.getScene();
            Window window = win = scene == null ? null : scene.getWindow();
            if (win == null) {
                return;
            }
            super.show(win, screenX, screenY);
        } else {
            super.show(anchor, screenX, screenY);
        }
        Event.fireEvent(this, new Event(Menu.ON_SHOWN));
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        Event.fireEvent(this, new Event(Menu.ON_HIDING));
        super.hide();
        Event.fireEvent(this, new Event(Menu.ON_HIDDEN));
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ContextMenuSkin(this);
    }
}

