/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.MenuButtonSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;

public class MenuButton
extends ButtonBase {
    private final ObservableList<MenuItem> items = FXCollections.observableArrayList();
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(this, "showing", false){

        @Override
        protected void invalidated() {
            MenuButton.this.pseudoClassStateChanged(PSEUDO_CLASS_SHOWING, this.get());
            super.invalidated();
        }
    };
    private ObjectProperty<Side> popupSide;
    private static final String DEFAULT_STYLE_CLASS = "menu-button";
    private static final PseudoClass PSEUDO_CLASS_OPENVERTICALLY = PseudoClass.getPseudoClass("openvertically");
    private static final PseudoClass PSEUDO_CLASS_SHOWING = PseudoClass.getPseudoClass("showing");

    public MenuButton() {
        this(null, null);
    }

    public MenuButton(String text) {
        this(text, null);
    }

    public MenuButton(String text, Node graphic) {
        this(text, graphic, null);
    }

    public MenuButton(String text, Node graphic, MenuItem ... items) {
        if (text != null) {
            this.setText(text);
        }
        if (graphic != null) {
            this.setGraphic(graphic);
        }
        if (items != null) {
            this.getItems().addAll((MenuItem[])items);
        }
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.MENU_BUTTON);
        this.setMnemonicParsing(true);
        this.pseudoClassStateChanged(PSEUDO_CLASS_OPENVERTICALLY, true);
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    private void setShowing(boolean value) {
        this.showing.set(value);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final void setPopupSide(Side value) {
        this.popupSideProperty().set(value);
    }

    public final Side getPopupSide() {
        return this.popupSide == null ? Side.BOTTOM : (Side)((Object)this.popupSide.get());
    }

    public final ObjectProperty<Side> popupSideProperty() {
        if (this.popupSide == null) {
            this.popupSide = new ObjectPropertyBase<Side>(Side.BOTTOM){

                @Override
                protected void invalidated() {
                    Side side = (Side)((Object)this.get());
                    boolean active = side == Side.TOP || side == Side.BOTTOM;
                    MenuButton.this.pseudoClassStateChanged(PSEUDO_CLASS_OPENVERTICALLY, active);
                }

                @Override
                public Object getBean() {
                    return MenuButton.this;
                }

                @Override
                public String getName() {
                    return "popupSide";
                }
            };
        }
        return this.popupSide;
    }

    public void show() {
        if (!this.isDisabled() && !this.showing.isBound()) {
            this.setShowing(true);
        }
    }

    public void hide() {
        if (!this.showing.isBound()) {
            this.setShowing(false);
        }
    }

    @Override
    public void fire() {
        if (!this.isDisabled()) {
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MenuButtonSkin(this);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case FIRE: {
                if (this.isShowing()) {
                    this.hide();
                    break;
                }
                this.show();
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }
}

