/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn$$Lambda$1;
import javafx.scene.control.TableColumn$$Lambda$2;
import javafx.scene.control.TableColumn$$Lambda$3;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class TableColumn<S, T>
extends TableColumnBase<S, T>
implements EventTarget {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TABLE_COLUMN_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<TableColumn<?, ?>, TableCell<?, ?>> DEFAULT_CELL_FACTORY = new Callback<TableColumn<?, ?>, TableCell<?, ?>>(){

        @Override
        public TableCell<?, ?> call(TableColumn<?, ?> param) {
            return new TableCell<Object, Object>(){

                @Override
                protected void updateItem(Object item, boolean empty) {
                    if (item == this.getItem()) {
                        return;
                    }
                    super.updateItem(item, empty);
                    if (item == null) {
                        super.setText(null);
                        super.setGraphic(null);
                    } else if (item instanceof Node) {
                        super.setText(null);
                        super.setGraphic((Node)item);
                    } else {
                        super.setText(item.toString());
                        super.setGraphic(null);
                    }
                }
            };
        }
    };
    private EventHandler<CellEditEvent<S, T>> DEFAULT_EDIT_COMMIT_HANDLER = TableColumn$$Lambda$1.lambdaFactory$(this);
    private ListChangeListener<TableColumn<S, ?>> columnsListener = TableColumn$$Lambda$2.lambdaFactory$(this);
    private WeakListChangeListener<TableColumn<S, ?>> weakColumnsListener = new WeakListChangeListener(this.columnsListener);
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private ReadOnlyObjectWrapper<TableView<S>> tableView = new ReadOnlyObjectWrapper(this, "tableView");
    private ObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactory;
    private final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactory = new SimpleObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>>(this, "cellFactory", DEFAULT_CELL_FACTORY){

        @Override
        protected void invalidated() {
            TableView table = TableColumn.this.getTableView();
            if (table == null) {
                return;
            }
            ObservableMap<Object, Object> properties = table.getProperties();
            if (properties.containsKey("tableRecreateKey")) {
                properties.remove("tableRecreateKey");
            }
            properties.put("tableRecreateKey", Boolean.TRUE);
        }
    };
    private ObjectProperty<SortType> sortType;
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditStart;
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCommit;
    private ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCancel;
    private static final String DEFAULT_STYLE_CLASS = "table-column";

    public static <S, T> EventType<CellEditEvent<S, T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S, T> EventType<CellEditEvent<S, T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public TableColumn() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setOnEditCommit(this.DEFAULT_EDIT_COMMIT_HANDLER);
        this.getColumns().addListener(this.weakColumnsListener);
        this.tableViewProperty().addListener(TableColumn$$Lambda$3.lambdaFactory$(this));
    }

    public TableColumn(String text) {
        this();
        this.setText(text);
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableView.getReadOnlyProperty();
    }

    final void setTableView(TableView<S> value) {
        this.tableView.set(value);
    }

    public final TableView<S> getTableView() {
        return (TableView)this.tableView.get();
    }

    public final void setCellValueFactory(Callback<CellDataFeatures<S, T>, ObservableValue<T>> value) {
        this.cellValueFactoryProperty().set(value);
    }

    public final Callback<CellDataFeatures<S, T>, ObservableValue<T>> getCellValueFactory() {
        return this.cellValueFactory == null ? null : (Callback)this.cellValueFactory.get();
    }

    public final ObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactoryProperty() {
        if (this.cellValueFactory == null) {
            this.cellValueFactory = new SimpleObjectProperty<Callback<CellDataFeatures<S, T>, ObservableValue<T>>>(this, "cellValueFactory");
        }
        return this.cellValueFactory;
    }

    public final void setCellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> value) {
        this.cellFactory.set(value);
    }

    public final Callback<TableColumn<S, T>, TableCell<S, T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final ObjectProperty<SortType> sortTypeProperty() {
        if (this.sortType == null) {
            this.sortType = new SimpleObjectProperty<SortType>(this, "sortType", SortType.ASCENDING);
        }
        return this.sortType;
    }

    public final void setSortType(SortType value) {
        this.sortTypeProperty().set(value);
    }

    public final SortType getSortType() {
        return this.sortType == null ? SortType.ASCENDING : (SortType)((Object)this.sortType.get());
    }

    public final void setOnEditStart(EventHandler<CellEditEvent<S, T>> value) {
        this.onEditStartProperty().set(value);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditStart() {
        return this.onEditStart == null ? null : (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new SimpleObjectProperty<EventHandler<CellEditEvent<S, T>>>(this, "onEditStart"){

                @Override
                protected void invalidated() {
                    TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editStartEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<CellEditEvent<S, T>> value) {
        this.onEditCommitProperty().set(value);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditCommit() {
        return this.onEditCommit == null ? null : (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new SimpleObjectProperty<EventHandler<CellEditEvent<S, T>>>(this, "onEditCommit"){

                @Override
                protected void invalidated() {
                    TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editCommitEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<CellEditEvent<S, T>> value) {
        this.onEditCancelProperty().set(value);
    }

    public final EventHandler<CellEditEvent<S, T>> getOnEditCancel() {
        return this.onEditCancel == null ? null : (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<CellEditEvent<S, T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new SimpleObjectProperty<EventHandler<CellEditEvent<S, T>>>(this, "onEditCancel"){

                @Override
                protected void invalidated() {
                    TableColumn.this.eventHandlerManager.setEventHandler(TableColumn.editCancelEvent(), (EventHandler)this.get());
                }
            };
        }
        return this.onEditCancel;
    }

    @Override
    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(int index) {
        if (index < 0) {
            return null;
        }
        TableView<S> table = this.getTableView();
        if (table == null || table.getItems() == null) {
            return null;
        }
        ObservableList<S> items = table.getItems();
        if (index >= items.size()) {
            return null;
        }
        Object rowData = items.get(index);
        return this.getCellObservableValue(rowData);
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(S item) {
        Callback<CellDataFeatures<S, T>, ObservableValue<T>> factory = this.getCellValueFactory();
        if (factory == null) {
            return null;
        }
        TableView<S> table = this.getTableView();
        if (table == null) {
            return null;
        }
        CellDataFeatures cdf = new CellDataFeatures(table, this, item);
        return factory.call(cdf);
    }

    @Override
    public String getTypeSelector() {
        return "TableColumn";
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getTableView();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TableColumn.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }

    @Deprecated
    public Node impl_styleableGetNode() {
        if (!(this.getTableView().getSkin() instanceof TableViewSkin)) {
            return null;
        }
        TableViewSkin skin = (TableViewSkin)this.getTableView().getSkin();
        TableHeaderRow tableHeader = skin.getTableHeaderRow();
        NestedTableColumnHeader rootHeader = tableHeader.getRootHeader();
        return this.scan(rootHeader);
    }

    private TableColumnHeader scan(TableColumnHeader header) {
        if (this.equals(header.getTableColumn())) {
            return header;
        }
        if (header instanceof NestedTableColumnHeader) {
            NestedTableColumnHeader parent = (NestedTableColumnHeader)header;
            for (int i = 0; i < parent.getColumnHeaders().size(); ++i) {
                TableColumnHeader result = this.scan((TableColumnHeader)parent.getColumnHeaders().get(i));
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    /* synthetic */ void lambda$new$33(ListChangeListener.Change c) {
        while (c.next()) {
            for (TableColumn tc : c.getRemoved()) {
                if (this.getColumns().contains(tc)) continue;
                tc.setTableView(null);
                tc.setParentColumn(null);
            }
            for (TableColumn tc : c.getAddedSubList()) {
                tc.setTableView(this.getTableView());
            }
            this.updateColumnWidths();
        }
    }

    /* synthetic */ void lambda$new$32(CellEditEvent t) {
        int index = t.getTablePosition().getRow();
        ObservableList list = t.getTableView().getItems();
        if (list == null || index < 0 || index >= list.size()) {
            return;
        }
        Object rowData = list.get(index);
        ObservableValue<T> ov = this.getCellObservableValue(rowData);
        if (ov instanceof WritableValue) {
            ((WritableValue)((Object)ov)).setValue(t.getNewValue());
        }
    }

    /* synthetic */ void lambda$new$31(Observable observable) {
        for (TableColumn tableColumn : this.getColumns()) {
            tableColumn.setTableView(this.getTableView());
        }
    }

    static /* synthetic */ EventType access$000() {
        return EDIT_ANY_EVENT;
    }

    public static enum SortType {
        ASCENDING,
        DESCENDING;

    }

    public static class CellEditEvent<S, T>
    extends Event {
        private static final long serialVersionUID = -609964441682677579L;
        public static final EventType<?> ANY = TableColumn.access$000();
        private final T newValue;
        private final transient TablePosition<S, T> pos;

        public CellEditEvent(TableView<S> table, TablePosition<S, T> pos, EventType<CellEditEvent<S, T>> eventType, T newValue) {
            super(table, Event.NULL_SOURCE_TARGET, eventType);
            if (table == null) {
                throw new NullPointerException("TableView can not be null");
            }
            this.pos = pos;
            this.newValue = newValue;
        }

        public TableView<S> getTableView() {
            return this.pos.getTableView();
        }

        public TableColumn<S, T> getTableColumn() {
            return this.pos.getTableColumn();
        }

        public TablePosition<S, T> getTablePosition() {
            return this.pos;
        }

        public T getNewValue() {
            return this.newValue;
        }

        public T getOldValue() {
            S rowData = this.getRowValue();
            if (rowData == null || this.pos.getTableColumn() == null) {
                return null;
            }
            return this.pos.getTableColumn().getCellData(rowData);
        }

        public S getRowValue() {
            ObservableList<S> items = this.getTableView().getItems();
            if (items == null) {
                return null;
            }
            int row = this.pos.getRow();
            if (row < 0 || row >= items.size()) {
                return null;
            }
            return (S)items.get(row);
        }
    }

    public static class CellDataFeatures<S, T> {
        private final TableView<S> tableView;
        private final TableColumn<S, T> tableColumn;
        private final S value;

        public CellDataFeatures(TableView<S> tableView, TableColumn<S, T> tableColumn, S value) {
            this.tableView = tableView;
            this.tableColumn = tableColumn;
            this.value = value;
        }

        public S getValue() {
            return this.value;
        }

        public TableColumn<S, T> getTableColumn() {
            return this.tableColumn;
        }

        public TableView<S> getTableView() {
            return this.tableView;
        }
    }
}

